/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RedoLogGroupOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class DataBaseOracle
extends StorageObject
implements ModelObjectSetListener,
StorageObjectListener {
    private String controlFileReuse = "YES";
    private int maxLogFiles = 1;
    private int maxLogMembers = 1;
    private int maxLogHistory = 0;
    private int maxDataFiles = 10;
    private int maxInstances = 1;
    private String archiveLog = "YES";
    private String characterSet = "";
    private String nationalCharacterSet = "";
    protected StorageObjectCollection dfiles;
    protected StorageObjectCollection rlgroups;
    protected StorageObjectCollection sysAuxFiles;
    public static final String TYPE_NAME = "DB";
    public static final String OLD_TYPE_NAME = "DataBaseOracle";

    public DataBaseOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.dfiles = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getDataFileSet());
        this.rlgroups = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getRedoLogGroupSet());
        this.dfiles.setParent(this);
        this.dfiles.setName(Messages.getString("TableSpaceOracle.DataFiles"));
        this.dfiles.setSetMethod("setDataBase");
        this.dfiles.setClassForParent(DataBaseOracle.class);
        this.dfiles.setIcon(GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16));
        this.rlgroups.setParent(this);
        this.rlgroups.setName(Messages.getString("DataBaseOracle.RedoLogGroups"));
        this.rlgroups.setSetMethod("setDataBase");
        this.rlgroups.setClassForParent(DataBaseOracle.class);
        this.rlgroups.setIcon(GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16));
        ((StorageDesignOracle)storageDesign).getRedoLogGroupSet().addSetListener(this);
        ((StorageDesignOracle)storageDesign).getDataFileSet().addSetListener(this);
    }

    @Override
    public String getIDPrefix() {
        return "DBO";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public void setControlFileReuse(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.controlFileReuse = string;
            this.fireDataFieldChange();
        }
    }

    public String getControlFileReuse() {
        return this.controlFileReuse;
    }

    public void setMaxLogFiles(int n) {
        this.maxLogFiles = n;
        this.fireDataFieldChange();
    }

    public int getMaxLogFiles() {
        return this.maxLogFiles;
    }

    public void setMaxLogMembers(int n) {
        this.maxLogMembers = n;
        this.fireDataFieldChange();
    }

    public int getMaxLogMembers() {
        return this.maxLogMembers;
    }

    public void setMaxLogHistory(int n) {
        this.maxLogHistory = n;
        this.fireDataFieldChange();
    }

    public int getMaxLogHistory() {
        return this.maxLogHistory;
    }

    public void setMaxDataFiles(int n) {
        this.maxDataFiles = n;
        this.fireDataFieldChange();
    }

    public int getMaxDataFiles() {
        return this.maxDataFiles;
    }

    public void setMaxInstances(int n) {
        this.maxInstances = n;
        this.fireDataFieldChange();
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public void setArchiveLog(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.archiveLog = string;
            this.fireDataFieldChange();
        }
    }

    public String getArchiveLog() {
        return this.archiveLog;
    }

    public void setCharacterSet(String string) {
        this.characterSet = string;
        this.fireDataFieldChange();
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setNationalCharacterSet(String string) {
        this.nationalCharacterSet = string;
        this.fireDataFieldChange();
    }

    public String getNationalCharacterSet() {
        return this.nationalCharacterSet;
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.dfiles;
            }
            case 1: {
                return this.rlgroups;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.dfiles) {
            return 0;
        }
        if (modelObject == this.rlgroups) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.dfiles) {
            return 0;
        }
        if (object == this.rlgroups) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.dfiles.removeAll();
        this.rlgroups.removeAll();
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof DataFileOracle) {
                DataFileOracle dataFileOracle = (DataFileOracle)modelObjectSetEvent.getAffected();
                dataFileOracle.addObjectListener(this);
                if (dataFileOracle.getDataBase() != null && dataFileOracle.getDataBase() == this) {
                    dataFileOracle.setParent(this.dfiles);
                    this.dfiles.add(dataFileOracle);
                } else {
                    this.dfiles.remove(dataFileOracle);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof RedoLogGroupOracle) {
                RedoLogGroupOracle redoLogGroupOracle = (RedoLogGroupOracle)modelObjectSetEvent.getAffected();
                redoLogGroupOracle.addObjectListener(this);
                if (redoLogGroupOracle.getDataBase() != null && redoLogGroupOracle.getDataBase() == this) {
                    redoLogGroupOracle.setParent(this.rlgroups);
                    this.rlgroups.add(redoLogGroupOracle);
                } else {
                    this.rlgroups.remove(redoLogGroupOracle);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof DataFileOracle) {
                DataFileOracle dataFileOracle = (DataFileOracle)modelObjectSetEvent.getAffected();
                this.dfiles.remove(dataFileOracle);
                dataFileOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof RedoLogGroupOracle) {
                RedoLogGroupOracle redoLogGroupOracle = (RedoLogGroupOracle)modelObjectSetEvent.getAffected();
                this.rlgroups.remove(redoLogGroupOracle);
                redoLogGroupOracle.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof DataFileOracle) {
            DataFileOracle dataFileOracle = (DataFileOracle)objectChangeEvent.getAffected();
            if (dataFileOracle.getDataBase() != null && dataFileOracle.getDataBase() == this) {
                dataFileOracle.setParent(this.dfiles);
                this.dfiles.add(dataFileOracle);
            } else {
                this.dfiles.remove(dataFileOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof RedoLogGroupOracle) {
            RedoLogGroupOracle redoLogGroupOracle = (RedoLogGroupOracle)objectChangeEvent.getAffected();
            if (redoLogGroupOracle.getDataBase() != null && redoLogGroupOracle.getDataBase() == this) {
                redoLogGroupOracle.setParent(this.rlgroups);
                this.rlgroups.add(redoLogGroupOracle);
            } else {
                this.rlgroups.remove(redoLogGroupOracle);
            }
        }
    }

    public List getDataFiles() {
        ArrayList arrayList = new ArrayList();
        this.dfiles.addAllElementsTo(arrayList);
        return arrayList;
    }

    public List getRedoLogGroups() {
        ArrayList arrayList = new ArrayList();
        this.rlgroups.addAllElementsTo(arrayList);
        return arrayList;
    }

    public StorageObjectCollection getDataFileCollection() {
        return this.dfiles;
    }

    public DataFileOracle createDataFile() {
        if (this.dfiles.getStorageObjectSet() != null) {
            return (DataFileOracle)this.dfiles.createElement(null);
        }
        return null;
    }

    public StorageObjectCollection getRedoLogGroupCollection() {
        return this.rlgroups;
    }

    public RedoLogGroupOracle createRedoLogGroup() {
        if (this.rlgroups.getStorageObjectSet() != null) {
            return (RedoLogGroupOracle)this.rlgroups.createElement(null);
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DATABASE_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        this.rlgroups.removeAll();
        this.dfiles.removeAll();
        if (this.sysAuxFiles != null) {
            this.sysAuxFiles.removeAll();
        }
    }
}

