/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.StructuredTypePropertyDialogOraclev9i;

public class CollectionTypeProxyOracle
extends CollectionTypeProxy {
    private UserOracle owner;

    public CollectionTypeProxyOracle(CollectionType collectionType, StorageDesign storageDesign) {
        super(collectionType, storageDesign);
    }

    public CollectionTypeProxyOracle(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    public UserOracle getOwner() {
        return this.owner;
    }

    public void setOwner(UserOracle userOracle) {
        if (this.owner != userOracle) {
            this.owner = userOracle;
            boolean bl = userOracle.getName().equalsIgnoreCase("MDSYS") || userOracle.getName().equalsIgnoreCase("SYS") || userOracle.getName().equalsIgnoreCase("ORDSYS");
            this.getCollectionType().setPredefined(bl);
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StructuredTypePropertyDialogOraclev9i structuredTypePropertyDialogOraclev9i = new StructuredTypePropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            structuredTypePropertyDialogOraclev9i.show();
        }
    }

    public String getType() {
        return ((CollectionType)this.getObject()).getType();
    }

    public String getDataType() {
        return ((CollectionType)this.getObject()).getElementType().getType().getName();
    }

    public String getDataType(String string) {
        return ((CollectionType)this.getObject()).getElementType().getDataType(string);
    }

    public int getMaxElement() {
        return ((CollectionType)this.getObject()).getMaxElement();
    }

    public boolean isArrayType(String string) {
        return ((CollectionType)this.getObject()).isArrayType();
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !"".equals(this.getOwner().getLongName())) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public StorageObject getSchemaOrOwner() {
        return this.getOwner();
    }
}

