/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class ClusterOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener {
    private static final String[] UNITS = new String[]{"", "K"};
    private static List measureUnitList = Arrays.asList(UNITS);
    private UserOracle user = null;
    private int size = 0;
    private static Set unitSet = null;
    private String measureUnit = UNITS[0];
    private TableSpaceOracle tableSpace = null;
    private SegmentOracle segment = null;
    private String indexed = "YES";
    private String singleTable = "NO";
    private int hashKeys = 0;
    private String hashExpression = "";
    private String parallel = "NO";
    private int degree = 0;
    private String cache = "NO";
    private String rowDependency = "NO";
    StorageObjectCollection aindexes;
    StorageObjectCollection columns;
    public static final String TYPE_NAME = "Cluster";

    public ClusterOracle() {
    }

    public ClusterOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.columns = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getClusterColumnSet());
        this.aindexes = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getClusterIndexSet());
        this.columns.setParent(this);
        this.columns.setName(Messages.getString("TableProxy.Columns"));
        this.columns.setSetMethod("setCluster");
        this.columns.setClassForParent(ClusterOracle.class);
        this.columns.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON", 16));
        this.aindexes.setParent(this);
        this.aindexes.setName(Messages.getString("TableProxy.Indexes"));
        this.aindexes.setSetMethod("setCluster");
        this.aindexes.setClassForParent(ClusterOracle.class);
        this.aindexes.setAllowedNumberOfElements(1);
        this.aindexes.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        ((StorageDesignOracle)storageDesign).getClusterIndexSet().addSetListener(this);
        ((StorageDesignOracle)storageDesign).getClusterColumnSet().addSetListener(this);
        this.addIndFromDesign(((StorageDesignOracle)storageDesign).getClusterIndexSet());
        this.addColumnFromDesign(((StorageDesignOracle)storageDesign).getClusterColumnSet());
    }

    @Override
    public String getIDPrefix() {
        return "CL";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public UserOracle getUser() {
        return this.user;
    }

    public void setUser(UserOracle userOracle) {
        this.user = userOracle;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
        this.fireDataFieldChange();
    }

    public static String[] getUnitChoices() {
        return UNITS;
    }

    protected boolean checkUnit(String string) {
        if (unitSet == null) {
            unitSet = new HashSet();
            unitSet.addAll(Arrays.asList(ClusterOracle.getUnitChoices()));
        }
        return unitSet.contains(string);
    }

    public void setMeasureUnit(String string) {
        if (this.checkUnit(string)) {
            this.measureUnit = string;
            this.fireDataFieldChange();
        }
    }

    public String getMeasureUnit() {
        return this.measureUnit;
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(TableSpaceOracle tableSpaceOracle) {
        if (this.tableSpace != tableSpaceOracle) {
            this.tableSpace = tableSpaceOracle;
            this.fireDataFieldChange();
        }
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentOracle segmentOracle) {
        this.segment = segmentOracle;
        this.fireDataFieldChange();
    }

    public void setIndexed(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.indexed = string;
            this.fireDataFieldChange();
        }
    }

    public String getIndexed() {
        return this.indexed;
    }

    public void setSingleTable(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.singleTable = string;
            this.fireDataFieldChange();
        }
    }

    public String getSingleTable() {
        return this.singleTable;
    }

    public int getHashKeys() {
        return this.hashKeys;
    }

    public void setHashKeys(int n) {
        this.hashKeys = n;
        this.fireDataFieldChange();
    }

    public String getHashExpression() {
        return this.hashExpression;
    }

    public void setHashExpression(String string) {
        this.hashExpression = string;
        this.fireDataFieldChange();
    }

    public void setParallel(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.parallel = string;
            this.fireDataFieldChange();
        }
    }

    public String getParallel() {
        return this.parallel;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int n) {
        this.degree = n;
        this.fireDataFieldChange();
    }

    public void setCache(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.cache = string;
            this.fireDataFieldChange();
        }
    }

    public String getCache() {
        return this.cache;
    }

    public void setRowDependency(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.rowDependency = string;
            this.fireDataFieldChange();
        }
    }

    public String getRowDependency() {
        return this.rowDependency;
    }

    public static List getMeasureUnitValues() {
        return measureUnitList;
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null && !"".equals(this.getUser().getLongName())) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getUser() != null) {
            string = this.getUser().getLongName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    @Override
    public int getMaxNameLength() {
        return 30;
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.aindexes;
            }
            case 1: {
                return this.columns;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.aindexes) {
            return 0;
        }
        if (modelObject == this.columns) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.aindexes) {
            return 0;
        }
        if (object == this.columns) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.aindexes.removeAll();
        this.columns.removeAll();
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof ClusterColumnOracle) {
                ClusterColumnOracle clusterColumnOracle = (ClusterColumnOracle)modelObjectSetEvent.getAffected();
                clusterColumnOracle.addObjectListener(this);
                if (clusterColumnOracle.getCluster() != null && clusterColumnOracle.getCluster() == this && !this.columns.contains(clusterColumnOracle)) {
                    clusterColumnOracle.setParent(this.columns);
                    this.columns.add(clusterColumnOracle);
                } else {
                    this.columns.remove(clusterColumnOracle);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof ClusterIndexOracle) {
                ClusterIndexOracle clusterIndexOracle = (ClusterIndexOracle)modelObjectSetEvent.getAffected();
                clusterIndexOracle.addObjectListener(this);
                if (clusterIndexOracle.getCluster() != null && clusterIndexOracle.getCluster() == this && !this.aindexes.contains(clusterIndexOracle)) {
                    clusterIndexOracle.setParent(this.aindexes);
                    this.aindexes.add(clusterIndexOracle);
                } else {
                    this.aindexes.remove(clusterIndexOracle);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            AbstractStorageObjectOracle abstractStorageObjectOracle;
            if (modelObjectSetEvent.getAffected() instanceof ClusterColumnOracle) {
                abstractStorageObjectOracle = (ClusterColumnOracle)modelObjectSetEvent.getAffected();
                this.columns.remove(abstractStorageObjectOracle);
            }
            if (modelObjectSetEvent.getAffected() instanceof ClusterIndexOracle) {
                abstractStorageObjectOracle = (ClusterIndexOracle)modelObjectSetEvent.getAffected();
                this.aindexes.remove(abstractStorageObjectOracle);
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof ClusterIndexOracle) {
            ClusterIndexOracle clusterIndexOracle = (ClusterIndexOracle)objectChangeEvent.getAffected();
            if (clusterIndexOracle.getCluster() != null && clusterIndexOracle.getCluster() == this) {
                if (!this.aindexes.contains(clusterIndexOracle)) {
                    clusterIndexOracle.setParent(this.aindexes);
                    this.aindexes.add(clusterIndexOracle);
                }
            } else {
                this.aindexes.remove(clusterIndexOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof ClusterColumnOracle) {
            ClusterColumnOracle clusterColumnOracle = (ClusterColumnOracle)objectChangeEvent.getAffected();
            if (clusterColumnOracle.getCluster() != null && clusterColumnOracle.getCluster() == this) {
                if (!this.columns.contains(clusterColumnOracle)) {
                    clusterColumnOracle.setParent(this.columns);
                    this.columns.add(clusterColumnOracle);
                }
            } else {
                this.columns.remove(clusterColumnOracle);
            }
        }
    }

    public void addIndFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            ClusterIndexOracle clusterIndexOracle = (ClusterIndexOracle)iterator.next();
            if (clusterIndexOracle.getCluster() != null && clusterIndexOracle.getCluster() == this) {
                clusterIndexOracle.setParent(this.aindexes);
                this.aindexes.add(clusterIndexOracle);
                continue;
            }
            this.aindexes.remove(clusterIndexOracle);
        }
    }

    public void addColumnFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            ClusterColumnOracle clusterColumnOracle = (ClusterColumnOracle)iterator.next();
            if (clusterColumnOracle.getCluster() != null && clusterColumnOracle.getCluster() == this) {
                clusterColumnOracle.setParent(this.columns);
                this.columns.add(clusterColumnOracle);
                continue;
            }
            this.columns.remove(clusterColumnOracle);
        }
    }

    public List getColumns() {
        ArrayList arrayList = new ArrayList();
        this.columns.addAllElementsTo(arrayList);
        return arrayList;
    }

    public List getIndexes() {
        ArrayList arrayList = new ArrayList();
        this.aindexes.addAllElementsTo(arrayList);
        return arrayList;
    }

    public StorageObjectCollection getColumnsCollection() {
        return this.columns;
    }

    public StorageObjectCollection getIndexesCollection() {
        return this.aindexes;
    }

    public ClusterColumnOracle createColumn() {
        if (this.columns.getStorageObjectSet() != null) {
            return (ClusterColumnOracle)this.columns.createElement(null);
        }
        return null;
    }

    public ClusterIndexOracle createIndex() {
        if (this.aindexes.getStorageObjectSet() != null) {
            return (ClusterIndexOracle)this.aindexes.createElement(null);
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("CLUSTER_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        this.columns.removeAll();
    }

    @Override
    public void clearMergableStructure(Map map) {
        if (map != null) {
            Iterator iterator = this.aindexes.iterator();
            while (iterator.hasNext()) {
                StorageObject storageObject = (StorageObject)iterator.next();
                if (map.get(storageObject.getObjectID()) != null) continue;
                storageObject.remove(true);
            }
        }
    }
}

