/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class BitmapJoinIndexOracle
extends AbstractStorageObjectOracle {
    protected UserOracle user;
    protected TableProxyOracle table;
    protected String indexColumns = "";
    protected InlineList indexColumnSet = null;
    protected String dimensionKeys = "";
    protected InlineList dimensionKeySet = null;
    protected String joinColumns = "";
    protected InlineList joinColumnSet = null;
    protected String localPartitioning = "NO";
    protected String tablespace = "Default";
    protected String logging = "";
    protected SegmentOracle segment;
    protected int compress = 0;
    protected String parallel = "NO";
    protected String degree = "";
    protected String sortedRows = "NO";
    public static final String SORTED = "SORTED";
    public static final String REVERSE = "REVERSE";
    private static String[] sortedRowsChoices = new String[]{"NO", "SORTED", "REVERSE"};
    private static Set sortedRowsSet = null;
    protected String computeStatistics = "NO";
    protected String online = "NO";
    private String hashSubPartitionsTableSpaces = "";
    private InlineList hashPartitionsTableSpacesSet = null;
    public static final String TYPE_NAME = "BJIndex";
    public static final String OLD_TYPE_NAME = "BitmapJoinIndex";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "BJI";
    }

    public InlineList getIndexColumnSet() {
        if (this.indexColumnSet == null) {
            this.indexColumnSet = new InlineList();
        }
        return this.indexColumnSet;
    }

    public void clearIndexColumns() {
        this.getIndexColumnSet().removeAllElements();
        this.indexColumns = "";
    }

    public String getIndexColumns() {
        return this.indexColumns;
    }

    public void setIndexColumns(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateIndexColumnSet(string);
        } else {
            this.addIndexColumn(string);
        }
        this.indexColumns = this.getIndexColumnSet().toString();
        this.fireDataFieldChange();
    }

    private void addIndexColumn(String string) {
        this.getIndexColumnSet().add(string);
    }

    public void recreateIndexColumnSet(String string) {
        this.getIndexColumnSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.indexColumnSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getIndexColumnSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getJoinColumnSet() {
        if (this.joinColumnSet == null) {
            this.joinColumnSet = new InlineList();
        }
        return this.joinColumnSet;
    }

    public void clearJoinColumns() {
        this.getJoinColumnSet().removeAllElements();
        this.joinColumns = "";
    }

    public String getJoinColumns() {
        return this.joinColumns;
    }

    public void setJoinColumns(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateJoinColumnSet(string);
        } else {
            this.addJoinColumn(string);
        }
        this.joinColumns = this.getJoinColumnSet().toString();
        this.fireDataFieldChange();
    }

    private void addJoinColumn(String string) {
        this.getJoinColumnSet().add(string);
    }

    public void recreateJoinColumnSet(String string) {
        this.getJoinColumnSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.joinColumnSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getJoinColumnSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getDimensionKeySet() {
        if (this.dimensionKeySet == null) {
            this.dimensionKeySet = new InlineList();
        }
        return this.dimensionKeySet;
    }

    public void clearDimensionKeys() {
        this.getDimensionKeySet().removeAllElements();
        this.dimensionKeys = "";
    }

    public String getDimensionKeys() {
        return this.dimensionKeys;
    }

    public void setDimensionKeys(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateDimensionKeySet(string);
        } else {
            this.addDimensionKey(string);
        }
        this.dimensionKeys = this.getDimensionKeySet().toString();
        this.fireDataFieldChange();
    }

    private void addDimensionKey(String string) {
        this.getDimensionKeySet().add(string);
    }

    public void recreateDimensionKeySet(String string) {
        this.getDimensionKeySet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.dimensionKeySet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getDimensionKeySet().add(stringTokenizer.nextToken().trim());
        }
    }

    protected boolean checkSortedRows(String string) {
        if (sortedRowsSet == null) {
            sortedRowsSet = new HashSet();
            sortedRowsSet.addAll(Arrays.asList(sortedRowsChoices));
        }
        return sortedRowsSet.contains(string);
    }

    public int getCompress() {
        return this.compress;
    }

    public void setCompress(int n) {
        this.compress = n;
        this.fireDataFieldChange();
    }

    public String getComputeStatistics() {
        return this.computeStatistics;
    }

    public void setComputeStatistics(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.computeStatistics = string;
            this.fireDataFieldChange();
        }
    }

    public String getLocalPartitioning() {
        return this.localPartitioning;
    }

    public void setLocalPartitioning(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.localPartitioning = string;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String string) {
        if (!this.logging.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.logging = string;
            this.fireDataFieldChange();
        }
    }

    public String getOnline() {
        return this.online;
    }

    public void setOnline(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.online = string;
            this.fireDataFieldChange();
        }
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setParallel(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.parallel = string;
            this.fireDataFieldChange();
        }
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentOracle segmentOracle) {
        this.segment = segmentOracle;
        this.fireDataFieldChange();
    }

    public String getSortedRows() {
        return this.sortedRows;
    }

    public void setSortedRows(String string) {
        if (this.checkSortedRows(string)) {
            this.sortedRows = string;
            this.fireDataFieldChange();
        }
    }

    public TableProxyOracle getTable() {
        return this.table;
    }

    public void setTable(TableProxyOracle tableProxyOracle) {
        this.table = tableProxyOracle;
        this.setPAC_Element(tableProxyOracle);
        this.fireDataFieldChange();
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String string) {
        this.tablespace = string;
        this.fireDataFieldChange();
    }

    public UserOracle getUser() {
        return this.user;
    }

    public void setUser(UserOracle userOracle) {
        this.user = userOracle;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public String getColumnSortOrder(String string) {
        int n;
        if (this.indexColumnSet != null && (n = this.getIndexColumnSet().indexOf(string)) > -1) {
            return (String)this.getIndexColumnSet().elementAt(n + 1);
        }
        return "ASC";
    }

    public IndexProxy getDimensionKey(TableProxyOracle tableProxyOracle) {
        int n;
        if (this.dimensionKeySet != null && (n = this.getDimensionKeySet().indexOf(tableProxyOracle.getObjectID())) > -1) {
            String string = (String)this.getDimensionKeySet().elementAt(n + 1);
            ModelIDObject modelIDObject = tableProxyOracle.getPrimaryKeys().getById(string);
            if (modelIDObject == null) {
                modelIDObject = tableProxyOracle.getUniqueKeys().getById(string);
            }
            return (IndexProxy)modelIDObject;
        }
        return null;
    }

    public ColumnProxyOracle getJoinColumn(ColumnProxyOracle columnProxyOracle) {
        int n;
        if (this.joinColumnSet != null && (n = this.getJoinColumnSet().indexOf(columnProxyOracle.getObjectID())) > -1) {
            String string = (String)this.getJoinColumnSet().elementAt(n + 1);
            ColumnProxyOracle columnProxyOracle2 = (ColumnProxyOracle)this.getStorageDesign().getColumnProxySet().getProxy(string);
            return columnProxyOracle2;
        }
        return null;
    }

    public Object[] getDimensionTables() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = this.getDimensionKeySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            ++i;
            arrayList.add(string);
        }
        return arrayList.toArray();
    }

    public void setHashSubPartitionsTableSpaces(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateHashSubPartitionsTSSet(string);
        } else {
            this.addHashSubPartitionsTS(string);
        }
        this.hashSubPartitionsTableSpaces = this.getHashPartitionsTableSpacesSet().toString();
        this.fireDataFieldChange();
    }

    public String getHashSubPartitionsTableSpaces() {
        return this.hashSubPartitionsTableSpaces;
    }

    public String getAllHashSubPartitionsTableSpaces() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.hashSubPartitionsTableSpaces, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)this.getStorageDesignOracle().getTableSpaceSet().getById(string);
            if (tableSpaceOracle == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(tableSpaceOracle.getName());
        }
        return stringBuffer.toString();
    }

    private void addHashSubPartitionsTS(String string) {
        if (!this.getHashPartitionsTableSpacesSet().contains(string)) {
            this.getHashPartitionsTableSpacesSet().add(string);
        }
    }

    public void recreateHashSubPartitionsTSSet(String string) {
        this.getHashPartitionsTableSpacesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getHashPartitionsTableSpacesSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getHashPartitionsTableSpacesSet() {
        if (this.hashPartitionsTableSpacesSet == null) {
            this.hashPartitionsTableSpacesSet = new InlineList();
        }
        return this.hashPartitionsTableSpacesSet;
    }

    public void clear() {
        this.getHashPartitionsTableSpacesSet().clear();
        this.hashSubPartitionsTableSpaces = "";
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String string) {
        if (!"".equalsIgnoreCase(string)) {
            try {
                Integer.parseInt(string);
                this.degree = string;
            }
            catch (NumberFormatException numberFormatException) {
                this.degree = "";
            }
        } else {
            this.degree = "";
        }
        this.fireDataFieldChange();
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null && !"".equals(this.getUser().getLongName())) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getUser() != null) {
            string = this.getUser().getLongName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("INDEX_ICON", 16);
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

