/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v80;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.InstanceDescriptorColumnDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TablePartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.TablePartitionSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TablePartitionDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableSpaceDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TriggerDB2v80;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.v80.TablePropertyDialogDB2v80;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxyDB2v80
extends TableProxyDB2
implements ModelObjectSetListener,
StorageObjectListener {
    protected StorageObjectCollection fkeys;
    protected String partitioned = YES_NO_STATES[1];
    private String partitioningKey = "";
    private InlineList partitioningKeySet = null;
    protected String materializedQuery = YES_NO_STATES[1];
    protected String tableAccess = TABLE_ACCESS_STATES[0];
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String[] TABLE_ACCESS_STATES = new String[]{"NOT VOLATILE", "VOLATILE"};
    private static Set tableAccessSet = null;
    protected String mqQueryDefinition = "";
    protected String mqStatus = MQ_STATUS_STATES[0];
    protected String mqMaintenance = MQ_MAINTENANCE_STATES[0];
    protected String mqQueryOptimization = MQ_QUERY_OPTIMIZATION_STATES[0];
    protected String mqIdentityColumnAttr = MQ_IDENTITY_COLUMN_ATTR_STATES[0];
    protected String mqColumnDefaults = MQ_COLUMN_DEFAULTS_STATES[0];
    public static final String[] MQ_STATUS_STATES = new String[]{"MATERIALIZED QUERY", "NO DATA"};
    private static Set mqStatusSet = null;
    public static final String[] MQ_MAINTENANCE_STATES = new String[]{"BY SYSTEM", "BY USER"};
    private static Set mqMaintenanceSet = null;
    public static final String[] MQ_QUERY_OPTIMIZATION_STATES = new String[]{"ENABLE", "DISABLE"};
    private static Set mqQueryOptimizationSet = null;
    public static final String[] MQ_IDENTITY_COLUMN_ATTR_STATES = new String[]{"EXCLUDE", "INCLUDE"};
    private static Set mqIdentityColumnAttrSet = null;
    public static final String[] MQ_COLUMN_DEFAULTS_STATES = new String[]{"EXCLUDING", "INCLUDING", "USING TYPE DEFAULTS"};
    private static Set mqColumnDefaultsSet = null;
    private List propertyWrapperList = null;
    int numbChildren = 6;

    public TableProxyDB2v80(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        this.fkeys = new StorageObjectCollection();
        this.fkeys.setParent(this);
        this.fkeys.setName(Messages.getString("TableProxyDB2v80.ForeignKeys"));
        this.fkeys.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON", 16));
        this.addFKProxiesFromDesign(((StorageDesignDB2v80)storageDesign).getFKProxySet());
        ((StorageDesignDB2v80)storageDesign).getFKProxySet().addSetListener(this);
        this.tablePartitions = new StorageObjectCollection(((StorageDesignDB2v80)storageDesign).getTablePartitionSet());
        this.tablePartitions.setParent(this);
        this.tablePartitions.setName(Messages.getString("TableProxyDB2v80.Partitions"));
        this.tablePartitions.setClassForParent(TableProxyDB2.class);
        this.tablePartitions.setSetMethod("setTable");
        this.tablePartitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        ((StorageDesignDB2v80)storageDesign).getTablePartitionSet().addSetListener(this);
        this.addPartitionsFromDesign(((StorageDesignDB2v80)storageDesign).getTablePartitionSet());
        if (this.partitioned.equalsIgnoreCase(YES_NO_STATES[0])) {
            this.enablePartitions();
        } else {
            this.disablePartitions();
        }
    }

    public TableProxyDB2v80(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.fkeys = new StorageObjectCollection();
        this.fkeys.setParent(this);
        this.fkeys.setName(Messages.getString("TableProxyDB2v80.ForeignKeys"));
        this.fkeys.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON", 16));
        this.addFKProxiesFromDesign(((StorageDesignDB2v80)storageDesign).getFKProxySet());
        ((StorageDesignDB2v80)storageDesign).getFKProxySet().addSetListener(this);
        this.tablePartitions = new StorageObjectCollection(((StorageDesignDB2v80)storageDesign).getTablePartitionSet());
        this.tablePartitions.setParent(this);
        this.tablePartitions.setName(Messages.getString("TableProxyDB2v80.Partitions"));
        this.tablePartitions.setSetMethod("setTable");
        this.tablePartitions.setClassForParent(TableProxyDB2v80.class);
        this.tablePartitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        ((StorageDesignDB2v80)storageDesign).getTablePartitionSet().addSetListener(this);
        this.addPartitionsFromDesign(((StorageDesignDB2v80)storageDesign).getTablePartitionSet());
        if (this.partitioned.equalsIgnoreCase(YES_NO_STATES[0])) {
            this.enablePartitions();
        } else {
            this.disablePartitions();
        }
    }

    private void enablePartitions() {
        this.tablePartitions.setForbiddenCreateElement(false);
    }

    private void disablePartitions() {
        this.tablePartitions.setForbiddenCreateElement(true);
        this.tablePartitions.removeAll();
    }

    public StorageObjectCollection getTablePartitions() {
        return this.tablePartitions;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogDB2v80 tablePropertyDialogDB2v80 = new TablePropertyDialogDB2v80(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tablePropertyDialogDB2v80.show();
        }
    }

    public void addFKProxiesFromDesign(RelationalObjectProxySet relationalObjectProxySet) {
        Iterator iterator = relationalObjectProxySet.iterator();
        while (iterator.hasNext()) {
            IndexProxy indexProxy = (IndexProxy)iterator.next();
            Index index = (Index)indexProxy.getObject();
            if (this.getObject() != index.getContainerWithKeyObject() || !index.isFK()) continue;
            indexProxy.setParent(this.fkeys);
            this.fkeys.add(indexProxy);
        }
    }

    public void addPartitionsFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            TablePartitionDB2v80 tablePartitionDB2v80 = (TablePartitionDB2v80)iterator.next();
            tablePartitionDB2v80.addObjectListener(this);
            if (tablePartitionDB2v80.getTable() != null && tablePartitionDB2v80.getTable() == this) {
                tablePartitionDB2v80.setParent(this.tablePartitions);
                this.tablePartitions.add(tablePartitionDB2v80);
                continue;
            }
            this.tablePartitions.remove(tablePartitionDB2v80);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return this.numbChildren;
    }

    @Override
    public ModelObject getChild(int n) {
        if (n == this.getNumberOfChildren() - 1) {
            return this.fkeys;
        }
        if (n == this.getNumberOfChildren() - 2) {
            return this.tablePartitions;
        }
        return super.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.fkeys) {
            return this.getNumberOfChildren() - 1;
        }
        if (modelObject == this.tablePartitions) {
            return this.getNumberOfChildren() - 2;
        }
        return super.getIndexForChild(modelObject);
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.fkeys) {
            return this.getNumberOfChildren() - 1;
        }
        if (object == this.tablePartitions) {
            return this.getNumberOfChildren() - 2;
        }
        return super.getIndexForChild(object);
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof ColumnProxy) {
                ColumnProxy columnProxy = (ColumnProxy)modelObjectSetEvent.getAffected();
                if (this.getObject() == ((Column)columnProxy.getObject()).getContainerWithKeyObject()) {
                    this.columns.add(modelObjectSetEvent.getAffected());
                    columnProxy.setPAC_Element(this);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof IndexProxy) {
                IndexProxy indexProxy = (IndexProxy)modelObjectSetEvent.getAffected();
                Index index = (Index)indexProxy.getObject();
                if (this.getObject() == index.getContainerWithKeyObject()) {
                    if (index.isFK() && !this.fkeys.contains(indexProxy)) {
                        indexProxy.setParent(this.fkeys);
                        indexProxy.setPAC_Element(this);
                        this.fkeys.add(indexProxy);
                    } else {
                        indexProxy.addObjectListener(this);
                        if (!this.indexes.contains(indexProxy)) {
                            this.addIndexProxyWithoutCheck(indexProxy);
                        }
                    }
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof ColumnProxy) {
                this.columns.remove(((ColumnProxy)modelObjectSetEvent.getAffected()).getObject().getObjectID());
            } else if (modelObjectSetEvent.getAffected() instanceof IndexProxy) {
                IndexProxy indexProxy = (IndexProxy)modelObjectSetEvent.getAffected();
                indexProxy.removeObjectListener(this);
                if (this.indexes.contains(indexProxy)) {
                    this.indexes.remove(modelObjectSetEvent.getAffected());
                }
                if (this.integrityIndexes.contains(indexProxy)) {
                    this.integrityIndexes.remove(modelObjectSetEvent.getAffected());
                }
                if (this.fkeys.contains(indexProxy)) {
                    this.fkeys.remove(modelObjectSetEvent.getAffected());
                }
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(storageObject, objectChangeEvent);
        if (objectChangeEvent.getAffected() instanceof TablePartitionDB2v80) {
            TablePartitionDB2v80 tablePartitionDB2v80 = (TablePartitionDB2v80)objectChangeEvent.getAffected();
            if (tablePartitionDB2v80.getTable() != null && tablePartitionDB2v80.getTable() == this) {
                tablePartitionDB2v80.setParent(this.tablePartitions);
                this.tablePartitions.add(tablePartitionDB2v80);
                if (!this.getStorageDesign().isLoading()) {
                    tablePartitionDB2v80.removeObjectListener(this);
                    tablePartitionDB2v80.setPartNumber(this.tablePartitions.size());
                    tablePartitionDB2v80.addObjectListener(this);
                }
                this.synchronizeTablespacePartNum();
            } else {
                this.tablePartitions.remove(tablePartitionDB2v80);
                this.synchronizeTablespacePartNum();
            }
        }
    }

    private void synchronizeTablespacePartNum() {
        if (this.getTableSpace() != null) {
            this.getTableSpace().setMaxPartitionCount(this.getNumParts());
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof TriggerDB2) {
                TriggerDB2 triggerDB2 = (TriggerDB2)modelObjectSetEvent.getAffected();
                triggerDB2.addObjectListener(this);
                if (triggerDB2.getTable() != null && triggerDB2.getTable() == this) {
                    triggerDB2.setParent(this.triggers);
                    this.triggers.add(triggerDB2);
                } else {
                    this.triggers.remove(triggerDB2);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof TablePartitionDB2v80) {
                TablePartitionDB2v80 tablePartitionDB2v80 = (TablePartitionDB2v80)modelObjectSetEvent.getAffected();
                tablePartitionDB2v80.addObjectListener(this);
                if (tablePartitionDB2v80.getTable() != null && tablePartitionDB2v80.getTable() == this) {
                    tablePartitionDB2v80.setParent(this.tablePartitions);
                    if (!this.getStorageDesign().isLoading()) {
                        tablePartitionDB2v80.removeObjectListener(this);
                        tablePartitionDB2v80.setPartNumber(this.tablePartitions.size());
                        tablePartitionDB2v80.addObjectListener(this);
                    }
                    this.tablePartitions.add(tablePartitionDB2v80);
                } else {
                    this.tablePartitions.remove(tablePartitionDB2v80);
                    if (!this.getStorageDesign().isLoading()) {
                        for (int i = 0; i < this.tablePartitions.size(); ++i) {
                            ((TablePartitionDB2v80)this.tablePartitions.getElement(i)).removeObjectListener(this);
                            ((TablePartitionDB2v80)this.tablePartitions.getElement(i)).setPartNumber(i + 1);
                            ((TablePartitionDB2v80)this.tablePartitions.getElement(i)).addObjectListener(this);
                        }
                    }
                }
            } else if (modelObjectSetEvent.getAffected() instanceof SynonymDB2) {
                SynonymDB2 synonymDB2 = (SynonymDB2)modelObjectSetEvent.getAffected();
                synonymDB2.addObjectListener(this);
                if (synonymDB2.getTable() != null && synonymDB2.getTable() == this) {
                    synonymDB2.setParent(this.synonyms);
                    this.synonyms.add(synonymDB2);
                } else {
                    this.synonyms.remove(synonymDB2);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof InstanceDescriptorColumnDB2) {
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)modelObjectSetEvent.getAffected();
                instanceDescriptorColumnDB2.addObjectListener(this);
                if (instanceDescriptorColumnDB2.getTable() != null && instanceDescriptorColumnDB2.getTable() == this) {
                    instanceDescriptorColumnDB2.setParent(this.instDescriptorCols);
                    this.instDescriptorCols.add(instanceDescriptorColumnDB2);
                } else {
                    this.instDescriptorCols.remove(instanceDescriptorColumnDB2);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof TriggerDB2) {
                TriggerDB2 triggerDB2 = (TriggerDB2)modelObjectSetEvent.getAffected();
                this.triggers.remove(triggerDB2);
                triggerDB2.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof TablePartitionDB2v80) {
                TablePartitionDB2v80 tablePartitionDB2v80 = (TablePartitionDB2v80)modelObjectSetEvent.getAffected();
                this.tablePartitions.remove(tablePartitionDB2v80);
                for (int i = 0; i < this.tablePartitions.size(); ++i) {
                    ((TablePartitionDB2v80)this.tablePartitions.getElement(i)).removeObjectListener(this);
                    ((TablePartitionDB2v80)this.tablePartitions.getElement(i)).setPartNumber(i + 1);
                    ((TablePartitionDB2v80)this.tablePartitions.getElement(i)).removeObjectListener(this);
                }
                tablePartitionDB2v80.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof SynonymDB2) {
                SynonymDB2 synonymDB2 = (SynonymDB2)modelObjectSetEvent.getAffected();
                this.synonyms.remove(synonymDB2);
                synonymDB2.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof InstanceDescriptorColumnDB2) {
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)modelObjectSetEvent.getAffected();
                this.instDescriptorCols.remove(instanceDescriptorColumnDB2);
                instanceDescriptorColumnDB2.removeObjectListener(this);
            }
        }
    }

    @Override
    public void setPrimaryQuantity(int n) {
        this.primaryQuantity = n;
        this.fireUpdate();
        PRIMARY_QTY_CHANGED.setAffected(this);
        this.fireChange(PRIMARY_QTY_CHANGED);
    }

    public int getNumParts() {
        return this.tablePartitions.size();
    }

    public TablePartitionDB2[] getPartitions() {
        TablePartitionSetDB2 tablePartitionSetDB2 = ((StorageDesignDB2v80)this.getStorageDesign()).getTablePartitionSet();
        return tablePartitionSetDB2.getPartitionsFor(this);
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(TableProxyDB2v80.getYesNoChoices()));
        }
        return yesNoSet.contains(string);
    }

    public static String[] getTableAccessChoices() {
        return TABLE_ACCESS_STATES;
    }

    protected boolean checkTableAccess(String string) {
        if (tableAccessSet == null) {
            tableAccessSet = new HashSet();
            tableAccessSet.addAll(Arrays.asList(TableProxyDB2v80.getTableAccessChoices()));
        }
        return tableAccessSet.contains(string);
    }

    public String getMaterializedQuery() {
        return this.materializedQuery;
    }

    public void setMaterializedQuery(String string) {
        if (this.checkYesNo(string)) {
            this.materializedQuery = string;
            this.fireDataFieldChange();
        }
    }

    public String getPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(String string) {
        if (this.checkYesNo(string)) {
            if (string.equalsIgnoreCase(YES_NO_STATES[0]) && this.tableSpace != null) {
                ((TableSpaceDB2v80)this.tableSpace).setPartTable(this);
            }
            if (string.equalsIgnoreCase(YES_NO_STATES[0])) {
                this.enablePartitions();
            } else {
                this.disablePartitions();
            }
            this.partitioned = string;
            this.fireDataFieldChange();
        }
    }

    public String getTableAccess() {
        return this.tableAccess;
    }

    public void setTableAccess(String string) {
        if (this.checkTableAccess(string)) {
            this.tableAccess = string;
            this.fireDataFieldChange();
        }
    }

    public static String[] getMQStatusChoices() {
        return MQ_STATUS_STATES;
    }

    protected boolean checkMQStatus(String string) {
        if (mqStatusSet == null) {
            mqStatusSet = new HashSet();
            mqStatusSet.addAll(Arrays.asList(TableProxyDB2v80.getMQStatusChoices()));
        }
        return mqStatusSet.contains(string);
    }

    public static String[] getMQMaintenanceChoices() {
        return MQ_MAINTENANCE_STATES;
    }

    protected boolean checkMQMaintenance(String string) {
        if (mqMaintenanceSet == null) {
            mqMaintenanceSet = new HashSet();
            mqMaintenanceSet.addAll(Arrays.asList(TableProxyDB2v80.getMQMaintenanceChoices()));
        }
        return mqMaintenanceSet.contains(string);
    }

    public static String[] getMQQueryOptimizationChoices() {
        return MQ_QUERY_OPTIMIZATION_STATES;
    }

    protected boolean checkMQQueryOptimization(String string) {
        if (mqQueryOptimizationSet == null) {
            mqQueryOptimizationSet = new HashSet();
            mqQueryOptimizationSet.addAll(Arrays.asList(TableProxyDB2v80.getMQQueryOptimizationChoices()));
        }
        return mqQueryOptimizationSet.contains(string);
    }

    public static String[] getMQIdentityColumnAttrChoices() {
        return MQ_IDENTITY_COLUMN_ATTR_STATES;
    }

    protected boolean checkMQIdentityColumnAttr(String string) {
        if (mqIdentityColumnAttrSet == null) {
            mqIdentityColumnAttrSet = new HashSet();
            mqIdentityColumnAttrSet.addAll(Arrays.asList(TableProxyDB2v80.getMQIdentityColumnAttrChoices()));
        }
        return mqIdentityColumnAttrSet.contains(string);
    }

    public static String[] getMQColumnDefaultsChoices() {
        return MQ_COLUMN_DEFAULTS_STATES;
    }

    protected boolean checkMQColumnDefaults(String string) {
        if (mqColumnDefaultsSet == null) {
            mqColumnDefaultsSet = new HashSet();
            mqColumnDefaultsSet.addAll(Arrays.asList(TableProxyDB2v80.getMQColumnDefaultsChoices()));
        }
        return mqColumnDefaultsSet.contains(string);
    }

    public String getMqColumnDefaults() {
        return this.mqColumnDefaults;
    }

    public void setMqColumnDefaults(String string) {
        if (this.checkMQColumnDefaults(string)) {
            this.mqColumnDefaults = string;
            this.fireDataFieldChange();
        }
    }

    public String getMqIdentityColumnAttr() {
        return this.mqIdentityColumnAttr;
    }

    public void setMqIdentityColumnAttr(String string) {
        if (this.checkMQIdentityColumnAttr(string)) {
            this.mqIdentityColumnAttr = string;
            this.fireDataFieldChange();
        }
    }

    public String getMqMaintenance() {
        return this.mqMaintenance;
    }

    public void setMqMaintenance(String string) {
        if (this.checkMQMaintenance(string)) {
            this.mqMaintenance = string;
            this.fireDataFieldChange();
        }
    }

    public String getMqQueryDefinition() {
        return this.mqQueryDefinition;
    }

    public void setMqQueryDefinition(String string) {
        this.mqQueryDefinition = string;
        this.fireDataFieldChange();
    }

    public String getMqQueryOptimization() {
        return this.mqQueryOptimization;
    }

    public void setMqQueryOptimization(String string) {
        if (this.checkMQQueryOptimization(string)) {
            this.mqQueryOptimization = string;
            this.fireDataFieldChange();
        }
    }

    public String getMqStatus() {
        return this.mqStatus;
    }

    public void setMqStatus(String string) {
        if (this.checkMQStatus(string)) {
            this.mqStatus = string;
            this.fireDataFieldChange();
        }
    }

    public String getPartitioningKey() {
        return this.partitioningKey;
    }

    public void setPartitioningKey(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePartitioningKeySet(string);
        } else {
            this.addColumnToPartitioningKey(string);
        }
        this.partitioningKey = this.getPartitioningKeySet().toString();
        this.fireDataFieldChange();
    }

    private void addColumnToPartitioningKey(String string) {
        this.getPartitioningKeySet().add(string);
    }

    private void recreatePartitioningKeySet(String string) {
        this.getPartitioningKeySet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.partitioningKeySet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getPartitioningKeySet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getPartitioningKeySet() {
        if (this.partitioningKeySet == null) {
            this.partitioningKeySet = new InlineList();
        }
        return this.partitioningKeySet;
    }

    public void clear() {
        this.getPartitioningKeySet().removeAllElements();
        this.partitioningKey = "";
    }

    public String getPartKeySortOrder(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.partitioningKey, ",");
        String string2 = "";
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            string3 = stringTokenizer.nextToken().trim();
            if (!string2.equalsIgnoreCase(string)) continue;
            return string3;
        }
        return "ASC";
    }

    @Override
    public void setTableSpace(TableSpaceDB2 tableSpaceDB2) {
        if (this.tableSpace != tableSpaceDB2) {
            if (this.tableSpace != null) {
                ((TableSpaceDB2v80)this.tableSpace).setPartTable(null);
                this.tableSpace.setMaxPartitionCount(0);
            }
            if (this.partitioned.equalsIgnoreCase(YES_NO_STATES[0]) && tableSpaceDB2 != null) {
                ((TableSpaceDB2v80)tableSpaceDB2).setPartTable(this);
                tableSpaceDB2.setMaxPartitionCount(this.getPartitions().length);
            }
            this.tableSpace = tableSpaceDB2;
            this.fireDataFieldChange();
        }
    }

    public StorageObjectCollection getFkeys() {
        return this.fkeys;
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Owner", this, "getOwner", "setOwner", Owner.class));
            this.propertyWrapperList.add(new PropertyWrapper("TableSpace", this, "getTableSpace", "setTableSpace", TableSpaceDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Edit Proc", this, "getEditProc", "setEditProc", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Valid Proc", this, "getValidProc", "setValidProc", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Audit", this, "getAudit", "setAudit", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Data Capture", this, "getDataCapture", "setDataCapture", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Drop Restrict", this, "getDropRestrict", "setDropRestrict", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("CCSID", this, "getCcsid", "setCcsid", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partitioned", this, "getPartitioned", "setPartitioned", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Materialized Query", this, "getMaterializedQuery", "setMaterializedQuery", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Table Access", this, "getTableAccess", "setTableAccess", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        Table table = (Table)((StorageDesignDB2v80)storageDesign).getPhysicalDesign().getTableSet().getByName(this.getObject().getName());
        TableProxyDB2v80 tableProxyDB2v80 = null;
        RelationalObjectProxy relationalObjectProxy = ((StorageDesignDB2v80)storageDesign).getTableProxySet().getProxy(table.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            tableProxyDB2v80 = (TableProxyDB2v80)relationalObjectProxy;
        }
        if (tableProxyDB2v80 != null) {
            StorageObject storageObject;
            StorageObject storageObject2;
            StorageObject storageObject3;
            tableProxyDB2v80.setName(this.getName());
            Iterator iterator = this.getTablePartitions().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (TablePartitionDB2v80)iterator.next();
                storageObject2 = (TablePartitionDB2v80)((StorageDesignDB2v80)storageDesign).getTablePartitionSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    storageObject = (TablePartitionDB2v80)((StorageDesignDB2v80)storageDesign).getTablePartitionSet().createTablePartition();
                    storageObject.setName(storageObject3.getName());
                    storageObject.setRawObject(true);
                    ((TablePartitionDB2v80)storageObject).setTable(tableProxyDB2v80);
                    continue;
                }
                ((TablePartitionDB2v80)storageObject2).setTable(tableProxyDB2v80);
            }
            iterator = this.getSynonyms().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (SynonymDB2)iterator.next();
                storageObject2 = (SynonymDB2)((StorageDesignDB2v80)storageDesign).getSynonymSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    storageObject = ((StorageDesignDB2v80)storageDesign).getSynonymSet().createSynonym();
                    storageObject.setName(storageObject3.getName());
                    storageObject.setRawObject(true);
                    ((SynonymDB2)storageObject).setTable(tableProxyDB2v80);
                    continue;
                }
                ((SynonymDB2)storageObject2).setTable(tableProxyDB2v80);
            }
            iterator = this.getTriggers().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (TriggerDB2v80)iterator.next();
                storageObject2 = (TriggerDB2v80)((StorageDesignDB2v80)storageDesign).getTriggerSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    storageObject = (TriggerDB2v80)((StorageDesignDB2v80)storageDesign).getTriggerSet().createTrigger();
                    storageObject.setName(storageObject3.getName());
                    storageObject.setRawObject(true);
                    ((TriggerDB2)storageObject).setTable(tableProxyDB2v80);
                    tableProxyDB2v80.addTriggersFromDesign(((StorageDesignDB2v80)storageDesign).getTriggerSet());
                    continue;
                }
                ((TriggerDB2)storageObject2).setTable(tableProxyDB2v80);
                tableProxyDB2v80.addTriggersFromDesign(((StorageDesignDB2v80)storageDesign).getTriggerSet());
            }
            if (this.getOwner() != null) {
                storageObject3 = (Owner)((StorageDesignDB2v80)storageDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (storageObject3 == null) {
                    storageObject2 = (Owner)((StorageDesignDB2v80)storageDesign).getOwnerSet().createElement(null);
                    storageObject2.setName(this.getOwner().getName());
                    storageObject2.setRawObject(true);
                    tableProxyDB2v80.setOwner((Owner)storageObject2);
                } else {
                    tableProxyDB2v80.setOwner((Owner)storageObject3);
                }
            }
            if (this.getTableSpace() != null) {
                storageObject3 = (TableSpaceDB2)((StorageDesignDB2v80)storageDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (storageObject3 == null) {
                    storageObject2 = ((StorageDesignDB2v80)storageDesign).getTableSpaceSet().createTableSpace();
                    storageObject2.setName(this.getTableSpace().getName());
                    storageObject2.setRawObject(true);
                    tableProxyDB2v80.setTableSpace((TableSpaceDB2)storageObject2);
                } else {
                    tableProxyDB2v80.setTableSpace((TableSpaceDB2)storageObject3);
                }
            }
            tableProxyDB2v80.setObid(this.getObid());
            tableProxyDB2v80.setEditProc(this.getEditProc());
            tableProxyDB2v80.setValidProc(this.getValidProc());
            tableProxyDB2v80.setAudit(this.getAudit());
            tableProxyDB2v80.setDataCapture(this.getDataCapture());
            tableProxyDB2v80.setDropRestrict(this.getDropRestrict());
            tableProxyDB2v80.setCcsid(this.getCcsid());
            tableProxyDB2v80.setLabel(this.getLabel());
            tableProxyDB2v80.setPartitioned(this.getPartitioned());
            tableProxyDB2v80.setMaterializedQuery(this.getMaterializedQuery());
            tableProxyDB2v80.setTableAccess(this.getTableAccess());
            tableProxyDB2v80.setMqQueryDefinition(this.getMqQueryDefinition());
            tableProxyDB2v80.setMqStatus(this.getMqStatus());
            tableProxyDB2v80.setMqMaintenance(this.getMqMaintenance());
            tableProxyDB2v80.setMqQueryOptimization(this.getMqQueryOptimization());
            tableProxyDB2v80.setMqIdentityColumnAttr(this.getMqIdentityColumnAttr());
            tableProxyDB2v80.setMqColumnDefaults(this.getMqColumnDefaults());
            tableProxyDB2v80.setComment(this.getComment());
            tableProxyDB2v80.setCommentInRDBMS(this.getCommentInRDBMS());
            tableProxyDB2v80.setRawObject(false);
        }
    }

    public TablePartitionDB2v80 createPartition() {
        TablePartitionDB2v80 tablePartitionDB2v80 = (TablePartitionDB2v80)this.tablePartitions.createElement(null);
        tablePartitionDB2v80.setTable(this);
        return tablePartitionDB2v80;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

