/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObject;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObjectImpl;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.TableViewPropertyDialogDB2;

public class TableViewProxyDB2
extends TableViewProxy
implements OwnedObject,
ModelObjectSetListener,
StorageObjectListener {
    private OwnedObjectImpl ownedObjectImpl = null;
    private String labelOn = "";
    public static final String CASCADED_CHECK_OPTIONS = "CASCADED";
    public static final String LOCAL_CHECK_OPTIONS = "LOCAL";
    public static String[] availableCheckOptionScopes = new String[]{"CASCADED", "LOCAL"};
    private String checkOptionScope = "CASCADED";
    private StorageObjectCollection synonyms;

    public TableViewProxyDB2(TableView tableView, StorageDesign storageDesign) {
        super(tableView, storageDesign);
        this.synonyms = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("TableViewProxyDB2.Synonyms"));
        this.synonyms.setClassForParent(TableViewProxyDB2.class);
        this.synonyms.setSetMethod("setView");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
    }

    public TableViewProxyDB2(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.synonyms = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("TableViewProxyDB2.Synonyms"));
        this.synonyms.setClassForParent(TableViewProxyDB2.class);
        this.synonyms.setSetMethod("setView");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof SynonymDB2) {
                SynonymDB2 synonymDB2 = (SynonymDB2)modelObjectSetEvent.getAffected();
                synonymDB2.addObjectListener(this);
                if (synonymDB2.getView() != null && synonymDB2.getView() == this) {
                    synonymDB2.setParent(this.synonyms);
                    this.synonyms.add(synonymDB2);
                } else {
                    this.synonyms.remove(synonymDB2);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof SynonymDB2) {
            SynonymDB2 synonymDB2 = (SynonymDB2)modelObjectSetEvent.getAffected();
            this.synonyms.remove(synonymDB2);
            synonymDB2.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof SynonymDB2) {
            SynonymDB2 synonymDB2 = (SynonymDB2)objectChangeEvent.getAffected();
            if (synonymDB2.getView() != null && synonymDB2.getView() == this) {
                synonymDB2.setParent(this.synonyms);
                this.synonyms.add(synonymDB2);
            } else {
                this.synonyms.remove(synonymDB2);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.synonyms;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.synonyms.removeAll();
    }

    @Override
    public void setOwner(Owner owner) {
        this.getOwnedObjectImpl().setOwner(owner);
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public Owner getOwner() {
        return this.getOwnedObjectImpl().getOwner();
    }

    private OwnedObjectImpl getOwnedObjectImpl() {
        if (this.ownedObjectImpl == null) {
            this.ownedObjectImpl = new OwnedObjectImpl();
            this.ownedObjectImpl.setOwnerSet(((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet());
        }
        return this.ownedObjectImpl;
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !this.getOwner().isNullInstance() && !"".equalsIgnoreCase(this.getOwner().getName())) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        ContainerObject containerObject = (ContainerObject)this.getObject();
        SchemaObject schemaObject = containerObject.getSchemaObject();
        if (schemaObject != null) {
            StorageObject storageObject = ((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getBySchemaObject(schemaObject);
            if (storageObject != null && !storageObject.isNullInstance()) {
                return new StringBuffer(storageObject.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(schemaObject.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    public void setLabelOn(String string) {
        if (string.length() <= 30) {
            this.labelOn = string;
            this.fireDataFieldChange();
        }
    }

    public String getLabelOn() {
        return this.labelOn;
    }

    public static String[] getAvailableCheckOptionScopes() {
        return availableCheckOptionScopes;
    }

    public void setCheckOptionScope(String string) {
        this.checkOptionScope = string;
        this.fireDataFieldChange();
    }

    public String getCheckOptionScope() {
        return this.checkOptionScope;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableViewPropertyDialogDB2 tableViewPropertyDialogDB2 = new TableViewPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tableViewPropertyDialogDB2.show();
        }
    }

    protected void addSynonymsFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            SynonymDB2 synonymDB2 = (SynonymDB2)iterator.next();
            if (synonymDB2.getView() != null && synonymDB2.getView() == this) {
                synonymDB2.setParent(this.synonyms);
                this.synonyms.add(synonymDB2);
                continue;
            }
            this.synonyms.remove(synonymDB2);
        }
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    @Override
    public void clearMergableStructure(Map map) {
        if (map != null) {
            ArrayList arrayList = new ArrayList();
            this.synonyms.addAllElementsTo(arrayList);
            for (StorageObject storageObject : arrayList) {
                if (map.get(storageObject.getObjectID()) != null) continue;
                storageObject.remove(true);
            }
        }
    }

    public SynonymDB2 createSynonym() {
        SynonymDB2 synonymDB2 = (SynonymDB2)this.synonyms.createElement(null);
        synonymDB2.setView(this);
        return synonymDB2;
    }
}

