/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.IndexProxySetDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.TableSpacePropertyDialogDB2;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableSpaceDB2
extends DataBaseSpaceDB2
implements ModelObjectSetListener,
PropertiesPropagator {
    public static final String NEW_LINE = "\n";
    public static final String TYPE_NORMAL = "REGULAR";
    public static final String TYPE_MEMBER_CLUSTER = "MEMBER_CLUSTER";
    public static final String TYPE_PARTITIONED = "PARTITIONED";
    public static final String TYPE_MC_PARTITIONED = "MC_PARTITIONED";
    public static final String TYPE_LOB = "LOB";
    public static final String LOCKSIZE_ANY = "ANY";
    public static final String LOCKSIZE_PAGE = "PAGE";
    public static final String LOCKSIZE_TABLESPACE = "TABLESPACE";
    public static final String LOCKSIZE_TABLE = "TABLE";
    public static final String LOCKSIZE_ROW = "ROW";
    public static final String LOCKSIZE_LOB = "LOB";
    public static final String CCSID_ASCII = "ASCII";
    public static final String CCSID_EBCDIC = "EBCDIC";
    public static final String CCSID_UNICODE = "UNICODE";
    private static final String[] CCSIDS = new String[]{"", "ASCII", "EBCDIC", "UNICODE"};
    private static final String[] TYPES = new String[]{"REGULAR", "PARTITIONED", "LOB"};
    private static final String[] LOCKSIZES = new String[]{"ANY", "PAGE", "TABLESPACE", "TABLE", "ROW", "LOB"};
    private static final String[] DS_SIZE = new String[]{"", "1 G", "2 G", "4 G", "8 G", "16 G", "32 G", "64 G"};
    private static final String[] SEG_SIZE = new String[]{"0", "4", "8", "12", "16", "20", "24", "28", "32", "36", "40", "44", "48", "52", "56", "60", "64"};
    protected String type = TYPES[0];
    private String clustered = YES_NO_STATES[1];
    private DataBaseDB2 dataBase = null;
    private StorageTemplateDB2 storageTemplate = null;
    private boolean lobLogging = true;
    private String dsSize = DS_SIZE[0];
    private String segSize = SEG_SIZE[0];
    protected IndexProxyDB2 partIndex = null;
    private BufferPoolDB2 bufferPool = null;
    private String lockSize = LOCKSIZES[0];
    private int lockMax = 0;
    private boolean close = true;
    private boolean compress = false;
    private String ccsid = CCSIDS[0];
    private boolean lockPart = false;
    private int maxRows = 0;
    protected int numParts = 0;
    private int obid = 0;
    private int psid = 0;
    private int nactive = 0;
    private String createdBy = "";
    private int pageSave = 0;
    private static final int PRIQTY = 1;
    private static final int SECQTY = 2;
    private StringBuffer proposedQTYRemarks = new StringBuffer();
    private int fragmentationPCT = 10;
    private int compressionPercentage = 0;
    private StorageObjectCollection partitions;
    private String users = "";
    private UserSet userSet = null;
    private String grantOption = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    private List propertyWrapperList = null;
    public static final String TYPE_NAME = "TSpace";
    public static final String OLD_TYPE_NAME = "TableSpace";
    private static int maxQTY = 0x400000;

    public TableSpaceDB2() {
    }

    public TableSpaceDB2(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.partitions = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getPartitionSet());
        this.partitions.setParent(this);
        this.partitions.setName(Messages.getString("TableSpaceDB2.Partitions"));
        this.partitions.setSetMethod("setTableSpace");
        this.partitions.setClassForParent(TableSpaceDB2.class);
        this.partitions.setAllowedNumberOfElements(0);
        this.partitions.addSetListener(this);
        this.partitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getPartitionSet().addSetListener(this);
    }

    public StorageObjectCollection getTSPartitions() {
        return this.partitions;
    }

    @Override
    public String getIDPrefix() {
        return "TS";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        if (string != null && string.equals(this.type)) {
            return;
        }
        if (TYPE_MC_PARTITIONED.equalsIgnoreCase(string)) {
            this.type = TYPE_PARTITIONED;
            this.clustered = YES;
        } else if (TYPE_MEMBER_CLUSTER.equalsIgnoreCase(string)) {
            this.clustered = YES;
        } else {
            this.type = string;
        }
        this.fireDataFieldChange();
    }

    @Override
    public DataBaseDB2 getDataBase() {
        return this.dataBase;
    }

    @Override
    public void setDataBase(DataBaseDB2 dataBaseDB2) {
        if (dataBaseDB2 == null) {
            DataBaseDB2 dataBaseDB22 = null;
            Iterator iterator = ((AbstractStorageDesignDB2)this.getStorageDesign()).getDataBaseSet().iterator();
            while (iterator.hasNext() && !(dataBaseDB22 = (DataBaseDB2)iterator.next()).isSystemDatabase()) {
            }
            if (dataBaseDB22 != null) {
                this.dataBase = dataBaseDB22;
                this.fireDataFieldChange();
            }
        } else if (dataBaseDB2 != this.dataBase) {
            this.dataBase = dataBaseDB2;
            this.fireDataFieldChange();
        }
    }

    public StorageTemplateDB2 getStorageTemplate() {
        return this.storageTemplate;
    }

    public void setStorageTemplate(StorageTemplateDB2 storageTemplateDB2) {
        this.storageTemplate = storageTemplateDB2;
        this.fireDataFieldChange();
    }

    public boolean isLobLogging() {
        return this.lobLogging;
    }

    public void setLobLogging(boolean bl) {
        this.lobLogging = bl;
        this.fireDataFieldChange();
    }

    public String getDsSize() {
        return this.dsSize;
    }

    public void setDsSize(String string) {
        this.dsSize = string;
        this.fireDataFieldChange();
    }

    public String getSegSize() {
        return this.segSize;
    }

    public void setSegSize(String string) {
        this.segSize = string;
        this.fireDataFieldChange();
    }

    public IndexProxyDB2 getPartIndex() {
        return this.partIndex;
    }

    public void setPartIndex(IndexProxyDB2 indexProxyDB2) {
        if (this.partIndex != indexProxyDB2) {
            this.partIndex = indexProxyDB2;
            if (indexProxyDB2 != null) {
                this.setMaxPartitionCount(indexProxyDB2.getNumParts());
            } else {
                this.setMaxPartitionCount(0);
            }
            this.fireDataFieldChange();
        }
        if (this.partIndex != null && !this.isPartitioned()) {
            this.type = TYPE_PARTITIONED;
            this.fireDataFieldChange();
        }
    }

    public boolean isPartitioned() {
        return this.type.equalsIgnoreCase(TYPE_PARTITIONED) || this.type.equalsIgnoreCase(TYPE_MC_PARTITIONED);
    }

    @Override
    public BufferPoolDB2 getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public void setBufferPool(BufferPoolDB2 bufferPoolDB2) {
        this.bufferPool = bufferPoolDB2;
        this.fireDataFieldChange();
    }

    public String getLockSize() {
        return this.lockSize;
    }

    public void setLockSize(String string) {
        this.lockSize = string;
        this.fireDataFieldChange();
    }

    public int getLockMax() {
        return this.lockMax;
    }

    public void setLockMax(int n) {
        this.lockMax = n;
        this.fireDataFieldChange();
    }

    public boolean isClose() {
        return this.close;
    }

    public void setClose(boolean bl) {
        this.close = bl;
        this.fireDataFieldChange();
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean bl) {
        this.compress = bl;
        this.fireDataFieldChange();
    }

    public String getCcsid() {
        return this.ccsid;
    }

    public void setCcsid(String string) {
        this.ccsid = string;
        this.fireDataFieldChange();
    }

    public boolean isLockPart() {
        return this.lockPart;
    }

    public void setLockPart(boolean bl) {
        this.lockPart = bl;
        this.fireDataFieldChange();
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
        this.fireDataFieldChange();
    }

    public int getNumParts() {
        if (this.partIndex != null) {
            return this.partIndex.getNumParts();
        }
        return this.numParts;
    }

    public void setNumParts(int n) {
        this.numParts = n;
        this.fireDataFieldChange();
    }

    public static String[] getCCSIDValues() {
        return CCSIDS;
    }

    public static String[] getTypeValues() {
        return TYPES;
    }

    public static String[] getLockSizeValues() {
        return LOCKSIZES;
    }

    public static String[] getDSSizeValues() {
        return DS_SIZE;
    }

    public static String[] getSegSizeValues() {
        return SEG_SIZE;
    }

    public void setObid(int n) {
        this.obid = n;
        this.fireDataFieldChange();
    }

    public void setPsid(int n) {
        this.psid = n;
        this.fireDataFieldChange();
    }

    public void setNactive(int n) {
        this.nactive = n;
        this.fireDataFieldChange();
    }

    public int getObid() {
        return this.obid;
    }

    public int getPsid() {
        return this.psid;
    }

    public int getNactive() {
        return this.nactive;
    }

    @Override
    public void setCreatedBy(String string) {
        this.createdBy = string;
        this.fireDataFieldChange();
    }

    public void setPageSave(int n) {
        this.pageSave = n;
        this.fireDataFieldChange();
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    public int getPageSave() {
        return this.pageSave;
    }

    public void setCompressionPercentage(int n) {
        this.compressionPercentage = n;
        this.fireDataFieldChange();
    }

    public void setCompressionRatio(int n) {
        this.setCompressionPercentage(n);
        this.fireDataFieldChange();
    }

    public int getCompressionPercentage() {
        return this.compressionPercentage;
    }

    public int getCompressionRatio() {
        return this.getCompressionPercentage();
    }

    public PartitionDB2[] getPartitions() {
        PartitionSetDB2 partitionSetDB2 = ((AbstractStorageDesignDB2)this.getStorageDesign()).getPartitionSet();
        return partitionSetDB2.getPartitionsFor(this);
    }

    public PartitionSetDB2 getPartitionSet() {
        return ((AbstractStorageDesignDB2)this.getStorageDesign()).getPartitionSet();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableSpacePropertyDialogDB2 tableSpacePropertyDialogDB2 = new TableSpacePropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tableSpacePropertyDialogDB2.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.partitions;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.partitions) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.partitions) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        block8: {
            block9: {
                block7: {
                    PartitionDB2 partitionDB2;
                    if (modelObjectSet != this.partitions) break block7;
                    if (modelObjectSetEvent.isType(1) && modelObjectSetEvent.getAffected() instanceof PartitionDB2 && (partitionDB2 = (PartitionDB2)modelObjectSetEvent.getAffected()).getTableSpace() == null) {
                        partitionDB2.setTableSpace(this);
                        partitionDB2.removeObjectListener(this);
                        if (!this.getStorageDesign().isLoading()) {
                            partitionDB2.setPartNumber(this.partitions.size());
                        }
                        partitionDB2.addObjectListener(this);
                    }
                    break block8;
                }
                if (!modelObjectSetEvent.isType(1)) break block9;
                if (!(modelObjectSetEvent.getAffected() instanceof PartitionDB2)) break block8;
                PartitionDB2 partitionDB2 = (PartitionDB2)modelObjectSetEvent.getAffected();
                partitionDB2.addObjectListener(this);
                if (this != partitionDB2.getTableSpace()) break block8;
                this.partitions.add(modelObjectSetEvent.getAffected());
                partitionDB2.removeObjectListener(this);
                if (!this.getStorageDesign().isLoading()) {
                    partitionDB2.setPartNumber(this.partitions.size());
                }
                partitionDB2.addObjectListener(this);
                break block8;
            }
            if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof PartitionDB2) {
                PartitionDB2 partitionDB2 = (PartitionDB2)modelObjectSetEvent.getAffected();
                partitionDB2.removeObjectListener(this);
                if (this.partitions.contains(partitionDB2)) {
                    this.partitions.remove(modelObjectSetEvent.getAffected());
                    if (!this.getStorageDesign().isLoading()) {
                        for (int i = 0; i < this.partitions.size(); ++i) {
                            partitionDB2.removeObjectListener(this);
                            ((PartitionDB2)this.partitions.getElement(i)).setPartNumber(i + 1);
                            partitionDB2.addObjectListener(this);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof PartitionDB2) {
            PartitionDB2 partitionDB2 = (PartitionDB2)objectChangeEvent.getAffected();
            if (partitionDB2.getTableSpace() != null && partitionDB2.getTableSpace() == this && !this.partitions.contains(partitionDB2)) {
                this.partitions.add(partitionDB2);
                partitionDB2.removeObjectListener(this);
                if (!this.getStorageDesign().isLoading()) {
                    partitionDB2.setPartNumber(this.partitions.size());
                }
                partitionDB2.addObjectListener(this);
            } else if ((partitionDB2.getTableSpace() == null || partitionDB2.getTableSpace() != null && partitionDB2.getTableSpace() != this) && this.partitions.contains(partitionDB2)) {
                this.partitions.remove(partitionDB2);
            }
        }
    }

    public int getProposedPRIQTY() {
        return this.getProposedQTY(1);
    }

    public ArrayList getTables() {
        ArrayList<TableProxyDB2> arrayList = new ArrayList<TableProxyDB2>();
        Iterator iterator = this.getStorageDesign().getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxyDB2 tableProxyDB2 = (TableProxyDB2)iterator.next();
            if (tableProxyDB2.getTableSpace() != this) continue;
            arrayList.add(tableProxyDB2);
        }
        return arrayList;
    }

    public int getProposedQTY(int n) {
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = this.getTables().iterator();
        this.proposedQTYRemarks.setLength(0);
        int n4 = 4;
        if (this.getBufferPool() != null) {
            n4 = this.getBufferPool().pageSize() / 1024;
        }
        int n5 = Integer.parseInt(this.getSegSize());
        while (iterator.hasNext()) {
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            TableProxyDB2 tableProxyDB2 = (TableProxyDB2)iterator.next();
            n7 += tableProxyDB2.getMaxNumberUsedPages();
            n6 += tableProxyDB2.getInitialNumberUsedPages();
            n6 = Math.max(3, n6);
            n7 = Math.max(3, n7);
            if (n5 > 0) {
                if (n6 != n5 && n6 != n6 / n5 * n5) {
                    n6 = (n6 / n5 + 1) * n5;
                    this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("TableSpaceDB2.SizeAdjustedMultiple"), this.getSegSize(), tableProxyDB2.getName()) + NEW_LINE);
                }
                if ((n7 = Math.max(n6, n7)) > n6 && n7 != n5 && n7 != n7 / n5 * n5) {
                    n7 = (n7 / n5 + 1) * n5;
                    this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("TableSpaceDB2.SizeAdjustedMultiple"), this.getSegSize(), tableProxyDB2.getName()) + NEW_LINE);
                }
            } else if ("LOB".equalsIgnoreCase(this.getType())) {
                if (n6 < 50 || n7 < 50) {
                    this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("TableSpaceDB2.SizeAdjustedMinimum"), tableProxyDB2.getName()) + NEW_LINE);
                }
                n6 = Math.max(50, n6);
                n7 = Math.max(50, n7);
            }
            if (n6 * 123 < n7) {
                n6 = (int)Math.ceil((float)n7 / 123.0f);
                this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("TableSpaceDB2.SizeAdjustedMaximum"), tableProxyDB2.getName()) + NEW_LINE);
                if (n5 > 0 && n6 != n5 && n6 != n6 / n5 * n5) {
                    n6 = (n6 / n5 + 1) * n5;
                    this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("TableSpaceDB2.SizeAdjustedMultiple"), this.getSegSize(), tableProxyDB2.getName()) + NEW_LINE);
                }
                n9 = n8 = n6;
            } else {
                n8 = n6;
                n9 = (n7 - n6) / 122;
                n9 = Math.max(n9, n8 * 10 / 100);
                n9 = Math.max(n9, 3);
                n9 = Math.max(n9, n5);
            }
            n8 *= n4;
            n9 *= n4;
            if (n6 == n7) {
                n9 = 0;
            }
            n2 += n8;
            n3 += n9;
        }
        if (this.isSimpleTablespace() && this.getTableCount() > 1 && this.getFragmentationPCT() > 0) {
            this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("TableSpaceDB2.SizeIncreased"), Integer.toString(this.getFragmentationPCT())));
            n2 = (int)((double)n2 * 1.1);
            n3 = (int)((double)n3 * 1.1);
        }
        n2 = Math.min(n2, maxQTY);
        n3 = Math.min(n3, maxQTY);
        return n == 1 ? n2 : n3;
    }

    public int getProposedSECQTY() {
        return this.getProposedQTY(2);
    }

    private boolean isSimpleTablespace() {
        if (this.getType().equalsIgnoreCase("LOB") || this.getType().equalsIgnoreCase(TYPE_MC_PARTITIONED) || this.getType().equalsIgnoreCase(TYPE_PARTITIONED)) {
            return false;
        }
        return Integer.parseInt(this.getSegSize()) <= 0 && this.getNumParts() <= 0 && this.getDsSize().equalsIgnoreCase("");
    }

    private int getTableCount() {
        return this.getTables().size();
    }

    public String getProposedQTYRemarks() {
        return this.proposedQTYRemarks.toString();
    }

    public int getFragmentationPCT() {
        return this.fragmentationPCT;
    }

    public void setFragmentationPCT(int n) {
        this.fragmentationPCT = n;
        this.fireDataFieldChange();
    }

    public int getInitialNumberUsedPages() {
        Iterator iterator = this.getTables().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TableProxyDB2 tableProxyDB2 = (TableProxyDB2)iterator.next();
            n += tableProxyDB2.getInitialNumberUsedPages();
        }
        return n;
    }

    public int getMaxNumberUsedPages() {
        Iterator iterator = this.getTables().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TableProxyDB2 tableProxyDB2 = (TableProxyDB2)iterator.next();
            n += tableProxyDB2.getMaxNumberUsedPages();
        }
        return n;
    }

    public int getInitialNumberUsedKB() {
        int n = 4;
        if (this.getBufferPool() != null) {
            n = this.getBufferPool().pageSize() / 1024;
        }
        return this.getInitialNumberUsedPages() * n;
    }

    public int getMaxNumberUsedKB() {
        int n = 4;
        if (this.getBufferPool() != null) {
            n = this.getBufferPool().pageSize() / 1024;
        }
        return this.getMaxNumberUsedPages() * n;
    }

    public void setMaxPartitionCount(int n) {
        this.partitions.setAllowedNumberOfElements(n);
        if (this.partIndex != null && !this.isPartitioned()) {
            this.type = TYPE_PARTITIONED;
            this.fireDataFieldChange();
        }
    }

    public String getClustered() {
        return this.clustered;
    }

    public void setClustered(String string) {
        this.clustered = string;
        this.fireDataFieldChange();
    }

    private void addUser(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (!this.getUserSet().contains(string2)) {
            this.getUserSet().add(string2);
        }
    }

    public void recreateUserSet(String string) {
        this.getUserSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getUserSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setUsers(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserSet(string);
        } else {
            this.addUser(string);
        }
        this.users = this.getUserSet().toString();
        this.fireDataFieldChange();
    }

    public String getUsers() {
        return this.users;
    }

    public UserSet getUserSet() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        }
        return this.userSet;
    }

    public void clear() {
        this.getUserSet().removeAllElements();
        this.users = "";
    }

    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(YES_NO_STATES));
        }
        return yesNoSet.contains(string);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String string) {
        if (string != null && string.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(string)) {
            this.grantOption = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY && this.getDataBase() != null) {
            return this.getDataBase().isDropEnabled() || this.getDataBase().shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Type", this, "getType", "setType", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Clustered", this, "getClustered", "setClustered", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("DataBase", this, "getDataBase", "setDataBase", DataBaseDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Storage Template", this, "getStorageTemplate", "setStorageTemplate", StorageTemplateDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("DS Size", this, "getDsSize", "setDsSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Seg Size", this, "getSegSize", "setSegSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Buffer Pool", this, "getBufferPool", "setBufferPool", BufferPoolDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Lock Size", this, "getLockSize", "setLockSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Lock Max", this, "getLockMax", "setLockMax", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Close", this, "isClose", "setClose", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Compress", this, "isCompress", "setCompress", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("CCSID", this, "getCcsid", "setCcsid", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Lock Part", this, "isLockPart", "setLockPart", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Max Rows", this, "getMaxRows", "setMaxRows", Integer.TYPE));
        }
        return this.propertyWrapperList;
    }

    public List getPartitionsList() {
        ArrayList arrayList = new ArrayList();
        this.partitions.addAllElementsTo(arrayList);
        return arrayList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        TableSpaceDB2 tableSpaceDB2 = null;
        StorageObject storageObject = (StorageObject)((StorageDesignDB2v70)storageDesign).getTableSpaceSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                tableSpaceDB2 = (TableSpaceDB2)storageObject;
            }
        } else {
            tableSpaceDB2 = ((StorageDesignDB2v70)storageDesign).getTableSpaceSet().createTableSpace();
        }
        if (tableSpaceDB2 != null) {
            StorageObject storageObject2;
            StorageObject storageObject32;
            tableSpaceDB2.setName(this.getName());
            for (StorageObject storageObject32 : this.getPartitionsList()) {
                storageObject2 = (PartitionDB2)((StorageDesignDB2v70)storageDesign).getPartitionSet().getByName(storageObject32.getName());
                if (storageObject2 == null) {
                    PartitionDB2 partitionDB2 = ((StorageDesignDB2v70)storageDesign).getPartitionSet().createPartition();
                    partitionDB2.setName(storageObject32.getName());
                    partitionDB2.setTableSpace(tableSpaceDB2);
                    partitionDB2.setRawObject(true);
                    ((StorageDesignDB2v70)storageDesign).getPartitionSet().add(partitionDB2);
                    continue;
                }
                ((PartitionDB2)storageObject2).setTableSpace(tableSpaceDB2);
                ((StorageDesignDB2v70)storageDesign).getPartitionSet().add(storageObject2);
            }
            tableSpaceDB2.setType(this.getType());
            tableSpaceDB2.setClustered(this.getClustered());
            if (this.getDataBase() != null) {
                storageObject32 = (DataBaseDB2)((StorageDesignDB2v70)storageDesign).getDataBaseSet().getByName(this.getDataBase().getName());
                if (storageObject32 == null) {
                    storageObject2 = ((StorageDesignDB2v70)storageDesign).getDataBaseSet().createDataBase();
                    storageObject2.setName(this.getDataBase().getName());
                    storageObject2.setRawObject(true);
                    tableSpaceDB2.setDataBase((DataBaseDB2)storageObject2);
                } else {
                    tableSpaceDB2.setDataBase((DataBaseDB2)storageObject32);
                }
            }
            if (this.getStorageTemplate() != null) {
                storageObject32 = (StorageTemplateDB2)((StorageDesignDB2v70)storageDesign).getStorageTemplateSet().getByName(this.getStorageTemplate().getName());
                if (storageObject32 == null) {
                    storageObject2 = ((StorageDesignDB2v70)storageDesign).getStorageTemplateSet().createStorageTemplate();
                    storageObject2.setName(this.getStorageTemplate().getName());
                    storageObject2.setRawObject(true);
                    tableSpaceDB2.setStorageTemplate((StorageTemplateDB2)storageObject2);
                } else {
                    tableSpaceDB2.setStorageTemplate((StorageTemplateDB2)storageObject32);
                }
            }
            tableSpaceDB2.setLobLogging(this.isLobLogging());
            tableSpaceDB2.setDsSize(this.getDsSize());
            tableSpaceDB2.setSegSize(this.getSegSize());
            if (this.getPartIndex() != null) {
                storageObject32 = (IndexProxyDB2)((StorageDesignDB2v70)storageDesign).getIndexProxySet().getByName(this.getPartIndex().getName());
                if (storageObject32 == null) {
                    storageObject2 = (IndexProxyDB2)((IndexProxySetDB2v70)((StorageDesignDB2v70)storageDesign).getIndexProxySet()).createProxy(this.getPartIndex().getObject());
                    ((RelationalObjectProxy)storageObject2).setName(this.getPartIndex().getName());
                    storageObject2.setRawObject(true);
                    tableSpaceDB2.setPartIndex((IndexProxyDB2)storageObject2);
                } else {
                    tableSpaceDB2.setPartIndex((IndexProxyDB2)storageObject32);
                }
            }
            tableSpaceDB2.setNumParts(this.getNumParts());
            if (this.getBufferPool() != null) {
                storageObject32 = (BufferPoolDB2)((StorageDesignDB2v70)storageDesign).getBufferPoolSet().getByName(this.getBufferPool().getName());
                if (storageObject32 == null) {
                    storageObject2 = (BufferPoolDB2)((StorageDesignDB2v70)storageDesign).getBufferPoolSet().createElement(null);
                    storageObject2.setName(this.getBufferPool().getName());
                    storageObject2.setRawObject(true);
                    tableSpaceDB2.setBufferPool((BufferPoolDB2)storageObject2);
                } else {
                    tableSpaceDB2.setBufferPool((BufferPoolDB2)storageObject32);
                }
            }
            tableSpaceDB2.setLockSize(this.getLockSize());
            tableSpaceDB2.setLockMax(this.getLockMax());
            tableSpaceDB2.setClose(this.isClose());
            tableSpaceDB2.setCompress(this.isCompress());
            tableSpaceDB2.setCcsid(this.getCcsid());
            tableSpaceDB2.setLockPart(this.isLockPart());
            tableSpaceDB2.setMaxRows(this.getMaxRows());
            tableSpaceDB2.recreateUserSet(this.getUserSet().toString());
            tableSpaceDB2.setGrantOption(this.getGrantOption());
            tableSpaceDB2.setComment(this.getComment());
            tableSpaceDB2.setRawObject(false);
        }
    }

    public boolean isUsedInOtherDefinitions(TableProxyDB2 tableProxyDB2) {
        Iterator iterator = this.getStorageDesign().getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxyDB2 tableProxyDB22 = (TableProxyDB2)iterator.next();
            if (tableProxyDB22.getTableSpace() == null || tableProxyDB22 == tableProxyDB2 || tableProxyDB22.getTableSpace() != this) continue;
            return true;
        }
        return false;
    }

    public void synchronizeStorageTemplateName() {
        StorageTemplateDB2 storageTemplateDB2;
        if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerTableSpace() && (storageTemplateDB2 = this.getStorageTemplate()) != null && !storageTemplateDB2.isUsedInOtherDefinitions(this)) {
            String string = this.getDesign().getAppView().getSettings().getNamingRuleStTablespaceDB2();
            String string2 = ApplyNamingStandards.createTableSpaceStorageTemplateDB2_Name(this.getName(), string, this.getStorageDesign().getPhysicalDesign().getName());
            storageTemplateDB2.setName(string2);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TABLESPACE_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        this.partitions.removeAll();
    }

    public PartitionDB2 createPartition() {
        PartitionDB2 partitionDB2 = (PartitionDB2)this.partitions.createElement(null);
        partitionDB2.setTableSpace(this);
        return partitionDB2;
    }

    public class UserSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

