/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.VolumesDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.StorageGroupPropertyDialogDB2;

public class StorageGroupDB2
extends AbstractStorageObjectDB2 {
    private String volumes = "";
    private VolumeSet volumeSet = null;
    private boolean smsManaged = false;
    private int smsVolumes = 1;
    private VCatDB2 vcat = null;
    private String users = "";
    private UserSet userSet = null;
    private String grantOption = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    private static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String TYPE_NAME = "StorageGroup";

    public StorageGroupDB2(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "STG";
    }

    protected String getDefaultNamePrefix() {
        return "STOGR";
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    private void addVolume(String string) {
        if (!this.getVolumeSet().contains(string)) {
            this.getVolumeSet().add(string);
        }
    }

    public void recreateVolumeSet(String string) {
        this.getVolumeSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (this.getVolumeSet().contains(string2)) continue;
            this.getVolumeSet().add(string2);
        }
        this.volumes = this.getVolumeSet().toString();
        this.fireDataFieldChange();
    }

    public void setVolumes(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateVolumeSet(string);
        } else {
            this.addVolume(string);
        }
        this.volumes = this.getVolumeSet().toString();
        this.fireDataFieldChange();
    }

    public String getVolumes() {
        return this.volumes;
    }

    public String getVolumesNames() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.volumes, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            VolumesDB2 volumesDB2 = (VolumesDB2)this.getStorageDesignDB2().getVolumesSet().getById(string);
            if (volumesDB2 == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(volumesDB2.getName());
        }
        return stringBuffer.toString();
    }

    public void setSMSManaged(boolean bl) {
        if (this.smsManaged != bl) {
            this.smsManaged = bl;
            this.fireDataFieldChange();
        }
    }

    public boolean isSMSManaged() {
        return this.smsManaged;
    }

    public void setSMSVolumes(int n) {
        if (this.smsVolumes != n) {
            this.smsVolumes = n;
            this.fireDataFieldChange();
        }
    }

    public int getSMSVolumes() {
        return this.smsVolumes;
    }

    public VCatDB2 getVCat() {
        return this.vcat;
    }

    public void setVCat(VCatDB2 vCatDB2) {
        if (this.vcat != vCatDB2) {
            this.vcat = vCatDB2;
            this.fireDataFieldChange();
        }
    }

    public String getAsteriskVolumes() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getSMSVolumes(); ++i) {
            stringBuffer.append('\'').append('*').append('\'');
            if (i >= this.getSMSVolumes() - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private void addUser(String string) {
        if (!this.getUserSet().contains(string)) {
            this.getUserSet().add(string);
        }
    }

    public void recreateUserSet(String string) {
        this.getUserSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getUserSet().add(stringTokenizer.nextToken().trim());
        }
        this.users = this.getUserSet().toString();
        this.fireDataFieldChange();
    }

    public void setUsers(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserSet(string);
        } else {
            this.addUser(string);
        }
        this.users = this.getUserSet().toString();
        this.fireDataFieldChange();
    }

    public String getUsers() {
        return this.users;
    }

    public String getUserNames() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.users, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            Owner owner = (Owner)this.getStorageDesignDB2().getOwnerSet().getById(string);
            if (owner == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(owner.getName());
        }
        return stringBuffer.toString();
    }

    public UserSet getUserSet() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        }
        return this.userSet;
    }

    public void clearUsers() {
        this.getUserSet().removeAllElements();
        this.users = "";
    }

    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(YES_NO_STATES));
        }
        return yesNoSet.contains(string);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String string) {
        if (string != null && string.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(string)) {
            this.grantOption = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StorageGroupPropertyDialogDB2 storageGroupPropertyDialogDB2 = new StorageGroupPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            storageGroupPropertyDialogDB2.show();
        }
    }

    public VolumeSet getVolumeSet() {
        if (this.volumeSet == null) {
            this.volumeSet = new VolumeSet();
        }
        return this.volumeSet;
    }

    public void clearVolumes() {
        this.getVolumeSet().removeAllElements();
        this.volumes = "";
    }

    public boolean containsTableSpace(TableSpaceDB2 tableSpaceDB2) {
        return this.getName().equalsIgnoreCase("SYSDEFLT") ? tableSpaceDB2.getStorageTemplate() != null && tableSpaceDB2.getStorageTemplate().getStorageGroup() != null && this == tableSpaceDB2.getStorageTemplate().getStorageGroup() || tableSpaceDB2.getStorageTemplate() != null && tableSpaceDB2.getStorageTemplate().getStorageGroup() == null && tableSpaceDB2.getDataBase() != null && this == tableSpaceDB2.getDataBase().getStorageGroup() || tableSpaceDB2.getStorageTemplate() == null && tableSpaceDB2.getDataBase() != null && this == tableSpaceDB2.getDataBase().getStorageGroup() || tableSpaceDB2.getStorageTemplate() == null && tableSpaceDB2.getDataBase() == null : tableSpaceDB2.getStorageTemplate() != null && tableSpaceDB2.getStorageTemplate().getStorageGroup() != null && this == tableSpaceDB2.getStorageTemplate().getStorageGroup() || tableSpaceDB2.getStorageTemplate() != null && tableSpaceDB2.getStorageTemplate().getStorageGroup() == null && tableSpaceDB2.getDataBase() != null && this == tableSpaceDB2.getDataBase().getStorageGroup() || tableSpaceDB2.getStorageTemplate() == null && tableSpaceDB2.getDataBase() != null && this == tableSpaceDB2.getDataBase().getStorageGroup();
    }

    public boolean containsIndex(IndexProxyDB2 indexProxyDB2) {
        TableProxyDB2 tableProxyDB2 = (TableProxyDB2)indexProxyDB2.getTableProxy();
        return this.getName().equalsIgnoreCase("SYSDEFLT") ? indexProxyDB2.getStorageTemplate() != null && indexProxyDB2.getStorageTemplate().getStorageGroup() != null && this == indexProxyDB2.getStorageTemplate().getStorageGroup() || indexProxyDB2.getStorageTemplate() != null && indexProxyDB2.getStorageTemplate().getStorageGroup() == null && indexProxyDB2.getTableProxy() != null && tableProxyDB2.getTableSpace() != null && tableProxyDB2.getTableSpace().getDataBase() != null && tableProxyDB2.getTableSpace().getDataBase().getStorageGroup() != null && this == tableProxyDB2.getTableSpace().getDataBase().getStorageGroup() || indexProxyDB2.getStorageTemplate() == null && tableProxyDB2.getTableSpace() != null && tableProxyDB2.getTableSpace().getDataBase() != null && tableProxyDB2.getTableSpace().getDataBase().getStorageGroup() != null && this == tableProxyDB2.getTableSpace().getDataBase().getStorageGroup() || indexProxyDB2.getStorageTemplate() == null && tableProxyDB2.getTableSpace() != null && tableProxyDB2.getTableSpace().getDataBase() != null && tableProxyDB2.getTableSpace().getDataBase().getStorageGroup() == null || indexProxyDB2.getStorageTemplate() == null && tableProxyDB2.getTableSpace() == null : indexProxyDB2.getStorageTemplate() != null && indexProxyDB2.getStorageTemplate().getStorageGroup() != null && this == indexProxyDB2.getStorageTemplate().getStorageGroup() || indexProxyDB2.getStorageTemplate() != null && indexProxyDB2.getStorageTemplate().getStorageGroup() == null && indexProxyDB2.getTableProxy() != null && tableProxyDB2.getTableSpace() != null && tableProxyDB2.getTableSpace().getDataBase() != null && tableProxyDB2.getTableSpace().getDataBase().getStorageGroup() != null && this == tableProxyDB2.getTableSpace().getDataBase().getStorageGroup() || indexProxyDB2.getStorageTemplate() == null && indexProxyDB2.getTableProxy() != null && tableProxyDB2.getTableSpace() != null && tableProxyDB2.getTableSpace().getDataBase() != null && tableProxyDB2.getTableSpace().getDataBase().getStorageGroup() != null && this == tableProxyDB2.getTableSpace().getDataBase().getStorageGroup();
    }

    public boolean containsAUXTableIndex(AUXTableIndexDB2 aUXTableIndexDB2) {
        return this.getName().equalsIgnoreCase("SYSDEFLT") ? aUXTableIndexDB2.getStorageTemplate() != null && aUXTableIndexDB2.getStorageTemplate().getStorageGroup() != null && this == aUXTableIndexDB2.getStorageTemplate().getStorageGroup() || aUXTableIndexDB2.getStorageTemplate() != null && aUXTableIndexDB2.getStorageTemplate().getStorageGroup() == null && aUXTableIndexDB2.getTableProxy() != null && aUXTableIndexDB2.getTableProxy().getTableSpace() != null && aUXTableIndexDB2.getTableProxy().getTableSpace().getDataBase() != null && aUXTableIndexDB2.getTableProxy().getTableSpace().getDataBase().getStorageGroup() != null && this == aUXTableIndexDB2.getTableProxy().getTableSpace().getDataBase().getStorageGroup() || aUXTableIndexDB2.getStorageTemplate() == null && aUXTableIndexDB2.getTableProxy() != null && aUXTableIndexDB2.getTableProxy().getTableSpace() != null && aUXTableIndexDB2.getTableProxy().getTableSpace().getDataBase() != null && aUXTableIndexDB2.getTableProxy().getTableSpace().getDataBase().getStorageGroup() != null && this == aUXTableIndexDB2.getTableProxy().getTableSpace().getDataBase().getStorageGroup() || aUXTableIndexDB2.getStorageTemplate() == null && aUXTableIndexDB2.getTableProxy() != null && aUXTableIndexDB2.getTableProxy().getTableSpace() != null && aUXTableIndexDB2.getTableProxy().getTableSpace().getDataBase() != null && aUXTableIndexDB2.getTableProxy().getTableSpace().getDataBase().getStorageGroup() == null || aUXTableIndexDB2.getStorageTemplate() == null && aUXTableIndexDB2.getTableProxy().getTableSpace() == null : aUXTableIndexDB2.getStorageTemplate() != null && aUXTableIndexDB2.getStorageTemplate().getStorageGroup() != null && this == aUXTableIndexDB2.getStorageTemplate().getStorageGroup() || aUXTableIndexDB2.getStorageTemplate() != null && aUXTableIndexDB2.getStorageTemplate().getStorageGroup() == null && aUXTableIndexDB2.getTableProxy() != null && aUXTableIndexDB2.getTableProxy().getTableSpace() != null && aUXTableIndexDB2.getTableProxy().getTableSpace().getDataBase() != null && aUXTableIndexDB2.getTableProxy().getTableSpace().getDataBase().getStorageGroup() != null && this == aUXTableIndexDB2.getTableProxy().getTableSpace().getDataBase().getStorageGroup() || aUXTableIndexDB2.getStorageTemplate() == null && aUXTableIndexDB2.getTableProxy() != null && aUXTableIndexDB2.getTableProxy().getTableSpace() != null && aUXTableIndexDB2.getTableProxy().getTableSpace().getDataBase() != null && aUXTableIndexDB2.getTableProxy().getTableSpace().getDataBase().getStorageGroup() != null && this == aUXTableIndexDB2.getTableProxy().getTableSpace().getDataBase().getStorageGroup();
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        StorageGroupDB2 storageGroupDB2 = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)storageDesign).getStorageGroupSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                storageGroupDB2 = (StorageGroupDB2)storageObject;
            }
        } else {
            storageGroupDB2 = ((AbstractStorageDesignDB2)storageDesign).getStorageGroupSet().createStorageGroup();
        }
        if (storageGroupDB2 != null) {
            storageGroupDB2.setName(this.getName());
            if (this.getVCat() != null) {
                VCatDB2 vCatDB2 = (VCatDB2)((AbstractStorageDesignDB2)storageDesign).getVCatSet().getByName(this.getVCat().getName());
                if (vCatDB2 == null) {
                    VCatDB2 vCatDB22 = ((AbstractStorageDesignDB2)storageDesign).getVCatSet().createVCat();
                    vCatDB22.setName(this.getVCat().getName());
                    vCatDB22.setRawObject(true);
                    storageGroupDB2.setVCat(vCatDB22);
                } else {
                    storageGroupDB2.setVCat(vCatDB2);
                }
            }
            storageGroupDB2.setSMSManaged(this.isSMSManaged());
            storageGroupDB2.setSMSVolumes(this.getSMSVolumes());
            storageGroupDB2.recreateVolumeSet(this.getVolumeSet().toString());
            storageGroupDB2.recreateUserSet(this.getUserSet().toString());
            storageGroupDB2.setGrantOption(this.getGrantOption());
            storageGroupDB2.setRawObject(false);
            storageGroupDB2.setComment(this.getComment());
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public class UserSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }

    public class VolumeSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

