/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;

public class PrivilegesDB2
extends StorageObject {
    protected DataBaseDB2 db = null;
    protected Owner user = null;
    private String systemPrivileges = "";
    private PrivilegesSet systemPrivilegesSet = null;
    private static final String[] PRIVILEGES = new String[]{"DBADM", "DBCTRL", "DBMAINT", "CREATETAB", "CREATETS", "DISPLAYDB", "DROP", "IMAGCOMPY", "LOAD", "RECOVERDB", "REORG", "REPAIR", "STARTDB", "STATS", "STOPDB"};
    public static final List PRIVILEGESLIST = Arrays.asList(PRIVILEGES);
    private String grantOption = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String TYPE_NAME = "Privileges";

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Priv";
    }

    private void addSystemPrivileges(String string) {
        if (!this.getSystemPrivilegesSet().contains(string)) {
            this.getSystemPrivilegesSet().add(string);
        }
    }

    private void recreateSystemPrivilegesSet(String string) {
        this.getSystemPrivilegesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.systemPrivilegesSet = new PrivilegesSet();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (!this.checkPrivileges(string2)) continue;
            this.getSystemPrivilegesSet().add(string2);
        }
    }

    public void setSystemPrivileges(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(string);
        } else if (this.checkPrivileges(string)) {
            this.addSystemPrivileges(string);
        }
        this.systemPrivileges = this.getSystemPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public String getSystemPrivileges() {
        return this.systemPrivileges;
    }

    public PrivilegesSet getSystemPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new PrivilegesSet();
        }
        return this.systemPrivilegesSet;
    }

    public static List getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    protected boolean checkPrivileges(String string) {
        return PRIVILEGESLIST.contains(string);
    }

    public void clear() {
        this.getSystemPrivilegesSet().removeAllElements();
        this.systemPrivileges = "";
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(PrivilegesDB2.getYesNoChoices()));
        }
        return yesNoSet.contains(string);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String string) {
        if (string != null && string.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(string)) {
            this.grantOption = string;
            this.fireDataFieldChange();
        }
    }

    public DataBaseDB2 getDb() {
        return this.db;
    }

    public void setDb(DataBaseDB2 dataBaseDB2) {
        if (this.db != dataBaseDB2) {
            this.db = dataBaseDB2;
            this.fireDataFieldChange();
        }
    }

    public Owner getUser() {
        return this.user;
    }

    public void setUser(Owner owner) {
        if (this.user != owner) {
            this.user = owner;
            this.setPAC_Element(owner);
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        PrivilegesDB2 privilegesDB2 = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)storageDesign).getPrivilegesSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                privilegesDB2 = (PrivilegesDB2)storageObject;
            }
        } else {
            privilegesDB2 = ((AbstractStorageDesignDB2)storageDesign).getPrivilegesSet().createPriv();
        }
        if (privilegesDB2 != null) {
            StorageObject storageObject2;
            StorageObject storageObject3;
            privilegesDB2.setName(this.getName());
            if (this.getDb() != null) {
                storageObject3 = (DataBaseDB2)((AbstractStorageDesignDB2)storageDesign).getDataBaseSet().getByName(this.getDb().getName());
                if (storageObject3 == null) {
                    storageObject2 = ((AbstractStorageDesignDB2)storageDesign).getDataBaseSet().createDataBase();
                    storageObject2.setName(this.getDb().getName());
                    storageObject2.setRawObject(true);
                    privilegesDB2.setDb((DataBaseDB2)storageObject2);
                } else {
                    privilegesDB2.setDb((DataBaseDB2)storageObject3);
                }
            }
            if (this.getUser() != null) {
                storageObject3 = (Owner)((AbstractStorageDesignDB2)storageDesign).getOwnerSet().getByName(this.getUser().getName());
                if (storageObject3 == null) {
                    storageObject2 = (Owner)((AbstractStorageDesignDB2)storageDesign).getOwnerSet().createElement(null);
                    storageObject2.setName(this.getUser().getName());
                    storageObject2.setRawObject(true);
                    privilegesDB2.setUser((Owner)storageObject2);
                } else {
                    privilegesDB2.setUser((Owner)storageObject3);
                }
            }
            privilegesDB2.recreateSystemPrivilegesSet(this.getSystemPrivilegesSet().toString());
            privilegesDB2.setGrantOption(this.getGrantOption());
            privilegesDB2.setRawObject(false);
        }
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object object, Object object2) {
            return String.valueOf(object).compareTo(String.valueOf(object2));
        }
    }

    public class PrivilegesSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

