/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.db2.AbstractSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;

public abstract class DataBaseSpaceDB2
extends AbstractStorageObjectDB2
implements AbstractSpaceDB2,
StorageObjectListener {
    protected int pageFree = 0;
    protected int spaceAllocationInterval = 0;
    protected VCatDB2 vcat = null;
    protected boolean define = true;
    protected int maintenanceInterval = 0;
    private int percentageFree = 5;
    protected boolean dataSetInfoErase = false;
    protected int catalogSpace = 0;
    private int primaryQuantity = 12;
    private int secondaryQuantity = 0;
    private boolean calculatePrimaryQuantity = true;
    private boolean calculateSecondaryQuantity = true;
    private DataBaseDB2 dataBase = null;
    private BufferPoolDB2 bufferPool = null;
    private StorageGroupDB2 storageGroup = null;

    @Override
    public void setDataBase(DataBaseDB2 dataBaseDB2) {
        this.dataBase = dataBaseDB2;
        this.fireDataFieldChange();
    }

    @Override
    public void setBufferPool(BufferPoolDB2 bufferPoolDB2) {
        this.bufferPool = bufferPoolDB2;
        this.fireDataFieldChange();
    }

    @Override
    public void setFreePage(int n) {
        if (this.checkFreePage(n)) {
            this.pageFree = n;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setSpaceAllocationInterval(int n) {
        if (this.checkSpaceAllocationInterval(n)) {
            this.spaceAllocationInterval = n;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setStorageGroup(StorageGroupDB2 storageGroupDB2) {
        this.storageGroup = storageGroupDB2;
        this.fireDataFieldChange();
    }

    @Override
    public void setVCat(VCatDB2 vCatDB2) {
        this.vcat = vCatDB2;
        this.fireDataFieldChange();
    }

    @Override
    public void setVCatName(String string) {
    }

    @Override
    public void setDefine(boolean bl) {
        this.define = bl;
        this.fireDataFieldChange();
    }

    @Override
    public boolean getDefine() {
        return this.define;
    }

    @Override
    public void setMaintenanceInterval(int n) {
        if (this.checkSpaceAllocationInterval(n)) {
            this.maintenanceInterval = n;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setDataSetInfoErase(boolean bl) {
        this.dataSetInfoErase = bl;
        this.fireDataFieldChange();
    }

    @Override
    public void setPercentageFree(int n) {
        if (this.checkPercentageFree(n)) {
            this.percentageFree = n;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setSpace(int n) {
        this.catalogSpace = n;
        this.fireDataFieldChange();
    }

    @Override
    public DataBaseDB2 getDataBase() {
        return this.dataBase;
    }

    @Override
    public BufferPoolDB2 getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public int getFreePage() {
        return this.pageFree;
    }

    @Override
    public int getSpaceAllocationInterval() {
        return this.spaceAllocationInterval;
    }

    @Override
    public StorageGroupDB2 getStorageGroup() {
        return this.storageGroup;
    }

    @Override
    public VCatDB2 getVCat() {
        return this.vcat;
    }

    @Override
    public String getVCatName() {
        VCatDB2 vCatDB2 = this.getVCat();
        if (vCatDB2 != null) {
            return this.getVCat().getName();
        }
        return "";
    }

    @Override
    public int getMaintenanceInterval() {
        return this.maintenanceInterval;
    }

    @Override
    public boolean getDataSetInfoErase() {
        return this.dataSetInfoErase;
    }

    @Override
    public int getPercentageFree() {
        return this.percentageFree;
    }

    @Override
    public int getSpace() {
        return this.catalogSpace;
    }

    public boolean checkFreePage(int n) {
        return n >= 0 && n <= 255;
    }

    public boolean checkSpaceAllocationInterval(int n) {
        return n >= 0 && n <= 999;
    }

    public boolean containsStorageGroup() {
        return this.getStorageGroup() != null;
    }

    public boolean checkPercentageFree(int n) {
        return n >= 0 && n <= 99;
    }

    public int getPrimaryQuantity() {
        return this.primaryQuantity;
    }

    public void setPrimaryQuantity(int n) {
        this.primaryQuantity = n;
        this.fireDataFieldChange();
    }

    public int getSecondaryQuantity() {
        return this.secondaryQuantity;
    }

    public void setSecondaryQuantity(int n) {
        this.secondaryQuantity = n;
        this.fireDataFieldChange();
    }

    public boolean getCalculatePrimaryQuantity() {
        return this.calculatePrimaryQuantity;
    }

    public void setCalculatePrimaryQuantity(boolean bl) {
        this.calculatePrimaryQuantity = bl;
        this.fireDataFieldChange();
    }

    public boolean getCalculateSecondaryQuantity() {
        return this.calculateSecondaryQuantity;
    }

    public void setCalculateSecondaryQuantity(boolean bl) {
        this.calculateSecondaryQuantity = bl;
        this.fireDataFieldChange();
    }

    @Override
    public PropertyHolder getPropertyHolder() {
        return null;
    }
}

