/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.DataBasePropertyDialogDB2;

public class DataBaseDB2
extends StorageObject
implements ModelObjectSetListener,
StorageObjectListener {
    private static final String[] TYPES = new String[]{"USUAL", "WORKFILE", "TEMP"};
    private static final String[] CCSID_CHOICES = new String[]{"", "ASCII", "EBCDIC", "UNICODE"};
    private BufferPoolDB2 bufferPool = null;
    private BufferPoolDB2 indexBufferPool = null;
    private String type = TYPES[0];
    private String member = "";
    private StorageGroupDB2 storageGroup = null;
    private String ccsid = CCSID_CHOICES[0];
    private StorageObjectCollection tablespaces;
    public static final String TYPE_NAME = "DataBase";

    public DataBaseDB2() {
    }

    public DataBaseDB2(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.tablespaces = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getTableSpaceSet());
        this.tablespaces.setParent(this);
        this.tablespaces.setName(Messages.getString("DataBaseDB2.Tablespaces"));
        this.tablespaces.setSetMethod("setDataBase");
        this.tablespaces.setClassForParent(DataBaseDB2.class);
        this.tablespaces.setIcon(GUIConfiguration.getInstance().getIcon("TABLESPACE_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getTableSpaceSet().addSetListener(this);
        this.addTablespacesFromDesign(((AbstractStorageDesignDB2)storageDesign).getTableSpaceSet());
    }

    public void setBufferPool(BufferPoolDB2 bufferPoolDB2) {
        this.bufferPool = bufferPoolDB2;
        this.fireDataFieldChange();
    }

    public void setIndexBufferPool(BufferPoolDB2 bufferPoolDB2) {
        this.indexBufferPool = bufferPoolDB2;
        this.fireDataFieldChange();
    }

    public void setType(String string) {
        this.type = string;
        this.fireDataFieldChange();
    }

    public void setMember(String string) {
        this.member = string;
        this.fireDataFieldChange();
    }

    public void setStorageGroup(StorageGroupDB2 storageGroupDB2) {
        this.storageGroup = storageGroupDB2;
        this.fireDataFieldChange();
    }

    public void setCcsid(String string) {
        this.ccsid = string;
        this.fireDataFieldChange();
    }

    @Override
    public PropertyHolder getPropertyHolder() {
        return null;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "DB";
    }

    public BufferPoolDB2 getBufferPool() {
        return this.bufferPool;
    }

    public BufferPoolDB2 getIndexBufferPool() {
        return this.indexBufferPool;
    }

    public String getType() {
        return this.type;
    }

    public String getMember() {
        return this.member;
    }

    public StorageGroupDB2 getStorageGroup() {
        return this.storageGroup;
    }

    public String getCcsid() {
        return this.ccsid;
    }

    public static String[] getCcsidChoices() {
        return CCSID_CHOICES;
    }

    public static String[] getTypesChoices() {
        return TYPES;
    }

    public boolean isSystemDatabase() {
        return false;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DataBasePropertyDialogDB2 dataBasePropertyDialogDB2 = new DataBasePropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dataBasePropertyDialogDB2.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.tablespaces;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.tablespaces) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.tablespaces) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    private void addTablespacesFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)iterator.next();
            tableSpaceDB2.addObjectListener(this);
            if (tableSpaceDB2.getDataBase() != null && tableSpaceDB2.getDataBase() == this) {
                tableSpaceDB2.setParent(this.tablespaces);
                this.tablespaces.add(tableSpaceDB2);
                continue;
            }
            this.tablespaces.justRemove(tableSpaceDB2);
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof TableSpaceDB2) {
            TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)objectChangeEvent.getAffected();
            if (tableSpaceDB2.getDataBase() != null && tableSpaceDB2.getDataBase() == this) {
                tableSpaceDB2.setParent(this.tablespaces);
                this.tablespaces.add(tableSpaceDB2);
            } else {
                this.tablespaces.justRemove(tableSpaceDB2);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof TableSpaceDB2) {
                TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)modelObjectSetEvent.getAffected();
                tableSpaceDB2.addObjectListener(this);
                if (tableSpaceDB2.getDataBase() != null && tableSpaceDB2.getDataBase() == this) {
                    tableSpaceDB2.setParent(this.tablespaces);
                    this.tablespaces.add(tableSpaceDB2);
                } else {
                    this.tablespaces.justRemove(tableSpaceDB2);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof TableSpaceDB2) {
            TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)modelObjectSetEvent.getAffected();
            this.tablespaces.justRemove(tableSpaceDB2);
            tableSpaceDB2.removeObjectListener(this);
        }
    }

    public boolean containsTable(TableProxyDB2 tableProxyDB2) {
        return this.getName().equalsIgnoreCase("DSNDB04") ? tableProxyDB2.getTableSpace() != null && tableProxyDB2.getTableSpace().getDataBase() != null && this == tableProxyDB2.getTableSpace().getDataBase() || tableProxyDB2.getTableSpace() != null && tableProxyDB2.getTableSpace().getDataBase() == null || tableProxyDB2.getTableSpace() == null : tableProxyDB2.getTableSpace() != null && tableProxyDB2.getTableSpace().getDataBase() != null && this == tableProxyDB2.getTableSpace().getDataBase();
    }

    public List getTablespaces() {
        ArrayList arrayList = new ArrayList();
        this.tablespaces.addAllElementsTo(arrayList);
        return arrayList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        DataBaseDB2 dataBaseDB2 = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)storageDesign).getDataBaseSet().getByName(this.getName());
        if (storageObject != null) {
            if (storageObject.isRawObject()) {
                dataBaseDB2 = (DataBaseDB2)storageObject;
            }
        } else {
            dataBaseDB2 = ((AbstractStorageDesignDB2)storageDesign).getDataBaseSet().createDataBase();
        }
        if (dataBaseDB2 != null) {
            StorageObject storageObject2;
            StorageObject storageObject32;
            dataBaseDB2.setName(this.getName());
            for (StorageObject storageObject32 : this.getTablespaces()) {
                storageObject2 = (TableSpaceDB2)((AbstractStorageDesignDB2)storageDesign).getTableSpaceSet().getByName(storageObject32.getName());
                if (storageObject2 == null) {
                    TableSpaceDB2 tableSpaceDB2 = ((AbstractStorageDesignDB2)storageDesign).getTableSpaceSet().createTableSpace();
                    tableSpaceDB2.setName(storageObject32.getName());
                    tableSpaceDB2.setDataBase(dataBaseDB2);
                    tableSpaceDB2.setRawObject(true);
                    dataBaseDB2.addTablespacesFromDesign(((AbstractStorageDesignDB2)storageDesign).getTableSpaceSet());
                    continue;
                }
                ((TableSpaceDB2)storageObject2).setDataBase(dataBaseDB2);
                dataBaseDB2.addTablespacesFromDesign(((AbstractStorageDesignDB2)storageDesign).getTableSpaceSet());
            }
            if (this.getBufferPool() != null) {
                storageObject32 = (BufferPoolDB2)((AbstractStorageDesignDB2)storageDesign).getBufferPoolSet().getByName(this.getBufferPool().getName());
                if (storageObject32 == null) {
                    storageObject2 = (BufferPoolDB2)((AbstractStorageDesignDB2)storageDesign).getBufferPoolSet().createElement(null);
                    storageObject2.setName(this.getBufferPool().getName());
                    storageObject2.setRawObject(true);
                    dataBaseDB2.setBufferPool((BufferPoolDB2)storageObject2);
                } else {
                    dataBaseDB2.setBufferPool((BufferPoolDB2)storageObject32);
                }
            }
            if (this.getIndexBufferPool() != null) {
                storageObject32 = (BufferPoolDB2)((AbstractStorageDesignDB2)storageDesign).getBufferPoolSet().getByName(this.getIndexBufferPool().getName());
                if (storageObject32 == null) {
                    storageObject2 = (BufferPoolDB2)((AbstractStorageDesignDB2)storageDesign).getBufferPoolSet().createElement(null);
                    storageObject2.setName(this.getIndexBufferPool().getName());
                    storageObject2.setRawObject(true);
                    dataBaseDB2.setIndexBufferPool((BufferPoolDB2)storageObject2);
                } else {
                    dataBaseDB2.setIndexBufferPool((BufferPoolDB2)storageObject32);
                }
            }
            dataBaseDB2.setType(this.getType());
            dataBaseDB2.setMember(this.getMember());
            if (this.getStorageGroup() != null) {
                storageObject32 = (StorageGroupDB2)((AbstractStorageDesignDB2)storageDesign).getStorageGroupSet().getByName(this.getStorageGroup().getName());
                if (storageObject32 == null) {
                    storageObject2 = ((AbstractStorageDesignDB2)storageDesign).getStorageGroupSet().createStorageGroup();
                    storageObject2.setName(this.getStorageGroup().getName());
                    storageObject2.setRawObject(true);
                    dataBaseDB2.setStorageGroup((StorageGroupDB2)storageObject2);
                } else {
                    dataBaseDB2.setStorageGroup((StorageGroupDB2)storageObject32);
                }
            }
            dataBaseDB2.setCcsid(this.getCcsid());
            dataBaseDB2.setComment(this.getComment());
            dataBaseDB2.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DATABASE_ICON", 16);
    }

    @Override
    public void clearMergableStructure(Map map) {
        if (map != null) {
            ArrayList arrayList = new ArrayList();
            this.tablespaces.addAllElementsTo(arrayList);
            for (StorageObject storageObject : arrayList) {
                if (map.get(storageObject.getObjectID()) != null) continue;
                storageObject.remove(true);
            }
        }
    }

    protected static class SystemDataBase
    extends DataBaseDB2 {
        public SystemDataBase(StorageDesign storageDesign) {
            super(storageDesign);
        }

        @Override
        public boolean isSystemDatabase() {
            return true;
        }
    }
}

