/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.BufferPool16K;
import oracle.dbtools.crest.model.design.storage.db2.BufferPool32K;
import oracle.dbtools.crest.model.design.storage.db2.BufferPool4K;
import oracle.dbtools.crest.model.design.storage.db2.BufferPool8K;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;

public class BufferPoolSetDB2
extends StorageObjectSet {
    private static final BufferPoolDB2[] PROTO_ARRAY = new BufferPoolDB2[0];

    public void initializeElements() {
        if (this.size() == 0) {
            this.initialize();
        }
    }

    @Override
    public boolean canCreateElement() {
        return false;
    }

    protected void initialize() {
        int n;
        for (n = 0; n < 50; ++n) {
            this.add(new BufferPool4K(n));
        }
        for (n = 0; n < 10; ++n) {
            this.add(new BufferPool8K(n));
        }
        for (n = 0; n < 10; ++n) {
            this.add(new BufferPool16K(n));
        }
        this.add(new BufferPool32K());
        for (n = 1; n < 10; ++n) {
            this.add(new BufferPool32K(n));
        }
    }

    @Override
    public void add(ModelObject modelObject) {
        BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)modelObject;
        bufferPoolDB2.setDesign(this.getDesign());
        bufferPoolDB2.setStorageDesign(this.getStorageDesign());
        bufferPoolDB2.setParent(this);
        super.add(modelObject);
    }

    public List getBufferPoolList() {
        return this.getElementsList();
    }

    @Override
    public ModelIDObject createElement(String string) {
        throw new IllegalArgumentException(Messages.getString("BufferPoolSetDB2.BufferPoolsCanNotBeCcreated"));
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "BPNOTUSED";
    }
}

