/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.propertyholder.PVInteger;
import oracle.dbtools.crest.model.propertyholder.PropertyVerifier;
import oracle.dbtools.crest.swingui.editor.storage.db2.BufferPoolPropertyDialogDB2;

public class BufferPoolDB2
extends StorageObject {
    private static PropertyVerifier verifier = new PVInteger(0, 400000);
    private int minBuffers;
    private int maxBuffers;
    private String users = "";
    private UserSet userSet = null;
    private String grantOption = "NO";
    private String allBufferpools = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String TYPE_NAME = "BufPool";
    public static final String OLD_TYPE_NAME = "Bufferpool";

    public void setMinBuffers(int n) {
        if (this.isNotTooSmall(n) && this.isNotTooLarge(n)) {
            this.minBuffers = n;
            this.sortMinMax();
            this.fireUpdate();
        }
    }

    public void setMaxBuffers(int n) {
        if (this.isNotTooSmall(n) && this.isNotTooLarge(n)) {
            this.maxBuffers = n;
            this.sortMinMax();
            this.fireUpdate();
        }
    }

    protected void sortMinMax() {
    }

    public int getMinBuffers() {
        return this.minBuffers;
    }

    public int getMaxBuffers() {
        return this.maxBuffers;
    }

    public int pageSize() {
        return 4096;
    }

    public int usablePageSize() {
        return 4074;
    }

    protected boolean isNotTooLarge(int n) {
        return n <= this.maxValue();
    }

    protected int maxValue() {
        return 400000;
    }

    protected boolean isNotTooSmall(int n) {
        return n >= this.minValue();
    }

    protected int minValue() {
        return 0;
    }

    void createName() {
        String string = this.getNamePrefix();
        this.setName(string);
        this.setObjectID(string);
    }

    void createName(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getNamePrefix()).append(n);
        String string = stringBuffer.toString();
        this.setName(string);
        this.setObjectID(string);
    }

    protected String getNamePrefix() {
        return "BP";
    }

    public static PropertyVerifier getBufferPropertyVerifier() {
        return verifier;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "IDPREFIXNOTUSED_BUFFERPOOL";
    }

    @Override
    public final void setReadOnly(boolean bl) {
        super.setReadOnly(bl);
    }

    private void addUser(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (!this.getUserSet().contains(string2)) {
            this.getUserSet().add(string2);
        }
    }

    private void recreateUserSet(String string) {
        this.getUserSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getUserSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setUsers(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserSet(string);
        } else {
            this.addUser(string);
        }
        this.users = this.getUserSet().toString();
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public String getUsers() {
        return this.users;
    }

    public UserSet getUserSet() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        }
        return this.userSet;
    }

    public void clear() {
        this.getUserSet().removeAllElements();
        this.users = "";
    }

    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(YES_NO_STATES));
        }
        return yesNoSet.contains(string);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String string) {
        if (string != null && string.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(string)) {
            this.grantOption = string;
            this.fireDataFieldChange();
        }
    }

    public String getAllBufferpools() {
        return this.allBufferpools;
    }

    public void setAllBufferpools(String string) {
        if (string != null && string.equals(this.allBufferpools)) {
            return;
        }
        if (this.checkYesNo(string)) {
            this.allBufferpools = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            BufferPoolPropertyDialogDB2 bufferPoolPropertyDialogDB2 = new BufferPoolPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            bufferPoolPropertyDialogDB2.show();
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        BufferPoolDB2 bufferPoolDB2 = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)storageDesign).getBufferPoolSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                bufferPoolDB2 = (BufferPoolDB2)storageObject;
            }
        } else {
            bufferPoolDB2 = (BufferPoolDB2)((AbstractStorageDesignDB2)storageDesign).getBufferPoolSet().createElement(null);
        }
        if (bufferPoolDB2 != null) {
            bufferPoolDB2.setMinBuffers(this.getMinBuffers());
            bufferPoolDB2.setMaxBuffers(this.getMaxBuffers());
            bufferPoolDB2.recreateUserSet(this.getUsers());
            bufferPoolDB2.setAllBufferpools(this.getAllBufferpools());
            bufferPoolDB2.setGrantOption(this.getGrantOption());
            bufferPoolDB2.setComment(this.getComment());
            bufferPoolDB2.setRawObject(false);
        }
    }

    public class UserSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

