/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObject;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObjectImpl;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxySetDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.AliasPropertyDialogDB2;

public class AliasDB2
extends AbstractStorageObjectDB2
implements OwnedObject,
ModelObjectSetListener,
StorageObjectListener {
    private OwnedObjectImpl owner;
    private TableProxyDB2 table;
    private TableViewProxyDB2 view;
    private AliasDB2 anotherAlias;
    private StorageObjectCollection synonyms;
    public static final String TYPE_NAME = "Alias";

    public AliasDB2(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.synonyms = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("AliasDB2.Synonyms"));
        this.synonyms.setClassForParent(AliasDB2.class);
        this.synonyms.setSetMethod("setAlias");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof SynonymDB2) {
            SynonymDB2 synonymDB2 = (SynonymDB2)objectChangeEvent.getAffected();
            if (synonymDB2.getAlias() != null && synonymDB2.getAlias() == this) {
                synonymDB2.setParent(this.synonyms);
                this.synonyms.add(synonymDB2);
            } else {
                this.synonyms.remove(synonymDB2);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof SynonymDB2) {
                SynonymDB2 synonymDB2 = (SynonymDB2)modelObjectSetEvent.getAffected();
                synonymDB2.addObjectListener(this);
                if (synonymDB2.getAlias() != null && synonymDB2.getAlias() == this) {
                    synonymDB2.setParent(this.synonyms);
                    this.synonyms.add(synonymDB2);
                } else {
                    this.synonyms.remove(synonymDB2);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof SynonymDB2) {
            SynonymDB2 synonymDB2 = (SynonymDB2)modelObjectSetEvent.getAffected();
            this.synonyms.remove(synonymDB2);
            synonymDB2.removeObjectListener(this);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.synonyms;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.synonyms.removeAll();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ALS";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            AliasPropertyDialogDB2 aliasPropertyDialogDB2 = new AliasPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            aliasPropertyDialogDB2.show();
        }
    }

    public AliasDB2 getAnotherAlias() {
        return this.anotherAlias;
    }

    public void setAnotherAlias(AliasDB2 aliasDB2) {
        this.anotherAlias = aliasDB2;
        if (aliasDB2 != null) {
            this.table = null;
            this.view = null;
        }
        this.fireDataFieldChange();
    }

    public TableProxyDB2 getTable() {
        return this.table;
    }

    public void setTable(TableProxyDB2 tableProxyDB2) {
        this.table = tableProxyDB2;
        if (tableProxyDB2 != null) {
            this.view = null;
            this.anotherAlias = null;
        }
        this.fireDataFieldChange();
    }

    public TableViewProxyDB2 getView() {
        return this.view;
    }

    public void setView(TableViewProxyDB2 tableViewProxyDB2) {
        this.view = tableViewProxyDB2;
        if (tableViewProxyDB2 != null) {
            this.table = null;
            this.anotherAlias = null;
        }
        this.fireDataFieldChange();
    }

    @Override
    public void setOwner(Owner owner) {
        this.getOwnedObjectImpl().setOwner(owner);
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public Owner getOwner() {
        return this.getOwnedObjectImpl().getOwner();
    }

    private OwnedObjectImpl getOwnedObjectImpl() {
        if (this.owner == null) {
            this.owner = new OwnedObjectImpl();
            this.owner.setOwnerSet(((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet());
        }
        return this.owner;
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        Owner owner;
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!(bl || this.getOwner() == null || this.getOwner().isNullInstance() || (owner = this.getOwner()).isNullInstance())) {
            string = owner.getSchemaObject() != null ? owner.getSchemaObject().getName() + '.' + string : owner.getName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    private void addSynonymsFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            SynonymDB2 synonymDB2 = (SynonymDB2)iterator.next();
            if (synonymDB2.getAlias() != null && synonymDB2.getAlias() == this) {
                synonymDB2.setParent(this.synonyms);
                this.synonyms.add(synonymDB2);
                continue;
            }
            this.synonyms.remove(synonymDB2);
        }
    }

    public List getSynonyms() {
        ArrayList arrayList = new ArrayList();
        this.synonyms.addAllElementsTo(arrayList);
        return arrayList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        AliasDB2 aliasDB2 = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)storageDesign).getAliasSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                aliasDB2 = (AliasDB2)storageObject;
            }
        } else {
            aliasDB2 = ((AbstractStorageDesignDB2)storageDesign).getAliasSet().createAlias();
        }
        if (aliasDB2 != null) {
            StorageObject storageObject2;
            StorageObject storageObject32;
            aliasDB2.setName(this.getName());
            for (StorageObject storageObject32 : this.getSynonyms()) {
                storageObject2 = (SynonymDB2)((AbstractStorageDesignDB2)storageDesign).getSynonymSet().getById(storageObject32.getObjectID());
                if (storageObject2 == null) {
                    SynonymDB2 synonymDB2 = ((AbstractStorageDesignDB2)storageDesign).getSynonymSet().createSynonym();
                    synonymDB2.setName(storageObject32.getName());
                    synonymDB2.setAlias(aliasDB2);
                    synonymDB2.setRawObject(true);
                    aliasDB2.addSynonymsFromDesign(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
                    continue;
                }
                ((SynonymDB2)storageObject2).setAlias(aliasDB2);
                aliasDB2.addSynonymsFromDesign(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
            }
            if (this.getOwner() != null) {
                storageObject32 = (Owner)((AbstractStorageDesignDB2)storageDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (storageObject32 == null) {
                    storageObject2 = (Owner)((AbstractStorageDesignDB2)storageDesign).getOwnerSet().createElement(null);
                    storageObject2.setName(this.getOwner().getName());
                    storageObject2.setRawObject(true);
                    aliasDB2.setOwner((Owner)storageObject2);
                } else {
                    aliasDB2.setOwner((Owner)storageObject32);
                }
            }
            if (this.getView() != null) {
                storageObject32 = ((TableViewProxySetDB2)storageDesign.getTableViewProxySet()).getByName(this.getView().getName());
                if (storageObject32 == null) {
                    storageObject2 = (TableViewProxyDB2)((TableViewProxySetDB2)storageDesign.getTableViewProxySet()).createProxy(this.getView().getObject());
                    ((RelationalObjectProxy)storageObject2).setName(this.getView().getName());
                    storageObject2.setRawObject(true);
                    aliasDB2.setView((TableViewProxyDB2)storageObject2);
                } else {
                    aliasDB2.setView((TableViewProxyDB2)storageObject32);
                }
            }
            if (this.getTable() != null) {
                storageObject32 = ((TableProxySetDB2)storageDesign.getTableProxySet()).getByName(this.getTable().getName());
                if (storageObject32 == null) {
                    storageObject2 = (TableProxyDB2)((TableProxySetDB2)storageDesign.getTableProxySet()).createProxy(this.getTable().getObject());
                    ((RelationalObjectProxy)storageObject2).setName(this.getTable().getName());
                    storageObject2.setRawObject(true);
                    aliasDB2.setTable((TableProxyDB2)storageObject2);
                } else {
                    aliasDB2.setTable((TableProxyDB2)storageObject32);
                }
            }
            if (this.getAnotherAlias() != null) {
                storageObject32 = (AliasDB2)((AbstractStorageDesignDB2)storageDesign).getAliasSet().getByName(this.getAnotherAlias().getName());
                if (storageObject32 == null) {
                    storageObject2 = ((AbstractStorageDesignDB2)storageDesign).getAliasSet().createAlias();
                    storageObject2.setName(this.getAnotherAlias().getName());
                    storageObject2.setRawObject(true);
                    aliasDB2.setAnotherAlias((AliasDB2)storageObject2);
                } else {
                    aliasDB2.setAnotherAlias((AliasDB2)storageObject32);
                }
            }
            aliasDB2.setComment(this.getComment());
            aliasDB2.setCommentInRDBMS(this.getCommentInRDBMS());
            aliasDB2.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("ALIAS_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        this.synonyms.removeAll();
    }

    public SynonymDB2 createSynonym() {
        SynonymDB2 synonymDB2 = (SynonymDB2)this.synonyms.createElement(null);
        synonymDB2.setAlias(this);
        return synonymDB2;
    }

    public StorageObjectCollection getSynonymsCollection() {
        return this.synonyms;
    }
}

