/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.exports.ddl.udb.SSBNoneTransferableFK_UDB;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentitySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.InstanceDescriptorColumnSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.OwnerSet;
import oracle.dbtools.crest.model.design.storage.db2.PartitionSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.PermissionsSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.PrivilegesSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.SynonymSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.VolumesSetDB2;

public abstract class AbstractStorageDesignDB2
extends StorageDesign {
    private boolean scDialogVisible = false;
    private boolean dtDialogVisible = false;
    protected Owner publicAtAllLocations = new Owner();

    public AbstractStorageDesignDB2(RelationalDesign relationalDesign, RDBMSSite rDBMSSite, Design design) {
        super(relationalDesign, rDBMSSite, design);
        this.publicAtAllLocations.setStorageDesign(this);
        this.publicAtAllLocations.setObjectID(null);
        this.publicAtAllLocations.setName("PUBLIC AT ALL LOCATIONS");
        this.publicAtAllLocations.setDesign(this.getDesign());
    }

    public abstract VCatSetDB2 getVCatSet();

    public abstract TableSpaceSetDB2 getTableSpaceSet();

    public abstract AUXTableIndexSetDB2 getAUXTableIndexSet();

    public abstract IndexPartitionSetDB2 getIndexPartitionSet();

    public abstract PartitionSetDB2 getPartitionSet();

    public abstract TriggerSetDB2 getTriggerSet();

    public abstract ColumnIdentitySetDB2 getColumnIdentitySet();

    public abstract BufferPoolSetDB2 getBufferPoolSet();

    public abstract StorageGroupSetDB2 getStorageGroupSet();

    public abstract StorageTemplateSetDB2 getStorageTemplateSet();

    public abstract VolumesSetDB2 getVolumesSet();

    public abstract AliasSetDB2 getAliasSet();

    public abstract DataBaseSetDB2 getDataBaseSet();

    public abstract AUXTableSetDB2 getAUXTableSet();

    public abstract StoredProcedureSetDB2 getStoredProcedureSet();

    public abstract SynonymSetDB2 getSynonymSet();

    public abstract DistinctTypeSetDB2 getDistinctTypeSet();

    public abstract void updateGeneralRule();

    public abstract OwnerSet getOwnerSet();

    public abstract PrivilegesSetDB2 getPrivilegesSet();

    public abstract PermissionsSetDB2 getPermissionsSet();

    public abstract InstanceDescriptorColumnSetDB2 getInstanceDescriptorColumnSet();

    public Owner getPublicAtAllLocations() {
        return this.publicAtAllLocations;
    }

    public boolean isDtDialogVisible() {
        return this.dtDialogVisible;
    }

    public void setDtDialogVisible(boolean bl) {
        this.dtDialogVisible = bl;
    }

    public boolean isScDialogVisible() {
        return this.scDialogVisible;
    }

    public void setScDialogVisible(boolean bl) {
        this.scDialogVisible = bl;
    }

    @Override
    public List getDropableSets() {
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        arrayList.add(this.getDataBaseSet());
        this.getTableSpaceSet().setName(Messages.getString("AbstractStorageDesignDB2.Tablespaces"));
        arrayList.add(this.getTableSpaceSet());
        arrayList.add(this.getTableProxySet());
        this.getTriggerSet().setName(Messages.getString("AbstractStorageDesignDB2.Triggers"));
        arrayList.add(this.getTriggerSet());
        arrayList.add(this.getSynonymSet());
        arrayList.add(this.getIndexProxySet());
        if (this.getPhysicalDesign() != null) {
            arrayList.add(this.getPhysicalDesign().getFKIndexAssociationSet());
        }
        arrayList.add(this.getTableViewProxySet());
        arrayList.add(this.getStoredProcedureSet());
        arrayList.add(this.getAliasSet());
        this.getStorageGroupSet().setName(Messages.getString("AbstractStorageDesignDB2.StorageGroups"));
        this.getDistinctTypeSet().setName(Messages.getString("AbstractStorageDesignDB2.DistinctTypes"));
        arrayList.add(this.getStorageGroupSet());
        arrayList.add(this.getDistinctTypeSet());
        return arrayList;
    }

    @Override
    public void setOpen(boolean bl) {
        super.setOpen(bl);
        if (bl) {
            Object object;
            String string;
            Object object2;
            Object object3;
            Object object4;
            Iterator iterator = this.getTableProxySet().iterator();
            String string2 = this.getDesign().getAppView().getSettings().getDefaultDB2Database();
            DataBaseDB2 dataBaseDB2 = null;
            dataBaseDB2 = string2 != null ? (DataBaseDB2)this.getDataBaseSet().getByName(string2) : (DataBaseDB2)this.getDataBaseSet().getByName("DSNDB04");
            if (dataBaseDB2 != null) {
                while (iterator.hasNext()) {
                    TableProxyDB2 tableProxyDB2 = (TableProxyDB2)iterator.next();
                    if (tableProxyDB2.getTableSpace() == null) {
                        if (!this.getDesign().getAppView().getSettings().newDB2TableSpacePerTable()) continue;
                        object4 = this.getTableSpaceSet().createTableSpace();
                        tableProxyDB2.setTableSpace((TableSpaceDB2)object4);
                        ((TableSpaceDB2)object4).setDataBase(dataBaseDB2);
                        object3 = tableProxyDB2.getObject();
                        object2 = this.getDesign().getAppView().getSettings().getNamingRuleTablespaceDB2();
                        string = ApplyNamingStandards.createTableSpaceDB2_Name(((DesignObject)object3).getName(), (String)object2, ((DesignObject)object3).getDesignPart().getName());
                        ((StorageObject)object4).setName(string);
                        if (!this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerTableSpace()) continue;
                        object = ((TableSpaceDB2)object4).getStorageTemplate();
                        if (object == null) {
                            object = this.getStorageTemplateSet().createStorageTemplate();
                            tableProxyDB2.getTableSpace().setStorageTemplate((StorageTemplateDB2)object);
                        }
                        object2 = this.getDesign().getAppView().getSettings().getNamingRuleStTablespaceDB2();
                        string = ApplyNamingStandards.createTableSpaceStorageTemplateDB2_Name(tableProxyDB2.getTableSpace().getName(), (String)object2, ((DesignObject)object3).getDesignPart().getName());
                        ((StorageObject)object).setName(string);
                        continue;
                    }
                    if (tableProxyDB2.getTableSpace().getStorageTemplate() != null) continue;
                    if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerTableSpace()) {
                        object4 = this.getStorageTemplateSet().createStorageTemplate();
                        tableProxyDB2.getTableSpace().setStorageTemplate((StorageTemplateDB2)object4);
                        object3 = tableProxyDB2.getObject();
                        object2 = this.getDesign().getAppView().getSettings().getNamingRuleStTablespaceDB2();
                        string = ApplyNamingStandards.createTableSpaceStorageTemplateDB2_Name(tableProxyDB2.getTableSpace().getName(), (String)object2, ((DesignObject)object3).getDesignPart().getName());
                        ((StorageObject)object4).setName(string);
                        continue;
                    }
                    if (!this.getDesign().getAppView().getSettings().oneDB2StorageTemplatePerTS() || (object4 = this.getDesign().getAppView().getSettings().getDefaultTSStorageTemplateName()) == null || "".equalsIgnoreCase((String)object4)) continue;
                    object3 = (StorageTemplateDB2)this.getStorageTemplateSet().getByName((String)object4);
                    if (object3 == null) {
                        object3 = this.getStorageTemplateSet().createStorageTemplate();
                        ((StorageObject)object3).setName((String)object4);
                    }
                    if (object3 == null) continue;
                    tableProxyDB2.getTableSpace().setStorageTemplate((StorageTemplateDB2)object3);
                }
            }
            iterator = this.getIndexProxySet().iterator();
            while (iterator.hasNext()) {
                object4 = (IndexProxyDB2)iterator.next();
                if (((IndexProxyDB2)object4).getStorageTemplate() != null) continue;
                if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerIndex()) {
                    object3 = this.getStorageTemplateSet().createStorageTemplate();
                    ((IndexProxyDB2)object4).setStorageTemplate((StorageTemplateDB2)object3);
                    object2 = ((RelationalObjectProxy)object4).getObject();
                    string = this.getDesign().getAppView().getSettings().getNamingRuleStIndexDB2();
                    object = ApplyNamingStandards.createIndexStorageTemplateDB2_Name(((IndexProxyDB2)object4).getName(), string, ((DesignObject)object2).getDesignPart().getName());
                    ((StorageObject)object3).setName((String)object);
                    continue;
                }
                if (!this.getDesign().getAppView().getSettings().oneDB2StorageTemplatePerIndex() || (object3 = this.getDesign().getAppView().getSettings().getDefaultIndexStorageTemplateName()) == null || "".equalsIgnoreCase((String)object3)) continue;
                object2 = (StorageTemplateDB2)this.getStorageTemplateSet().getByName((String)object3);
                if (object2 == null) {
                    object2 = this.getStorageTemplateSet().createStorageTemplate();
                    ((StorageObject)object2).setName((String)object3);
                }
                if (object2 == null) continue;
                ((IndexProxyDB2)object4).setStorageTemplate((StorageTemplateDB2)object2);
            }
            object4 = (VCatDB2)this.getVCatSet().getNullInstance();
            iterator = this.getStorageGroupSet().iterator();
            while (iterator.hasNext()) {
                object3 = (StorageGroupDB2)iterator.next();
                if (((StorageGroupDB2)object3).getVCat() != null) continue;
                ((StorageGroupDB2)object3).setVCat((VCatDB2)object4);
            }
            this.getStorageTemplateSet().sortByName();
        }
    }

    @Override
    protected DDLGenerator createDDLTriggerGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        dDLGeneratorSpecific.append(new SSBNoneTransferableFK_UDB(this));
        return dDLGeneratorSpecific;
    }

    @Override
    public List getUniqueList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getFKProxyList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getPKProxyList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected List<ElementSet> createDDLSelectionSetsList() {
        List<ElementSet> list = super.createDDLSelectionSetsList();
        list.add(this.getTableProxySet());
        list.add(this.getAUXTableSet());
        list.add(this.getTableSpaceSet());
        list.add(this.getAliasSet());
        list.add(this.getTableViewProxySet());
        list.add(this.getStoredProcedureSet());
        list.add(this.getDistinctTypeSet());
        list.add(this.getStorageGroupSet());
        return list;
    }

    @Override
    public void sortCollections() {
        this.getDataBaseSet().sort();
        this.getOwnerSet().sort();
        this.getTableProxySet().sort();
        this.getTableViewProxySet().sort();
        this.getTableSpaceSet().sort();
        this.getPartitionSet().sort();
        this.getVCatSet().sort();
        this.getStorageGroupSet().sort();
        this.getBufferPoolSet().sort();
        this.getAliasSet().sort();
        this.getSynonymSet().sort();
        this.getVolumesSet().sort();
        this.getStorageTemplateSet().sort();
        this.getInstanceDescriptorColumnSet().sort();
        this.getColumnIdentitySet().sort();
        this.getAUXTableSet().sort();
        this.getAUXTableIndexSet().sort();
        this.getTriggerSet().sort();
        this.getStoredProcedureSet().sort();
        this.getDistinctTypeSet().sort();
        this.getPrivilegesSet().sort();
        this.getPermissionsSet().sort();
    }

    @Override
    public StorageObjectSet getUserSchemaSet() {
        return this.getOwnerSet();
    }
}

