/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.text.MessageFormat;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.AUXTableIndexPropertyDialogDB2;

public class AUXTableIndexDB2
extends AbstractStorageObjectDB2 {
    protected static final String[] PIECE_SIZES = new String[]{"254 K", "512 K", "1024 K", "2048 K", "4096 K", "8192 K", "16384 K", "32768 K", "65536 K", "131072 K", "262144 K", "524288 K", "1048576 K", "2097152 K", "4194304 K", "8388608 K", "16777216 K", "33554432 K", "67108864 K"};
    private AUXTableDB2 auxTable = null;
    private boolean unique = true;
    private Owner owner = null;
    private StorageTemplateDB2 storageTemplate = null;
    private String pieceSize = PIECE_SIZES[13];
    private BufferPoolDB2 bufferPool = null;
    private boolean close = true;
    private boolean copy = false;
    private final State UNIQUE = new Unique();
    private final State NONUNIQUE = new NonUnique();
    private State state = this.UNIQUE;
    private static final int PRIQTY = 1;
    private static final int SECQTY = 2;
    private static final int INITIALROWS = 1;
    private static final int MAXROWS = 2;
    private int rowsForCalculation = 1;
    private StringBuffer proposedQTYRemarks = new StringBuffer();
    public static final String TYPE_NAME = "AXTIdx";
    public static final String OLD_TYPE_NAME = "AUXTableIndex";
    private static int maxQTY = 0x400000;

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ATI";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            AUXTableIndexPropertyDialogDB2 aUXTableIndexPropertyDialogDB2 = new AUXTableIndexPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            aUXTableIndexPropertyDialogDB2.show();
        }
    }

    public AUXTableDB2 getAuxTable() {
        return this.auxTable;
    }

    public void setAuxTable(AUXTableDB2 aUXTableDB2) {
        this.auxTable = aUXTableDB2;
        this.fireDataFieldChange();
    }

    public BufferPoolDB2 getBufferPool() {
        return this.bufferPool;
    }

    public void setBufferPool(BufferPoolDB2 bufferPoolDB2) {
        this.bufferPool = bufferPoolDB2;
        this.fireDataFieldChange();
    }

    public boolean isClose() {
        return this.close;
    }

    public void setClose(boolean bl) {
        this.close = bl;
        this.fireDataFieldChange();
    }

    public boolean isCopy() {
        return this.copy;
    }

    public void setCopy(boolean bl) {
        this.copy = bl;
        this.fireDataFieldChange();
    }

    public String getPieceSize() {
        return this.pieceSize;
    }

    public void setPieceSize(String string) {
        this.pieceSize = string;
        this.fireDataFieldChange();
    }

    public StorageTemplateDB2 getStorageTemplate() {
        return this.storageTemplate;
    }

    public void setStorageTemplate(StorageTemplateDB2 storageTemplateDB2) {
        this.storageTemplate = storageTemplateDB2;
        this.fireDataFieldChange();
    }

    public boolean isUnique() {
        return this.unique;
    }

    public static String[] getPieceSizes() {
        return PIECE_SIZES;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null) {
            return new StringBuffer(this.getOwner().getName()).append('.').append(this.getName()).toString();
        }
        return super.getName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getOwner() != null && !this.getOwner().isNullInstance()) {
            string = this.getOwner().getName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    public TableProxyDB2 getTableProxy() {
        return this.getAuxTable().getTable();
    }

    protected void checkState() {
        this.state = this.isUnique() ? this.UNIQUE : this.NONUNIQUE;
    }

    private int getSpacePerKeyL() {
        this.checkState();
        return this.state.getSpacePerKeyL();
    }

    private int getSpacePerKeyNL() {
        this.checkState();
        return this.state.getSpacePerKeyNL();
    }

    private int getIndexByteSize() {
        return 19;
    }

    private int getRIDSize() {
        return 5;
    }

    private int getMaxUsableSpacePerPageL() {
        return (int)Math.floor((float)((100 - this.getPercentageFree()) * 4038) / 100.0f);
    }

    private int getMaxUsableSpacePerPageNL() {
        float f = Math.max(90, 100 - this.getPercentageFree());
        return (int)Math.floor(f * 4046.0f / 100.0f);
    }

    private int getEntriesPerPageL() {
        this.checkState();
        return this.state.getEntriesPerPageL();
    }

    private int getEntriesPerPageNL() {
        return (int)Math.floor(this.getMaxUsableSpacePerPageNL() / this.getSpacePerKeyNL());
    }

    private int getPercentageFree() {
        if (this.getTableProxy() != null) {
            if (this.getStorageTemplate() != null && this.getTableProxy().getInsertMethod().equalsIgnoreCase("Load/Reorg")) {
                return this.getStorageTemplate().getPctFree();
            }
            return 0;
        }
        return 0;
    }

    private int getFreePage() {
        if (this.getTableProxy() != null) {
            if (this.getStorageTemplate() != null && this.getTableProxy().getInsertMethod().equalsIgnoreCase("Load/Reorg")) {
                return this.getStorageTemplate().getFreePage();
            }
            return 0;
        }
        return 0;
    }

    private int getAverageNumberDuplicatesPerKey() {
        return this.getNumberOfDuplicates();
    }

    private int getKeyEntriesPerPageL() {
        return (int)Math.floor((float)(this.getAverageNumberDuplicatesPerKey() * this.getMaxUsableSpacePerPageL()) / (float)this.getSpacePerKeyL());
    }

    private int getRemainingSpacePerPageL() {
        return (int)Math.floor((float)this.getMaxUsableSpacePerPageL() - (float)(this.getKeyEntriesPerPageL() * this.getSpacePerKeyL()) / (float)this.getAverageNumberDuplicatesPerKey());
    }

    private int getDataRecordsPerPartialEntryL() {
        return (int)Math.floor((float)(this.getRemainingSpacePerPageL() - (this.getIndexByteSize() + 4)) / 5.0f);
    }

    private int getPartialEntriesPerPageL() {
        if (this.getDataRecordsPerPartialEntryL() < 1) {
            return 0;
        }
        float f = (float)this.getAverageNumberDuplicatesPerKey() / (float)this.getDataRecordsPerPartialEntryL();
        return this.getAverageNumberDuplicatesPerKey() / (int)Math.ceil(f);
    }

    private long getRowNumberOfTableProxy() {
        TableProxyDB2 tableProxyDB2 = this.getTableProxy();
        if (tableProxyDB2 != null) {
            return this.rowsForCalculation == 1 ? tableProxyDB2.getInitialRowNumber() : tableProxyDB2.getMaxRowNumber();
        }
        return 0L;
    }

    private long getNumberLeafPages() {
        return (long)Math.ceil((float)this.getRowNumberOfTableProxy() / (float)this.getEntriesPerPageL());
    }

    private int getMinNumberChildPages() {
        return Math.max(2, this.getEntriesPerPageNL() + 1);
    }

    private long getLevel2Pages() {
        return (long)Math.ceil((float)this.getNumberLeafPages() / (float)this.getMinNumberChildPages());
    }

    private long getLevelXPages(float f) {
        return (long)Math.ceil(f / (float)this.getMinNumberChildPages());
    }

    private long getNumberNonleafPages() {
        long l = this.getLevel2Pages();
        long l2 = this.getLevel2Pages();
        while (l2 > 1L) {
            l2 = this.getLevelXPages(l2);
            l += l2;
        }
        return l;
    }

    private long getFreePages() {
        if (this.getFreePage() != 0) {
            return (long)Math.floor((float)this.getNumberLeafPages() / (float)this.getFreePage());
        }
        return 0L;
    }

    private long getTreePages() {
        return Math.max(2L, this.getNumberLeafPages() + this.getNumberNonleafPages());
    }

    private long getSpaceMapPages() {
        return (long)Math.ceil((float)(this.getFreePages() + this.getTreePages()) / 8131.0f);
    }

    private int getNumberIndexPages() {
        return (int)Math.max(4L, 1L + this.getSpaceMapPages() + this.getTreePages() + this.getFreePages());
    }

    private int getRequiredSpacePages() {
        return this.getNumberIndexPages() + 2;
    }

    public int getInitialNumberUsedPages() {
        this.rowsForCalculation = 1;
        return this.getRequiredSpacePages();
    }

    public int getMaxNumberUsedPages() {
        this.rowsForCalculation = 2;
        return this.getRequiredSpacePages();
    }

    public long getInitialNumberUsedKB() {
        return 4 * this.getInitialNumberUsedPages();
    }

    public long getMaxNumberUsedKB() {
        return 4 * this.getMaxNumberUsedPages();
    }

    private int getNumberOfPieces() {
        return 254;
    }

    public int transformPSizeToLong(String string) {
        String string2 = string.substring(0, string.length() - 2);
        return Integer.parseInt(string2);
    }

    public int getPieceSizeKB() {
        String string = this.getPieceSize();
        String string2 = string.substring(0, string.length() - 2);
        return Integer.parseInt(string2);
    }

    public int getNumberOfDuplicates() {
        return 1;
    }

    public int getNumParts() {
        if (this.getTableProxy() != null && this.getTableProxy().getTableSpace() != null) {
            return this.getTableProxy().getTableSpace().getNumParts();
        }
        return 0;
    }

    int chooseProperPieceSize(int n) {
        for (int i = 0; i < PIECE_SIZES.length; ++i) {
            int n2 = this.transformPSizeToLong(PIECE_SIZES[i]);
            if (n >= n2) continue;
            return this.transformPSizeToLong(PIECE_SIZES[i]);
        }
        return this.transformPSizeToLong(PIECE_SIZES[PIECE_SIZES.length]);
    }

    public int getProposedPRIQTY() {
        return this.getProposedQTY(1);
    }

    public int getProposedQTY(int n) {
        this.proposedQTYRemarks.setLength(0);
        int n2 = 4;
        int n3 = (int)Math.ceil((float)this.getPieceSizeKB() / 4.0f);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n5 = this.getMaxNumberUsedPages();
        n4 = this.getInitialNumberUsedPages();
        n4 = Math.max(3, n4);
        n5 = Math.max(3, n5);
        n6 *= n2;
        n7 *= n2;
        if (this.getNumParts() == 0) {
            int n8 = this.getNumberOfPieces();
            int n9 = n8 * n3;
            if (n9 < n5) {
                this.proposedQTYRemarks.append(Messages.getString("AUXTableIndexDB2.CurrentPIECESIZENotSufficient"));
                int n10 = n5 / n8;
                n10 = this.chooseProperPieceSize(n10 * 4);
                this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("AUXTableIndexDB2.PIECESIZEProposed"), Integer.toString(n10)));
                n3 = n10 / 4;
            }
            if ((n6 = n4) >= n3) {
                n6 = n3;
                n7 = n6 / 10;
            } else {
                long l;
                n7 = Math.max(3, n6 / 10);
                if ((long)(n6 + 118 * n7) < (l = (long)Math.min(n3, n5))) {
                    n7 = n6 = (int)Math.ceil((float)l / 119.0f);
                    this.proposedQTYRemarks.append(Messages.getString("AUXTableIndexDB2.SizeAdjusted"));
                }
            }
        } else {
            n6 = n4;
            n7 = Math.max(3, n6 / 10);
            if (n6 + 118 * n7 < n5) {
                n7 = n6 = (int)Math.ceil((float)n5 / 119.0f);
                this.proposedQTYRemarks.append(Messages.getString("AUXTableIndexDB2.SizeAdjusted"));
            }
        }
        n6 *= n2;
        n7 *= n2;
        if (n4 == n5) {
            n7 = 0;
        }
        n6 = Math.min(n6, maxQTY);
        n7 = Math.min(n7, maxQTY);
        return n == 1 ? n6 : n7;
    }

    public int getProposedSECQTY() {
        return this.getProposedQTY(2);
    }

    public String getProposedQTYRemarks() {
        return this.proposedQTYRemarks.toString();
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        AUXTableIndexDB2 aUXTableIndexDB2 = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)storageDesign).getAUXTableIndexSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                aUXTableIndexDB2 = (AUXTableIndexDB2)storageObject;
            }
        } else {
            aUXTableIndexDB2 = ((AbstractStorageDesignDB2)storageDesign).getAUXTableIndexSet().createAUXTableIndex();
        }
        if (aUXTableIndexDB2 != null) {
            StorageObject storageObject2;
            StorageObject storageObject3;
            aUXTableIndexDB2.setName(this.getName());
            if (this.getOwner() != null) {
                storageObject3 = (Owner)((AbstractStorageDesignDB2)storageDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (storageObject3 == null) {
                    storageObject2 = (Owner)((AbstractStorageDesignDB2)storageDesign).getOwnerSet().createElement(null);
                    storageObject2.setName(this.getOwner().getName());
                    storageObject2.setRawObject(true);
                    aUXTableIndexDB2.setOwner((Owner)storageObject2);
                } else {
                    aUXTableIndexDB2.setOwner((Owner)storageObject3);
                }
            }
            if (this.getStorageTemplate() != null) {
                storageObject3 = (StorageTemplateDB2)((AbstractStorageDesignDB2)storageDesign).getStorageTemplateSet().getByName(this.getStorageTemplate().getName());
                if (storageObject3 == null) {
                    storageObject2 = ((AbstractStorageDesignDB2)storageDesign).getStorageTemplateSet().createStorageTemplate();
                    storageObject2.setName(this.getStorageTemplate().getName());
                    storageObject2.setRawObject(true);
                    aUXTableIndexDB2.setStorageTemplate((StorageTemplateDB2)storageObject2);
                } else {
                    aUXTableIndexDB2.setStorageTemplate((StorageTemplateDB2)storageObject3);
                }
            }
            aUXTableIndexDB2.setPieceSize(this.getPieceSize());
            if (this.getBufferPool() != null) {
                storageObject3 = (BufferPoolDB2)((AbstractStorageDesignDB2)storageDesign).getBufferPoolSet().getByName(this.getBufferPool().getName());
                if (storageObject3 == null) {
                    storageObject2 = (BufferPoolDB2)((AbstractStorageDesignDB2)storageDesign).getBufferPoolSet().createElement(null);
                    storageObject2.setName(this.getBufferPool().getName());
                    storageObject2.setRawObject(true);
                    aUXTableIndexDB2.setBufferPool((BufferPoolDB2)storageObject2);
                } else {
                    aUXTableIndexDB2.setBufferPool((BufferPoolDB2)storageObject3);
                }
            }
            aUXTableIndexDB2.setClose(this.isClose());
            aUXTableIndexDB2.setCopy(this.isCopy());
            aUXTableIndexDB2.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("INDEX_ICON", 16);
    }

    class NonUnique
    extends State {
        NonUnique() {
        }

        @Override
        public int getSpacePerKeyL() {
            return AUXTableIndexDB2.this.getIndexByteSize() + 4 + AUXTableIndexDB2.this.getAverageNumberDuplicatesPerKey() * (AUXTableIndexDB2.this.getRIDSize() + 1);
        }

        @Override
        public int getSpacePerKeyNL() {
            return AUXTableIndexDB2.this.getIndexByteSize() + AUXTableIndexDB2.this.getRIDSize() + 7;
        }

        @Override
        public int getEntriesPerPageL() {
            return Math.max(1, AUXTableIndexDB2.this.getKeyEntriesPerPageL() + AUXTableIndexDB2.this.getPartialEntriesPerPageL());
        }
    }

    class Unique
    extends State {
        Unique() {
        }

        @Override
        public int getSpacePerKeyL() {
            return AUXTableIndexDB2.this.getIndexByteSize() + AUXTableIndexDB2.this.getRIDSize() + 3;
        }

        @Override
        public int getSpacePerKeyNL() {
            return AUXTableIndexDB2.this.getIndexByteSize() + 7;
        }

        @Override
        public int getEntriesPerPageL() {
            return (int)Math.floor(AUXTableIndexDB2.this.getMaxUsableSpacePerPageL() / this.getSpacePerKeyL());
        }
    }

    abstract class State {
        State() {
        }

        public abstract int getSpacePerKeyL();

        public abstract int getSpacePerKeyNL();

        public abstract int getEntriesPerPageL();
    }
}

