/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.AUXTablePropertyDialogDB2;

public class AUXTableDB2
extends AbstractStorageObjectDB2
implements ModelObjectSetListener,
StorageObjectListener {
    private Owner owner = null;
    private TableSpaceDB2 tableSpace = null;
    private TableProxyDB2 table = null;
    private ColumnProxyDB2 column = null;
    private int partNumber = 0;
    StorageObjectCollection aindexes;
    public static final String TYPE_NAME = "AXTable";
    public static final String OLD_TYPE_NAME = "AUXTable";

    public AUXTableDB2(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.aindexes = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getAUXTableIndexSet());
        this.aindexes.setParent(this);
        this.aindexes.setName(Messages.getString("AUXTableDB2.Indexes"));
        this.aindexes.setClassForParent(AUXTableDB2.class);
        this.aindexes.setSetMethod("setAuxTable");
        this.aindexes.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getAUXTableIndexSet().addSetListener(this);
        this.addAUXIndexesFromDesign(((AbstractStorageDesignDB2)storageDesign).getAUXTableIndexSet());
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "AUXTBL";
    }

    public ColumnProxyDB2 getColumn() {
        return this.column;
    }

    public void setColumn(ColumnProxyDB2 columnProxyDB2) {
        this.column = columnProxyDB2;
        this.fireDataFieldChange();
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int n) {
        this.partNumber = n;
        this.fireDataFieldChange();
    }

    public TableProxyDB2 getTable() {
        return this.table;
    }

    public void setTable(TableProxyDB2 tableProxyDB2) {
        this.table = tableProxyDB2;
        this.fireDataFieldChange();
    }

    public TableSpaceDB2 getTableSpace() {
        return this.tableSpace;
    }

    public DataBaseDB2 getDatabase() {
        if (this.tableSpace != null) {
            return this.tableSpace.getDataBase();
        }
        return null;
    }

    public void setTableSpace(TableSpaceDB2 tableSpaceDB2) {
        if (tableSpaceDB2 != null) {
            this.tableSpace = tableSpaceDB2;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            AUXTablePropertyDialogDB2 aUXTablePropertyDialogDB2 = new AUXTablePropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            aUXTablePropertyDialogDB2.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.aindexes;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.aindexes) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.aindexes) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null) {
            return new StringBuffer(this.getOwner().getName()).append('.').append(this.getName()).toString();
        }
        return super.getName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getOwner() != null && !this.getOwner().isNullInstance()) {
            string = this.getOwner().getName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    private void addAUXIndexesFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            AUXTableIndexDB2 aUXTableIndexDB2 = (AUXTableIndexDB2)iterator.next();
            if (aUXTableIndexDB2.getAuxTable() != null && aUXTableIndexDB2.getAuxTable() == this) {
                aUXTableIndexDB2.setParent(this.aindexes);
                this.aindexes.add(aUXTableIndexDB2);
                continue;
            }
            this.aindexes.remove(aUXTableIndexDB2);
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof AUXTableIndexDB2) {
            AUXTableIndexDB2 aUXTableIndexDB2 = (AUXTableIndexDB2)objectChangeEvent.getAffected();
            if (aUXTableIndexDB2.getAuxTable() != null && aUXTableIndexDB2.getAuxTable() == this) {
                aUXTableIndexDB2.setParent(this.aindexes);
                this.aindexes.add(aUXTableIndexDB2);
                aUXTableIndexDB2.setPAC_Element(this);
            } else {
                this.aindexes.remove(aUXTableIndexDB2);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof AUXTableIndexDB2) {
                AUXTableIndexDB2 aUXTableIndexDB2 = (AUXTableIndexDB2)modelObjectSetEvent.getAffected();
                aUXTableIndexDB2.addObjectListener(this);
                if (aUXTableIndexDB2.getAuxTable() != null && aUXTableIndexDB2.getAuxTable() == this) {
                    aUXTableIndexDB2.setParent(this.aindexes);
                    this.aindexes.add(aUXTableIndexDB2);
                    aUXTableIndexDB2.setPAC_Element(this);
                } else {
                    this.aindexes.remove(aUXTableIndexDB2);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof AUXTableIndexDB2) {
            AUXTableIndexDB2 aUXTableIndexDB2 = (AUXTableIndexDB2)modelObjectSetEvent.getAffected();
            this.aindexes.remove(aUXTableIndexDB2);
            aUXTableIndexDB2.removeObjectListener(this);
        }
    }

    public List getAuxIndexes() {
        ArrayList arrayList = new ArrayList();
        this.aindexes.addAllElementsTo(arrayList);
        return arrayList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        AUXTableDB2 aUXTableDB2 = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)storageDesign).getAUXTableSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                aUXTableDB2 = (AUXTableDB2)storageObject;
            }
        } else {
            aUXTableDB2 = ((AbstractStorageDesignDB2)storageDesign).getAUXTableSet().createAUXTable();
        }
        if (aUXTableDB2 != null) {
            StorageObject storageObject2;
            StorageObject storageObject3;
            aUXTableDB2.setName(this.getName());
            Iterator iterator = this.aindexes.iterator();
            while (iterator.hasNext()) {
                storageObject3 = (AUXTableIndexDB2)iterator.next();
                storageObject2 = (AUXTableIndexDB2)((AbstractStorageDesignDB2)storageDesign).getAUXTableIndexSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    AUXTableIndexDB2 aUXTableIndexDB2 = ((AbstractStorageDesignDB2)storageDesign).getAUXTableIndexSet().createAUXTableIndex();
                    aUXTableIndexDB2.setName(storageObject3.getName());
                    aUXTableIndexDB2.setAuxTable(aUXTableDB2);
                    aUXTableIndexDB2.setRawObject(true);
                    aUXTableDB2.addAUXIndexesFromDesign(((AbstractStorageDesignDB2)storageDesign).getAUXTableIndexSet());
                    continue;
                }
                ((AUXTableIndexDB2)storageObject2).setAuxTable(aUXTableDB2);
                aUXTableDB2.addAUXIndexesFromDesign(((AbstractStorageDesignDB2)storageDesign).getAUXTableIndexSet());
            }
            if (this.getOwner() != null) {
                storageObject3 = (Owner)((AbstractStorageDesignDB2)storageDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (storageObject3 == null) {
                    storageObject2 = (Owner)((AbstractStorageDesignDB2)storageDesign).getOwnerSet().createElement(null);
                    storageObject2.setName(this.getOwner().getName());
                    storageObject2.setRawObject(true);
                    aUXTableDB2.setOwner((Owner)storageObject2);
                } else {
                    aUXTableDB2.setOwner((Owner)storageObject3);
                }
            }
            if (this.getTableSpace() != null) {
                storageObject3 = (TableSpaceDB2)((AbstractStorageDesignDB2)storageDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (storageObject3 == null) {
                    storageObject2 = ((AbstractStorageDesignDB2)storageDesign).getTableSpaceSet().createTableSpace();
                    storageObject2.setName(this.getTableSpace().getName());
                    storageObject2.setRawObject(true);
                    aUXTableDB2.setTableSpace((TableSpaceDB2)storageObject2);
                } else {
                    aUXTableDB2.setTableSpace((TableSpaceDB2)storageObject3);
                }
            }
            if (this.getTable() != null) {
                storageObject3 = ((TableProxySetDB2)storageDesign.getTableProxySet()).getByName(this.getTable().getName());
                if (storageObject3 == null) {
                    storageObject2 = (TableProxyDB2)((TableProxySetDB2)storageDesign.getTableProxySet()).createProxy(this.getTable().getObject());
                    ((RelationalObjectProxy)storageObject2).setName(this.getTable().getName());
                    storageObject2.setRawObject(true);
                    aUXTableDB2.setTable((TableProxyDB2)storageObject2);
                } else {
                    aUXTableDB2.setTable((TableProxyDB2)storageObject3);
                }
            }
            if (this.getColumn() != null) {
                storageObject3 = ((ColumnProxySetDB2)storageDesign.getColumnProxySet()).getByName(this.getColumn().getName());
                if (storageObject3 == null) {
                    storageObject2 = (ColumnProxyDB2)((ColumnProxySetDB2)storageDesign.getColumnProxySet()).createProxy(this.getColumn().getObject());
                    ((RelationalObjectProxy)storageObject2).setName(this.getColumn().getName());
                    storageObject2.setRawObject(true);
                    aUXTableDB2.setColumn((ColumnProxyDB2)storageObject2);
                } else {
                    aUXTableDB2.setColumn((ColumnProxyDB2)storageObject3);
                }
            }
            aUXTableDB2.setPartNumber(this.getPartNumber());
            aUXTableDB2.setComment(this.getComment());
            aUXTableDB2.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TABLE_ICON", 16);
    }

    @Override
    public void clearMergableStructure(Map map) {
        if (map != null) {
            ArrayList arrayList = new ArrayList();
            this.aindexes.addAllElementsTo(arrayList);
            for (StorageObject storageObject : arrayList) {
                if (map.get(storageObject.getObjectID()) != null) continue;
                storageObject.remove(true);
            }
        }
    }

    public StorageObjectCollection getAUXTableIndexes() {
        return this.aindexes;
    }

    public AUXTableIndexDB2 createAUXTableIndex() {
        AUXTableIndexDB2 aUXTableIndexDB2 = (AUXTableIndexDB2)this.aindexes.createElement(null);
        aUXTableIndexDB2.setAuxTable(this);
        aUXTableIndexDB2.setPAC_Element(this);
        return aUXTableIndexDB2;
    }
}

