/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;

public abstract class Trigger
extends StorageObject {
    protected String body = "";
    protected String triggerTime;
    public static final String[] ACTION_TYPES = new String[]{"INSERT", "UPDATE", "DELETE"};
    private static List actionList = Arrays.asList(ACTION_TYPES);
    private String actions = "";
    private ArraySet actionSet = null;
    private boolean cWDGenerated = false;
    public static final String TYPE_NAME = "Trigger";

    public Trigger() {
    }

    public Trigger(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Trg";
    }

    public String getTriggerTime() {
        return this.triggerTime;
    }

    public void setTriggerTime(String string) {
        if (this.checkTriggerTime(string)) {
            this.triggerTime = string;
        }
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String string) {
        this.body = string;
    }

    protected boolean checkActionType(String string) {
        return Arrays.asList(ACTION_TYPES).contains(string);
    }

    protected abstract boolean checkTriggerTime(String var1);

    private void addAction(String string) {
        if (this.checkActionType(string) && !this.getActionSet().contains(string) && actionList.contains(string)) {
            this.getActionSet().add(string);
        }
    }

    private void recreateActionSet(String string) {
        this.getActionSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (!this.checkActionType(string2)) continue;
            this.getActionSet().add(string2.trim());
        }
    }

    public void setActions(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateActionSet(string);
        } else {
            this.addAction(string);
        }
        this.actions = this.getActionSet().toString();
        this.fireDataFieldChange();
    }

    public String getActions() {
        return this.actions;
    }

    public ArraySet getActionSet() {
        if (this.actionSet == null) {
            this.actionSet = new ArraySet();
        }
        return this.actionSet;
    }

    public void clearActions() {
        this.getActionSet().removeAllElements();
        this.actions = "";
    }

    public boolean isCWDGenerated() {
        return this.cWDGenerated;
    }

    public void setCWDGenerated(boolean bl) {
        this.cWDGenerated = bl;
    }

    public class ArraySet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

