/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.MethodProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TypeElementProxy;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class StructuredTypeProxy
extends RelationalObjectProxy
implements RelationalObjectProxySetListener {
    private boolean commentChanged = false;
    private boolean commentInRDBMSChanged = false;
    protected StorageObjectCollection elements;
    protected StorageObjectCollection methods;
    public static final String TYPE_NAME = "SType";

    public StructuredTypeProxy(StructuredType structuredType, StorageDesign storageDesign) {
        super(structuredType, storageDesign);
        this.initElementsAndMethods(storageDesign);
    }

    public StructuredTypeProxy(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.initElementsAndMethods(storageDesign);
    }

    private void initElementsAndMethods(StorageDesign storageDesign) {
        this.elements = new StorageObjectCollection();
        this.elements.setParent(this);
        this.elements.setName(Messages.getString("StructuredTypeProxy.Attributes"));
        this.elements.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON", 16));
        this.methods = new StorageObjectCollection();
        this.methods.setParent(this);
        this.methods.setName(Messages.getString("StructuredTypeProxy.Methods"));
        this.methods.setIcon(GUIConfiguration.getInstance().getIcon("METHOD_ICON", 16));
        storageDesign.getTypeElementProxySet();
        storageDesign.getMethodProxySet();
        this.addTypeElementProxiesFromDesign();
        this.addMethodProxiesFromDesign();
        storageDesign.getTypeElementProxySet().addSetListener(this);
        storageDesign.getMethodProxySet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return "Structure Type";
    }

    public StructuredType getStructuredType() {
        return (StructuredType)this.getObject();
    }

    @Override
    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    @Override
    public void setCommentChanged(boolean bl) {
        this.commentChanged = bl;
    }

    @Override
    public boolean isCommentInRDBMSChanged() {
        return this.commentInRDBMSChanged;
    }

    @Override
    public void setCommentInRDBMSChanged(boolean bl) {
        this.commentInRDBMSChanged = bl;
    }

    @Override
    public String getComment() {
        if (this.isCommentChanged()) {
            return super.getComment();
        }
        return this.getObject().getComment();
    }

    @Override
    public void setComment(String string) {
        if (!string.equals(this.getObject().getComment())) {
            super.setComment(string);
            this.setCommentChanged(true);
        } else {
            this.setCommentChanged(false);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.elements;
            }
            case 1: {
                return this.methods;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.elements) {
            return 0;
        }
        if (modelObject == this.methods) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.elements) {
            return 0;
        }
        if (object == this.methods) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof TypeElementProxy) {
                TypeElementProxy typeElementProxy = (TypeElementProxy)modelObjectSetEvent.getAffected();
                if (this.getObject() == typeElementProxy.getStructuredType()) {
                    typeElementProxy.setParent(this.elements);
                    this.elements.add(modelObjectSetEvent.getAffected());
                }
            } else if (modelObjectSetEvent.getAffected() instanceof MethodProxy) {
                MethodProxy methodProxy = (MethodProxy)modelObjectSetEvent.getAffected();
                if (this.getObject() == methodProxy.getStructuredType()) {
                    methodProxy.setParent(this.methods);
                    this.methods.add(modelObjectSetEvent.getAffected());
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof TypeElementProxy) {
                TypeElementProxy typeElementProxy = (TypeElementProxy)modelObjectSetEvent.getAffected();
                this.elements.remove(typeElementProxy.getObject().getObjectID());
            } else if (modelObjectSetEvent.getAffected() instanceof MethodProxy) {
                MethodProxy methodProxy = (MethodProxy)modelObjectSetEvent.getAffected();
                this.methods.remove(methodProxy.getObject().getObjectID());
            }
        }
    }

    private void addTypeElementProxiesFromDesign() {
        for (TypeElement typeElement : this.getStructuredType().getAttributesList()) {
            TypeElementProxy typeElementProxy = (TypeElementProxy)this.getStorageDesign().getStorageObject(typeElement.getObjectID());
            if (typeElementProxy == null) continue;
            typeElementProxy.setParent(this.elements);
            this.elements.addWithoutCheck(typeElementProxy);
        }
    }

    private void addMethodProxiesFromDesign() {
        for (Method method : this.getStructuredType().getMethodsList()) {
            MethodProxy methodProxy = (MethodProxy)this.getStorageDesign().getStorageObject(method.getObjectID());
            if (methodProxy == null) continue;
            methodProxy.setParent(this.methods);
            this.methods.addWithoutCheck(methodProxy);
        }
    }

    public StorageObjectCollection getElements() {
        return this.elements;
    }

    public StorageObjectCollection getMethods() {
        return this.methods;
    }

    public boolean hasParentType() {
        return this.getStructuredType().getParentType() != null;
    }

    public StructuredTypeProxy getParentType() {
        if (this.hasParentType()) {
            return (StructuredTypeProxy)this.getStorageDesign().getProxy(this.getStructuredType().getParentType());
        }
        return null;
    }

    public TypeElementProxy getElementByDesignObject(DesignObject designObject) {
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            TypeElementProxy typeElementProxy = (TypeElementProxy)iterator.next();
            if (typeElementProxy.getObject() != designObject) continue;
            return typeElementProxy;
        }
        return null;
    }

    public StorageObject getSchemaOrUser() {
        return null;
    }
}

