/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.SegmentNameManager;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSetEvent;
import oracle.dbtools.crest.model.design.storage.StorageObjectSetListener;
import oracle.dbtools.crest.model.design.storage.StorageSet;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;

public abstract class StorageObjectSet
extends ModelIDObjectSet
implements StorageSet {
    private StorageDesign storageDesign = null;
    private Map adapterMap = new HashMap();
    protected StorageObject nullInstance;
    private SegmentNameManager segManager = new SegmentNameManager();
    private Boolean containsTopLevelStorableObjects = null;

    public void setStorageDesign(StorageDesign storageDesign) {
        if (this.storageDesign != null) {
            this.removeSetListener(storageDesign);
        }
        this.storageDesign = storageDesign;
        if (storageDesign != null) {
            this.addSetListener(storageDesign);
        }
    }

    @Override
    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    @Override
    public abstract Object[] getProtoTypeArray();

    public void addSetListener(StorageObjectSetListener storageObjectSetListener) {
        if (this.adapterMap.containsKey(storageObjectSetListener)) {
            return;
        }
        if (storageObjectSetListener == null) {
            throw new RuntimeException("listener == null, check if inner class is registered during construction.");
        }
        ListenerAdapter listenerAdapter = new ListenerAdapter(storageObjectSetListener);
        this.adapterMap.put(storageObjectSetListener, listenerAdapter);
        super.addSetListener(listenerAdapter);
    }

    public void removeSetListener(StorageObjectSetListener storageObjectSetListener) {
        if (!this.adapterMap.containsKey(storageObjectSetListener)) {
            return;
        }
        ListenerAdapter listenerAdapter = (ListenerAdapter)this.adapterMap.remove(storageObjectSetListener);
        super.removeSetListener(listenerAdapter);
    }

    @Override
    public String getSeparator() {
        return "";
    }

    @Override
    public boolean isWriteable() {
        return true;
    }

    public String getNullInstanceName() {
        return "[None]";
    }

    public String getNullInstanceComment() {
        return "No value";
    }

    public StorageObject getNullInstance() {
        return this.getNullInstance(this.getNullInstanceName());
    }

    public void clearNullInstance() {
        this.nullInstance = null;
    }

    public StorageObject getNullInstance(String string) {
        if (this.nullInstance == null) {
            this.nullInstance = (StorageObject)this.createElement(this.getDefaultNamePrefix() + "_NULLELEMENT");
            this.nullInstance.setName(string);
            this.nullInstance.setComment(this.getNullInstanceComment());
            this.nullInstance.setIsNullInstance(true);
            this.nameCounterDecrement();
            this.nullInstance.setOwnerDesignName(Design.getSystemDesignName());
        }
        return this.nullInstance;
    }

    public boolean hasNullInstance() {
        return this.nullInstance != null;
    }

    @Override
    public boolean containsSiteStorageObjects() {
        return true;
    }

    @Override
    public final boolean containsDesignStorageObjects() {
        return !this.containsSiteStorageObjects();
    }

    @Override
    public void add(ModelObject modelObject) {
        modelObject.setParent(this);
        super.add(modelObject);
        ((StorageObject)modelObject).setObjectSet(this);
        this.getStorageDesign().registerModelIDObject((StorageObject)modelObject);
    }

    @Override
    public boolean remove(ModelObject modelObject) {
        boolean bl;
        if (modelObject instanceof ModelIDObject) {
            ((ModelIDObject)modelObject).closePropertiesDialog();
        }
        if (bl = super.remove(modelObject)) {
            this.getStorageDesign().unregisterModelIDObject((StorageObject)modelObject);
        }
        return bl;
    }

    public void justAdd(ModelObject modelObject) {
        super.add(modelObject);
    }

    public boolean justRemove(ModelObject modelObject) {
        return super.remove(modelObject);
    }

    @Override
    public void sort() {
        Collections.sort(this.elements, ModelObjectSet.NAME_COMPARATOR);
    }

    @Override
    public boolean canCreateElement() {
        return true;
    }

    public StorageObject getByNameAndDatabase(String string, String string2) {
        if (string != null && string2 != null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                StorageObject storageObject = (StorageObject)iterator.next();
                if (storageObject instanceof AbstractStorageObjectSqlServer) {
                    AbstractStorageObjectSqlServer abstractStorageObjectSqlServer = (AbstractStorageObjectSqlServer)storageObject;
                    if (abstractStorageObjectSqlServer.getDatabase() == null || !string.equalsIgnoreCase(abstractStorageObjectSqlServer.getName()) || !string2.equalsIgnoreCase(abstractStorageObjectSqlServer.getDatabase().getName())) continue;
                    return abstractStorageObjectSqlServer;
                }
                return null;
            }
        }
        return null;
    }

    public StorageObject getByNameAndDatabase(String string, DataBaseSqlServer dataBaseSqlServer) {
        if (string != null && dataBaseSqlServer != null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                StorageObject storageObject = (StorageObject)iterator.next();
                if (storageObject instanceof AbstractStorageObjectSqlServer) {
                    AbstractStorageObjectSqlServer abstractStorageObjectSqlServer = (AbstractStorageObjectSqlServer)storageObject;
                    if (abstractStorageObjectSqlServer.getDatabase() == null || !string.equalsIgnoreCase(abstractStorageObjectSqlServer.getName()) || dataBaseSqlServer != abstractStorageObjectSqlServer.getDatabase()) continue;
                    return abstractStorageObjectSqlServer;
                }
                return null;
            }
        }
        return null;
    }

    public String getSegmentName(ModelIDObject modelIDObject) {
        if (this.isContainsTopLevelStorableObjects()) {
            return this.segManager.getSegmentName(modelIDObject);
        }
        return "";
    }

    public String getSegmentName(String string) {
        if (this.isContainsTopLevelStorableObjects()) {
            return this.segManager.getSegmentName(string);
        }
        return "";
    }

    public void addSegmentEntry(String string, String string2) {
        this.addSegmentEntry(string, string2, false);
    }

    public void addSegmentEntry(String string, String string2, boolean bl) {
        if (this.isContainsTopLevelStorableObjects()) {
            if (bl) {
                this.segManager.removeID(string2);
            }
            this.segManager.add(string, string2);
        }
    }

    public boolean isContainsTopLevelStorableObjects() {
        if (this.containsTopLevelStorableObjects == null) {
            this.containsTopLevelStorableObjects = this.getStorageDesign().getStorableSetsList().contains(this) ? new Boolean(true) : new Boolean(false);
        }
        return this.containsTopLevelStorableObjects;
    }

    public StorageObject getBySchemaObject(SchemaObject schemaObject) {
        if (schemaObject != null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                StorageObject storageObject = (StorageObject)iterator.next();
                if (schemaObject != storageObject.getSchemaObject()) continue;
                return storageObject;
            }
        }
        return null;
    }

    @Override
    protected String createName() {
        if (this.getStorageDesign().isLoading() || this.getStorageDesign().getAppView().isImporting()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getDefaultNamePrefix());
            stringBuffer.append(this.getSeparator());
            stringBuffer.append(this.count++);
            return stringBuffer.toString();
        }
        return super.createName();
    }

    @Override
    public void doAdd() {
        if (this.canSort()) {
            this.sort();
        }
    }

    @Override
    public boolean canSort() {
        return this.getStorageDesign() != null && !this.getStorageDesign().isLoading() && ApplicationView.canLogging;
    }

    static class EventAdapter
    extends StorageObjectSetEvent {
        private EventAdapter(ModelObjectSetEvent modelObjectSetEvent) {
            super((StorageObject)modelObjectSetEvent.getAffected(), modelObjectSetEvent.getType());
        }
    }

    static class ListenerAdapter
    implements ModelObjectSetListener {
        private StorageObjectSetListener listener = null;

        private ListenerAdapter(StorageObjectSetListener storageObjectSetListener) {
            this.listener = storageObjectSetListener;
        }

        @Override
        public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
            this.listener.changed((StorageObjectSet)modelObjectSet, new EventAdapter(modelObjectSetEvent));
        }
    }
}

