/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;

public class StorageObjectPlaceHolder
extends StorageObject
implements StorageObjectListener {
    StorageObject object;
    Object parent;

    public StorageObjectPlaceHolder() {
    }

    public StorageObjectPlaceHolder(String string) {
        this();
        this.setName(string);
    }

    public StorageObjectPlaceHolder(StorageObject storageObject) {
        this();
        this.object = storageObject;
        this.setDesign(storageObject.getDesign());
        if (this.getStorageObject() != null) {
            this.getStorageObject().addObjectListener(this);
        }
    }

    public void setObject(StorageObject storageObject) {
        if (this.getStorageObject() != null) {
            this.getStorageObject().removeObjectListener(this);
        }
        this.object = storageObject;
        if (this.getStorageObject() != null) {
            this.getStorageObject().addObjectListener(this);
        }
    }

    public Object getObject() {
        return this.object;
    }

    public StorageObject getStorageObject() {
        return this.object;
    }

    @Override
    public String getName() {
        if (this.object != null) {
            String string = this.object.getName();
            string = this.applyNameSubstitution(string);
            return string;
        }
        return super.getName();
    }

    public boolean isDesignLevelAccessibleObject() {
        return false;
    }

    @Override
    public String getObjectTypeName() {
        return "StorageObjectPlaceHolder";
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("StorageObjectPlaceHolder");
    }

    @Override
    public int getNumberOfChildren() {
        return 0;
    }

    @Override
    public ModelObject getChild(int n) {
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void setParent(Object object) {
        this.parent = object;
    }

    @Override
    public Object getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        return super.getParent();
    }

    @Override
    public String toString() {
        return this.getObject().toString();
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.NAME_CHANGED)) {
            this.fireChange(new ObjectChangeEvent("StorageObject Name Changed"));
        }
    }
}

