/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;

public class StorageObjectCollection
extends ModelIDObjectSet
implements ModelObjectSetListener {
    private static final StorageObject[] PROTO_ARRAY = new StorageObject[0];
    private StorageObjectSet set;
    Class parcl;
    private String setMethod;
    int allowedNumberOfElements = 99999;
    private boolean forbiddenCreateElement = false;
    private ModelObject logicalParent;

    public StorageObjectCollection() {
    }

    public StorageObjectCollection(StorageObjectSet storageObjectSet) {
        this.set = storageObjectSet;
        this.set.addSetListener(this);
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public ModelIDObject createElement(String string) {
        if (this.set != null) {
            StorageObject storageObject = (StorageObject)this.set.createElement(string);
            storageObject.setParent(this);
            if (this.getClassForParent() != null && this.getSetMethod() != null && this.getLogicalParent() != null) {
                Class<?> clazz = storageObject.getClass();
                try {
                    Method method = clazz.getMethod(this.getSetMethod(), this.getClassForParent());
                    if (method != null) {
                        try {
                            method.invoke((Object)storageObject, this.getLogicalParent());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {}
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            this.add(storageObject);
            return storageObject;
        }
        return null;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "StorageObject";
    }

    @Override
    public boolean canCreateElement() {
        if (this.set != null) {
            return !this.isForbiddenCreateElement() && this.set.canCreateElement() && this.size() < this.getAllowedNumberOfElements();
        }
        return false;
    }

    public void removePlaceHolderFor(StorageObject storageObject) {
        StorageObject[] storageObjectArray = (StorageObject[])this.toArray();
        for (int i = 0; i < storageObjectArray.length; ++i) {
            StorageObject storageObject2 = storageObjectArray[i];
            if (!(storageObject2 instanceof StorageObjectPlaceHolder) || ((StorageObjectPlaceHolder)storageObject2).getStorageObject() != storageObject) continue;
            this.remove(storageObject2);
            return;
        }
    }

    public boolean containsPlaceHolderFor(StorageObject storageObject) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StorageObject storageObject2 = (StorageObject)iterator.next();
            if (!(storageObject2 instanceof StorageObjectPlaceHolder) || ((StorageObjectPlaceHolder)storageObject2).getStorageObject() != storageObject) continue;
            return true;
        }
        return false;
    }

    public Class getClassForParent() {
        return this.parcl;
    }

    public void setClassForParent(Class clazz) {
        this.parcl = clazz;
    }

    public String getSetMethod() {
        return this.setMethod;
    }

    public void setSetMethod(String string) {
        this.setMethod = string;
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof StorageObject) {
            this.remove(modelObjectSetEvent.getAffected());
        }
    }

    public int getAllowedNumberOfElements() {
        return this.allowedNumberOfElements;
    }

    public void setAllowedNumberOfElements(int n) {
        this.allowedNumberOfElements = n;
    }

    @Override
    public boolean remove(ModelObject modelObject) {
        boolean bl = super.remove(modelObject);
        if (bl && modelObject instanceof StorageObject) {
            ((StorageObject)modelObject).remove();
            return true;
        }
        return bl;
    }

    public boolean justRemove(ModelObject modelObject) {
        return super.remove(modelObject);
    }

    public boolean isForbiddenCreateElement() {
        return this.forbiddenCreateElement;
    }

    public void setForbiddenCreateElement(boolean bl) {
        this.forbiddenCreateElement = bl;
    }

    public ModelObject getLogicalParent() {
        if (this.logicalParent != null) {
            return this.logicalParent;
        }
        return (ModelObject)this.getParent();
    }

    public void setLogicalParent(ModelObject modelObject) {
        this.logicalParent = modelObject;
    }

    @Override
    public void add(ModelObject modelObject) {
        if (modelObject instanceof StorageObjectPlaceHolder) {
            if (!this.containsPlaceHolderFor(((StorageObjectPlaceHolder)modelObject).getStorageObject())) {
                super.add(modelObject);
            }
        } else if (!this.contains(modelObject)) {
            super.add(modelObject);
        }
    }

    public void addWithoutCheck(ModelObject modelObject) {
        super.add(modelObject);
    }

    public StorageObjectSet getStorageObjectSet() {
        return this.set;
    }

    public void setStorageObjectSet(StorageObjectSet storageObjectSet) {
        this.set = storageObjectSet;
    }
}

