/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.RDBMSObject;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObject;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubject;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubjectImpl;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.SubstitutionPattern;

public abstract class StorageObject
extends ModelIDObject
implements UpdateSubject,
RDBMSObject {
    public final ObjectChangeEvent GENERATED_IN_RDBMS_CHANGED = new ObjectChangeEvent("generated in RDBMS");
    public final ObjectChangeEvent DATAFIELD_CHANGED = new ObjectChangeEvent("Some data field changed");
    public static final String[] RELATIVE_PATH_DUMMY = new String[]{"proxy_or_site_elm", "object_type_elm"};
    private StorageDesign storageDesign = null;
    private boolean generatedInRDBMS = false;
    private boolean markedGenerate = true;
    private UpdateSubjectImpl updateDelegate = new UpdateSubjectImpl();
    private boolean isNullInstance = false;
    private boolean storableNullInstance = false;
    private boolean nameHasQuotes = false;
    private boolean rawObject = false;
    public static final String NAME_SUBSTITUTION_TYPE = "Unsupported Type";
    protected SchemaObject schemaObject;
    private boolean nameChanged = false;

    public List<JMenuItem> getAdditionalActions() {
        return new ArrayList<JMenuItem>();
    }

    public String getFullyQualifiedName() {
        if (this instanceof OwnedObject) {
            Owner owner = ((OwnedObject)((Object)this)).getOwner();
            String string = "";
            if (!owner.isNullInstance() && (string = owner.isNameChanged() ? new StringBuffer(owner.getName()).append('.').append(this.getName()).toString() : (owner.getSchemaObject() != null ? new StringBuffer(owner.getSchemaObject().getName()).append('.').append(this.getName()).toString() : new StringBuffer(owner.getName()).append('.').append(this.getName()).toString())).indexOf(46) == 0 && string.length() > 0) {
                string = string.substring(1);
            }
        }
        return this.getName();
    }

    @Override
    public String getLongName() {
        return this.getFullyQualifiedName();
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public PropertyHolder getPropertyHolder() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        RepositoryObject repositoryObject;
        if (this.isNullInstance() && !this.isStorableNullInstance()) {
            return true;
        }
        if (!this.isPAC_Element() && (repositoryObject = this.getPAC_Element()).getRepositoryOID() != null && this.getDesign().isLoadFromDB() && !this.getStorageDesign().isLoading()) {
            return !repositoryObject.isCheckedOutByMe();
        }
        if (this.getRepositoryOID() != null && this.getDesign().isLoadFromDB() && !this.getStorageDesign().isLoading()) {
            return !this.isCheckedOutByMe();
        }
        return this.readOnly;
    }

    public boolean isPhysicalObjectProxy() {
        return false;
    }

    public boolean isNullInstance() {
        return this.isNullInstance;
    }

    public void setIsNullInstance(boolean bl) {
        this.isNullInstance = bl;
    }

    public void addObjectListener(StorageObjectListener storageObjectListener) {
        this.getListeners().add(storageObjectListener);
    }

    public void removeObjectListener(StorageObjectListener storageObjectListener) {
        this.getListeners().remove(storageObjectListener);
    }

    protected void fireDataFieldChange() {
        this.fireChange(this.DATAFIELD_CHANGED);
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
        objectChangeEvent.setAffected(this);
        this.setDirty(true);
        this.getChange().setTimeNow();
        Object[] objectArray = this.getListeners().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            StorageObjectListener storageObjectListener = (StorageObjectListener)objectArray[i];
            storageObjectListener.changed(this, objectChangeEvent);
        }
        this.fireUpdate();
    }

    protected void fireChangeNoDirty(ObjectChangeEvent objectChangeEvent) {
        objectChangeEvent.setAffected(this);
        Object[] objectArray = this.getListeners().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            StorageObjectListener storageObjectListener = (StorageObjectListener)objectArray[i];
            storageObjectListener.changed(this, objectChangeEvent);
        }
        this.fireUpdate();
    }

    @Override
    public void setDirty(boolean bl) {
        super.setDirty(bl);
        RepositoryObject repositoryObject = this.getPAC_Element();
        if (repositoryObject != null) {
            repositoryObject.setDirty(bl);
        }
        if (bl && this.storageDesign != null) {
            this.storageDesign.setDirty(bl);
        }
    }

    protected void fireUpdate() {
        this.updateDelegate.fireChange();
    }

    @Override
    public void addUpdateListener(UpdateListener updateListener) {
        this.updateDelegate.addUpdateListener(updateListener);
    }

    @Override
    public void removeUpdateListener(UpdateListener updateListener) {
        this.updateDelegate.removeUpdateListener(updateListener);
    }

    @Override
    public boolean isGeneratedInRDBMS() {
        return this.generatedInRDBMS;
    }

    @Override
    public void setGeneratedInRDBMS(boolean bl) {
        this.generatedInRDBMS = bl;
        this.fireChange(this.GENERATED_IN_RDBMS_CHANGED);
    }

    @Override
    public boolean isMarkedGenerate() {
        return this.getStorageDesign().isOpen() && this.markedGenerate && !this.isNullInstance();
    }

    @Override
    public void setMarkedGenerate(boolean bl) {
        this.markedGenerate = bl;
    }

    @Override
    public boolean belongsTo(StorageDesign storageDesign) {
        if (this.getStorageDesign() == null) {
            return false;
        }
        return this.getStorageDesign().equals(storageDesign) && this.belongsToDesign();
    }

    public RDBMSSite getRDBMSSite() {
        return this.getStorageDesign().getRDBMSSite();
    }

    public RDBMSType getRDBMSType() {
        return this.getStorageDesign().getRDBMSType();
    }

    public String[] getRelativePath() {
        return RELATIVE_PATH_DUMMY;
    }

    public boolean isSiteStorageObject() {
        return true;
    }

    public final boolean isDesignStorageObject() {
        return !this.isSiteStorageObject();
    }

    public boolean isOwnedObject() {
        return this instanceof OwnedObject;
    }

    public OwnedObject asOwnedObject() {
        return (OwnedObject)((Object)this);
    }

    public void clearChildren() {
    }

    public void remove(boolean bl) {
        if (!this.isNullInstance) {
            if (!bl) {
                this.remove();
            } else if (this.getStorageDesign() != null) {
                RepositoryObject repositoryObject;
                StorageObjectSet storageObjectSet = (StorageObjectSet)this.getObjectSet();
                if (storageObjectSet == null && (storageObjectSet = this.getStorageDesign().getStorageObjectSetForType(this.getObjectTypeName())) == null) {
                    storageObjectSet = this.getStorageDesign().getStorageObjectSetForType(this.getOldObjectTypeName());
                }
                if (storageObjectSet != null) {
                    repositoryObject = this.getStorageDesign();
                    this.clearChildren();
                    storageObjectSet.remove(this);
                    ((ModelIDObject)repositoryObject).setDirty(true);
                }
                if ((repositoryObject = this.getPAC_Element()) != null) {
                    repositoryObject.setDirty(true);
                }
            }
        }
    }

    @Override
    public void remove() {
        if (this.isWriteable() && this.getStorageDesign() != null) {
            RepositoryObject repositoryObject;
            StorageObjectSet storageObjectSet = (StorageObjectSet)this.getObjectSet();
            if (storageObjectSet == null && (storageObjectSet = this.getStorageDesign().getStorageObjectSetForType(this.getObjectTypeName())) == null) {
                storageObjectSet = this.getStorageDesign().getStorageObjectSetForType(this.getOldObjectTypeName());
            }
            if (storageObjectSet != null) {
                repositoryObject = this.getStorageDesign();
                this.clearChildren();
                storageObjectSet.remove(this);
                ((ModelIDObject)repositoryObject).setDirty(true);
            }
            if ((repositoryObject = this.getPAC_Element()) != null) {
                repositoryObject.setDirty(true);
            }
        }
    }

    @Override
    public void setObjectID(String string) {
        if (this.storageDesign != null) {
            this.getStorageDesign().unregisterModelIDObject(this);
            this.id = string;
            this.getStorageDesign().registerModelIDObject(this);
        } else {
            this.id = string;
        }
    }

    public void setLongName(String string) {
    }

    @Override
    public abstract void showPropertyDialog();

    public boolean canDeleteInGUI() {
        return true;
    }

    public boolean hasPropertyDialog() {
        return true;
    }

    public boolean getNameHasQuotes() {
        return this.nameHasQuotes;
    }

    public void setNameHasQuotes(boolean bl) {
        this.nameHasQuotes = bl;
    }

    public String getNameSubstitutionType() {
        return NAME_SUBSTITUTION_TYPE;
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        return super.allowName(string, bl);
    }

    @Override
    public boolean setName(String string) {
        if (string != null) {
            if (this.name.equals(string)) {
                return true;
            }
            if (this.getStorageDesign() != null) {
                this.getStorageDesign().setObjectListChanged(true);
            }
            if (this.isTopLevelObject()) {
                if ("".equals(this.name) && this.getStorageDesign() != null && (this.getStorageDesign().isLoading() || this.getStorageDesign().getAppView().isImporting())) {
                    this.name = string;
                    return true;
                }
                boolean bl = super.setName(string);
                if (bl && this.getStorageDesign() != null && !this.getStorageDesign().isLoading() && ApplicationView.canLogging) {
                    this.sortObjectSet();
                }
                return bl;
            }
            this.name = string;
            return true;
        }
        return false;
    }

    protected void sortObjectSet() {
        StorageObjectSet storageObjectSet = (StorageObjectSet)this.getObjectSet();
        if (storageObjectSet != null) {
            storageObjectSet.sort();
        }
    }

    @Override
    public String getName() {
        String string = super.getName();
        string = this.applyNameSubstitution(string);
        return string;
    }

    protected String applyNameSubstitution(String string) {
        SubstitutionPattern substitutionPattern;
        if (this.getDesign().isApplyNameSubstitution() && !this.getNameSubstitutionType().equals(NAME_SUBSTITUTION_TYPE) && this.getStorageDesign().isNameSubstitutionTypeSelected(this.getNameSubstitutionType()) && (substitutionPattern = this.getsSubstitutionPatterns(string)) != null) {
            String string2 = string;
            if (string2 == null) {
                return "";
            }
            if ((string2 = this.replaceWord(string2, substitutionPattern)).indexOf(46) == 0) {
                string2 = string2.substring(1);
            }
            return string2;
        }
        return string;
    }

    private SubstitutionPattern getsSubstitutionPatterns(String string) {
        Design.DLSettings dLSettings = this.getDesign().getDLSettings();
        for (SubstitutionPattern substitutionPattern : dLSettings.getSubstitutionList()) {
            if (!substitutionPattern.isSelected() || !this.hasString(string, substitutionPattern)) continue;
            return substitutionPattern;
        }
        return null;
    }

    private boolean hasString(String string, SubstitutionPattern substitutionPattern) {
        String string2 = substitutionPattern.getSourceString();
        if (!substitutionPattern.isCaseSensitive()) {
            string2 = string2.toUpperCase();
            string = string.toUpperCase();
        }
        return string.indexOf(string2) > -1;
    }

    private String replaceWord(String string, SubstitutionPattern substitutionPattern) {
        String string2;
        String string3;
        String string4 = substitutionPattern.getSourceString();
        int n = -1;
        if (!substitutionPattern.isCaseSensitive()) {
            string3 = string4.toUpperCase();
            string2 = string.toUpperCase();
            n = string2.indexOf(string3);
        } else {
            n = string.indexOf(string4);
        }
        if (n > -1) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + substitutionPattern.getSourceString().length());
            string = string3 + substitutionPattern.getReplacementString() + string2;
        }
        return string;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void copy(StorageDesign storageDesign) {
    }

    public boolean isRawObject() {
        return this.rawObject;
    }

    public void setRawObject(boolean bl) {
        this.rawObject = bl;
    }

    public boolean isTopLevelObject() {
        return true;
    }

    public void clearNoneMergableStructure() {
    }

    public void clearMergableStructure(Map map) {
    }

    @Override
    public String getIDPrefix() {
        return null;
    }

    @Override
    public String getObjectTypeName() {
        return null;
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        StorageObject storageObject = this.storageDesign.getStorageObject(string2);
        if (storageObject == null) {
            ModelIDObject modelIDObject;
            String string3 = null;
            Map map = this.storageDesign.getCorrespondenceMap();
            if (map != null && (modelIDObject = (ModelIDObject)map.get(string2)) != null) {
                string3 = modelIDObject.getObjectID();
                storageObject = this.storageDesign.getStorageObject(string3);
            }
        }
        if (storageObject != null) {
            return storageObject;
        }
        return super.translateIdToObject(string, string2);
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getStorageDesign().getStoragePath(), this.getObjectTypeName() + "/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public SchemaObject getSchemaObject() {
        return this.schemaObject;
    }

    public void setSchemaObject(SchemaObject schemaObject) {
        this.schemaObject = schemaObject;
    }

    public boolean isNameChanged() {
        return this.nameChanged;
    }

    public void setNameChanged(boolean bl) {
        this.nameChanged = bl;
    }

    @Override
    public String getDirectorySegmentName() {
        StorageObjectSet storageObjectSet;
        if ("".equals(this.directorySegmentName) && (storageObjectSet = (StorageObjectSet)this.getObjectSet()) != null) {
            this.directorySegmentName = storageObjectSet.getSegmentName(this);
        }
        return this.directorySegmentName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getSegmentedStorageName() {
        StorageObjectSet storageObjectSet = (StorageObjectSet)this.getObjectSet();
        if (this.segmentedStorageName != null) return this.segmentedStorageName;
        if (storageObjectSet == null) return super.getSegmentedStorageName();
        String string = storageObjectSet.getSegmentName(this);
        if ("".equals(string)) return super.getSegmentedStorageName();
        File file = new File(this.getStorageName());
        String string2 = file.getName();
        this.segmentedStorageName = file.getParent() + "/" + string + "/" + string2;
        return this.segmentedStorageName;
    }

    @Override
    public void setDirectorySegmentName(String string) {
        this.setDirectorySegmentName(string, false);
    }

    @Override
    public void setDirectorySegmentName(String string, boolean bl) {
        StorageObjectSet storageObjectSet;
        if (string != null && !"".equals(string) && (storageObjectSet = (StorageObjectSet)this.getObjectSet()) != null) {
            storageObjectSet.addSegmentEntry(string, this.getObjectID(), bl);
        }
        this.directorySegmentName = string;
    }

    public boolean isStorableNullInstance() {
        return this.storableNullInstance;
    }

    public void setStorableNullInstance(boolean bl) {
        this.storableNullInstance = bl;
    }

    @Override
    public String replaceIDsInValue(String string) {
        if (string != null && !"".equals(string)) {
            String string2 = "";
            Map map = this.getStorageDesign().getCorrespondenceMap();
            if (map != null) {
                StringTokenizer stringTokenizer = null;
                if (string.indexOf(44) > 0) {
                    stringTokenizer = new StringTokenizer(string, ",");
                } else if (string.trim().indexOf(32) > 0) {
                    stringTokenizer = new StringTokenizer(string.trim(), " ");
                }
                if (stringTokenizer != null) {
                    boolean bl = true;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        String string4 = string3.trim();
                        ModelIDObject modelIDObject = (ModelIDObject)map.get(string4);
                        if (modelIDObject != null && modelIDObject.getObjectID() != string4) {
                            string3 = modelIDObject.getObjectID();
                        }
                        if (bl) {
                            string2 = string3;
                            bl = false;
                            continue;
                        }
                        string2 = string2 + "," + string3;
                    }
                    return string2;
                }
                ModelIDObject modelIDObject = (ModelIDObject)map.get(string);
                if (modelIDObject != null) {
                    String string5 = modelIDObject.getObjectID();
                    return string5;
                }
            }
        }
        return string;
    }

    @Override
    public ElementSet getSet() {
        return this.getObjectSet();
    }
}

