/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.SegmentNameManager;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ReadRequest;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageSet;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubject;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubjectImpl;
import oracle.dbtools.crest.swingui.ApplicationView;

public class RelationalObjectProxySet
extends ModelObject
implements SetListener,
UpdateSubject,
StorageSet,
ElementSet {
    private Map idMap = new TreeMap();
    private UpdateSubjectImpl updateDelegate = new UpdateSubjectImpl();
    private StorageDesign storageDesign;
    protected List elements = new ArrayList();
    private Set listeners = new HashSet();
    private SegmentNameManager segManager = new SegmentNameManager();
    private Boolean containsTopLevelStorableObjects = null;

    public RelationalObjectProxySet(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public void doAfterAdd(RelationalObjectProxy relationalObjectProxy) {
    }

    @Override
    public ModelIDObject getObjectGeneratedBy(String string) {
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            RelationalObjectProxy relationalObjectProxy = (RelationalObjectProxy)iterator.next();
            if (!string.equals(relationalObjectProxy.getObject().getObjectID())) continue;
            iterator = null;
            return relationalObjectProxy;
        }
        iterator = null;
        return null;
    }

    @Override
    public ModelIDObject getObjectGeneratedBy(DesignObject designObject) {
        return this.getObjectGeneratedBy(designObject.getObjectID());
    }

    @Override
    public Collection getObjectsGeneratedBy(String string, Collection collection) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StorageObject storageObject = (StorageObject)iterator.next();
            if (!string.equals(storageObject.getGeneratorID())) continue;
            collection.add(storageObject);
        }
        return collection;
    }

    public void add(DesignObject designObject) {
        if (!this.isBackupObject(designObject)) {
            String string = designObject.getObjectID();
            RelationalObjectProxy relationalObjectProxy = this.getProxy(string);
            if (relationalObjectProxy != null) {
                if (!relationalObjectProxy.isLoaded()) {
                    relationalObjectProxy.loadDesignObject();
                }
            } else {
                relationalObjectProxy = this.createProxy(designObject);
                this.add(relationalObjectProxy);
                this.fireUpdate();
            }
        }
    }

    protected boolean isBackupObject(DesignObject designObject) {
        return designObject.isBackup();
    }

    @Override
    public void sort() {
        Collections.sort(this.elements, ModelObjectSet.NAME_COMPARATOR);
    }

    public void remove(ModelIDObject modelIDObject) {
        this.remove(modelIDObject.getObjectID());
    }

    public void remove(String string) {
        ModelIDObject modelIDObject = (ModelIDObject)this.idMap.remove(string);
        if (modelIDObject != null) {
            int n = this.elements.indexOf(modelIDObject);
            this.elements.remove(modelIDObject);
            if (this.getStorageDesign() != null && modelIDObject != null) {
                this.getStorageDesign().unregisterModelIDObject(modelIDObject);
            }
            modelIDObject.remove();
            this.fireUpdate();
            this.fireRemoved(modelIDObject, n);
        }
    }

    public void updateProxyID(String string, String string2) {
        ModelIDObject modelIDObject = (ModelIDObject)this.idMap.remove(string);
        if (modelIDObject != null) {
            this.idMap.put(string2, modelIDObject);
        }
    }

    public void add(String string, String string2) {
        if (!this.idMap.containsKey(string)) {
            RelationalObjectProxy relationalObjectProxy = this.createProxy(this.getDesign(), string, string2);
            this.add(relationalObjectProxy);
        }
    }

    public void addSetListener(RelationalObjectProxySetListener relationalObjectProxySetListener) {
        this.listeners.add(relationalObjectProxySetListener);
    }

    public void removeSetListener(RelationalObjectProxySetListener relationalObjectProxySetListener) {
        this.listeners.remove(relationalObjectProxySetListener);
    }

    protected void fireAdded(ModelObject modelObject, int n) {
        this.fireChange(modelObject, 1, n);
    }

    protected void fireRemoved(ModelObject modelObject, int n) {
        this.fireChange(modelObject, 0, n);
    }

    protected void fireChange(ModelObject modelObject, int n, int n2) {
        Iterator iterator = this.listeners.iterator();
        ModelObjectSetEvent modelObjectSetEvent = new ModelObjectSetEvent(modelObject, n);
        modelObjectSetEvent.childIndex = n2;
        while (iterator.hasNext()) {
            ((RelationalObjectProxySetListener)iterator.next()).changed(this, modelObjectSetEvent);
        }
    }

    public void createReadRequest(RelationalObjectProxy relationalObjectProxy) {
        if (this.shouldCreateRequest(relationalObjectProxy)) {
            ReadRequest readRequest = this.getStorageDesign().getReadRequestFor(relationalObjectProxy.getObjectID());
            readRequest.setObjectSet(this);
            readRequest.setStorageObject(relationalObjectProxy);
        }
    }

    public void reloadExistingData(RelationalObjectProxy relationalObjectProxy) {
        ReadRequest readRequest = this.getStorageDesign().getReadRequestFor(relationalObjectProxy.getObjectID());
        readRequest.setObjectSet(this);
        readRequest.setStorageObject(relationalObjectProxy);
        this.getDesign().getAppView().getPersistenceManager().read((Object)readRequest, this.getDesign(), true);
    }

    private boolean shouldCreateRequest(RelationalObjectProxy relationalObjectProxy) {
        DesignObject designObject = relationalObjectProxy.getObject();
        return !(designObject instanceof Column) && !(designObject instanceof Index) && !(designObject instanceof FKIndexAssociation);
    }

    protected RelationalObjectProxy createProxy(DesignObject designObject) {
        return new RelationalObjectProxy(designObject, this.getStorageDesign());
    }

    protected RelationalObjectProxy createProxy(Design design, String string, String string2) {
        return new RelationalObjectProxy(design, string, string2, this.getStorageDesign());
    }

    public void add(RelationalObjectProxy relationalObjectProxy) {
        this.idMap.put(relationalObjectProxy.getObjectID(), relationalObjectProxy);
        this.elements.add(relationalObjectProxy);
        int n = this.elements.size() - 1;
        relationalObjectProxy.setParent(this);
        relationalObjectProxy.setProxySet(this);
        if (this.getStorageDesign() != null) {
            this.getStorageDesign().registerModelIDObject(relationalObjectProxy);
            try {
                this.createReadRequest(relationalObjectProxy);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.doAfterAdd(relationalObjectProxy);
        }
        this.fireUpdate();
        this.fireAdded(relationalObjectProxy, n);
    }

    public void justAdd(RelationalObjectProxy relationalObjectProxy) {
        this.idMap.put(relationalObjectProxy.getObjectID(), relationalObjectProxy);
        this.elements.add(relationalObjectProxy);
        int n = this.elements.indexOf(relationalObjectProxy);
        relationalObjectProxy.setParent(this);
        this.fireAdded(relationalObjectProxy, n);
    }

    public RelationalObjectProxy getProxy(String string) {
        return (RelationalObjectProxy)this.idMap.get(string);
    }

    public Collection getObjectCollection() {
        return this.idMap.values();
    }

    @Override
    public int size() {
        return this.idMap.size();
    }

    public List getObjectList() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getObjectCollection());
        return arrayList;
    }

    public boolean containsId(String string) {
        return this.idMap.containsKey(string);
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (setEvent.getAffected() != null) {
            if (setEvent.isAdded()) {
                this.add(setEvent.getAffected());
            } else if (setEvent.isRemoved()) {
                this.remove(setEvent.getAffected());
            }
        }
    }

    @Override
    public void addUpdateListener(UpdateListener updateListener) {
        this.updateDelegate.addUpdateListener(updateListener);
    }

    @Override
    public void removeUpdateListener(UpdateListener updateListener) {
        this.updateDelegate.removeUpdateListener(updateListener);
    }

    public void fireUpdate() {
        this.updateDelegate.fireChange();
    }

    public void dumpContents(PrintStream printStream) {
        Iterator iterator = this.idMap.keySet().iterator();
        printStream.println("PhysicalObjectProxy.dumpContents(): -------------------------");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            RelationalObjectProxy relationalObjectProxy = this.getProxy(string);
            printStream.print("--");
            printStream.print(relationalObjectProxy.getLongName());
            printStream.print("\t");
            printStream.print(relationalObjectProxy.getObjectID());
            printStream.print("\tloaded: ");
            printStream.println(relationalObjectProxy.isLoaded());
        }
        printStream.println("end PhysicalObjectProxy.dumpContents() ----------------------");
    }

    public RelationalObjectProxy[] toProxyArray() {
        return (RelationalObjectProxy[])this.getObjectCollection().toArray(this.getElementsPrototype());
    }

    @Override
    public Object[] toArray() {
        return this.toProxyArray();
    }

    protected Object[] getElementsPrototype() {
        return new RelationalObjectProxy[0];
    }

    @Override
    public boolean containsSiteStorageObjects() {
        return false;
    }

    @Override
    public boolean containsDesignStorageObjects() {
        return !this.containsSiteStorageObjects();
    }

    @Override
    public boolean contains(ModelObject modelObject) {
        return modelObject instanceof RelationalObjectProxy && this.idMap.containsValue(modelObject);
    }

    @Override
    public Iterator iterator() {
        return Collections.unmodifiableCollection(this.elements).iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.idMap.isEmpty();
    }

    public void clearAll() {
        Object[] objectArray = this.elements.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.remove((ModelIDObject)objectArray[i]);
        }
        this.idMap.clear();
        this.elements.clear();
        this.unregisterFromDesignObjectSet();
    }

    protected void unregisterFromDesignObjectSet() {
    }

    @Override
    public int getNumberOfChildren() {
        return this.elements.size();
    }

    @Override
    public ModelObject getChild(int n) {
        return (ModelObject)this.elements.get(n);
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        return this.elements.indexOf(modelObject);
    }

    @Override
    public int getIndexForChild(Object object) {
        return this.elements.indexOf(object);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public List getElements() {
        return this.elements;
    }

    public String getSegmentName(ModelIDObject modelIDObject) {
        if (this.isContainsTopLevelStorableObjects()) {
            return this.segManager.getSegmentName(modelIDObject);
        }
        return "";
    }

    public String getSegmentName(String string) {
        if (this.isContainsTopLevelStorableObjects()) {
            return this.segManager.getSegmentName(string);
        }
        return "";
    }

    public void addSegmentEntry(String string, String string2) {
        this.addSegmentEntry(string, string2, false);
    }

    public void addSegmentEntry(String string, String string2, boolean bl) {
        if (this.isContainsTopLevelStorableObjects()) {
            if (bl) {
                this.segManager.removeID(string2);
            }
            this.segManager.add(string, string2);
        }
    }

    public boolean isContainsTopLevelStorableObjects() {
        if (this.containsTopLevelStorableObjects == null) {
            this.containsTopLevelStorableObjects = this.getStorageDesign().getStorableSetsList().contains(this) ? new Boolean(true) : new Boolean(false);
        }
        return this.containsTopLevelStorableObjects;
    }

    @Override
    public ModelObject getByName(String string) {
        if (string != null) {
            String string2 = string.trim();
            for (ModelObject modelObject : this.elements) {
                if (modelObject.getName() == null || !modelObject.getName().trim().equalsIgnoreCase(string2)) continue;
                return modelObject;
            }
        }
        return null;
    }

    @Override
    public ModelIDObject getObjectByID(String string) {
        for (ModelIDObject modelIDObject : this.elements) {
            if (!string.equals(modelIDObject.getObjectID())) continue;
            return modelIDObject;
        }
        return null;
    }

    @Override
    public void addAllElementsTo(Collection collection) {
        collection.addAll(this.elements);
    }

    @Override
    public boolean canSort() {
        return this.getStorageDesign() != null && !this.getStorageDesign().isLoading() && ApplicationView.canLogging;
    }
}

