/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;

public abstract class ProxyDesignObjectSet
extends RelationalObjectProxySet {
    private boolean isAddingFromDesign = false;

    public ProxyDesignObjectSet(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void setDesign(Design design) {
        super.setDesign(design);
        if (design != null) {
            this.getPhysicalDesignObjectSet().removeSetListener(this);
        }
        if (design != null) {
            this.getPhysicalDesignObjectSet().addSetListener(this);
            this.addProxiesFromDesign();
        }
    }

    protected void addProxiesFromDesign() {
        this.setIsAddingFromDesign(true);
        if (this.getDesign() != null) {
            Iterator iterator = this.getPhysicalDesignObjectSet().iterator();
            while (iterator.hasNext()) {
                this.add((DesignObject)iterator.next());
            }
        }
        this.setIsAddingFromDesign(false);
    }

    protected abstract DesignObjectSet getPhysicalDesignObjectSet();

    @Override
    public String getName() {
        return this.getPhysicalDesignObjectSet().getName();
    }

    public void setIsAddingFromDesign(boolean bl) {
        this.isAddingFromDesign = bl;
    }

    public boolean getIsAddingFromDesign() {
        return this.isAddingFromDesign;
    }

    @Override
    protected void unregisterFromDesignObjectSet() {
        this.getPhysicalDesignObjectSet().removeSetListener(this);
    }
}

