/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.storage.MethodParamProxy;
import oracle.dbtools.crest.model.design.storage.MethodProxy;
import oracle.dbtools.crest.model.design.storage.ProxyDesignObjectSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;

public class MethodProxySet
extends ProxyDesignObjectSet {
    public MethodProxySet(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected DesignObjectSet getPhysicalDesignObjectSet() {
        return this.getDesign().getDataTypesDesign().getMethodSet();
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject designObject) {
        return new MethodProxy((Method)designObject, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String string, String string2) {
        return new MethodProxy(design, string, string2, this.getStorageDesign());
    }

    @Override
    public MethodProxy getByName(String string) {
        Iterator iterator = this.getElements().iterator();
        MethodProxy methodProxy = null;
        while (iterator.hasNext()) {
            methodProxy = (MethodProxy)iterator.next();
            if (!string.equalsIgnoreCase(methodProxy.getName())) continue;
            return methodProxy;
        }
        return null;
    }

    public MethodProxy getMethodByNameAndParams(StructuredTypeProxy structuredTypeProxy, String string, List list, List list2) {
        MethodProxy methodProxy = null;
        Iterator iterator = structuredTypeProxy.getMethods().iterator();
        while (iterator.hasNext()) {
            methodProxy = (MethodProxy)iterator.next();
            if (!string.equalsIgnoreCase(methodProxy.getName()) || !this.checkMethodParams(methodProxy, list, list2)) continue;
            return methodProxy;
        }
        return null;
    }

    private boolean checkMethodParams(MethodProxy methodProxy, List list, List list2) {
        if (methodProxy.getParams().size() != list.size()) {
            return false;
        }
        Iterator iterator = methodProxy.getParams().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            MethodParamProxy methodParamProxy = (MethodParamProxy)iterator.next();
            String string = methodParamProxy.getName();
            if (string.equalsIgnoreCase((String)list.get(n))) {
                String string2;
                String string3;
                int n2;
                if ((n2 = (string3 = (String)list2.get(n++)).indexOf(".")) >= 0 && n2 + 1 < string3.length()) {
                    string3 = string3.substring(n2 + 1);
                }
                if (string3.equalsIgnoreCase(string2 = methodParamProxy.getMethodParam().getDataType())) continue;
                String string4 = StandardDatatypeNames.getUsedDatatypeName(string3);
                String string5 = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(this.getSelectedRDBMSType(), string4);
                if (string5.equalsIgnoreCase(string2) || string3.equalsIgnoreCase(methodParamProxy.getMethodParam().getDataType(this.getSelectedRDBMSType().toString())) || string3.equalsIgnoreCase("STRING") && string2.equalsIgnoreCase("VARCHAR") || string2.equalsIgnoreCase("unknown")) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

