/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.MethodParamProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;

public class MethodProxy
extends RelationalObjectProxy
implements RelationalObjectProxySetListener {
    private boolean bodyChanged = false;
    private boolean commentChanged = false;
    private boolean commentInRDBMSChanged = false;
    protected StorageObjectCollection params;
    public static final String TYPE_NAME = "Method";

    public MethodProxy(Method method, StorageDesign storageDesign) {
        super(method, storageDesign);
        this.initParams(storageDesign);
    }

    public MethodProxy(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.initParams(storageDesign);
    }

    private void initParams(StorageDesign storageDesign) {
        this.params = new StorageObjectCollection();
        this.params.setParent(this);
        this.params.setName(Messages.getString("MethodProxy.MethodParams"));
        storageDesign.getMethodParamProxySet();
        this.addMethodParamProxiesFromDesign();
        storageDesign.getMethodParamProxySet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return "MethodParam";
    }

    public StructuredType getStructuredType() {
        return ((Method)this.getObject()).getStructuredType();
    }

    public Method getMethod() {
        return (Method)this.getObject();
    }

    public boolean isBodyChanged() {
        return this.bodyChanged;
    }

    public void setBodyChanged(boolean bl) {
        this.bodyChanged = bl;
    }

    @Override
    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    @Override
    public void setCommentChanged(boolean bl) {
        this.commentChanged = bl;
    }

    @Override
    public boolean isCommentInRDBMSChanged() {
        return this.commentInRDBMSChanged;
    }

    @Override
    public void setCommentInRDBMSChanged(boolean bl) {
        this.commentInRDBMSChanged = bl;
    }

    @Override
    public String getComment() {
        if (this.isCommentChanged()) {
            return super.getComment();
        }
        return this.getObject().getComment();
    }

    @Override
    public void setComment(String string) {
        if (!string.equals(this.getObject().getComment())) {
            super.setComment(string);
            this.setCommentChanged(true);
        } else {
            this.setCommentChanged(false);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.params;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.params) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.params) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        MethodParamProxy methodParamProxy;
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof MethodParamProxy) {
                MethodParamProxy methodParamProxy2 = (MethodParamProxy)modelObjectSetEvent.getAffected();
                if (this.getObject() == methodParamProxy2.getObject().getParent()) {
                    methodParamProxy2.setParent(this.params);
                    this.params.add(modelObjectSetEvent.getAffected());
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof MethodParamProxy && (methodParamProxy = (MethodParamProxy)modelObjectSetEvent.getAffected()) != null && methodParamProxy.getObject() != null) {
            try {
                this.params.remove(methodParamProxy.getObject().getObjectID());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private void addMethodParamProxiesFromDesign() {
        for (MethodParam methodParam : this.getMethod().getParameters()) {
            MethodParamProxy methodParamProxy = (MethodParamProxy)this.getStorageDesign().getStorageObject(methodParam.getObjectID());
            if (methodParamProxy == null) continue;
            methodParamProxy.setParent(this.params);
            this.params.add(methodParamProxy);
        }
    }

    public StorageObjectCollection getParams() {
        return this.params;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        StructuredType structuredType;
        if (this.pac_Element == null && (structuredType = this.getStructuredType()) != null) {
            StorageObject storageObject = this.getStorageDesign().getStorageObject(structuredType.getObjectID());
            this.setPAC_Element(storageObject);
        }
        return super.getPAC_Element();
    }
}

