/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalContainerProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;

public class IndexProxy
extends RelationalContainerProxy {
    private boolean clustered = false;
    private boolean partitioned = false;
    private boolean markGenerateIfFK = true;
    private boolean commentChanged = false;
    private boolean commentInRDBMSChanged = false;
    public static final String TYPE_NAME = "Index";

    public IndexProxy(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxy(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public boolean isIndex() {
        return true;
    }

    public void setPartitioned(boolean bl) {
        this.partitioned = bl;
    }

    public boolean isPartitioned() {
        return this.partitioned;
    }

    public boolean isUnique() {
        return this.getIndex().isUnique();
    }

    public void setClustered(boolean bl) {
        this.clustered = bl;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setMarkGenerateIfFK(boolean bl) {
        this.markGenerateIfFK = bl;
    }

    public boolean getMarkGenerateIfFK() {
        return this.markGenerateIfFK;
    }

    public Index getIndex() {
        return (Index)this.getObject();
    }

    public Table getTable() {
        return (Table)this.getIndex().getContainerObject();
    }

    public TableProxy getTableProxy() {
        return (TableProxy)this.getStorageDesign().getTableProxySet().getProxy(this.getTable().getObjectID());
    }

    @Override
    public ColumnProxy[] getColumnProxies() {
        return super.getColumnProxies();
    }

    @Override
    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    @Override
    public void setCommentChanged(boolean bl) {
        this.commentChanged = bl;
    }

    @Override
    public boolean isCommentInRDBMSChanged() {
        return this.commentInRDBMSChanged;
    }

    @Override
    public void setCommentInRDBMSChanged(boolean bl) {
        this.commentInRDBMSChanged = bl;
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            return this.getTableProxy().isDropEnabled() || this.getTableProxy().shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        Table table;
        if (this.pac_Element == null && (table = this.getTable()) != null) {
            StorageObject storageObject = this.getStorageDesign().getStorageObject(table.getObjectID());
            if (storageObject == null) {
                this.getStorageDesign().getTableProxySet().getObjectGeneratedBy(table);
            }
            if (storageObject != null && storageObject instanceof TableProxy) {
                this.setPAC_Element(storageObject);
            }
        }
        return super.getPAC_Element();
    }
}

