/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.GlobalIndexSet;
import oracle.dbtools.crest.model.design.relational.Table;

public class TableSet
extends DesignObjectSet
implements SetListener {
    public static final Object[] PROTOTYPE_ARRAY = new Table[0];
    private GlobalIndexSet globalIndexSet;

    public TableSet(DesignPart designPart) {
        super(designPart);
        this.requireSort = true;
        this.getGlobalIndexSet();
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTOTYPE_ARRAY;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return this.getPreference("default table name");
    }

    public Table createTable(String string) {
        Table table = new Table(this.getDesignPart());
        table.setBeingRecreated(false);
        this.initialize(table, string);
        return table;
    }

    public Table recreateTable(String string) {
        Table table = new Table(this.getDesignPart());
        table.setBeingRecreated(true);
        this.initialize(table, string);
        return table;
    }

    private void initialize(Table table, String string) {
        table.setObjectID(string);
        table.setDesign(this.getDesign());
        table.setParent(this);
        this.getDesign().addDesignObject(table);
        this.add(table);
    }

    @Override
    public Object getParent() {
        return this.getDesignPart();
    }

    @Override
    public void remove(DesignObject designObject) {
        designObject.setParent(null);
        super.remove(designObject);
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
    }

    public GlobalIndexSet getGlobalIndexSet() {
        if (this.globalIndexSet == null) {
            this.globalIndexSet = new GlobalIndexSet(this);
            this.globalIndexSet.addSetListener((ModelObjectSetListener)((Object)this.getDesignPart()));
        }
        return this.globalIndexSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        clearAll = true;
        try {
            Object[] objectArray = this.toArray();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                DesignObject designObject = (DesignObject)objectArray[i];
                designObject.remove();
            }
        }
        finally {
            clearAll = false;
        }
        super.removeAll();
    }

    @Override
    public Table getBySchemaAndName(String string, String string2) {
        if (string != null && string2 != null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                if (!string.equalsIgnoreCase(table.getSchema()) || !string2.equalsIgnoreCase(table.getName())) continue;
                return table;
            }
        }
        return null;
    }
}

