/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.util.GUID;

public class SpatialColumnDefObject
implements ID_ObjectPropertyTranslator {
    private String name = "";
    private Column spatialColumn = null;
    private boolean isFunction = false;
    private String funcExpression = "";
    private String systemID = "";
    private List tableDimensions;
    private Index spatialIndex;
    private Table parent;
    private String objectID;
    private int id;

    public SpatialColumnDefObject(Table table) {
        this.parent = table;
        this.name = this.createName();
        this.objectID = new GUID().toString();
    }

    public String getObjectTypeName() {
        return "ColumnDefinition";
    }

    public String createName(int n) {
        return this.getObjectTypeName().concat("_").concat(String.valueOf(n));
    }

    private String createName() {
        return this.createName(this.parent.getSpatialDefinitions().size() + 1);
    }

    public String getFuncExpression() {
        return this.funcExpression;
    }

    public void setFuncExpression(String string) {
        this.funcExpression = string;
        if (this.getSpatialIndex() != null) {
            this.getSpatialIndex().setIndexExpression(string);
        }
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public void setFunction(boolean bl) {
        this.isFunction = bl;
    }

    public Column getSpatialColumn() {
        return this.spatialColumn;
    }

    public void setSpatialColumn(Column column) {
        this.spatialColumn = column;
        if (this.spatialColumn != null && this.getSpatialIndex() != null) {
            this.getSpatialIndex().add(this.spatialColumn);
        }
    }

    public String getSystemID() {
        return this.systemID;
    }

    public void setSystemID(String string) {
        this.systemID = string;
    }

    public Index getSpatialIndex() {
        return this.spatialIndex;
    }

    public void setSpatialIndex(Index index) {
        if (this.spatialIndex != null && this.spatialIndex != index) {
            this.spatialIndex.setSpatialColumnDefiniton(null);
        } else if (index != null) {
            index.setSpatialColumnDefiniton(this);
        }
        this.spatialIndex = index;
    }

    public List getTableDimensions() {
        if (this.tableDimensions == null) {
            this.tableDimensions = new ArrayList();
        }
        return this.tableDimensions;
    }

    public void setTableDimensions(List list) {
        this.getTableDimensions().clear();
        for (TableDimension tableDimension : list) {
            if (tableDimension.isEmpty()) continue;
            this.addTableDimension(tableDimension);
        }
    }

    private void addTableDimension(TableDimension tableDimension) {
        this.getTableDimensions().add(tableDimension);
    }

    public boolean isDesignLevelAccessibleObject() {
        return false;
    }

    public String getIDPrefix() {
        return "SPDC";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void removeSpatialIndex() {
        this.setSpatialIndex(null);
    }

    public Table getParent() {
        return this.parent;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public void copyTo(SpatialColumnDefObject spatialColumnDefObject, Map map) {
        Object object;
        Object object2;
        Table table = spatialColumnDefObject.getParent();
        Column column = this.getSpatialColumn();
        if (column != null) {
            object2 = column.getObjectID();
            object = (Column)table.getElementByID((String)object2);
            if (object == null) {
                if (map != null) {
                    object = (Column)map.get(object2);
                }
                if (object == null) {
                    object = (Column)table.getElementByName(column.getName());
                }
            }
            spatialColumnDefObject.setSpatialColumn((Column)object);
        }
        if ((object2 = this.getSpatialIndex()) != null) {
            object = ((ModelIDObject)object2).getObjectID();
            Index index = (Index)table.getKeySet().getObjectByID((String)object);
            if (index == null) {
                if (map != null) {
                    index = (Index)map.get(object);
                }
                if (index == null) {
                    index = (Index)table.getKeySet().getByName(((DesignObject)object2).getName());
                }
            }
            if (index != null) {
                spatialColumnDefObject.setSpatialIndex(index);
            }
        }
        spatialColumnDefObject.setSystemID(this.getSystemID());
        spatialColumnDefObject.setFuncExpression(this.getFuncExpression());
        spatialColumnDefObject.setFunction(this.isFunction());
        spatialColumnDefObject.setName(this.getName());
        this.copyDimensionsTo(spatialColumnDefObject);
    }

    public void copyTo(SpatialColumnDefObject spatialColumnDefObject) {
        this.copyTo(spatialColumnDefObject, null);
    }

    private void copyDimensionsTo(SpatialColumnDefObject spatialColumnDefObject) {
        for (TableDimension tableDimension : this.getTableDimensions()) {
            TableDimension tableDimension2 = spatialColumnDefObject.new TableDimension();
            tableDimension.copyTo(tableDimension2);
        }
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String string) {
        this.objectID = string;
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        return this.parent.translateIdToObject(string, string2);
    }

    @Override
    public String translateObjectToID(String string, Object object) {
        return this.parent.translateObjectToID(string, object);
    }

    public TableDimension createTableDimension() {
        return new TableDimension();
    }

    public void removeTableDimension(TableDimension tableDimension) {
        this.getTableDimensions().remove(tableDimension);
    }

    public TableDimension getTableDimensionByID(String string) {
        for (TableDimension tableDimension : this.getTableDimensions()) {
            if (!tableDimension.getDimensionID().equals(string)) continue;
            return tableDimension;
        }
        return null;
    }

    public class TableDimension {
        private String name = "";
        private String lowBoundary = "";
        private String upperBoundary = "";
        private String tolerance = "";
        private String dimensionID = new GUID().toString();

        public TableDimension() {
            SpatialColumnDefObject.this.addTableDimension(this);
        }

        public String getLowBoundary() {
            return this.lowBoundary;
        }

        public void setLowBoundary(String string) {
            this.lowBoundary = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getTolerance() {
            return this.tolerance;
        }

        public void setTolerance(String string) {
            this.tolerance = string;
        }

        public String getUpperBoundary() {
            return this.upperBoundary;
        }

        public void setUpperBoundary(String string) {
            this.upperBoundary = string;
        }

        public boolean isEmpty() {
            return this.name.trim().equals("") || this.lowBoundary.trim().equals("") || this.upperBoundary.trim().equals("") || this.tolerance.trim().equals("");
        }

        public void copyTo(TableDimension tableDimension) {
            tableDimension.setName(this.getName());
            tableDimension.setLowBoundary(this.getLowBoundary());
            tableDimension.setUpperBoundary(this.getUpperBoundary());
            tableDimension.setTolerance(this.getTolerance());
        }

        public String getDimensionID() {
            return this.dimensionID;
        }

        public void setDimensionID(String string) {
            this.dimensionID = string;
        }
    }
}

