/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.GlobalCandidateKeySet;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnSet;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.editor.relational.IndexPropertiesDialogEx;

public class Index
extends KeyObject {
    public static final String VALUE_ASCENDING = "ASC";
    public static final String VALUE_DESCENDING = "DESC";
    private static final String[] SORT_ORDER_CHOICES = new String[]{"ASC", "DESC"};
    private static String SORT_ORDER = "sortOrder";
    private static String COLUMN_ID = "columnID";
    private String indexState = "Plain Index";
    private static Set indexStateSet = null;
    private Map sortMap = new TreeMap();
    private String indexExpression = "";
    private boolean isSpatialIndex = false;
    public static final String POINT = "POINT";
    public static final String LINE = "LINE";
    public static final String POLYGON = "POLYGON";
    public static final String COLLECTION = "COLLECTION";
    public static final String MULTIPOINT = "MULTIPOINT";
    public static final String MULTILINE = "MULTILINE";
    public static final String MULTIPOLYGON = "MULTIPOLYGON";
    private static final String[] CONSTRAIN_LAYER_TYPES = new String[]{"", "POINT", "LINE", "POLYGON", "COLLECTION", "MULTIPOINT", "MULTILINE", "MULTIPOLYGON"};
    private String layerType;
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private String geodetic = YES_NO_STATES[0];
    private int dimensionsNumber = 2;
    private SpatialColumnDefObject spatialColumnDefiniton = null;
    private String idOfRecoveredIntegrityIndex;
    private IndexMemento memento;
    public static final String TYPE_NAME = "Index";

    public Index(DesignPart designPart) {
        super(designPart);
    }

    public Index(DesignPart designPart, FKIndexAssociation fKIndexAssociation) {
        this(designPart);
        this.indexState = "Foreign Key";
        this.name = fKIndexAssociation.getName();
        this.setFKAssociation(fKIndexAssociation);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("index id prefix");
    }

    @Override
    public int getByteSize(String string) {
        return super.getByteSize(string);
    }

    public ColumnSet getColumnSet() {
        return ((RelationalDesign)this.getDesignPart()).getColumnSet();
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getColumnSet();
    }

    @Override
    public Collection getElementsCollection() {
        return super.getElementsCollection();
    }

    @Override
    public void add(ContainedObject containedObject) {
        super.add(containedObject);
        if (containedObject.getObjectID() != null) {
            this.sortMap.put(containedObject.getObjectID(), VALUE_ASCENDING);
        }
    }

    @Override
    public void remove(ContainedObject containedObject) {
        super.remove(containedObject);
        this.sortMap.remove(containedObject.getObjectID());
    }

    public void setColumnSortOrder(Object object, String string) {
        if (((ContainedObject)object).getObjectID() != null) {
            this.sortMap.put(((ContainedObject)object).getObjectID(), string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getColumnSortOrder(Object object) {
        String string = null;
        if (object instanceof Column) {
            if (((ContainedObject)object).getObjectID() == null) return VALUE_ASCENDING;
            string = (String)this.sortMap.get(((ContainedObject)object).getObjectID());
            if (string == null) {
                return " ";
            }
            if (!"".equals(string.trim())) return string;
            return VALUE_ASCENDING;
        }
        if (!(object instanceof ColumnProxy)) return " ";
        if (((ColumnProxy)object).getObjectID() == null) return VALUE_ASCENDING;
        string = (String)this.sortMap.get(((ColumnProxy)object).getObjectID());
        if (string == null) {
            return " ";
        }
        if (!"".equals(string.trim())) return string;
        return VALUE_ASCENDING;
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        if (objectChangeEvent.isType(ObjectChangeEvent.NAME_CHANGED)) {
            if (this.isOidKey() && designObject == this.getContainerObject()) {
                this.setName("Oid_PK_" + designObject.getName());
            }
            this.sharedEvent.setElement(designObject);
            this.sharedEvent.setType(8);
            this.fireChange(this.sharedEvent);
        }
    }

    public boolean isSortOrderColumnsAscending() {
        return this.getSortOrderColumnsString().equalsIgnoreCase(VALUE_ASCENDING);
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            return this.getContainerWithKeyObject().isDropEnabled() || this.getContainerWithKeyObject().shouldBeDroppedIndirectly();
        }
        return false;
    }

    public static final String[] getSortOrderColumnsChoices() {
        return SORT_ORDER_CHOICES;
    }

    public String getSortOrderColumnsString() {
        return "Edit";
    }

    @Override
    public int getMaxNameLength() {
        if (this.isPK()) {
            return 8;
        }
        return super.getMaxNameLength();
    }

    private boolean checkIndexStateValue(String string) {
        if (indexStateSet == null) {
            indexStateSet = new HashSet();
            indexStateSet.addAll(Arrays.asList(INDEX_STATES));
        }
        return indexStateSet.contains(string);
    }

    public boolean hasFKAssociations() {
        Iterator iterator = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            if (!fKIndexAssociation.getRemoteIndex().getObjectID().equals(this.getObjectID())) continue;
            return true;
        }
        return false;
    }

    public void setIndexState(String string) {
        if (this.checkIndexStateValue(string)) {
            String string2 = this.getIndexState();
            this.indexState = string;
            if ("Primary Constraint".equalsIgnoreCase(string)) {
                if (!this.isPK()) {
                    Index index = (Index)this.getContainerWithKeyObject().getPK();
                    if (index != null) {
                        index.setIndexState("Unique Constraint");
                    }
                    this.setPK(true);
                }
                this.makeValidPKIfNotEmpty();
            } else if ("Unique Constraint".equalsIgnoreCase(string)) {
                if (this.isPK()) {
                    this.setPK(false);
                } else if (!this.isUnique()) {
                    this.setUnique(true);
                }
            } else if ((this.isPK() || this.isUnique()) && this.hasFKAssociations()) {
                this.indexState = string2;
            } else {
                if (this.isPK()) {
                    this.setPK(false);
                }
                if (this.isUnique()) {
                    this.setUnique(false);
                }
            }
        }
    }

    @Override
    public void setMarkedGenerate(boolean bl) {
        super.setMarkedGenerate(bl);
        if (this.getFKAssociation() != null) {
            this.getFKAssociation().synchronizeMarkedGenerate(bl);
        }
    }

    @Override
    public void setDropEnabled(boolean bl) {
        super.setDropEnabled(bl);
        if (this.getFKAssociation() != null) {
            this.getFKAssociation().setDropEnabled(bl);
        }
    }

    public String getIndexState() {
        if (this.isPK()) {
            return "Primary Constraint";
        }
        if (this.isUnique()) {
            return "Unique Constraint";
        }
        if (this.isFK()) {
            return "Foreign Key";
        }
        if (!this.isPK() && "Primary Constraint".equalsIgnoreCase(this.indexState)) {
            return "Plain Index";
        }
        return this.indexState;
    }

    public CandidateKey getEngCandidateKey(Entity entity) {
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping xtdMapping = (XtdMapping)list.get(i);
                CandidateKey candidateKey = (CandidateKey)xtdMapping.getObjectMappedTo(this);
                if (candidateKey == null || candidateKey.getContainerWithKeyObject() != entity) continue;
                return candidateKey;
            }
        }
        return null;
    }

    public XtdMapping getMappingFor(Entity entity) {
        List list;
        if (entity != null && (list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID())).size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping xtdMapping = (XtdMapping)list.get(i);
                CandidateKey candidateKey = (CandidateKey)xtdMapping.getObjectMappedTo(this);
                if (candidateKey == null || candidateKey.getContainerWithKeyObject() != entity) continue;
                return xtdMapping;
            }
        }
        return null;
    }

    public List getMappingsFor(Entity entity) {
        List list;
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        if (entity != null && (list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID())).size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping xtdMapping = (XtdMapping)list.get(i);
                CandidateKey candidateKey = (CandidateKey)xtdMapping.getObjectMappedTo(this);
                if (candidateKey == null || candidateKey.getContainerWithKeyObject() != entity) continue;
                arrayList.add(xtdMapping);
            }
        }
        return arrayList;
    }

    public CandidateKey getEngCandidateKey() {
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            XtdMapping xtdMapping = (XtdMapping)list.get(0);
            CandidateKey candidateKey = (CandidateKey)xtdMapping.getObjectMappedTo(this);
            return candidateKey;
        }
        return null;
    }

    @Override
    public boolean hasAliveGenerator() {
        ModelIDObject modelIDObject;
        GlobalCandidateKeySet globalCandidateKeySet = this.getDesign().getLogicalDesign().getGlobalCandidateKeySet();
        return this.isFK() || ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID()) || (modelIDObject = globalCandidateKeySet.getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertiesDialogEx indexPropertiesDialogEx = new IndexPropertiesDialogEx(this.getDesign().getAppView(), this);
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.getTable().getElementsCollection());
            indexPropertiesDialogEx.setColumnsList(arrayList);
            IndexMemento indexMemento = this.getIndexMemento(true);
            indexPropertiesDialogEx.initProperties(indexMemento);
            indexPropertiesDialogEx.show();
        }
    }

    @Override
    public boolean isDropEnabled() {
        if (this.isFK()) {
            return this.getFKAssociation().isDropEnabled();
        }
        return super.isDropEnabled();
    }

    @Override
    protected void clearStructure() {
    }

    @Override
    protected void updateStructure() {
    }

    public String getIndexExpression() {
        return this.indexExpression;
    }

    public void setIndexExpression(String string) {
        this.indexExpression = string;
    }

    public boolean hasIndexExpression() {
        return !this.getIndexExpression().equals("");
    }

    public boolean isSpatialIndex() {
        return this.isSpatialIndex;
    }

    public void setSpatialIndex(boolean bl) {
        this.isSpatialIndex = bl;
    }

    public static final String[] getConstrainLayerTypeChoices() {
        return CONSTRAIN_LAYER_TYPES;
    }

    public int getDimensionsNumber() {
        return this.dimensionsNumber;
    }

    public void setDimensionsNumber(int n) {
        this.dimensionsNumber = n;
    }

    public String getGeodetic() {
        return this.geodetic;
    }

    public void setGeodetic(String string) {
        if (Arrays.asList(YES_NO_STATES).contains(string)) {
            this.geodetic = string;
        }
    }

    public String getLayerType() {
        return this.layerType;
    }

    public void setLayerType(String string) {
        if (Arrays.asList(CONSTRAIN_LAYER_TYPES).contains(string)) {
            this.layerType = string;
        }
    }

    public static String[] getGeodeticChoices() {
        return YES_NO_STATES;
    }

    public SpatialColumnDefObject getSpatialColumnDefiniton() {
        return this.spatialColumnDefiniton;
    }

    public void setSpatialColumnDefiniton(SpatialColumnDefObject spatialColumnDefObject) {
        this.spatialColumnDefiniton = spatialColumnDefObject;
    }

    public Table getTable() {
        return (Table)this.getContainerWithKeyObject();
    }

    public void synchronizeMarkedGenerate(boolean bl) {
        super.setMarkedGenerate(bl);
    }

    public boolean shouldBeEngineered(XtdMapping xtdMapping) {
        return xtdMapping.getIndexes().contains(this.getObjectID());
    }

    public boolean hasColumnInOptionalFK() {
        for (Column column : this.getElementsCollection()) {
            if (!column.isInOptionalFK()) continue;
            return true;
        }
        return false;
    }

    public boolean hasColumnInFKinArc() {
        for (Column column : this.getElementsCollection()) {
            if (!column.isInFKinArc()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void copy(DesignObject designObject) {
        super.copy(designObject);
        Index index = (Index)designObject;
        index.setIndexState(this.getIndexState());
        index.setIndexExpression(this.getIndexExpression());
        index.setSpatialIndex(this.isSpatialIndex());
        index.setLayerType(this.getLayerType());
        index.setDimensionsNumber(this.getDimensionsNumber());
        index.setGeodetic(this.getGeodetic());
        for (Column column : this.getElementsCollection()) {
            String string = this.getColumnSortOrder(column);
            Table table = (Table)index.getContainerWithKeyObject();
            Column column2 = (Column)table.getElementByID(column.getObjectID());
            if (column2 == null) {
                column2 = (Column)table.getElementByName(column.getName());
            }
            if (column2 == null) continue;
            index.setColumnSortOrder(column2, string);
        }
        index.setName(this.getName());
    }

    public IndexMemento getIndexMemento() {
        return this.getIndexMemento(false);
    }

    public IndexMemento getIndexMemento(boolean bl) {
        if (bl || this.memento == null) {
            this.memento = new IndexMemento(this);
        }
        return this.memento;
    }

    public void restoreFromMemento(IndexMemento indexMemento) {
        Column column;
        this.setSchemaObject(indexMemento.schemaObject);
        this.setName(indexMemento.name);
        this.setObjectID(indexMemento.id);
        this.setComment(indexMemento.comments);
        this.setCommentInRDBMS(indexMemento.comments_in_rdbms);
        this.setNotes(indexMemento.notes);
        this.setMarkedGenerate(indexMemento.generate_in_DDL);
        this.setShouldEngineer(indexMemento.engineer);
        this.setIndexExpression(indexMemento.expression);
        this.setSpatialIndex(indexMemento.spatial);
        this.setGeodetic(indexMemento.is_geodetic);
        this.setLayerType(indexMemento.layer_type);
        this.setDimensionsNumber(indexMemento.dimensionsNumber);
        this.setOidKey(indexMemento.isOidKey);
        ContainedObject[] containedObjectArray = this.getElements();
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Table table = (Table)this.getContainerWithKeyObject();
        for (IndexMemento.ColWr colWr : indexMemento.columns) {
            column = (Column)table.getElementByID(colWr.col_id);
            if (column != null) {
                arrayList.add(column);
                continue;
            }
            if (!table.isBST()) continue;
            Column object = (Column)table.getOidElement();
            arrayList.add(object);
        }
        for (int i = 0; i < containedObjectArray.length; ++i) {
            column = (Column)containedObjectArray[i];
            if (arrayList.contains(column)) continue;
            this.remove(column);
        }
        List list = (List)this.getElementsCollection();
        int n = 0;
        for (Column column2 : arrayList) {
            int n2 = list.indexOf(column2);
            if (n2 < 0) {
                this.add(column2);
                this.moveToIndex(column2, n);
            } else {
                this.moveToIndex(column2, n);
            }
            ++n;
        }
        for (IndexMemento.ColWr colWr : indexMemento.columns) {
            Column column3 = (Column)table.getElementByID(colWr.col_id);
            if (column3 == null) continue;
            this.setColumnSortOrder(column3, colWr.sort_order);
        }
        this.setIndexState(indexMemento.index_state);
    }

    public String getIdOfRecoveredIntegrityIndex() {
        return this.idOfRecoveredIntegrityIndex;
    }

    public void setIdOfRecoveredIntegrityIndex(String string) {
        this.idOfRecoveredIntegrityIndex = string;
    }

    public IndexColumnUsage createIndexColumnUsage() {
        return new IndexColumnUsage();
    }

    public List getIndexColumnUsageList() {
        ArrayList arrayList = new ArrayList();
        for (Column column : this.getElementsCollection()) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put(COLUMN_ID, column.getObjectID());
            String string = this.getColumnSortOrder(column);
            if (VALUE_DESCENDING.equals(string)) {
                treeMap.put(SORT_ORDER, string);
            }
            arrayList.add(treeMap);
        }
        return arrayList;
    }

    public void applyIndexColumnUsageList(List list) {
        int n;
        Object object;
        Object object22;
        ArrayList<Column> arrayList = new ArrayList<Column>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Object object22 : list) {
            Column column;
            Map map;
            if (!(object22 instanceof Map) || (object = (String)(map = (Map)object22).get(COLUMN_ID)) == null || (column = (Column)this.getTable().getElementByID((String)object)) == null) continue;
            arrayList.add(column);
            String string = (String)map.get(SORT_ORDER);
            if (string != null && VALUE_DESCENDING.equals(string)) {
                arrayList2.add(VALUE_DESCENDING);
                continue;
            }
            arrayList2.add(VALUE_ASCENDING);
        }
        object22 = this.getElements();
        for (n = 0; n < ((E)object22).length; ++n) {
            if (arrayList.contains(object22[n])) continue;
            this.remove((ContainedObject)object22[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (Column)arrayList.get(n);
            if (!this.contains((ContainedObject)object)) {
                this.add((ContainedObject)object);
            }
            this.moveToIndex((ContainedObject)object, n);
            this.setColumnSortOrder(object, (String)arrayList2.get(n));
        }
    }

    @Override
    public void setFKAssociation(FKIndexAssociation fKIndexAssociation) {
        super.setFKAssociation(fKIndexAssociation);
        this.indexState = "Foreign Key";
    }

    public void addIndexColumnUsage(IndexColumnUsage indexColumnUsage) {
        Column column;
        if (indexColumnUsage.getColumnID() != null && (column = (Column)this.getTable().getElementByID(indexColumnUsage.getColumnID())) != null) {
            if (!this.contains(column)) {
                this.add(column);
            }
            if (indexColumnUsage.getSortOrder() != null && VALUE_DESCENDING.equals(indexColumnUsage.getSortOrder())) {
                this.setColumnSortOrder(column, VALUE_DESCENDING);
            } else {
                this.setColumnSortOrder(column, VALUE_ASCENDING);
            }
        }
    }

    public boolean isIndexForColumns(Column[] columnArray) {
        ContainedObject[] containedObjectArray = this.getElements();
        if (columnArray.length != containedObjectArray.length) {
            return false;
        }
        for (int i = 0; i < containedObjectArray.length; ++i) {
            if (containedObjectArray[i] == columnArray[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isUniquePlainIndex() {
        return "Unique Plain Index".equalsIgnoreCase(this.getIndexState());
    }

    public Column[] getColumns() {
        return this.getElementsCollection().toArray(new Column[0]);
    }

    public RMExtendedMap getRMExtendedMap() {
        return ((RelationalDesign)this.getDesignPart()).getRMExtendedMap();
    }

    @Override
    public String getVeryLongName() {
        ContainerWithKeyObject containerWithKeyObject = this.getContainerWithKeyObject();
        if (containerWithKeyObject != null) {
            SchemaObject schemaObject = containerWithKeyObject.getSchemaObject();
            if (schemaObject != null) {
                StringBuffer stringBuffer = new StringBuffer(schemaObject.getName());
                stringBuffer.append(".").append(containerWithKeyObject.getName()).append(".").append(this.getName());
                return stringBuffer.toString();
            }
            StringBuffer stringBuffer = new StringBuffer(containerWithKeyObject.getName());
            stringBuffer.append(".").append(this.getName());
            return stringBuffer.toString();
        }
        return this.getName();
    }

    public static class IndexColumnUsage {
        String columnID;
        String sortOrder;

        public String getColumnID() {
            return this.columnID;
        }

        public void setColumnID(String string) {
            this.columnID = string;
        }

        public String getSortOrder() {
            return this.sortOrder;
        }

        public void setSortOrder(String string) {
            this.sortOrder = string;
        }
    }
}

