/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.reference.ModelIDObjectReference;
import oracle.dbtools.crest.model.reference.ReferenceSet;

public class FKIndexAssociationSet
extends DesignObjectSet {
    public static final Object[] PROTOTYPE_ARRAY = new FKIndexAssociation[0];
    private FKAssociationReferenceSet referenceSet = new FKAssociationReferenceSet();

    public FKIndexAssociationSet(DesignPart designPart) {
        super(designPart);
        this.setCreateNameVariants(true);
        this.requireSort = true;
    }

    public ModelIDObject createElement(String string) {
        throw new RuntimeException("FKIndexAssociations should be created via Table instances");
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTOTYPE_ARRAY;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "FK_ASS";
    }

    @Override
    public String getSeparator() {
        return "_";
    }

    public Collection getAssociationsWith(Table table) {
        ArrayList<FKIndexAssociation> arrayList = new ArrayList<FKIndexAssociation>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            if (!table.equals(fKIndexAssociation.getRemoteTable())) continue;
            arrayList.add(fKIndexAssociation);
        }
        return arrayList;
    }

    public Collection getAssociationsWith(KeyObject keyObject) {
        return this.iterateAndFill(keyObject, false);
    }

    public Collection getAssociatedTablesWith(Table table) {
        ArrayList<FKIndexAssociation> arrayList = new ArrayList<FKIndexAssociation>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            if (!table.equals(fKIndexAssociation.getRemoteTable())) continue;
            arrayList.add(fKIndexAssociation);
        }
        return arrayList;
    }

    public List getRelatedTablesTo(Table table) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            if (fKIndexAssociation.getTable() == fKIndexAssociation.getRemoteTable()) continue;
            if (table.equals(fKIndexAssociation.getTable())) {
                arrayList.add(fKIndexAssociation.getRemoteTable());
                continue;
            }
            if (!table.equals(fKIndexAssociation.getRemoteTable())) continue;
            arrayList.add(fKIndexAssociation.getTable());
        }
        return arrayList;
    }

    public List getParentTables(Table table) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            if (!table.equals(fKIndexAssociation.getTable())) continue;
            arrayList.add(fKIndexAssociation.getRemoteTable());
        }
        return arrayList;
    }

    public List getChildTables(Table table) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            if (!table.equals(fKIndexAssociation.getRemoteTable())) continue;
            arrayList.add(fKIndexAssociation.getTable());
        }
        return arrayList;
    }

    public Collection getAssociatedTablesWith(KeyObject keyObject) {
        return this.iterateAndFill(keyObject, true);
    }

    private Collection iterateAndFill(KeyObject keyObject, boolean bl) {
        if (keyObject == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<DesignObject> hashSet = new HashSet<DesignObject>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            if (!keyObject.equals(fKIndexAssociation.getRemoteIndex())) continue;
            if (bl) {
                hashSet.add(fKIndexAssociation.getTable());
                continue;
            }
            hashSet.add(fKIndexAssociation);
        }
        return hashSet;
    }

    public FKIndexAssociationReference createReference() {
        return (FKIndexAssociationReference)this.referenceSet.createReference(this.getDesign());
    }

    public List getFKeysToListOfKeys(List list) {
        ArrayList<FKIndexAssociation> arrayList = new ArrayList<FKIndexAssociation>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            if (!list.contains(fKIndexAssociation.getRemoteIndex())) continue;
            arrayList.add(fKIndexAssociation);
        }
        return arrayList;
    }

    public List getFKeysEndingTo(Table table) {
        ArrayList<FKIndexAssociation> arrayList = new ArrayList<FKIndexAssociation>();
        if (table != null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
                if (table != fKIndexAssociation.getRemoteTable() && table != fKIndexAssociation.getTable()) continue;
                arrayList.add(fKIndexAssociation);
            }
        }
        return arrayList;
    }

    @Override
    public boolean changeName(String string, String string2, DesignObject designObject) {
        Object v = this.names.get(string2.toUpperCase());
        if (v == null || v == designObject || this.checkDifferentSchema((FKIndexAssociation)designObject, (FKIndexAssociation)v)) {
            this.doRenaming(string, string2, designObject);
            return true;
        }
        return false;
    }

    private boolean checkDifferentSchema(FKIndexAssociation fKIndexAssociation, FKIndexAssociation fKIndexAssociation2) {
        Table table = fKIndexAssociation.getTable();
        Table table2 = fKIndexAssociation2.getTable();
        if (table != null && table2 != null) {
            return !table.getSchema().equals(table2.getSchema());
        }
        return true;
    }

    private void doRenaming(String string, String string2, DesignObject designObject) {
        String string3;
        DesignObject designObject2;
        if (string != null && (designObject2 = (DesignObject)this.names.get(string3 = string.toUpperCase())) == designObject) {
            this.names.remove(string3);
        }
        this.names.put(string2.toUpperCase(), designObject);
        if (!designObject.getDesign().isLoading()) {
            SetEvent.NAME_CHANGED.setAffected(designObject);
            this.fireChange(SetEvent.NAME_CHANGED);
        }
    }

    class FKAssociationReferenceSet
    extends ReferenceSet {
        FKAssociationReferenceSet() {
        }

        @Override
        protected ModelIDObjectReference instantiateReference(Design design) {
            return new FKIndexAssociationReference(this.counter++, design, this);
        }
    }
}

