/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.logical.RelationSet;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;
import oracle.dbtools.crest.swingui.editor.relational.ForeignKeyPropertiesDialogEx;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.GUID;
import oracle.ide.Ide;

public class FKIndexAssociation
extends DesignObject
implements ContainerObjectListener,
ConnectionInterface {
    public static final String DELETE_RULE_CASCADE = "CASCADE";
    public static final String DELETE_RULE_SET_NULL = "SET NULL";
    public static final String DELETE_RULE_RESTRICT = "RESTRICT";
    public static final String DELETE_RULE_NOTHING = "NO ACTION";
    public static final String DELETE_RULE_SET_DEFAULT = "SET DEFAULT";
    public static final String[] DELETE_RULES = new String[]{"NO ACTION", "CASCADE", "SET NULL", "RESTRICT"};
    public static final String[] DELETE_RULES_ORACLE = new String[]{"NO ACTION", "CASCADE", "SET NULL"};
    public static final String[] OPTIONAL_CHILD_DELETE_RULES = new String[]{"RESTRICT", "NO ACTION", "SET NULL"};
    public static final String[] DELETE_RULES_WITHOUT_NULL = new String[]{"NO ACTION", "CASCADE", "RESTRICT"};
    public static final String[] DELETE_RULES_WITHOUT_NULL_ORACLE = new String[]{"NO ACTION", "CASCADE"};
    public static final String[] DELETE_RULES_WITH_DEFAULT = new String[]{"NO ACTION", "CASCADE", "SET NULL", "SET DEFAULT"};
    public static final String[] DELETE_RULES_WITH_DEFAULT_WITHOUT_NULL = new String[]{"NO ACTION", "CASCADE", "SET DEFAULT"};
    public static final String[] DELETE_RULES_RESTRICT_CASCADE = new String[]{"CASCADE", "RESTRICT"};
    public static final String[] DELETE_RULES_NOACTION_CASCADE = new String[]{"CASCADE", "NO ACTION"};
    public static final String PROPERTY_ASSOCIATION_ID = "fkassociation.id";
    public static final String ID_PREFIX = "IDXFK";
    public static boolean RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS = true;
    private Index fkIndex = null;
    Collection dpvCol = new ArrayList();
    DesignPartView dpvPhysical;
    protected KeyObject keyObject = null;
    protected ContainerWithKeyObject container = null;
    protected Map elementMap = new HashMap();
    protected String deleteRule = "NO ACTION";
    private boolean mandatory = true;
    private boolean transferable = true;
    private FKArc arc = null;
    public static float[] dashpattern = new float[]{8.0f, 8.0f};
    private FKIndexAssociation originatingFK;
    private TVTable originatingSourceTVTable;
    private TVTable originatingTargetTVTable;
    private boolean silentRemove = false;
    public static final String TYPE_NAME = "FKIndexAssociation";
    TVTable sourceTVT = null;
    TVTable targetTVT = null;
    FKConnection fkConnection = null;

    public FKIndexAssociation(Table table) {
        super(table.getDesignPart());
        this.id = new GUID().toString();
        this.setContainerWithKeyObject(table);
        this.setBackup(table.isBackup());
    }

    public FKIndexAssociation(DesignPart designPart) {
        super(designPart);
    }

    public FKIndexAssociation(DesignPart designPart, FKIndexAssociation fKIndexAssociation) {
        super(designPart);
        this.originatingFK = fKIndexAssociation;
    }

    public void setContainerWithKeyObject(ContainerWithKeyObject containerWithKeyObject) {
        if (containerWithKeyObject != null) {
            containerWithKeyObject.addContainerListener(this);
        }
        this.container = containerWithKeyObject;
        if (containerWithKeyObject != null) {
            this.dpvPhysical = this.getDesign().getRelationalDesign().getMainView();
        }
    }

    public Table getTable() {
        return (Table)this.getContainerWithKeyObject();
    }

    public ContainedObject createElementFor(ContainedObject containedObject) {
        Column column = this.getTable().getFKColumn(this, (Column)containedObject);
        if (column == null) {
            Column column2 = this.getTable().createColumnFK((Column)containedObject, this);
            this.getLocalFKIndex().add(column2);
            return column2;
        }
        return column;
    }

    @Override
    public String getIDPrefix() {
        return ID_PREFIX;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public Column[] getColumns() {
        return (Column[])this.getLocalFKIndex().getElements();
    }

    public boolean hasLocalFKIndex() {
        return this.fkIndex != null;
    }

    public void setLocalFKIndex(Index index) {
        this.fkIndex = index;
        if (index != null) {
            this.initializeLocalIndex(this.fkIndex);
        }
    }

    public Index getLocalFKIndex() {
        if (this.fkIndex == null) {
            this.fkIndex = this.createLocalFKIndex();
        } else if (this.fkIndex.getFKAssociation() == this && this.fkIndex.getContainerWithKeyObject() == null) {
            this.fkIndex.setContainerObject(this.getContainerWithKeyObject());
        }
        return this.fkIndex;
    }

    public Index getRemoteIndex() {
        return (Index)this.getKeyObject();
    }

    public Table getRemoteTable() {
        if (this.getRemoteIndex() != null) {
            return (Table)this.getRemoteIndex().getContainerObject();
        }
        return null;
    }

    public Index createLocalFKIndex() {
        this.fkIndex = this.getTable().createIndexFK(this);
        return this.initializeLocalIndex(this.fkIndex);
    }

    protected Index initializeLocalIndex(Index index) {
        index.setFKAssociation(this);
        Column[] columnArray = this.getTable().getAllFKColumns(this);
        for (int i = 0; i < columnArray.length; ++i) {
            index.add(columnArray[i]);
        }
        return index;
    }

    @Override
    public void remove() {
        this.getTable().removeContainerListener(this);
        this.getLocalFKIndex().remove();
        this.getTable().removeFKAssociationFromList(this);
        this.removeAllFKElements();
        super.remove();
        this.dpvCol.clear();
    }

    public void callRemoveListeners() {
        ObjectChangeEvent objectChangeEvent = ObjectChangeEvent.OBJECT_REMOVED;
        objectChangeEvent.setAffected(this);
        this.fireChange(objectChangeEvent);
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            return this.getContainerWithKeyObject().isDropEnabled() || this.getContainerWithKeyObject().shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    public void changed(ContainerObject containerObject, ContainerObjectEvent containerObjectEvent) {
        if (!this.isBackupFK() && !this.getDesign().isCleaning()) {
            if (containerObject instanceof KeyObject && this.getDesign().isPropagatePKChahges()) {
                if (containerObjectEvent.isType(0)) {
                    this.addFKElement((ContainedObject)containerObjectEvent.getAffectedElement());
                } else if (containerObjectEvent.isType(1)) {
                    if (containerObjectEvent.getAffectedElement() instanceof Column) {
                        ArrayList<Column> arrayList = new ArrayList<Column>();
                        arrayList.add((Column)containerObjectEvent.getAffectedElement());
                        this.removeFKElement(arrayList);
                    }
                } else if (containerObjectEvent.isType(4)) {
                    System.out.println("FKAssociation.changed: DOES NOT HAPPEN ? or irrelevant ?");
                } else if (containerObjectEvent.isType(7)) {
                    this.moveLocalColumn(containerObject, (Column)containerObjectEvent.getAffectedElement());
                }
            }
            if (containerObjectEvent.isType(4) && this.hasLocalFKIndex() && this.getLocalFKIndex().equals(containerObjectEvent.getAffectedElement())) {
                this.setLocalFKIndex(null);
            }
        }
    }

    public void synchronizeFKColumns() {
        if (this.keyObject != null) {
            int n;
            Column[] columnArray = (Column[])this.keyObject.getElements();
            Table table = (Table)this.getContainerWithKeyObject();
            ArrayList<Column> arrayList = new ArrayList<Column>();
            for (n = 0; n < columnArray.length; ++n) {
                Column column = table.getFKColumn(this, columnArray[n]);
                if (column == null) {
                    column = table.getColumnForDelegate(this, columnArray[n]);
                    if (column != null) {
                        column.addFKAssociation(columnArray[n], this);
                        this.getLocalFKIndex().add(column);
                    } else {
                        column = table.createColumnFK(columnArray[n], this);
                        column.setName(columnArray[n].getName());
                    }
                }
                arrayList.add(column);
                if (this.getLocalFKIndex().contains(column)) continue;
                this.getLocalFKIndex().add(column);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this.getLocalFKIndex().moveToIndex((ContainedObject)arrayList.get(n), n);
            }
        }
    }

    private Column getColumnForReferencedColumn(Column column) {
        for (Column column2 : this.getLocalFKIndex().getElementsCollection()) {
            if (!column2.isReferingTo(this, column)) continue;
            return column2;
        }
        return null;
    }

    private void moveLocalColumn(ContainerObject containerObject, Column column) {
        int n = containerObject.getIndexOf(column);
        Column column2 = this.getColumnForReferencedColumn(column);
        if (column2 != null) {
            this.getLocalFKIndex().moveToIndex(column2, n);
        }
    }

    @Override
    public void setTopView(TopView topView) {
        this.addTopView(topView);
    }

    @Override
    public TopView getTopView() {
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            if (dpvInfo2.tv == null) continue;
            return dpvInfo2.tv;
        }
        return null;
    }

    public void addTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.tv != null && dpvInfo2.tv != topView) {
            throw new RuntimeException(Messages.getString("FKIndexAssociation.AssociationAlreadyExists"));
        }
        dpvInfo2.tv = topView;
    }

    @Override
    public void removeTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.tv == null) {
            return;
        }
        this.dpvCol.remove(dpvInfo2);
        this.removeObjectListener(topView);
    }

    @Override
    public void resetViewNumbers() {
    }

    public dpvInfo getDPVInfoFor(DesignPartView designPartView) {
        dpvInfo dpvInfo22;
        for (dpvInfo dpvInfo22 : this.dpvCol) {
            if (dpvInfo22.dpv != designPartView) continue;
            return dpvInfo22;
        }
        dpvInfo22 = new dpvInfo();
        dpvInfo22.dpv = designPartView;
        this.dpvCol.add(dpvInfo22);
        return dpvInfo22;
    }

    public List getAllTVRelations() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            if (dpvInfo2.tv == null) continue;
            arrayList.add(dpvInfo2.tv);
        }
        return arrayList;
    }

    @Override
    public TopView getViewFor(DesignPartView designPartView) {
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        return dpvInfo2.tv;
    }

    @Override
    public String getGeneratorID() {
        return this.getLocalFKIndex().getGeneratorID();
    }

    public void setSourceTVTable(TVTable tVTable) {
        DesignPartView designPartView = tVTable.getDesignPartView();
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.sourceTV != tVTable) {
            boolean bl = false;
            if (dpvInfo2.sourceTV != null) {
                bl = true;
                if (dpvInfo2.tv != null && !this.isBackupFK()) {
                    ((TVFKRelation)dpvInfo2.tv).removeConnection();
                }
                dpvInfo2.sourceTV.removeTopViewListener(this);
            }
            dpvInfo2.sourceTV = tVTable;
            if (!this.isBackupFK()) {
                dpvInfo2.sourceTV.addTopViewListener(this);
                this.addTVFKRelation(dpvInfo2);
                if (bl && dpvInfo2.tv != null) {
                    ((TVFKRelation)dpvInfo2.tv).addConnection(true);
                    ((TVFKRelation)dpvInfo2.tv).resetEdgeParams();
                }
            }
        }
    }

    public void setTargetTVTable(TVTable tVTable) {
        DesignPartView designPartView = tVTable.getDesignPartView();
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.targetTV != tVTable) {
            boolean bl = false;
            if (dpvInfo2.targetTV != null) {
                bl = true;
                if (dpvInfo2.tv != null && !this.isBackupFK()) {
                    ((TVFKRelation)dpvInfo2.tv).removeConnection();
                }
                dpvInfo2.targetTV.removeTopViewListener(this);
            }
            dpvInfo2.targetTV = tVTable;
            if (!this.isBackupFK()) {
                dpvInfo2.targetTV.addTopViewListener(this);
                this.addTVFKRelation(dpvInfo2);
                if (bl && dpvInfo2.tv != null) {
                    ((TVFKRelation)dpvInfo2.tv).addConnection(true);
                    ((TVFKRelation)dpvInfo2.tv).resetEdgeParams();
                }
            }
        }
    }

    public void addTVFKRelation(dpvInfo dpvInfo2) {
        if (dpvInfo2.tv == null && dpvInfo2.sourceTV != null && dpvInfo2.targetTV != null && dpvInfo2.dpv != null) {
            TVFKRelation tVFKRelation = new TVFKRelation(this.getDesign().getAppView(), dpvInfo2.dpv);
            tVFKRelation.setModel(this);
            tVFKRelation.setSize(new Dimension(100, 100));
            this.addObjectListener(tVFKRelation);
            dpvInfo2.dpv.registerForTreemodel(tVFKRelation);
            if (dpvInfo2.tv != null && ((TVFKRelation)dpvInfo2.tv).getEdge() == null && dpvInfo2.dpv.isVisible() && !ApplicationView.loading) {
                tVFKRelation.addConnection();
                tVFKRelation.resetEdgeParams();
            }
        }
        if (dpvInfo2.tv != null && dpvInfo2.sourceTV != null && dpvInfo2.targetTV != null && dpvInfo2.dpv != null) {
            dpvInfo2.dpv.registerTopView(dpvInfo2.tv);
        }
    }

    public void addTVFKRelation(TopView topView, TVTable tVTable, TVTable tVTable2, DesignPartView designPartView) {
        if (topView == null && tVTable != null && tVTable2 != null && designPartView != null) {
            TVFKRelation tVFKRelation = new TVFKRelation(this.getDesign().getAppView(), designPartView);
            tVFKRelation.setModel(this);
            tVFKRelation.setSize(new Dimension(100, 100));
            this.addObjectListener(tVFKRelation);
            designPartView.registerForTreemodel(tVFKRelation);
            if (designPartView.isVisible() && !ApplicationView.loading) {
                tVFKRelation.addConnection();
                tVFKRelation.resetEdgeParams();
            }
        }
    }

    public void changeKeyObject(KeyObject keyObject, Column[] columnArray) {
        KeyObject keyObject2 = this.getKeyObject();
        KeyObject keyObject3 = this.getKeyObject();
        if (keyObject3 != keyObject) {
            this.setKeyObject(keyObject);
            if (keyObject != null) {
                if (this.getContainerWithKeyObject().isBST()) {
                    if (this.getOriginalContainer().isBST()) {
                        Column column = (Column)this.getContainerWithKeyObject().getExactRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                        if (column == null) {
                            column = (Column)this.getContainerWithKeyObject().getRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                        }
                        if (column != null) {
                            this.setRefFKColumn(column);
                        }
                    }
                } else if (this.getOriginalContainer().isBST()) {
                    if (!this.getContainerWithKeyObject().isBST()) {
                        Table table = (Table)this.getContainerWithKeyObject();
                        table.createRefToStructuredType(this.getOriginalContainer().getBasedOnStructuredType(), this);
                    } else {
                        Column column = (Column)this.getContainerWithKeyObject().getExactRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getContainerWithKeyObject());
                        if (column == null) {
                            column = (Column)this.getContainerWithKeyObject().getRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                        }
                        if (column != null) {
                            this.setRefFKColumn(column);
                        }
                    }
                }
            }
            if (keyObject2 != keyObject) {
                this.callRemoveListeners();
                this.addToAllDPVs();
            }
        }
        this.swapFKColumnsWithAskDelete(columnArray);
    }

    public void addToAllDPVs() {
        DesignPartView designPartView;
        Collection collection = this.getContainerWithKeyObject().getAffectedDPVs();
        Collection collection2 = this.getRemoteTable().getAffectedDPVs();
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            designPartView = (DesignPartView)iterator.next();
            this.getTargetTV(designPartView);
        }
        while (iterator2.hasNext()) {
            designPartView = (DesignPartView)iterator2.next();
            this.getSourceTV(designPartView);
        }
    }

    public TVTable getSourceTVTable() {
        DesignPartView designPartView = ApplicationView.loading ? this.getDesignPart().getMainView() : this.getDesign().getAppView().getCurrentDPV();
        if (designPartView == null) {
            designPartView = this.getDesignPart().getMainView();
        }
        return this.getSourceTV(designPartView);
    }

    public TVTable getTargetTVTable() {
        DesignPartView designPartView = ApplicationView.loading ? this.getDesignPart().getMainView() : this.getDesign().getAppView().getCurrentDPV();
        if (designPartView == null) {
            designPartView = this.getDesignPart().getMainView();
        }
        return this.getTargetTV(designPartView);
    }

    public TVTable getSourceTV(DesignPartView designPartView) {
        Collection collection;
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.sourceTV == null && this.getRemoteTable() != null && !(collection = this.getRemoteTable().getAllViews(designPartView)).isEmpty()) {
            Iterator iterator = collection.iterator();
            dpvInfo2.sourceTV = (TVTable)iterator.next();
            if (!this.isBackupFK()) {
                dpvInfo2.sourceTV.addTopViewListener(this);
                this.addTVFKRelation(dpvInfo2);
            }
        }
        return dpvInfo2.sourceTV;
    }

    public TVTable getTargetTV(DesignPartView designPartView) {
        Collection collection;
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.targetTV == null && this.getContainerWithKeyObject() != null && !(collection = this.getContainerWithKeyObject().getAllViews(designPartView)).isEmpty()) {
            Iterator iterator = collection.iterator();
            dpvInfo2.targetTV = (TVTable)iterator.next();
            if (!this.isBackupFK()) {
                dpvInfo2.targetTV.addTopViewListener(this);
                this.addTVFKRelation(dpvInfo2);
            }
        }
        return dpvInfo2.targetTV;
    }

    public FKConnection getFKConnection() {
        if (this.fkConnection == null) {
            this.fkConnection = new FKConnection();
            this.fkConnection.setParentTable(this.getRemoteTable());
            this.fkConnection.setChildTable((Table)this.getContainerWithKeyObject());
        }
        return this.fkConnection;
    }

    @Override
    public void changed(TopView topView, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.TOPVIEW_REMOVED)) {
            DesignPartView designPartView = topView.getDesignPartView();
            designPartView.removeViewFor(this);
            dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
            dpvInfo2.tv = null;
            if (dpvInfo2.sourceTV == topView) {
                dpvInfo2.sourceTV = null;
            }
            if (dpvInfo2.targetTV == topView) {
                dpvInfo2.targetTV = null;
            }
        }
    }

    public void repairSelfReference() {
        if (this.getContainerWithKeyObject() == this.getRemoteTable()) {
            Collection collection = this.getContainerWithKeyObject().getAffectedDPVs();
            for (DesignPartView designPartView : collection) {
                TVTable tVTable = this.getTargetTV(designPartView);
                ((TVFKRelation)this.getViewFor(designPartView)).repairSelfReference(tVTable);
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        if (this.getContainerWithKeyObject() != null && this.getContainerWithKeyObject().isReadOnly()) {
            return true;
        }
        return super.isReadOnly();
    }

    public void swapAndRemoveFKColumn(Column column, Column column2, Column column3) {
        if (column == column2) {
            return;
        }
        if (column.getContainerWithKeyObject() != column2.getContainerWithKeyObject() || column.getContainerWithKeyObject() != this.getContainerWithKeyObject()) {
            return;
        }
        if (FKUtilities.compatibleColumns(column, column2)) {
            int n = this.getLocalFKIndex().getIndexOf(column);
            column.removeFKAssociation(this.getObjectID());
            this.getLocalFKIndex().remove(column);
            column2.addFKAssociation(column3, this);
            this.getLocalFKIndex().add(column2);
            this.getLocalFKIndex().moveToIndex(column2, n);
            if (column.getAssociationsCount() == 0 && !column.isPreviousColumn()) {
                column.remove();
            }
        }
    }

    public void swapFKColumnsWith(Column[] columnArray) {
        int n;
        Column[] columnArray2 = (Column[])this.getLocalFKIndex().getElements();
        for (int i = 0; i < columnArray2.length; ++i) {
            Column column = columnArray2[i];
            column.removeFKAssociation(this.getObjectID());
            this.getLocalFKIndex().remove(column);
        }
        Column[] columnArray3 = (Column[])this.getKeyObject().getElements();
        for (n = 0; n < columnArray.length; ++n) {
            if (columnArray[n] == null) continue;
            columnArray[n].addFKAssociation(columnArray3[n], this);
            this.getLocalFKIndex().add(columnArray[n]);
        }
        for (n = 0; n < columnArray2.length; ++n) {
            Column column = columnArray2[n];
            if (column.getAssociationsCount() != 0 || column.isPreviousColumn()) continue;
            column.remove();
        }
    }

    public void swapFKColumnsWithAskDelete(Column[] columnArray) {
        Object object;
        int n = this.getDesign().getAppView().getSettings().getDeleteFKColumnStrategy();
        ContainedObject[] containedObjectArray = this.getLocalFKIndex().getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            Column column = (Column)containedObjectArray[i];
            column.removeFKAssociation(this.getObjectID());
            this.getLocalFKIndex().remove(column);
        }
        ContainedObject[] containedObjectArray2 = this.getKeyObject().getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i] == null) continue;
            columnArray[i].addFKAssociation((Column)containedObjectArray2[i], this);
            this.getLocalFKIndex().add(columnArray[i]);
        }
        String string = "";
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            object = (Column)containedObjectArray[i];
            if (((Column)object).getAssociationsCount() != 0 || ((Column)object).isPreviousColumn()) continue;
            string = string.equals("") ? ((ContainedObject)object).getName() : string + ", " + ((ContainedObject)object).getName();
            arrayList.add((Column)object);
        }
        if (arrayList.size() > 0) {
            if (this.getDesign().isClosing() || this.isSilentRemove()) {
                this.removeColumns(arrayList);
            } else if (n == 0 || this.getDesignPart().getUndoManager().isInUndoRedoMode()) {
                this.removeColumns(arrayList);
            } else if (n == 2) {
                JOptionPane jOptionPane = new JOptionPane(MessageFormat.format(Messages.getString("FKIndexAssociation.DoYouWantToDeleteColumns"), string), 3, 0);
                object = jOptionPane.createDialog((Component)Ide.getMainWindow(), Messages.getString("FKIndexAssociation.DeleteFKColumnsStrategy"));
                ((Dialog)object).setVisible(true);
                Integer n2 = (Integer)jOptionPane.getValue();
                if (n2 == 0) {
                    this.removeColumns(arrayList);
                }
            }
        }
    }

    private void removeColumns(List<Column> list) {
        for (Column column : list) {
            column.remove();
            this.elementMap.remove(column);
        }
    }

    public Column[] getCompatibleColumns(Column column) {
        return FKUtilities.getCompatibleColumns(this.getContainerWithKeyObject(), column);
    }

    public Column getColumnForDelegate(Column column) {
        Column[] columnArray = this.getColumns();
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].isReferingTo(this, column)) continue;
            return columnArray[i];
        }
        return null;
    }

    public String getSubstitudeCaption() {
        return "Substitute FK Columns";
    }

    @Override
    public boolean hasAliveGenerator() {
        RelationSet relationSet;
        DesignObject designObject;
        RelationSet relationSet2 = this.getDesign().getLogicalDesign().getRelationSet();
        return ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID()) || (designObject = relationSet2.getObjectByID(this.getGeneratorID())) != null || (designObject = (relationSet = this.getDesign().getLogicalDesign().getInheritanceRelationSet()).getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ApplicationView applicationView = this.getDesign().getAppView();
            DesignPartView designPartView = applicationView.getCurrentDPV();
            if (designPartView != null && this.getContainerWithKeyObject().getDesignPart() != designPartView.getDesignPart() || designPartView == null) {
                designPartView = this.getContainerWithKeyObject().getDesignPart().getMainView();
            }
            ForeignKeyPropertiesDialogEx foreignKeyPropertiesDialogEx = new ForeignKeyPropertiesDialogEx(applicationView, this);
            foreignKeyPropertiesDialogEx.initProperties(this.getFKMemento(designPartView));
            foreignKeyPropertiesDialogEx.show();
        }
    }

    public boolean showPropertyDialog(FKMemento fKMemento, Dialog dialog) {
        if (!this.isDialogVisible()) {
            ForeignKeyPropertiesDialogEx foreignKeyPropertiesDialogEx = new ForeignKeyPropertiesDialogEx(dialog, this.getDesign().getAppView(), this, fKMemento);
            foreignKeyPropertiesDialogEx.initProperties(fKMemento);
            foreignKeyPropertiesDialogEx.setModal(true);
            foreignKeyPropertiesDialogEx.show();
            return foreignKeyPropertiesDialogEx.changed();
        }
        return false;
    }

    public void addFKElement(ContainedObject containedObject) {
        ContainerObject containerObject = this.getOriginalContainer();
        if (!this.getContainerWithKeyObject().isBST() && containerObject != null) {
            Table table = (Table)this.getContainerWithKeyObject();
            Column column = null;
            column = table.getColumnForDelegate(this, (Column)containedObject);
            if (column == null || !column.getFKAssociationsForDelegate(containedObject.getObjectID()).contains(this)) {
                column = (Column)this.doCreateElementFor(containedObject);
            } else {
                this.getLocalFKIndex().add(column);
                column.addFKAssociation((Column)containedObject, this);
            }
            column.setNullsAllowed(!this.isMandatory());
            this.elementMap.put(containedObject, column);
        }
    }

    protected ContainedObject doCreateElementFor(ContainedObject containedObject) {
        ContainedObject containedObject2 = this.createElementFor(containedObject);
        if (!containedObject2.isNameFixed()) {
            String string = ApplyNamingStandards.createFKColumnName((Column)containedObject, this.getDesign().getDLSettings().getNamingStandardRule());
            containedObject2.setName(string != null ? string : containedObject.getName());
        }
        this.elementMap.put(containedObject, containedObject2);
        return containedObject2;
    }

    public void removeAllFKElements() {
        if (this.keyObject != null) {
            ArrayList<Column> arrayList = new ArrayList<Column>();
            ContainedObject[] containedObjectArray = this.keyObject.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                arrayList.add((Column)containedObjectArray[i]);
            }
            if (this.keyObject.getElementsCollection().size() > 0) {
                this.removeFKElement(arrayList);
            } else {
                this.removeAssociationFromColumns();
            }
        }
        this.elementMap.clear();
    }

    private void removeAssociationFromColumns() {
        for (Column column : this.getLocalFKIndex().getElementsCollection()) {
            column.removeFKAssociation(this.getObjectID());
        }
        this.getLocalFKIndex().getElementsCollection().clear();
    }

    public void removeFKElement(List<Column> list) {
        Object object;
        int n = this.getDesign().getAppView().getSettings().getDeleteFKColumnStrategy();
        String string = null;
        String string2 = "";
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Iterator<Column> iterator = list.iterator();
        while (iterator.hasNext()) {
            object = ((Table)this.getContainerWithKeyObject()).getFKColumn(this, iterator.next());
            if (object == null) continue;
            string = ((ContainedObject)object).getContainer().getName();
            this.getLocalFKIndex().remove((ContainedObject)object);
            ((Column)object).removeFKAssociation(this.getObjectID());
            if (this.isColumnUsedInConstraints((Column)object) || ((Column)object).getAssociationsCount() != 0 || ((Column)object).isPreviousColumn()) continue;
            string2 = string2.equals("") ? ((ContainedObject)object).getName() : string2 + ", " + ((ContainedObject)object).getName();
            arrayList.add((Column)object);
        }
        if (arrayList.size() > 0) {
            if (this.getDesign().isClosing() || this.isSilentRemove()) {
                this.removeColumns(arrayList);
            } else if (n == 0 || this.getDesignPart().getUndoManager().isInUndoRedoMode()) {
                this.removeColumns(arrayList);
            } else if (n == 2) {
                object = new JOptionPane(MessageFormat.format(Messages.getString("FKIndexAssociation.DoYouWantToDelete"), string2, string), 3, 0);
                JDialog jDialog = ((JOptionPane)object).createDialog((Component)Ide.getMainWindow(), Messages.getString("FKIndexAssociation.DeleteFKColumnsStrategy"));
                jDialog.setVisible(true);
                Integer n2 = (Integer)((JOptionPane)object).getValue();
                if (n2 == 0) {
                    this.removeColumns(arrayList);
                }
            }
        }
    }

    public void setKeyObject(KeyObject keyObject) {
        if (this.keyObject != keyObject) {
            if (this.keyObject != null) {
                this.keyObject.removeContainerListener(this);
                this.keyObject.removeObjectListener(this.getContainerWithKeyObject());
            }
            this.keyObject = keyObject;
            if (this.keyObject != null) {
                keyObject.addContainerListener(this);
                keyObject.addObjectListener(this.getContainerWithKeyObject());
            }
        }
    }

    public KeyObject getKeyObject() {
        return this.keyObject;
    }

    public String[] getDeleteRuleChoices() {
        return DELETE_RULES;
    }

    public void setDeleteRule(String string) {
        this.deleteRule = string != null ? string : DELETE_RULE_NOTHING;
    }

    public String getDeleteRule() {
        return this.deleteRule;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public void addAllFKElements() {
        if (!this.getContainerWithKeyObject().isBST() && !this.getOriginalContainer().isBST()) {
            ContainedObject[] containedObjectArray = this.keyObject.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                this.addFKElement(containedObjectArray[i]);
            }
        } else if (this.keyObject.getElements().length > 0) {
            if (this.getContainerWithKeyObject().isBST()) {
                if (this.getOriginalContainer().isBST()) {
                    Column column = (Column)this.getContainerWithKeyObject().getExactRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                    if (column == null) {
                        column = (Column)this.getContainerWithKeyObject().getRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                    }
                    if (column != null) {
                        this.setRefFKColumn(column);
                    }
                }
            } else if (this.getOriginalContainer().isBST()) {
                if (!this.getContainerWithKeyObject().isBST()) {
                    ContainedObject[] containedObjectArray = this.keyObject.getElements();
                    if (containedObjectArray.length > 0 && !containedObjectArray[0].isOid()) {
                        for (int i = 0; i < containedObjectArray.length; ++i) {
                            this.addFKElement(containedObjectArray[i]);
                        }
                    } else {
                        Table table = (Table)this.getContainerWithKeyObject();
                        table.createRefToStructuredType(this.getOriginalContainer().getBasedOnStructuredType(), this);
                    }
                } else {
                    Column column = (Column)this.getContainerWithKeyObject().getExactRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                    if (column == null) {
                        column = (Column)this.getContainerWithKeyObject().getRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                    }
                    if (column != null) {
                        this.setRefFKColumn(column);
                    }
                }
            }
        }
    }

    private void setRefFKColumn(Column column) {
        Column column2 = (Column)this.getOriginalContainer().getOidElement();
        if (column2 != null) {
            column.addFKAssociation(column2, this);
        }
        column.setScopeId(this.getOriginalContainer().getObjectID());
    }

    protected String longNameToName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(".")) {
                stringBuffer.append('_');
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public ContainerObject getOriginalContainer() {
        if (this.getKeyObject() == null) {
            return null;
        }
        return this.getKeyObject().getTopLevelContainer();
    }

    public ContainerWithKeyObject getContainerWithKeyObject() {
        return this.container;
    }

    @Override
    public String getLongName() {
        if (this.container != null) {
            StringBuffer stringBuffer = new StringBuffer(this.container.getName());
            stringBuffer.append(".").append(this.getName());
            return stringBuffer.toString();
        }
        return this.getName();
    }

    @Override
    public String getVeryLongName() {
        if (this.container != null) {
            SchemaObject schemaObject = this.container.getSchemaObject();
            if (schemaObject != null) {
                StringBuffer stringBuffer = new StringBuffer(schemaObject.getName());
                stringBuffer.append(".").append(this.container.getName()).append(".").append(this.getName());
                return stringBuffer.toString();
            }
            StringBuffer stringBuffer = new StringBuffer(this.container.getName());
            stringBuffer.append(".").append(this.getName());
            return stringBuffer.toString();
        }
        return this.getName();
    }

    @Override
    public boolean hasRepresentationInDPV(DesignPartView designPartView) {
        return this.getViewFor(designPartView) != null;
    }

    public Relation getEngRelation() {
        RepositoryObject repositoryObject;
        DesignObject designObject;
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0 && (designObject = (repositoryObject = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null && designObject instanceof Relation) {
            return (Relation)designObject;
        }
        repositoryObject = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectByID(this.getGeneratorID());
        if (repositoryObject == null) {
            repositoryObject = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectGeneratedBy(this.getObjectID());
        }
        return repositoryObject;
    }

    public Relation getEngRelation(Entity entity) {
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        for (int i = 0; i < list.size(); ++i) {
            Relation relation;
            XtdMapping xtdMapping = (XtdMapping)list.get(i);
            DesignObject designObject = xtdMapping.getObjectMappedTo(this);
            if (designObject == null || !(designObject instanceof Relation) || (relation = (Relation)designObject).getSourceEntity() != entity && relation.getTargetEntity() != entity) continue;
            return (Relation)designObject;
        }
        Relation relation = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectByID(this.getGeneratorID());
        if (relation == null) {
            relation = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectGeneratedBy(this.getObjectID());
        }
        return relation;
    }

    public InheritanceRelation getEngInheritanceRelation() {
        XtdMapping xtdMapping;
        DesignObject designObject;
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0 && (designObject = (xtdMapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null && designObject instanceof InheritanceRelation) {
            return (InheritanceRelation)designObject;
        }
        return null;
    }

    @Override
    public void copy(DesignObject designObject) {
        super.copy(designObject);
        FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)designObject;
        fKIndexAssociation.setDeleteRule(this.getDeleteRule());
        fKIndexAssociation.setMandatory(this.isMandatory());
        fKIndexAssociation.setTransferable(this.isTransferable());
    }

    public void backupTo(FKIndexAssociation fKIndexAssociation, DesignPartView designPartView) {
        if (!fKIndexAssociation.isBackupFK()) {
            throw new RuntimeException("FKIndexAssociation.backupTo(...) can be used only for backup FK");
        }
        this.copy(fKIndexAssociation);
        fKIndexAssociation.setObjectID(this.getObjectID());
        Table table = (Table)fKIndexAssociation.getContainerWithKeyObject();
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (Column column : this.getLocalFKIndex().getElementsCollection()) {
            Column column2 = (Column)table.getElementByID(column.getObjectID());
            if (column2 == null) continue;
            arrayList.add(column2);
        }
        fKIndexAssociation.swapFKColumnsWith(arrayList.toArray(new Column[0]));
    }

    public void restoreTo(FKIndexAssociation fKIndexAssociation, DesignPartView designPartView) {
        if (!this.isBackupFK()) {
            throw new RuntimeException("FKIndexAssociation.restoreTo(...) can be used only tp restore from backup FK");
        }
        this.copy(fKIndexAssociation);
        Table table = (Table)fKIndexAssociation.getContainerWithKeyObject();
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (Column column : this.getLocalFKIndex().getElementsCollection()) {
            Column column2 = (Column)table.getElementByID(column.getObjectID());
            if (column2 == null) continue;
            arrayList.add(column2);
        }
        fKIndexAssociation.swapFKColumnsWith(arrayList.toArray(new Column[0]));
    }

    public void restoreToCandidateOrigFK(FKIndexAssociation fKIndexAssociation, DesignPartView designPartView) {
        if (!this.getContainerWithKeyObject().isBackup() || this.originatingFK != null && this.originatingFK != fKIndexAssociation) {
            throw new RuntimeException("FKIndexAssociation.restoreToCandidateOrigFK(...) can be used only when new FK on backup table is created in TablePropertiesDialogEx");
        }
        this.originatingFK = fKIndexAssociation;
        this.restoreTo(fKIndexAssociation, designPartView);
    }

    public XtdMapping getDeletedMapping() {
        List list = this.getRMExtendedMap().getDeletedMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            XtdMapping xtdMapping = (XtdMapping)list.get(0);
            return xtdMapping;
        }
        return null;
    }

    @Override
    public void setSourceTopView(TopView topView) {
        this.setSourceTVTable((TVTable)topView);
    }

    @Override
    public void setTargetTopView(TopView topView) {
        this.setTargetTVTable((TVTable)topView);
    }

    @Override
    public TopView getSourceTopView(DesignPartView designPartView) {
        return this.getSourceTV(designPartView);
    }

    @Override
    public TopView getTargetTopView(DesignPartView designPartView) {
        return this.getTargetTV(designPartView);
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView designPartView) {
        return this.getViewFor(designPartView);
    }

    @Override
    public DesignObject getSourceObject() {
        return this.getRemoteTable();
    }

    @Override
    public DesignObject getTargetObject() {
        return this.getContainerWithKeyObject();
    }

    public boolean hasColumnWithAllowNulls() {
        Column[] columnArray = this.getColumns();
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].getNullsAllowed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean setName(String string) {
        Index index;
        boolean bl = super.setName(string);
        if (ApplicationView.loading) {
            return bl;
        }
        if (bl && (index = this.getLocalFKIndex()) != null) {
            index.setName(string);
        }
        return bl;
    }

    @Override
    public void setMarkedGenerate(boolean bl) {
        super.setMarkedGenerate(bl);
        if (this.getLocalFKIndex() != null) {
            this.getLocalFKIndex().synchronizeMarkedGenerate(bl);
        }
    }

    public void synchronizeMarkedGenerate(boolean bl) {
        super.setMarkedGenerate(bl);
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean bl) {
        if (this.mandatory != bl) {
            this.mandatory = bl;
            if (this.getLocalFKIndex() != null) {
                KeyObject keyObject = this.getContainerWithKeyObject().getPK();
                for (Column column : this.getLocalFKIndex().getElementsCollection()) {
                    boolean bl2 = column.getNullsAllowed();
                    if (keyObject != null && keyObject.contains(column)) {
                        column.setNullsAllowed(false);
                    } else if (!bl) {
                        if (column.isInMandatoryFK()) {
                            column.setNullsAllowed(false);
                        } else {
                            column.setNullsAllowed(true);
                        }
                    } else {
                        column.setNullsAllowed(!bl);
                    }
                    if (column.getNullsAllowed() == bl2) continue;
                    column.setDirty(true);
                }
            }
        } else if (this.getLocalFKIndex() != null) {
            KeyObject keyObject = this.getContainerWithKeyObject().getPK();
            for (Column column : this.getLocalFKIndex().getElementsCollection()) {
                boolean bl3 = column.getNullsAllowed();
                if (bl) {
                    if (column.getNullsAllowed()) {
                        column.setNullsAllowed(false);
                    }
                } else if (keyObject != null && keyObject.contains(column) || column.isInMandatoryFK()) {
                    column.setNullsAllowed(false);
                } else if (!column.getNullsAllowed()) {
                    column.setNullsAllowed(true);
                }
                if (column.getNullsAllowed() == bl3) continue;
                column.setDirty(true);
            }
        }
        if (bl && DELETE_RULE_SET_NULL.equals(this.getDeleteRule())) {
            this.setDeleteRule(DELETE_RULE_NOTHING);
            this.resetEdgeParams();
        }
    }

    public boolean canBeOptional() {
        KeyObject keyObject = this.getTable().getPK();
        if (keyObject != null) {
            for (ContainedObject containedObject : this.getLocalFKIndex().getElementsCollection()) {
                if (!keyObject.contains(containedObject)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isTransferable() {
        return this.transferable;
    }

    public void setTransferable(boolean bl) {
        this.transferable = bl;
    }

    public FKArc getArc() {
        return this.arc;
    }

    public void setArc(FKArc fKArc) {
        this.arc = fKArc;
    }

    public boolean isInArc() {
        return this.arc != null;
    }

    public void resetEdgeParams() {
        for (TVFKRelation tVFKRelation : this.getAllTVRelations()) {
            tVFKRelation.resetEdgeParams();
        }
    }

    public void resetMandatoryUsingColumns() {
        if (this.getLocalFKIndex() != null) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (Column column : this.getLocalFKIndex().getElementsCollection()) {
                if (column.isPKElement()) {
                    bl3 = true;
                }
                if (column.getNullsAllowed()) {
                    bl = true;
                    continue;
                }
                bl2 = true;
            }
            boolean bl4 = false;
            if (bl && bl2) {
                if (bl3) {
                    bl4 = false;
                } else if (this.getRemoteIndex() != null && this.getRemoteIndex().isPK()) {
                    bl4 = true;
                } else if (this.getRemoteIndex() != null && this.getRemoteIndex().isUnique()) {
                    boolean bl5 = false;
                    for (Column column : this.getRemoteIndex().getElementsCollection()) {
                        if (!column.getNullsAllowed()) continue;
                        bl5 = true;
                        break;
                    }
                    if (!bl5) {
                        bl4 = true;
                    }
                }
            } else if (bl2) {
                bl4 = true;
            }
            if (RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS) {
                this.setMandatory(bl4);
            } else {
                this.mandatory = bl4;
            }
            if (this.mandatory && DELETE_RULE_SET_NULL.equals(this.getDeleteRule())) {
                this.setDeleteRule(DELETE_RULE_NOTHING);
            }
            this.resetEdgeParams();
        }
    }

    @Override
    public List getAllViews() {
        return this.getAllTVRelations();
    }

    @Override
    public void restoreTopView(TopView topView, TopView topView2, TopView topView3) {
        topView.getDesignPartView().restoreTopview(topView, this);
        dpvInfo dpvInfo2 = this.getDPVInfoFor(topView.getDesignPartView());
        if (dpvInfo2.tv == topView) {
            this.addObjectListener(topView);
            dpvInfo2.targetTV = (TVTable)topView3;
            dpvInfo2.targetTV.addTopViewListener(this);
            dpvInfo2.sourceTV = (TVTable)topView2;
            dpvInfo2.sourceTV.addTopViewListener(this);
        }
    }

    public boolean canRemoveColumnAutomaticaly(Column column) {
        Table table = (Table)column.getContainerWithKeyObject();
        Index index = this.getLocalFKIndex();
        if (table != this.getContainerWithKeyObject()) {
            return false;
        }
        if (column.isPreviousColumn()) {
            return false;
        }
        int n = this.getDesign().getAppView().getSettings().getDeleteFKColumnStrategy();
        if (n == 1) {
            return false;
        }
        KeyObject[] keyObjectArray = table.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            Index index2 = (Index)keyObjectArray[i];
            if (index2 == index || !index2.isFK() && !index2.isPK() && !index2.isUnique() || !index2.contains(column)) continue;
            return false;
        }
        return true;
    }

    public List getAutomaticallyRemovedcolumns() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (Column column : this.getLocalFKIndex().getElementsCollection()) {
            if (!this.canRemoveColumnAutomaticaly(column)) continue;
            arrayList.add(column);
        }
        return arrayList;
    }

    private boolean isColumnUsedInConstraints(Column column) {
        Table table = (Table)this.getContainerWithKeyObject();
        Index index = this.getLocalFKIndex();
        KeyObject[] keyObjectArray = table.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            Index index2 = (Index)keyObjectArray[i];
            if (index2 == index || !index2.isFK() && !index2.isPK() && !index2.isUnique() || !index2.contains(column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    public boolean isBackupFK() {
        return this.originatingFK != null;
    }

    public FKIndexAssociation getOriginatingFK() {
        return this.originatingFK;
    }

    public TVTable getOriginatingSourceTVTable() {
        return this.originatingSourceTVTable;
    }

    public void setOriginatingSourceTVTable(TVTable tVTable) {
        this.originatingSourceTVTable = tVTable;
    }

    public TVTable getOriginatingTargetTVTable() {
        return this.originatingTargetTVTable;
    }

    public void setOriginatingTargetTVTable(TVTable tVTable) {
        this.originatingTargetTVTable = tVTable;
    }

    public FKMemento getFKMemento(DesignPartView designPartView) {
        FKMemento fKMemento = new FKMemento(this);
        fKMemento.name = this.getName();
        fKMemento.comments = this.getComment();
        fKMemento.notes = this.getNotes();
        fKMemento.id = this.getObjectID();
        fKMemento.index_id = this.getLocalFKIndex().getObjectID();
        fKMemento.mandatory = this.isMandatory();
        fKMemento.generate_in_DDL = this.isMarkedGenerate();
        fKMemento.transferable = this.isTransferable();
        fKMemento.table = (Table)this.getContainerWithKeyObject();
        fKMemento.remoteTable = this.getRemoteTable();
        fKMemento.remoteKey = this.getRemoteIndex();
        if (fKMemento.remoteKey != null) {
            fKMemento.remoteKeyID = this.getRemoteIndex().getObjectID();
        }
        fKMemento.deleteRule = this.getDeleteRule();
        fKMemento.arc = this.getArc();
        fKMemento.dpv = designPartView;
        fKMemento.sourceTV = this.getSourceTV(designPartView);
        fKMemento.targetTV = this.getTargetTV(designPartView);
        for (Column column : this.getLocalFKIndex().getElementsCollection()) {
            Column column2 = column.getReferencedColumn(this);
            if (column == null || column2 == null) continue;
            fKMemento.columns.add(column.getObjectID());
        }
        return fKMemento;
    }

    public void resetFromMemento(FKMemento fKMemento) {
        if (fKMemento.fk != this) {
            throw new RuntimeException("FKMemento object is for another Foreign key");
        }
        this.setName(fKMemento.name);
        this.setComment(fKMemento.comments);
        this.setNotes(fKMemento.notes);
        this.setMarkedGenerate(fKMemento.generate_in_DDL);
        this.getLocalFKIndex().setMarkedGenerate(fKMemento.generate_in_DDL);
        this.setDeleteRule(fKMemento.deleteRule);
        this.setTransferable(fKMemento.transferable);
        Column[] columnArray = FKUtilities.getFKColumnsFromTable(fKMemento, (Table)this.getContainerWithKeyObject());
        this.changeKeyObject(fKMemento.remoteKey, columnArray);
        if (fKMemento.sourceTV != null && fKMemento.targetTV != null) {
            this.setSourceTVTable(fKMemento.sourceTV);
            this.setTargetTVTable(fKMemento.targetTV);
        }
        this.setMandatory(fKMemento.mandatory);
        this.getTable().setDirty(true);
        for (TVFKRelation tVFKRelation : this.getAllTVRelations()) {
            tVFKRelation.displayLabels();
        }
        this.resetEdgeParams();
    }

    public void setNewFK(FKIndexAssociation fKIndexAssociation) {
        this.setName(fKIndexAssociation.name);
        this.setComment(fKIndexAssociation.getComment());
        this.setNotes(fKIndexAssociation.getNotes());
        this.setMarkedGenerate(fKIndexAssociation.isMarkedGenerate());
        this.setDeleteRule(fKIndexAssociation.deleteRule);
        this.setTransferable(fKIndexAssociation.transferable);
        this.setMandatory(fKIndexAssociation.mandatory);
        if (fKIndexAssociation.sourceTVT != null && fKIndexAssociation.targetTVT != null) {
            this.setSourceTVTable(fKIndexAssociation.sourceTVT);
            this.setTargetTVTable(fKIndexAssociation.targetTVT);
        }
        this.getTable().setDirty(true);
        this.resetEdgeParams();
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "foreignkey/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean isSilentRemove() {
        return this.silentRemove;
    }

    public void setSilentRemove(boolean bl) {
        this.silentRemove = bl;
    }

    public boolean isOneToOne() {
        ContainedObject[] containedObjectArray = this.getLocalFKIndex().getElements();
        Iterator iterator = this.getTable().getKeySet().iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            if (!index.isPK() && !index.isUnique() && !"Unique Plain Index".equalsIgnoreCase(index.getIndexState()) || index.getElementsCollection().size() != containedObjectArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < containedObjectArray.length; ++i) {
                if (index.contains(containedObjectArray[i])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToTable() {
        Table table = this.getTable();
        if (table != null && !table.getFKAssociationsList().contains(this)) {
            boolean bl = this.getDesign().isPropagatePKChahges();
            try {
                String string = this.getDirectorySegmentName();
                this.getDesign().setPropagatePKChahges(false);
                table.addRecreateFKAssociation(this);
                this.setDirectorySegmentName(string, true);
            }
            catch (Exception exception) {
                System.out.println("fk - " + this.getName() + "   - table " + this.getTable().getName());
            }
            finally {
                this.getDesign().setPropagatePKChahges(bl);
            }
        }
    }

    public RMExtendedMap getRMExtendedMap() {
        return ((RelationalDesign)this.getDesignPart()).getRMExtendedMap();
    }

    @Override
    public String toString() {
        return this.getVeryLongName();
    }

    public class FKMemento {
        public FKIndexAssociation fk;
        public DesignPartView dpv;
        public String comments = "";
        public String notes = "";
        public String name;
        public String id;
        public String index_id;
        public boolean mandatory;
        public boolean transferable;
        public boolean generate_in_DDL;
        public Table table;
        public Table remoteTable;
        public String remoteKeyID;
        public Index remoteKey;
        public List<String> columns = new ArrayList<String>();
        public String deleteRule = "";
        public FKArc arc;
        public TVTable sourceTV;
        public TVTable targetTV;

        public FKMemento(FKIndexAssociation fKIndexAssociation2) {
            this.fk = fKIndexAssociation2;
        }

        public void copyTo(FKMemento fKMemento) {
            fKMemento.comments = this.comments;
            fKMemento.notes = this.notes;
            fKMemento.name = this.name;
            fKMemento.id = this.id;
            fKMemento.index_id = this.index_id;
            fKMemento.mandatory = this.mandatory;
            fKMemento.transferable = this.transferable;
            fKMemento.generate_in_DDL = this.generate_in_DDL;
            fKMemento.table = this.table;
            fKMemento.remoteTable = this.remoteTable;
            fKMemento.remoteKeyID = this.remoteKeyID;
            fKMemento.remoteKey = this.remoteKey;
            fKMemento.columns.addAll(this.columns);
            fKMemento.deleteRule = this.deleteRule;
            fKMemento.sourceTV = this.sourceTV;
            fKMemento.targetTV = this.targetTV;
            fKMemento.arc = this.arc;
            fKMemento.dpv = this.dpv;
        }
    }

    public class dpvInfo {
        public TVTable sourceTV;
        public TVTable targetTV;
        public TopView tv;
        public DesignPartView dpv;

        dpvInfo() {
        }
    }

    public class FKConnection {
        Table child;
        Table parent;
        public int countAdded = 0;

        public void setChildTable(Table table) {
            this.child = table;
        }

        public Table getChildTable() {
            return this.child;
        }

        public TVTable getSourceTV(DesignPartView designPartView) {
            return FKIndexAssociation.this.getSourceTV(designPartView);
        }

        public TVTable getTargetTV(DesignPartView designPartView) {
            return FKIndexAssociation.this.getTargetTV(designPartView);
        }

        public void setParentTable(Table table) {
            this.parent = table;
        }

        public Table getParentTable() {
            return this.parent;
        }

        public String toString() {
            return FKIndexAssociation.this.getName();
        }

        public TopView getTopView() {
            return FKIndexAssociation.this.getTopView();
        }

        public TopView getViewFor(DesignPartView designPartView) {
            return FKIndexAssociation.this.getViewFor(designPartView);
        }

        public FKIndexAssociation getFKIndexAssociation() {
            return FKIndexAssociation.this;
        }
    }
}

