/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.AbstractDenormalizer;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;

public class DenormalizerSplitTable
extends AbstractDenormalizer {
    public void setOriginalTable(Table table) {
        this.setBaseTable(table);
    }

    public void setSplitTable(Table table) {
        this.setDerivedTable(table);
    }

    public List getPossibleSplits() {
        return this.getBaseTable().getPossibleSplits();
    }

    public Table getOriginalTable() {
        return this.getBaseTable();
    }

    public Table getSplitTable() {
        return this.getDerivedTable();
    }

    public void makeSplitTable(String string) {
        if (this.canSplit()) {
            Table table = this.getTableSet().createTable(null);
            table.setName(string);
            table.setGeneratorID(this.getOriginalTable().getGeneratorID());
            table.setSplittedTableID(this.getOriginalTable().getObjectID());
            table.setSchemaObject(this.getOriginalTable().getSchemaObject());
            this.setSplitTable(table);
            this.copyPK();
        }
    }

    public boolean canSplit() {
        return this.getOriginalTable() != null;
    }

    public void copyPK() {
        Index index = (Index)this.getOriginalTable().getPK();
        if (index != null && !this.getSplitTable().hasFKAssociationFor(index)) {
            DesignPart designPart = this.getSplitTable().getDesignPart();
            FKIndexAssociation fKIndexAssociation = this.getSplitTable().addFK(index);
            Index index2 = fKIndexAssociation.getLocalFKIndex();
            Index index3 = this.getSplitTable().createIndex();
            Iterator iterator = ((ContainerObject)index2).getElementsCollection().iterator();
            while (iterator.hasNext()) {
                index3.getElementsCollection().add(iterator.next());
            }
            index3.makePK();
            index3.setOidKey(index.isOidKey());
            index3.setName(ApplyNamingStandards.createPK_Name(this.getSplitTable().getName(), designPart.getDesign().getDLSettings().getNamingStandardRule(), designPart.getName(), null));
        }
    }

    @Override
    public TableSet getTableSet() {
        return ((RelationalDesign)this.getOriginalTable().getDesignPart()).getTableSet();
    }
}

