/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.AbstractDenormalizer;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;

public class DenormalizerMergeTable
extends AbstractDenormalizer {
    private FKIndexAssociation mergeThisAssociation = null;

    public Collection getTargetableTables() {
        Table table = this.getSource();
        FKIndexAssociationSet fKIndexAssociationSet = ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet();
        return fKIndexAssociationSet.getChildTables(table);
    }

    public void setTarget(Table table) {
        this.setBaseTable(table);
    }

    public void setSource(Table table) {
        this.setDerivedTable(table);
    }

    public Table getTarget() {
        return this.getBaseTable();
    }

    public Table getSource() {
        return this.getDerivedTable();
    }

    public Table[] getAllTablesWithSourceAssociation() {
        Collection collection = this.getTargetableTables();
        return collection.toArray(new Table[collection.size()]);
    }

    public FKIndexAssociation[] getSourceAssociationsIn(Table table) {
        FKIndexAssociation[] fKIndexAssociationArray = table.getFKAssociations();
        ArrayList<FKIndexAssociation> arrayList = new ArrayList<FKIndexAssociation>();
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            FKIndexAssociation fKIndexAssociation = fKIndexAssociationArray[i];
            if (!this.getSource().equals(fKIndexAssociation.getRemoteTable())) continue;
            arrayList.add(fKIndexAssociation);
        }
        return arrayList.toArray(new FKIndexAssociation[arrayList.size()]);
    }

    public void merge() {
        if (this.mergeThisAssociation != null) {
            this.merge(this.mergeThisAssociation);
            this.mergeThisAssociation = null;
        } else if (this.getTarget() != null) {
            this.merge(this.getTarget());
        } else {
            this.mergeAll();
        }
        this.getSource().remove();
    }

    public void merge(Table table) {
        int n;
        FKIndexAssociation[] fKIndexAssociationArray = this.getSourceAssociationsIn(table);
        for (n = 0; n < fKIndexAssociationArray.length; ++n) {
            fKIndexAssociationArray[n].remove();
        }
        fKIndexAssociationArray = this.getSource().getFKAssociations();
        for (n = 0; n < fKIndexAssociationArray.length; ++n) {
            if (table.equals(fKIndexAssociationArray[n].getRemoteTable())) {
                KeyObject keyObject = this.getSource().getPK();
                if (keyObject != null) {
                    keyObject.remove();
                }
                fKIndexAssociationArray[n].remove();
                continue;
            }
            if (!this.getSource().equals(fKIndexAssociationArray[n].getRemoteTable())) continue;
            fKIndexAssociationArray[n].remove();
        }
        this.mergeTables();
    }

    public void mergeAll() {
        Table[] tableArray = this.getAllTablesWithSourceAssociation();
        for (int i = 0; i < tableArray.length; ++i) {
            this.merge(tableArray[i]);
        }
    }

    public void merge(FKIndexAssociation fKIndexAssociation) {
        Table table = this.getTarget();
        Table table2 = (Table)fKIndexAssociation.getContainerWithKeyObject();
        this.setTarget(table2);
        fKIndexAssociation.remove();
        this.changeColumns((Column[])this.getSource().getElements(), this.getTarget(), false);
        this.setTarget(table);
    }

    public void mergeTables() {
        this.changeColumns((Column[])this.getSource().getElements(), this.getTarget(), false);
    }

    public boolean canMerge() {
        return this.getSource() != null && (this.getTarget() == null || this.isTargetable(this.getTarget()));
    }

    public boolean isTargetable(Table table) {
        return true;
    }

    public Table findMainTarget(Table[] tableArray) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        arrayList.addAll(Arrays.asList(tableArray));
        return this.findMainTarget(arrayList);
    }

    protected Table findMainTarget(List list) {
        int n = list.size();
        if (n > 1) {
            Table table = (Table)list.get(0);
            Table table2 = (Table)list.get(1);
            this.setSource(table);
            if (this.isTargetable(table2)) {
                list.remove(table);
            } else {
                this.setSource(table2);
                if (this.isTargetable(table)) {
                    list.remove(table2);
                } else {
                    list.remove(table);
                    list.remove(table2);
                }
            }
            return this.findMainTarget(list);
        }
        if (n == 1) {
            return (Table)list.get(0);
        }
        return null;
    }

    @Override
    public TableSet getTableSet() {
        return ((RelationalDesign)this.getSource().getDesignPart()).getTableSet();
    }
}

