/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.AbstractApplyNamingStandards;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;
import oracle.dbtools.crest.util.string.StringUtilities;

public class ApplyNamingStandards
extends AbstractApplyNamingStandards<Table> {
    private static final String SEQ_NR = "seq nr";
    public boolean applyToPK = true;
    public boolean applyToFK = true;
    public boolean applyToTableCHC = true;
    public boolean applyToUC = true;
    public boolean applyToIndex = true;
    public boolean applyToColumnCHC = true;
    public boolean applyToFKColumn = true;
    private NamingStandardRule nsr;

    public ApplyNamingStandards(NamingStandardRule namingStandardRule) {
        this.nsr = namingStandardRule;
    }

    public ApplyNamingStandards(NamingStandardRule namingStandardRule, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        this(namingStandardRule);
        this.applyToColumnCHC = bl;
        this.applyToFK = bl2;
        this.applyToIndex = bl3;
        this.applyToPK = bl4;
        this.applyToTableCHC = bl5;
        this.applyToUC = bl6;
        this.applyToFKColumn = bl7;
    }

    private Object[] getUniqueKeys(Table table) {
        ArrayList<KeyObject> arrayList = new ArrayList<KeyObject>();
        Iterator iterator = table.getKeySet().iterator();
        while (iterator.hasNext()) {
            KeyObject keyObject = (KeyObject)iterator.next();
            if (!keyObject.isUnique()) continue;
            arrayList.add(keyObject);
        }
        return arrayList.toArray();
    }

    private Object[] getIndexes(Table table) {
        ArrayList<KeyObject> arrayList = new ArrayList<KeyObject>();
        Iterator iterator = table.getKeySet().iterator();
        while (iterator.hasNext()) {
            KeyObject keyObject = (KeyObject)iterator.next();
            if (keyObject.isPK() || keyObject.isUnique() || keyObject.isFK()) continue;
            arrayList.add(keyObject);
        }
        return arrayList.toArray();
    }

    @Override
    public void apply(Table table) {
        Object object;
        int n;
        Object object2;
        if (this.applyToPK && table.hasPK()) {
            this.applyToPK(table);
        }
        if (this.applyToFK) {
            object2 = table.getFKAssociations();
            for (n = 0; n < ((FKIndexAssociation[])object2).length; ++n) {
                object = object2[n];
                this.applyToFK((FKIndexAssociation)object, n, null);
            }
        }
        if (this.applyToTableCHC) {
            object2 = table.getCheckConstraints().iterator();
            n = 0;
            while (object2.hasNext()) {
                object = (TableLevelConstraint)object2.next();
                this.applyToTableCheckConstraint((TableLevelConstraint)object, n, table.getName(), table.getAbbreviation());
                ++n;
            }
        }
        if (this.applyToUC) {
            object2 = this.getUniqueKeys(table);
            for (n = 0; n < ((FKIndexAssociation[])object2).length; ++n) {
                this.applyToUK((Index)object2[n], n, table.getName(), table.getAbbreviation());
            }
        }
        if (this.applyToIndex) {
            object2 = this.getIndexes(table);
            for (n = 0; n < ((FKIndexAssociation[])object2).length; ++n) {
                this.applyToIndex((Index)object2[n], n, null, table.getAbbreviation());
            }
        }
        if (this.applyToColumnCHC) {
            for (Column column : table.getElementsCollection()) {
                this.applyToColumnCheckConstraint(column, null, table.getAbbreviation());
            }
        }
        if (this.applyToFKColumn) {
            object2 = table.getFKAssociations();
            for (n = 0; n < ((Object)object2).length; ++n) {
                object = object2[n];
                this.applyToFKColumn((FKIndexAssociation)object);
            }
        }
    }

    public void applyToIndex(Index index, int n, String string, String string2) {
        String string3 = this.nsr.getIdxConstr();
        if (string3.length() > 0) {
            String string4 = string;
            if (string4 == null && index.getContainerWithKeyObject() != null) {
                string4 = index.getContainerWithKeyObject().getName();
            }
            String string5 = index.getDesignPart().getName();
            string5 = string5.replaceAll("\\$", "\\\\\\$");
            if (string4 != null) {
                string4 = string4.replaceAll("\\$", "\\\\\\$");
                string3 = string3.replaceAll("\\{table\\}", string4);
            }
            string3 = string3.replaceAll("\\{model\\}", string5);
            string3 = string3.replaceAll("\\{table abbr\\}", string2 != null && string2.length() > 0 ? string2 : string4);
            if (index.getElements().length > 0) {
                Object column2 = null;
                String string6 = "";
                String string7 = "";
                List<ContainedObject> list = Arrays.asList(index.getElements());
                for (Column column : list) {
                    String string8 = column.getName();
                    string6 = string6 + "_" + string8;
                    String string9 = column.getAbbreviation();
                    if (string9 != null && string9.length() > 0) {
                        string7 = string7 + "_" + string9;
                        continue;
                    }
                    if (string9 != null && string9.length() != 0) continue;
                    string7 = string7 + "_" + string8;
                }
                string6 = string6.substring(1, string6.length());
                string3 = string3.replaceAll("\\{column\\}", string6.replaceAll("\\$", "\\\\\\$"));
                string7 = string7.substring(1, string7.length());
                string3 = string3.replaceAll("\\{column abbr\\}", string7);
            } else {
                string3 = string3.replaceAll("\\{column\\}", "");
                string3 = string3.replaceAll("\\{column abbr\\}", "");
            }
            string3 = ApplyNamingStandards.processSequenceNumberClause(string3, n);
            string3 = ApplyNamingStandards.process_SUBSTR_Clause(string3);
            index.setName(string3);
            index.getIndexMemento().name = string3;
        }
    }

    private static String processSequenceNumberClause(String string, int n) {
        if (string.indexOf("{seq nr}") == -1) {
            return string;
        }
        return string.replaceAll("\\{seq nr\\}", String.valueOf(n + 1));
    }

    public static String createIndexName(String string, int n, NamingStandardRule namingStandardRule, String string2, String string3) {
        String string4 = namingStandardRule.getIdxConstr();
        if (string4.length() > 0) {
            String string5 = string2;
            string5 = string5.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{model\\}", string5);
            string = string.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{table\\}", string);
            string4 = string4.replaceAll("\\{table abbr\\}", string3 != null && string3.length() > 0 ? string3 : string);
            string4 = string4.replaceAll("\\{column\\}", "");
            string4 = string4.replaceAll("\\{column abbr\\}", "");
            string4 = ApplyNamingStandards.processSequenceNumberClause(string4, n);
            string4 = ApplyNamingStandards.process_SUBSTR_Clause(string4);
            return string4;
        }
        return "default index name_" + (n + 1);
    }

    public static String createPK_Name(String string, NamingStandardRule namingStandardRule, String string2, String string3) {
        String string4 = namingStandardRule.getPkConstr();
        if (string4.length() > 0) {
            String string5 = string2;
            string5 = string5.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{model\\}", string5);
            string = string.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{table\\}", string);
            string4 = string4.replaceAll("\\{table abbr\\}", string3 != null && string3.length() > 0 ? string3 : string);
            string4 = ApplyNamingStandards.process_SUBSTR_Clause(string4);
            return string4;
        }
        return string + "_PK";
    }

    public static String createUK_Name(String string, NamingStandardRule namingStandardRule, String string2, String string3) {
        String string4 = namingStandardRule.getUnConstr();
        if (string4.length() > 0) {
            String string5 = string2;
            string5 = string5.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{model\\}", string5);
            string = string.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{table\\}", string);
            string4 = string4.replaceAll("\\{table abbr\\}", string3 != null && string3.length() > 0 ? string3 : string);
            string4 = ApplyNamingStandards.process_SUBSTR_Clause(string4);
            return string4;
        }
        return string + "_UK";
    }

    public void applyToPK(Table table) {
        String string = this.nsr.getPkConstr();
        if (string.length() > 0 && table.getPK() != null) {
            KeyObject keyObject = table.getPK();
            String string2 = keyObject.getDesignPart().getName();
            string2 = string2.replaceAll("\\$", "\\\\\\$");
            string = string.replaceAll("\\{model\\}", string2);
            String string3 = table.getName();
            string3 = string3.replaceAll("\\$", "\\\\\\$");
            string = string.replaceAll("\\{table\\}", string3);
            String string4 = table.getAbbreviation();
            string = string.replaceAll("\\{table abbr\\}", (string4 = string4.replaceAll("\\$", "\\\\\\$")) != null && string4.length() > 0 ? string4 : string3);
            if (keyObject.getElements().length > 0) {
                Object column2 = null;
                String string5 = "";
                String string6 = "";
                List<ContainedObject> list = Arrays.asList(keyObject.getElements());
                for (Column column : list) {
                    String string7 = column.getName();
                    string5 = string5 + "_" + string7;
                    String string8 = column.getAbbreviation();
                    if (string8 != null && string8.length() > 0) {
                        string6 = string6 + "_" + string8;
                        continue;
                    }
                    if (string8 != null && string8.length() != 0) continue;
                    string6 = string6 + "_" + string7;
                }
                string5 = string5.substring(1, string5.length());
                string = string.replaceAll("\\{column\\}", string5.replaceAll("\\$", "\\\\\\$"));
                string6 = string6.substring(1, string6.length());
                string = string.replaceAll("\\{column abbr\\}", string6);
            } else {
                string = string.replaceAll("\\{column\\}", "");
                string = string.replaceAll("\\{column abbr\\}", "");
            }
            string = ApplyNamingStandards.process_SUBSTR_Clause(string);
            keyObject.setName(string);
        }
    }

    public static String applyToPK(KeyObject keyObject, NamingStandardRule namingStandardRule, String string, String string2) {
        String string3 = namingStandardRule.getPkConstr();
        if (string3.length() > 0 && keyObject != null) {
            String string4 = keyObject.getDesignPart().getName();
            string4 = string4.replaceAll("\\$", "\\\\\\$");
            string3 = string3.replaceAll("\\{model\\}", string4);
            String string5 = string;
            string5 = string5.replaceAll("\\$", "\\\\\\$");
            string3 = string3.replaceAll("\\{table\\}", string5);
            String string6 = string2;
            string3 = string3.replaceAll("\\{table abbr\\}", (string6 = string6.replaceAll("\\$", "\\\\\\$")) != null && string6.length() > 0 ? string6 : string5);
            if (keyObject.getElements().length > 0) {
                Object column2 = null;
                String string7 = "";
                String string8 = "";
                List<ContainedObject> list = Arrays.asList(keyObject.getElements());
                for (Column column : list) {
                    String string9 = column.getName();
                    string7 = string7 + "_" + string9;
                    String string10 = column.getAbbreviation();
                    if (string10 != null && string10.length() > 0) {
                        string8 = string8 + "_" + string10;
                        continue;
                    }
                    string8 = string8 + "_" + string9;
                }
                string7 = string7.substring(1);
                string3 = string3.replaceAll("\\{column\\}", string7.replaceAll("\\$", "\\\\\\$"));
                string8 = string8.substring(1);
                string3 = string3.replaceAll("\\{column abbr\\}", string8);
            } else {
                string3 = string3.replaceAll("\\{column\\}", "");
                string3 = string3.replaceAll("\\{column abbr\\}", "");
            }
            string3 = ApplyNamingStandards.process_SUBSTR_Clause(string3);
            keyObject.setName(string3);
            return string3;
        }
        return string + "_PK";
    }

    public void applyToUK(Index index, int n, String string, String string2) {
        String string3 = this.nsr.getUnConstr();
        if (string3.length() > 0) {
            string3 = ApplyNamingStandards.createUK_Name(index, n, this.nsr, index.getDesignPart().getName(), string == null ? index.getContainerWithKeyObject().getName() : string, string2);
            index.setName(string3);
            index.getIndexMemento().name = string3;
        }
    }

    public static String createUK_Name(KeyObject keyObject, int n, NamingStandardRule namingStandardRule, String string, String string2, String string3) {
        String string4 = namingStandardRule.getUnConstr();
        if (string4.length() > 0) {
            string = string.replaceAll("\\$", "\\\\\\$");
            string2 = string2.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{model\\}", string);
            string4 = string4.replaceAll("\\{table\\}", string2);
            string4 = string4.replaceAll("\\{table abbr\\}", string3 != null && string3.length() > 0 ? string3 : string2);
            if (keyObject != null && keyObject.getElements().length > 0) {
                Object column2 = null;
                String string5 = "";
                String string6 = "";
                List<ContainedObject> list = Arrays.asList(keyObject.getElements());
                for (Column column : list) {
                    String string7 = column.getName();
                    string5 = string5 + "_" + string7;
                    String string8 = column.getAbbreviation();
                    if (string8 != null && string8.length() > 0) {
                        string6 = string6 + "_" + string8;
                        continue;
                    }
                    if (string8 != null && string8.length() != 0) continue;
                    string6 = string6 + "_" + string7;
                }
                string5 = string5.substring(1, string5.length());
                string4 = string4.replaceAll("\\{column\\}", string5.replaceAll("\\$", "\\\\\\$"));
                string6 = string6.substring(1, string6.length());
                string4 = string4.replaceAll("\\{column abbr\\}", string6);
            } else {
                string4 = string4.replaceAll("\\{column\\}", "");
                string4 = string4.replaceAll("\\{column abbr\\}", "");
            }
            string4 = ApplyNamingStandards.processSequenceNumberClause(string4, n);
            string4 = ApplyNamingStandards.process_SUBSTR_Clause(string4);
        }
        return string4;
    }

    public static String createFK_Name(String string, Table table, int n, NamingStandardRule namingStandardRule, String string2, String string3) {
        return ApplyNamingStandards.createFK_Name(string, table, null, n, namingStandardRule, string2, string3);
    }

    public static String createFK_Name(String string, Table table, KeyObject keyObject, int n, NamingStandardRule namingStandardRule, String string2, String string3) {
        String string4 = "";
        String string5 = "";
        if (table != null) {
            string4 = table.getName();
            string5 = table.getAbbreviation();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (keyObject != null) {
            for (ContainedObject containedObject : keyObject.getElements()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('_').append(containedObject.getName());
                    continue;
                }
                stringBuilder.append(containedObject.getName());
            }
        }
        String string6 = stringBuilder.toString();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (keyObject != null) {
            for (Column column : (Column[])keyObject.getElements()) {
                String string7 = column.getAbbreviation();
                if (!StringUtilities.isNotEmpty(string7)) {
                    string7 = column.getName();
                }
                if (stringBuilder2.length() > 0) {
                    stringBuilder2.append('_').append(string7);
                    continue;
                }
                stringBuilder2.append(string7);
            }
        }
        Object object = stringBuilder2.toString();
        String string8 = namingStandardRule.getFkConstr();
        if (string8.length() > 0) {
            String string9 = string2;
            string9 = string9.replaceAll("\\$", "\\\\\\$");
            string8 = string8.replaceAll("\\{model\\}", string9);
            string4 = string4.replaceAll("\\$", "\\\\\\$");
            string = string.replaceAll("\\$", "\\\\\\$");
            string8 = string8.replaceAll("\\{parent\\}", string4);
            string8 = string8.replaceAll("\\{parent abbr\\}", StringUtilities.isNotEmpty(string5) ? string5 : string4);
            string8 = string8.replaceAll("\\{child\\}", string);
            string8 = string8.replaceAll("\\{child abbr\\}", StringUtilities.isNotEmpty(string3) ? string3 : string);
            string8 = string8.replaceAll("\\{ref column\\}", string6);
            string8 = string8.replaceAll("\\{ref column abbr\\}", (String)(StringUtilities.isNotEmpty((String)object) ? object : string6));
            string8 = ApplyNamingStandards.processSequenceNumberClause(string8, n);
            string8 = ApplyNamingStandards.process_SUBSTR_Clause(string8);
            return string8;
        }
        return "FK" + String.valueOf(n + 1) + "_" + string;
    }

    public void applyToFK(FKIndexAssociation fKIndexAssociation, int n, String string) {
        if (this.nsr.getFkConstr().length() > 0) {
            String string2 = fKIndexAssociation.getDesignPart().getName();
            Table table = (Table)fKIndexAssociation.getSourceObject();
            Table table2 = (Table)fKIndexAssociation.getTargetObject();
            String string3 = string;
            if (string3 == null) {
                string3 = table2.getName();
            }
            String string4 = table2.getAbbreviation();
            fKIndexAssociation.setName(ApplyNamingStandards.createFK_Name(string3, table, fKIndexAssociation.getRemoteIndex(), n, this.nsr, string2, string4));
        }
    }

    public void applyToTableCheckConstraint(TableLevelConstraint tableLevelConstraint, int n, String string, String string2) {
        String string3 = this.nsr.getCkConstr();
        if (string3.length() > 0) {
            String string4 = string;
            if (string4 == null && tableLevelConstraint.getTable() != null) {
                string4 = tableLevelConstraint.getTable().getName();
            }
            if (tableLevelConstraint.getTable() != null) {
                String string5 = tableLevelConstraint.getTable().getDesignPart().getName();
                string5 = string5.replaceAll("\\$", "\\\\\\$");
                string3 = string3.replaceAll("\\{model\\}", string5);
            }
            if (string4 != null) {
                string4 = string4.replaceAll("\\$", "\\\\\\$");
                string3 = string3.replaceAll("\\{table\\}", string4);
            }
            string3 = string3.replaceAll("\\{table abbr\\}", string2 != null && string2.length() > 0 ? string2 : string4);
            string3 = ApplyNamingStandards.processSequenceNumberClause(string3, n);
            string3 = ApplyNamingStandards.process_SUBSTR_Clause(string3);
            tableLevelConstraint.setName(string3);
        }
    }

    public static String createTableCheckName(String string, int n, NamingStandardRule namingStandardRule, String string2, String string3) {
        String string4 = namingStandardRule.getCkConstr();
        if (string4.length() > 0) {
            String string5 = string2;
            string5 = string5.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{model\\}", string5);
            string = string.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{table\\}", string);
            string4 = string4.replaceAll("\\{table abbr\\}", string3 != null && string3.length() > 0 ? string3 : string);
            string4 = ApplyNamingStandards.processSequenceNumberClause(string4, n);
            string4 = ApplyNamingStandards.process_SUBSTR_Clause(string4);
            return string4;
        }
        return "CK_" + string;
    }

    public static String createColumnCheckName(String string, String string2, NamingStandardRule namingStandardRule, String string3, String string4, String string5) {
        String string6 = namingStandardRule.getColckConstr();
        if (string6.length() > 0) {
            String string7 = string3;
            string7 = string7.replaceAll("\\$", "\\\\\\$");
            string6 = string6.replaceAll("\\{model\\}", string7);
            string = string.replaceAll("\\$", "\\\\\\$");
            string6 = string6.replaceAll("\\{table\\}", string);
            string6 = string6.replaceAll("\\{table abbr\\}", string4 != null && string4.length() > 0 ? string4 : string);
            string2 = string2.replaceAll("\\$", "\\\\\\$");
            string6 = string6.replaceAll("\\{column\\}", string2);
            string6 = string6.replaceAll("\\{column abbr\\}", string5 != null && string5.length() > 0 ? string5 : string2);
            string6 = ApplyNamingStandards.process_SUBSTR_Clause(string6);
            return string6;
        }
        return "CK_" + string + "_" + string2;
    }

    public void applyToColumnCheckConstraint(Column column, String string, String string2) {
        String string3 = this.nsr.getColckConstr();
        if (string3.length() > 0 && column.hasConstraintsDefined()) {
            String string4 = string;
            if (string4 == null && column.getContainerWithKeyObject() != null) {
                string4 = column.getContainerWithKeyObject().getName();
            }
            String string5 = column.getDesignPart().getName();
            string5 = string5.replaceAll("\\$", "\\\\\\$");
            string3 = string3.replaceAll("\\{model\\}", string5);
            if (string4 != null) {
                string4 = string4.replaceAll("\\$", "\\\\\\$");
                string3 = string3.replaceAll("\\{table\\}", string4);
            }
            if ((string3 = string3.replaceAll("\\{table abbr\\}", string2 != null && string2.length() > 0 ? string2 : string4)).length() > 0) {
                String string6 = column.getName();
                string6 = string6.replaceAll("\\$", "\\\\\\$");
                string3 = string3.replaceAll("\\{column\\}", string6);
                String string7 = column.getAbbreviation();
                string3 = string3.replaceAll("\\{column abbr\\}", string7 != null && string7.length() > 0 ? string7 : string6);
            } else {
                string3 = string3.replaceAll("\\{column\\}", "");
                string3 = string3.replaceAll("\\{column abbr\\}", "");
            }
            string3 = ApplyNamingStandards.process_SUBSTR_Clause(string3);
            column.setConstraintName(string3);
        }
    }

    public static String createFKColumnName(Column column, NamingStandardRule namingStandardRule) {
        String string = namingStandardRule.getFkColumn();
        if (string.length() > 0) {
            Table table = (Table)column.getParent();
            String string2 = table.getName().replaceAll("\\$", "\\\\\\$");
            String string3 = table.getAbbreviation();
            String string4 = column.getName().replaceAll("\\$", "\\\\\\$");
            String string5 = column.getAbbreviation();
            string = string.replaceAll("\\{ref table\\}", string2);
            string = string.replaceAll("\\{ref table abbr\\}", string3 != null && string3.length() > 0 ? string3 : string2);
            string = string.replaceAll("\\{ref column\\}", string4);
            string = string.replaceAll("\\{ref column abbr\\}", string5 != null && string5.length() > 0 ? string5 : string4);
            string = ApplyNamingStandards.process_SUBSTR_Clause(string);
        }
        return string;
    }

    public void applyToFKColumn(FKIndexAssociation fKIndexAssociation) {
        Column[] columnArray = fKIndexAssociation.getColumns();
        ContainedObject[] containedObjectArray = fKIndexAssociation.getRemoteIndex().getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            columnArray[i].setName(ApplyNamingStandards.createFKColumnName((Column)containedObjectArray[i], this.nsr));
        }
    }

    public static String createTableSpaceDB2_Name(String string, String string2, String string3) {
        String string4 = string2;
        if (string4.length() > 0) {
            String string5 = string3;
            string5 = string5.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{model\\}", string5);
            string = string.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{table\\}", string);
            string4 = ApplyNamingStandards.process_SUBSTR_Clause(string4);
            return string4;
        }
        return "TS_" + string;
    }

    public static String createIndexStorageTemplateDB2_Name(String string, String string2, String string3) {
        String string4 = string2;
        if (string4.length() > 0) {
            String string5 = string3;
            string5 = string5.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{model\\}", string5);
            string = string.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{index\\}", string);
            string4 = ApplyNamingStandards.process_SUBSTR_Clause(string4);
            return string4;
        }
        return "ST_IX_" + string;
    }

    public static String createTableSpaceStorageTemplateDB2_Name(String string, String string2, String string3) {
        String string4 = string2;
        if (string4.length() > 0) {
            String string5 = string3;
            string5 = string5.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{model\\}", string5);
            string = string.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{tablespace\\}", string);
            string4 = ApplyNamingStandards.process_SUBSTR_Clause(string4);
            return string4;
        }
        return "ST_TS_" + string;
    }

    public static String createView_Name(String string, String string2, String string3, String string4) {
        String string5 = string2;
        if (string5.length() > 0) {
            String string6 = string3;
            string6 = string6.replaceAll("\\$", "\\\\\\$");
            string5 = string5.replaceAll("\\{model\\}", string6);
            string = string.replaceAll("\\$", "\\\\\\$");
            string5 = string5.replaceAll("\\{table\\}", string);
            string5 = string5.replaceAll("\\{table abbr\\}", string4 != null && string4.length() > 0 ? string4 : string);
            string5 = ApplyNamingStandards.process_SUBSTR_Clause(string5);
            return string5;
        }
        return "V_" + string;
    }

    public static String createTableName(String string, String string2, String string3) {
        String string4 = string2;
        if (string4.length() > 0) {
            String string5 = string3;
            string5 = string5.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{model\\}", string5);
            string = string.replaceAll("\\$", "\\\\\\$");
            string4 = string4.replaceAll("\\{view\\}", string);
            string4 = ApplyNamingStandards.process_SUBSTR_Clause(string4);
            return string4;
        }
        return "T_" + string;
    }

    public NamingStandardRule getNamingStandardRule() {
        return this.nsr;
    }
}

