/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.Collection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;

public abstract class AbstractDenormalizer {
    private Table baseTable;
    private Table derivedTable;

    public abstract TableSet getTableSet();

    public void changeColumns(Collection collection, Table table, boolean bl) {
        this.changeColumns(collection.toArray(new Column[0]), table, bl);
    }

    public Column[] changeColumns(Column[] columnArray, Table table, boolean bl) {
        Column[] columnArray2 = new Column[columnArray.length];
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            Column column2 = null;
            if (column.isFKElement()) {
                ContainedObject[] containedObjectArray;
                Column column3 = column;
                FKIndexAssociation fKIndexAssociation = column3.getFKIndexAssociation();
                FKIndexAssociation fKIndexAssociation2 = null;
                FKIndexAssociation[] fKIndexAssociationArray = table.getFKAssociations();
                for (int j = 0; j < fKIndexAssociationArray.length; ++j) {
                    containedObjectArray = fKIndexAssociationArray[j];
                    if (!fKIndexAssociation.getObjectID().equalsIgnoreCase(containedObjectArray.getGeneratorID())) continue;
                    fKIndexAssociation2 = containedObjectArray;
                    break;
                }
                if (fKIndexAssociation2 == null) {
                    fKIndexAssociation2 = table.addFK(fKIndexAssociation.getKeyObject(), fKIndexAssociation);
                    Index index = fKIndexAssociation2.getLocalFKIndex();
                    index.setGeneratorID(fKIndexAssociation.getGeneratorID());
                    containedObjectArray = index.getElements();
                    if (containedObjectArray.length == 1) {
                        column2 = (Column)containedObjectArray[0];
                    }
                }
                System.out.println("AbstractDenormalizer.changeColumns: should FKAssociation be recreated ?");
            } else {
                column2 = table.createColumn();
            }
            if (column2 != null) {
                column.copy(column2);
                column2.setGeneratorID(column.getGeneratorID());
            }
            columnArray2[i] = column2;
            if (!bl) continue;
            column.remove();
        }
        return columnArray2;
    }

    public FKIndexAssociation[] changeForeignKeys(Collection collection, Table table, boolean bl) {
        return this.changeForeignKeys(collection.toArray(new FKIndexAssociation[0]), table, bl);
    }

    public FKIndexAssociation[] changeForeignKeys(FKIndexAssociation[] fKIndexAssociationArray, Table table, boolean bl) {
        FKIndexAssociation[] fKIndexAssociationArray2 = new FKIndexAssociation[fKIndexAssociationArray.length];
        return fKIndexAssociationArray2;
    }

    public void setBaseTable(Table table) {
        this.baseTable = table;
    }

    public void setDerivedTable(Table table) {
        this.derivedTable = table;
    }

    public Table getBaseTable() {
        return this.baseTable;
    }

    public Table getDerivedTable() {
        return this.derivedTable;
    }

    protected Design getDesign() {
        Table table = this.getBaseTable();
        if (table == null) {
            table = this.getDerivedTable();
        }
        return table.getDesign();
    }
}

