/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ExternalDataSet;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStoreSet;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.ProcessSet;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationFlow;
import oracle.dbtools.crest.model.design.process.TransformationFlowSet;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.process.TranformationTaskPropertiesDialog;
import oracle.dbtools.crest.swingui.process.DPVTransformation;

public class TransformationTask
extends DesignPart {
    public static final String OBJECT_TYPE_NAME = "TransformationTask";
    public static final String FLOW_SET_NAME = "Flows";
    public static final String NOTE_SET_NAME = "Notes";
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    private ProcessModel processModel;
    protected DesignPartView mainView;
    private TransformationSet processSet;
    private TransformationFlowSet flowSet;
    DesignObjectCollection agents;
    DesignObjectCollection extProcesses;
    DesignObjectCollection stores;
    private NoteSet noteSet;
    private boolean topLevel = true;
    private Process process;
    private TransformationPackage transformationPackage;
    private InOutParams inputParams;
    private InOutParams outputParams;
    private IDGenerator localIDGenerator;
    private Map localIDs = new TreeMap();
    private List inputParameters = new ArrayList();
    private List outputParameters = new ArrayList();
    private List sources = new ArrayList();
    private List targets = new ArrayList();
    private boolean pmDirty = false;

    public TransformationTask(ProcessModel processModel, TransformationPackage transformationPackage) {
        this.setDesign(processModel.getDesign());
        this.processModel = processModel;
        this.transformationPackage = transformationPackage;
        this.processModel.setDirty(true);
        transformationPackage.setDirty(true);
        this.setParent(transformationPackage);
        this.inputParams = new InOutParams(this, "Input");
        this.outputParams = new InOutParams(this, "Output");
        this.inputParams.setDesign(processModel.getDesign());
        this.outputParams.setDesign(processModel.getDesign());
        if (this.inputParams.getObjectID() != null) {
            this.assignLocalID(this.inputParams);
        }
        if (this.outputParams.getObjectID() != null) {
            this.assignLocalID(this.outputParams);
        }
    }

    public ProcessModel getProcessModel() {
        return this.processModel;
    }

    public void setProcessModel(ProcessModel processModel) {
        this.processModel = processModel;
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList arrayList = new ArrayList();
        this.getTransformationSet().addAllElementsTo(arrayList);
        this.getFlowSet().addAllElementsTo(arrayList);
        this.getNoteSet().addAllElementsTo(arrayList);
        this.getDiagramViewSet().addAllElementsTo(arrayList);
        return arrayList;
    }

    public TransformationFlowSet getFlowSet() {
        if (this.flowSet == null) {
            this.flowSet = new TransformationFlowSet(this);
            this.flowSet.setDesign(this.getDesign());
            this.flowSet.setName(Messages.getString("TransformationTask.Flows"));
            this.flowSet.setParent(this);
            this.flowSet.addSetListener(this);
        }
        return this.flowSet;
    }

    public InfoStoreSet getInfoStoreSet() {
        return this.getDesign().getProcessModel().getInfoStoreSet();
    }

    public TransformationSet getTransformationSet() {
        if (this.processSet == null) {
            this.processSet = new TransformationSet(this);
            this.processSet.setDesign(this.getDesign());
            this.processSet.setName(Messages.getString("TransformationTask.Transformations"));
            this.processSet.setParent(this);
            this.processSet.addSetListener(this);
        }
        return this.processSet;
    }

    @Override
    public NoteSet getNoteSet() {
        if (this.noteSet == null) {
            this.noteSet = new NoteSet(this);
            this.noteSet.setDesign(this.getDesign());
            this.noteSet.setName(Messages.getString("TransformationTask.Notes"));
            this.noteSet.setParent(this);
            this.noteSet.addSetListener(this);
        }
        return this.noteSet;
    }

    public ExternalDataSet getExternalDataSet() {
        return this.getProcessModel().getExternalDataSet();
    }

    public Transformation createTransformation() {
        Transformation transformation = this.createTransformation(null);
        return transformation;
    }

    public Transformation createTransformation(String string) {
        Transformation transformation = this.getTransformationSet().createTransformation(string);
        return transformation;
    }

    public TransformationFlow createFlow() {
        return this.getFlowSet().createFlow(null);
    }

    public Flow createFlow(String string) {
        return this.getFlowSet().createFlow(string);
    }

    public InfoStore createInfoStore() {
        return this.getInfoStoreSet().createInfoStore(null);
    }

    public ExternalData createExternalData() {
        return this.getExternalDataSet().createExternalData(null);
    }

    @Override
    public Note createNote() {
        Note note = this.getNoteSet().createNote(null);
        return note;
    }

    @Override
    public Note recreateNote(String string) {
        return this.getNoteSet().createNote(string);
    }

    @Override
    public void setDirty(boolean bl) {
        super.setDirty(bl);
        if (bl) {
            this.processModel.setDirty(bl);
        }
    }

    @Override
    public void clearAll() {
        this.getTransformationSet().removeAll();
        this.getNoteSet().removeAll();
        this.getStores().removeAll();
        this.getDiagramViewSet().removeAll();
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
    }

    @Override
    public int getNumberOfChildren() {
        return 3;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.getTransformationSet();
            }
            case 1: {
                return this.getStores();
            }
            case 2: {
                return this.getFlowSet();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.getTransformationSet()) {
            return 0;
        }
        if (modelObject == this.getStores()) {
            return 1;
        }
        if (modelObject == this.getFlowSet()) {
            return 2;
        }
        return -1;
    }

    @Override
    protected DesignPartView createDesignPartSubView(String string) {
        return null;
    }

    @Override
    public DesignPartView getMainView() {
        if (this.mainView == null) {
            this.mainView = new DPVTransformation(this.getDesign().getAppView(), this);
            this.mainView.addViewFor(this.inputParams);
            this.mainView.addViewFor(this.outputParams);
            this.mainView.setDPVId(this.getDesign().getAppView().getIDGenerator().createNewID());
            TopView topView = this.outputParams.getTopView();
            if (topView != null) {
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(600, 400, 150, 80));
                } else {
                    topView.setLocation(600, 400);
                }
            }
            if ((topView = this.inputParams.getTopView()) != null && topView.getCellView() != null) {
                Rectangle rectangle = topView.getCellView().getBounds().getBounds();
                topView.getCellView().setNewBounds(new Rectangle(rectangle.x, rectangle.y, 150, 80));
            }
        }
        return this.mainView;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "TRTASK";
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (setEvent == SetEvent.OBJECT_ADDED) {
            this.fireAdded(setEvent.getAffected());
        } else if (setEvent == SetEvent.OBJECT_REMOVED) {
            if (this.process != null) {
                this.agents.removePlaceHolderFor(setEvent.getAffected());
                this.stores.removePlaceHolderFor(setEvent.getAffected());
            }
            this.fireRemoved(setEvent.getAffected());
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> arrayList = new ArrayList<DesignObjectSet>();
        arrayList.add(this.getTransformationSet());
        arrayList.add(this.getFlowSet());
        arrayList.add(this.getNoteSet());
        return arrayList;
    }

    @Override
    public void doBeforeLoad() {
        this.pmDirty = this.getProcessModel().isDirty();
    }

    @Override
    public void doAfterLoad() {
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.getProcessModel().setDirty(this.pmDirty);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void load() {
        boolean bl = this.getProcessModel().isDirty();
        XMLPersistenceManager xMLPersistenceManager = this.getDesign().getAppView().getPersistenceManager();
        AbstractXMLReader abstractXMLReader = xMLPersistenceManager.getDesignPartReader(this);
        if (abstractXMLReader != null) {
            if (this.getDesign().getLoadedVersion() < 3.2f) {
                abstractXMLReader.recreateDesign(this.getObjectID(), (DesignPart)this, false);
            } else {
                abstractXMLReader.recreateDesign(this.getPathIDString(), (DesignPart)this, false);
            }
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.getProcessModel().setDirty(bl);
        this.checkAndSetIDGenerator();
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
        this.setParent(process);
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    public void setTopLevel(boolean bl) {
        this.topLevel = bl;
    }

    public Collection getFlowsForProcessObject(AbstractProcessObject abstractProcessObject) {
        ArrayList<Flow> arrayList = new ArrayList<Flow>();
        Iterator iterator = this.getFlowSet().iterator();
        while (iterator.hasNext()) {
            Flow flow = (Flow)iterator.next();
            if (abstractProcessObject != flow.getSourceProcessObject() && abstractProcessObject != flow.getTargetProcessObject()) continue;
            arrayList.add(flow);
        }
        return arrayList;
    }

    public void registerLocalObject(TopView topView) {
        DesignObject designObject = topView.getModel();
        if (designObject != null) {
            if (designObject instanceof ExternalAgent && !this.getAgents().containsPlaceHolderFor(designObject)) {
                this.getAgents().add(new DesignObjectPlaceHolder((DesignPart)this, designObject));
            } else if (designObject instanceof InfoStore && !this.getStores().containsPlaceHolderFor(designObject)) {
                this.getStores().add(new DesignObjectPlaceHolder((DesignPart)this, designObject));
            }
        }
    }

    public void unRegisterLocalObject(TopView topView) {
        DesignObject designObject = topView.getModel();
        if (designObject != null) {
            if (designObject instanceof ExternalAgent) {
                this.getAgents().removePlaceHolderFor(designObject);
            } else if (designObject instanceof InfoStore) {
                this.getStores().removePlaceHolderFor(designObject);
            }
        }
    }

    public DesignObjectCollection getStores() {
        if (this.stores == null) {
            this.stores = new DesignObjectCollection();
            this.stores.setDesign(this.getDesign());
            this.stores.setName(Messages.getString("TransformationTask.UsedInformationStores"));
            this.stores.setParent(this);
            this.stores.setElementDescriptor(InfoStore.class);
        }
        return this.stores;
    }

    public DesignObjectCollection getAgents() {
        if (this.agents == null) {
            this.agents = new DesignObjectCollection();
            this.agents.setDesign(this.getDesign());
            this.agents.setName(Messages.getString("TransformationTask.ProcessExternalAgents"));
            this.agents.setElementDescriptor(ExternalAgent.class);
            this.agents.setParent(this);
        }
        return this.agents;
    }

    public TransformationTask getParentDataFlowdesign() {
        if (this.process != null) {
            return (TransformationTask)this.process.getDesignPart();
        }
        return null;
    }

    public Flow getFirstFlowBetween(AbstractProcessObject abstractProcessObject, AbstractProcessObject abstractProcessObject2) {
        Iterator iterator = this.getFlowSet().iterator();
        while (iterator.hasNext()) {
            Flow flow = (Flow)iterator.next();
            if (flow.getSourceProcessObject() != abstractProcessObject || flow.getTargetProcessObject() != abstractProcessObject2) continue;
            return flow;
        }
        return null;
    }

    public List getFlowsBetween(AbstractProcessObject abstractProcessObject, AbstractProcessObject abstractProcessObject2) {
        ArrayList<Flow> arrayList = new ArrayList<Flow>();
        Iterator iterator = this.getFlowSet().iterator();
        while (iterator.hasNext()) {
            Flow flow = (Flow)iterator.next();
            if (flow.getSourceProcessObject() != abstractProcessObject || flow.getTargetProcessObject() != abstractProcessObject2) continue;
            arrayList.add(flow);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public TransformationPackage getTransformationPackage() {
        return this.transformationPackage;
    }

    public void addInputParam(ParameterObject parameterObject) {
        this.assignLocalID(parameterObject);
        this.inputParameters.add(parameterObject);
    }

    public void addOutputParam(ParameterObject parameterObject) {
        this.assignLocalID(parameterObject);
        this.outputParameters.add(parameterObject);
    }

    public void addInputParam(String string, String string2, String string3) {
        ParameterObject parameterObject = new ParameterObject(this);
        parameterObject.setLogicalDatatype(this.getDesign().getLogicalDatatypeSet().getLogTypeByName(string3));
        parameterObject.setName(string2);
        parameterObject.setObjectID(string);
        this.inputParameters.add(parameterObject);
    }

    public void addOutputParam(String string, String string2, String string3) {
        ParameterObject parameterObject = new ParameterObject(this);
        parameterObject.setLogicalDatatype(this.getDesign().getLogicalDatatypeSet().getLogTypeByName(string3));
        parameterObject.setName(string2);
        parameterObject.setObjectID(string);
        this.outputParameters.add(parameterObject);
    }

    protected void assignLocalID(ModelIDObject modelIDObject) {
        String string = modelIDObject.getObjectID();
        if (string == null) {
            while (this.localIDs.containsKey(string = this.getLocalIDGenerator().createNewID())) {
            }
            this.localIDs.put(string, modelIDObject);
            modelIDObject.setObjectID(string);
        } else {
            this.localIDs.put(string, modelIDObject);
        }
    }

    protected void assignOldLocalID(ModelIDObject modelIDObject) {
        String string = null;
        if (string == null) {
            while (this.localIDs.containsKey(string = this.getLocalIDGenerator().createNewID(this.getObjectID(), "#", modelIDObject.getIDPrefix()))) {
            }
            this.localIDs.put(string, modelIDObject);
            modelIDObject.setObjectID(string);
        } else {
            this.localIDs.put(string, modelIDObject);
        }
    }

    public IDGenerator getLocalIDGenerator() {
        if (this.localIDGenerator == null) {
            this.localIDGenerator = new IDGenerator();
            this.localIDGenerator.initializeWith(10000L, 3000000L);
        }
        return this.localIDGenerator;
    }

    public List getInputParameters() {
        return this.inputParameters;
    }

    public List getOutputParameters() {
        return this.outputParameters;
    }

    @Override
    public void setObjectID(String string) {
        super.setObjectID(string);
        this.assignLocalID(this.inputParams);
        this.assignLocalID(this.outputParams);
    }

    public InOutParams getInputParamsObject() {
        return this.inputParams;
    }

    public InOutParams getOutputParamsObject() {
        return this.outputParams;
    }

    public InOutParams getInOutParamsObjectById(String string) {
        if (this.getInputParamsObject().getObjectID().equalsIgnoreCase(string)) {
            return this.getInputParamsObject();
        }
        if (this.getOutputParamsObject().getObjectID().equalsIgnoreCase(string)) {
            return this.getOutputParamsObject();
        }
        return null;
    }

    public ParameterObject getParameterObjectById(String string) {
        for (ParameterObject parameterObject : this.inputParameters) {
            if (!parameterObject.getObjectID().equalsIgnoreCase(string)) continue;
            return parameterObject;
        }
        for (ParameterObject parameterObject : this.outputParameters) {
            if (!parameterObject.getObjectID().equalsIgnoreCase(string)) continue;
            return parameterObject;
        }
        return null;
    }

    public List getSources() {
        return this.sources;
    }

    public void addSource(InfoStore infoStore) {
        this.sources.add(infoStore);
    }

    public void removeSource(InfoStore infoStore) {
        this.sources.remove(infoStore);
    }

    public void removeAllSources() {
        this.sources.clear();
    }

    public List getTargets() {
        return this.targets;
    }

    public void addTarget(InfoStore infoStore) {
        this.targets.add(infoStore);
    }

    public void removeTarget(InfoStore infoStore) {
        this.targets.remove(infoStore);
    }

    public void removeAllTargets() {
        this.targets.clear();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TranformationTaskPropertiesDialog tranformationTaskPropertiesDialog = new TranformationTaskPropertiesDialog(this.getDesign().getAppView(), this);
            tranformationTaskPropertiesDialog.initProperties(this);
            tranformationTaskPropertiesDialog.showDialog();
        }
    }

    public void updateFontsAndColors(boolean bl) {
        Object object;
        Iterator iterator = this.getTransformationSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getNoteSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        this.getInputParamsObject().resetFontsAndColors(bl);
        this.getOutputParamsObject().resetFontsAndColors(bl);
        iterator = this.getFlowSet().iterator();
        while (iterator.hasNext()) {
            object = (DesignObject)iterator.next();
            if (bl) {
                ((DesignObject)object).setBackgroundColor(null);
            } else if (((DesignObject)object).getBackgroundColor() == null) {
                ((DesignObject)object).setBackgroundColor(((DesignObject)object).getTopView().getDefaultLineColor());
            }
            ((DesignObject)object).setUseDefaultColor(bl);
        }
        iterator = this.getLabelSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
    }

    @Override
    public void setMainViewVisible(boolean bl) {
        super.setMainViewVisible(bl);
        if (!ApplicationView.loading) {
            this.transformationPackage.setDirty(true);
        }
    }

    @Override
    public void setMainViewVisible(boolean bl, ProgressDialog progressDialog) {
        super.setMainViewVisible(bl, progressDialog);
        if (!ApplicationView.loading) {
            this.transformationPackage.setDirty(true);
        }
    }

    public void assignOldLocalIDs() {
        this.assignOldLocalID(this.inputParams);
        this.assignOldLocalID(this.outputParams);
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Transformation");
        arrayList.add(TransformationFlow.TYPE_NAME);
        arrayList.add("Note");
        arrayList.add("MainView");
        arrayList.add("SubView");
        return arrayList;
    }

    @Override
    public int getPathID() {
        if (this.pathID == 0) {
            this.pathID = this.transformationPackage.getTransformationTaskSet().nextIndex();
        }
        return this.pathID;
    }

    @Override
    public String getStoragePath() {
        String string = this.getTransformationPackage().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "tt/" + this.getObjectID()).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String string = this.getTransformationPackage().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "tt/" + this.getObjectID() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public StorableObject createObject(String string, String string2, String string3) {
        DesignObject designObject = null;
        if ("Transformation".equalsIgnoreCase(string)) {
            designObject = this.getTransformationSet().createTransformation(string2);
        } else if (TransformationFlow.TYPE_NAME.equalsIgnoreCase(string)) {
            designObject = this.getFlowSet().createFlow(string2);
        } else if ("Note".equalsIgnoreCase(string)) {
            designObject = this.getNoteSet().createNote(string2);
        }
        if (designObject != null && string3 != null && string3.length() > 0) {
            designObject.setName(string3);
        }
        return designObject;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("process", "Transformation");
            this.f2tMap.put("flow", TransformationFlow.TYPE_NAME);
            this.f2tMap.put("note", "Note");
        }
        return this.f2tMap;
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        DesignObject designObject = null;
        designObject = this.getDesign().getDesignObject(string2);
        if (designObject != null) {
            return designObject;
        }
        if ("processModel".equalsIgnoreCase(string)) {
            ProcessModel processModel = this.getDesign().getProcessModel();
            if (processModel.getObjectID().equals(string2)) {
                return processModel;
            }
        } else if ("sourceProcessObject".equalsIgnoreCase(string) || "targetProcessObject".equalsIgnoreCase(string)) {
            designObject = this.getInOutParamsObjectById(string2);
        }
        if (designObject != null) {
            return designObject;
        }
        return super.translateIdToObject(string, string2);
    }

    public String getInputParObjectID() {
        return this.getInputParamsObject().getObjectID();
    }

    public void setInputParObjectID(String string) {
        this.getInputParamsObject().setObjectID(string);
    }

    public String getOutputParObjectID() {
        return this.getOutputParamsObject().getObjectID();
    }

    public void setOutputParObjectID(String string) {
        this.getOutputParamsObject().setObjectID(string);
    }

    public static void initObjectDetails(Design design, File file, String string, StorableObjectStatusHelper storableObjectStatusHelper, String string2, String string3) {
        Object object;
        storableObjectStatusHelper.designPartClass = TransformationTask.class;
        storableObjectStatusHelper.designPart = TransformationTask.findTransformationTask(design, string2);
        SVNObjectHelper sVNObjectHelper = SVNObjectHelper.getSVNObjectHelperFor(design, string2);
        if (sVNObjectHelper != null) {
            object = SVNObjectHelper.getSVNObjectHelperFor(design, sVNObjectHelper.parentID);
            while (object != null) {
                try {
                    Class<ModelIDObject> clazz = Class.forName(((SVNObjectHelper)object).className);
                    if (clazz.isAssignableFrom(TransformationPackage.class)) {
                        storableObjectStatusHelper.treePath.add(0, new TreePathHelper(((SVNObjectHelper)object).propName, new File(((SVNObjectHelper)object).fileName), clazz));
                        storableObjectStatusHelper.treePath.add(0, new TreePathHelper(ProcessModel.getTransformationPackageSetName(), new File(((SVNObjectHelper)object).fileName).getParentFile(), clazz));
                    } else if (clazz.isAssignableFrom(TransformationTask.class)) {
                        storableObjectStatusHelper.treePath.add(0, new TreePathHelper(((SVNObjectHelper)object).propName, new File(((SVNObjectHelper)object).fileName), clazz));
                    } else if (clazz.isAssignableFrom(ProcessModel.class)) {
                        storableObjectStatusHelper.treePath.add(0, new TreePathHelper("Process Model", new File(design.getProcessModel().getStorageName()), clazz));
                    }
                    object = SVNObjectHelper.getSVNObjectHelperFor(design, ((SVNObjectHelper)object).parentID);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        if ("tt".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = TransformationTask.class;
            storableObjectStatusHelper.objectType = OBJECT_TYPE_NAME;
            storableObjectStatusHelper.objectSet = null;
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((TransformationTask)storableObjectStatusHelper.designPart).getTransformationPackage().getTransformationTaskSet();
                storableObjectStatusHelper.storableObject = ((TransformationTask)storableObjectStatusHelper.designPart).getTransformationPackage().getTransformationTaskSet().getObjectByID(string2);
            }
        } else if ("process".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Transformation.class;
            storableObjectStatusHelper.objectType = "Transformation";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(Messages.getString("TransformationTask.Transformations"), file.getParentFile(), ProcessSet.class));
            storableObjectStatusHelper.designPart = TransformationTask.findTransformationTask(design, string3);
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((TransformationTask)storableObjectStatusHelper.designPart).getTransformationSet();
                storableObjectStatusHelper.storableObject = ((TransformationTask)storableObjectStatusHelper.designPart).getTransformationSet().getObjectByID(string2);
            }
        } else if ("flow".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = TransformationFlow.class;
            storableObjectStatusHelper.objectType = TransformationFlow.TYPE_NAME;
            storableObjectStatusHelper.treePath.add(new TreePathHelper(FLOW_SET_NAME, file.getParentFile(), TransformationFlowSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((TransformationTask)storableObjectStatusHelper.designPart).getFlowSet();
                storableObjectStatusHelper.storableObject = ((TransformationTask)storableObjectStatusHelper.designPart).getFlowSet().getObjectByID(string2);
            }
        } else if ("note".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Note.class;
            storableObjectStatusHelper.objectType = "Note";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(NOTE_SET_NAME, file.getParentFile(), NoteSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((TransformationTask)storableObjectStatusHelper.designPart).getNoteSet();
                storableObjectStatusHelper.storableObject = ((TransformationTask)storableObjectStatusHelper.designPart).getNoteSet().getObjectByID(string2);
            }
        } else if ("subviews".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = DPVTransformation.class;
            storableObjectStatusHelper.treePath.add(new TreePathHelper(DIAGRAM_SET_NAME, file.getParentFile(), DPVTransformation.class));
            if (storableObjectStatusHelper.designPart != null && storableObjectStatusHelper.designPart instanceof TransformationTask) {
                object = (TransformationTask)storableObjectStatusHelper.designPart;
                storableObjectStatusHelper.storableObject = ((TransformationTask)object).getMainView().getDPVId().equals(string2) ? ((TransformationTask)object).getMainView() : ((DesignPart)object).getSubViewByID(string2);
            }
        }
    }

    private static TransformationTask findTransformationTask(Design design, String string) {
        for (Object e : design.getProcessModel().getAllTransformationTasks()) {
            TransformationTask transformationTask = (TransformationTask)e;
            if (!string.equalsIgnoreCase(transformationTask.getObjectID())) continue;
            return transformationTask;
        }
        return null;
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        if (this.getMainView() != null) {
            this.getMainView().getWorkSpace().updateSettings();
        }
        this.sortCollections();
    }

    @Override
    public List<Object> getObjectsWithMeasurements() {
        DesignObject designObject;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.getTransformationSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Transformation)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getFlowSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Flow)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getNoteSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Note)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        return arrayList;
    }
}

