/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.process.TransformationTaskSet;
import oracle.dbtools.crest.swingui.editor.process.TransformationPackageDialog;

public class TransformationPackage
extends AbstractProcessObject {
    private String systemObjective = "";
    private TransformationTaskSet trTaskSet;
    private TransformationTask lastTaskAdded;
    private TransformationTask lastTaskRemoved;
    private boolean transformationTaskListChanged = false;
    protected Map f2tMap = null;
    public static final String TYPE_NAME = "TransformationPackage";

    public TransformationPackage(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "TRPACK";
    }

    public String getSystemObjective() {
        return this.systemObjective;
    }

    public void setSystemObjective(String string) {
        this.systemObjective = string;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TransformationPackageDialog transformationPackageDialog = new TransformationPackageDialog(this.getDesign().getAppView(), this);
            transformationPackageDialog.initProperties(this);
            transformationPackageDialog.show();
        }
    }

    public static final String getTransformationTaskSetName() {
        return Messages.getString("TransformationPackage.TransformationTasks");
    }

    public TransformationTaskSet getTransformationTaskSet() {
        if (this.trTaskSet == null) {
            this.trTaskSet = new TransformationTaskSet((ProcessModel)this.getDesignPart());
            this.trTaskSet.setDesign(this.getDesign());
            this.trTaskSet.setName(Messages.getString("TransformationPackage.TransformationTasks"));
            this.trTaskSet.setTransformationPackage(this);
            this.trTaskSet.addSetListener((ProcessModel)this.getDesignPart());
        }
        return this.trTaskSet;
    }

    public TransformationTask createTransformationTask() {
        this.lastTaskAdded = this.createTransformationTask(null);
        return this.lastTaskAdded;
    }

    public TransformationTask createTransformationTask(String string) {
        this.lastTaskAdded = (TransformationTask)this.getTransformationTaskSet().createElement(string);
        this.lastTaskAdded.setParent(this);
        ((ProcessModel)this.getDesignPart()).setTransformationTask(this.lastTaskAdded);
        this.fireChange(ObjectChangeEvent.TRANSFORMATIONTASK_ADDED);
        this.getDesign().setModelListChanged(true);
        this.setTransformationTaskListChanged(true);
        return this.lastTaskAdded;
    }

    public void removeTransformationTask(TransformationTask transformationTask) {
        this.lastTaskRemoved = transformationTask;
        this.getTransformationTaskSet().remove(transformationTask);
        transformationTask.clearDesignPart();
        transformationTask.fireDeleted();
        this.fireChange(ObjectChangeEvent.TRANSFORMATIONTASK_REMOVED);
        this.getDesign().setModelListChanged(true);
        this.setTransformationTaskListChanged(true);
    }

    public ModelObject getElement(int n) {
        return this.getTransformationTaskSet().getElement(n);
    }

    public int getIndexOf(ModelObject modelObject) {
        return this.getTransformationTaskSet().getIndexForChild(modelObject);
    }

    @Override
    public int getNumberOfChildren() {
        return this.getTransformationTaskSet().size();
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        return this.getIndexOf(modelObject);
    }

    @Override
    public ModelObject getChild(int n) {
        return this.getElement(n);
    }

    @Override
    public boolean isLeaf() {
        return this.getTransformationTaskSet().size() <= 0;
    }

    public TransformationTask getLastTaskAdded() {
        return this.lastTaskAdded;
    }

    public TransformationTask getLastTaskRemoved() {
        return this.lastTaskRemoved;
    }

    @Override
    public boolean hasGUIView() {
        return false;
    }

    public void clearTasks() {
        Iterator iterator = this.getTransformationTaskSet().iterator();
        while (iterator.hasNext()) {
            TransformationTask transformationTask = (TransformationTask)iterator.next();
            transformationTask.clearDesignPart();
        }
        this.getTransformationTaskSet().removeAll();
    }

    @Override
    public String getStoragePath() {
        try {
            return new File(this.getDesign().getStoragePath(), "pm/tp/" + this.getObjectID()).getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesign().getStoragePath(), "pm/tp/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setTransformationTaskListChanged(boolean bl) {
        this.transformationTaskListChanged = bl;
    }

    public boolean isTransformationTaskListChanged() {
        return this.transformationTaskListChanged;
    }

    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("tt", "TransformationTask");
        }
        return this.f2tMap;
    }
}

