/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.swingui.editor.process.TransformationPropertiesDialogEx;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class Transformation
extends AbstractProcessObject
implements EditableFonts {
    public static final int PRIMITIVE_TYPE = 0;
    public static final int COMPOSITE_TYPE = 1;
    public static final String[] TRANSFORMATION_TYPES_DISPLAY = new String[]{Messages.getString("Transformation.AsItIs"), Messages.getString("Transformation.Derivation"), Messages.getString("Transformation.Aggregation"), Messages.getString("Transformation.Summarization"), Messages.getString("Transformation.ComplexFormula")};
    public static final String[] TRANSFORMATION_TYPES = new String[]{"As It Is", "Derivation", "Aggregation", "Summarization", "Complex Formula"};
    private int type = 0;
    private List targetElements = new ArrayList();
    private boolean primary = false;
    private String filterCondition = "";
    private String joinCondition = "";
    private List editableFonts;
    public static final String TYPE_NAME = "Transformation";

    public Transformation(DesignPart designPart) {
        super(designPart);
        this.initEditableFonts();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isLeaf() {
        return this.type == 0;
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        return -1;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "TRANSF";
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TransformationPropertiesDialogEx transformationPropertiesDialogEx = new TransformationPropertiesDialogEx(this.getDesign().getAppView(), this);
            transformationPropertiesDialogEx.initProperties(this);
            transformationPropertiesDialogEx.show();
        }
    }

    public List getInfoStructures() {
        ArrayList<InfoStructure> arrayList = new ArrayList<InfoStructure>();
        for (int i = 0; i < this.getAllFlows().length; ++i) {
            Flow flow = this.getAllFlows()[i].getFlow();
            for (InfoStructure infoStructure : flow.getInfoStructures()) {
                if (arrayList.contains(infoStructure)) continue;
                arrayList.add(infoStructure);
            }
        }
        return arrayList;
    }

    public List getProcessedAttributes(boolean bl) {
        ArrayList<ProcessedObject> arrayList = new ArrayList<ProcessedObject>();
        ArrayList<Flow> arrayList2 = new ArrayList<Flow>();
        for (Flow flow : this.getIncomingFlows()) {
            if (!(flow.getSourceProcessObject() instanceof InfoStore) && (bl || !(flow.getSourceProcessObject() instanceof Transformation)) || arrayList2.contains(flow)) continue;
            arrayList2.add(flow);
        }
        for (Flow flow : this.getOutgoingFlows()) {
            if (!(flow.getTargetProcessObject() instanceof InfoStore) && (bl || !(flow.getTargetProcessObject() instanceof Transformation)) || arrayList2.contains(flow)) continue;
            arrayList2.add(flow);
        }
        for (Flow flow : arrayList2) {
            List list = flow.getInfoStructures();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                for (Attribute attribute : ((InfoStructure)iterator.next()).getAttributes()) {
                    ProcessedObject processedObject = this.getProcessedObjectFor(arrayList, attribute);
                    if (processedObject == null) {
                        processedObject = new ProcessedObject();
                        processedObject.setObject(attribute);
                        arrayList.add(processedObject);
                    }
                    processedObject.setOpCreate(flow.isOpCreate() || processedObject.isOpCreate());
                    processedObject.setOpRead(flow.isOpRead() || processedObject.isOpRead());
                    processedObject.setOpUpdate(flow.isOpUpdate() || processedObject.isOpUpdate());
                    processedObject.setOpDelete(flow.isOpDelete() || processedObject.isOpDelete());
                }
            }
        }
        return arrayList;
    }

    public List getTargetAttributes(boolean bl) {
        Iterator iterator;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Flow> arrayList2 = new ArrayList<Flow>();
        for (Flow flow : this.getOutgoingFlows()) {
            if (flow.getTargetProcessObject() instanceof InfoStore || !bl && flow.getTargetProcessObject() instanceof Transformation) {
                if (arrayList2.contains(flow)) continue;
                arrayList2.add(flow);
                continue;
            }
            if (!(flow.getTargetProcessObject() instanceof InOutParams)) continue;
            iterator = (InOutParams)flow.getTargetProcessObject();
            arrayList.addAll(((InOutParams)((Object)iterator)).getParams());
        }
        for (Flow flow : arrayList2) {
            if (flow.getExternalData().size() < 1) {
                iterator = flow.getInfoStructures().iterator();
                while (iterator.hasNext()) {
                    for (DesignObject designObject : ((InfoStructure)iterator.next()).getAttributes()) {
                        if (arrayList.contains(designObject)) continue;
                        arrayList.add(designObject);
                    }
                }
                continue;
            }
            for (Object object : flow.getExternalData()) {
                if (arrayList.contains(object)) continue;
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    private ProcessedObject getProcessedObjectFor(List list, DesignObject designObject) {
        for (ProcessedObject processedObject : list) {
            if (processedObject.getObject() != designObject) continue;
            return processedObject;
        }
        return null;
    }

    public List getProcessedEntities(boolean bl) {
        ArrayList<ProcessedObject> arrayList = new ArrayList<ProcessedObject>();
        for (ProcessedObject processedObject : this.getProcessedAttributes(bl)) {
            ContainerObject containerObject = ((Attribute)processedObject.getObject()).getContainer();
            ProcessedObject processedObject2 = this.getProcessedObjectFor(arrayList, containerObject);
            if (processedObject2 == null) {
                processedObject2 = new ProcessedObject();
                processedObject2.setObject(containerObject);
                arrayList.add(processedObject2);
            }
            processedObject2.setObject(((Attribute)processedObject.getObject()).getContainer());
            processedObject2.setOpCreate(processedObject.isOpCreate() || processedObject2.isOpCreate());
            processedObject2.setOpRead(processedObject.isOpRead() || processedObject2.isOpRead());
            processedObject2.setOpUpdate(processedObject.isOpUpdate() || processedObject2.isOpUpdate());
            processedObject2.setOpDelete(processedObject.isOpDelete() || processedObject2.isOpDelete());
        }
        return arrayList;
    }

    public void addProcessedEntitiesToList(List list, boolean bl) {
        for (ProcessedObject processedObject : this.getProcessedEntities(bl)) {
            DesignObject designObject = processedObject.getObject();
            ProcessedObject processedObject2 = this.getProcessedObjectFor(list, designObject);
            if (processedObject2 == null) {
                processedObject2 = new ProcessedObject();
                processedObject2.setObject(designObject);
                list.add(processedObject2);
            }
            processedObject2.setObject(processedObject.getObject());
            processedObject2.setOpCreate(processedObject.isOpCreate() || processedObject2.isOpCreate());
            processedObject2.setOpRead(processedObject.isOpRead() || processedObject2.isOpRead());
            processedObject2.setOpUpdate(processedObject.isOpUpdate() || processedObject2.isOpUpdate());
            processedObject2.setOpDelete(processedObject.isOpDelete() || processedObject2.isOpDelete());
        }
    }

    public String getProcessNumber() {
        String string = Integer.toString(this.getDesignObjectSet().getIndexOf(this) + 1);
        return string;
    }

    public boolean isComposite() {
        return this.type == 1;
    }

    @Override
    public void remove() {
        this.removeFlows();
        super.remove();
    }

    public void updateTargetElements() {
        this.removeInvalidElements();
        for (Flow flow : this.getOutgoingFlows()) {
            if (flow.getTargetProcessObject() instanceof InOutParams) {
                InOutParams inOutParams = (InOutParams)flow.getTargetProcessObject();
                for (Object object2 : inOutParams.getParams()) {
                    if (this.containsTarget((DesignObject)object2)) continue;
                    this.targetElements.add(new TargetElement((DesignObject)object2));
                }
                continue;
            }
            for (Object object : flow.getInfoStructures()) {
                Object object2;
                object2 = ((InfoStructure)object).getAttributes().iterator();
                while (object2.hasNext()) {
                    Attribute attribute = (Attribute)object2.next();
                    if (this.containsTarget(attribute)) continue;
                    this.targetElements.add(new TargetElement(attribute));
                }
            }
        }
    }

    public void removeInvalidElements() {
        List list = this.getTargetAttributes(false);
        for (int i = this.targetElements.size() - 1; i >= 0; --i) {
            TargetElement targetElement = (TargetElement)this.targetElements.get(i);
            if (list.contains(targetElement.getTarget())) continue;
            this.targetElements.remove(targetElement);
        }
        List list2 = this.getSourceElements();
        for (int i = 0; i < this.targetElements.size(); ++i) {
            TargetElement targetElement = (TargetElement)this.targetElements.get(i);
            for (int j = targetElement.getSources().size() - 1; j >= 0; --j) {
                DesignObject designObject = (DesignObject)targetElement.getSources().get(j);
                if (list2.contains(designObject)) continue;
                targetElement.getSources().remove(j);
            }
        }
    }

    private boolean containsTarget(DesignObject designObject) {
        for (TargetElement targetElement : this.targetElements) {
            if (targetElement.getTarget() != designObject) continue;
            return true;
        }
        return false;
    }

    public List getSourceElements_WithParams() {
        return this.getSourceElements();
    }

    public List getSourceElements() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Flow flow : this.getIncomingFlows()) {
            Object object2;
            if (flow.getExternalData().size() < 1) {
                Iterator iterator = flow.getInfoStructures().iterator();
                while (iterator.hasNext()) {
                    for (DesignObject designObject : ((InfoStructure)iterator.next()).getAttributes()) {
                        if (arrayList.contains(designObject)) continue;
                        arrayList.add(designObject);
                    }
                }
            } else {
                for (Object object2 : flow.getExternalData()) {
                    if (arrayList.contains(object2)) continue;
                    arrayList.add(object2);
                }
            }
            if (!(flow.getSourceProcessObject() instanceof InOutParams)) continue;
            object2 = (InOutParams)flow.getSourceProcessObject();
            for (DesignObject designObject : ((InOutParams)object2).getParams()) {
                if (arrayList.contains(designObject)) continue;
                arrayList.add(designObject);
            }
        }
        return arrayList;
    }

    public List getTargetElements() {
        return this.targetElements;
    }

    public boolean isConnectedToStore() {
        Flow.Connection[] connectionArray = this.getAllFlows();
        for (int i = 0; i < connectionArray.length; ++i) {
            Flow flow = connectionArray[i].getFlow();
            if (!flow.isConnectedToInfoStore()) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean bl) {
        this.primary = bl;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String string) {
        this.filterCondition = string;
    }

    public String getJoinCondition() {
        return this.joinCondition;
    }

    public void setJoinCondition(String string) {
        this.joinCondition = string;
    }

    private void initEditableFonts() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && this.getDesignPart().getAppView() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    @Override
    public void resetFontsAndColors(boolean bl) {
        if (bl) {
            DefaultFontAndColor defaultFontAndColor;
            this.editableFonts.clear();
            if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
                for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                    this.editableFonts.add(fontObject.copy());
                }
            }
            this.setBackgroundColor(null);
            this.setForegroundColor(null);
            this.setUseDefaultColor(true);
        } else if (DefaultFontAndColor.isModified(TYPE_NAME)) {
            DefaultFontAndColor defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME);
            if (defaultFontAndColor != null) {
                if (this.getBackgroundColor() == null) {
                    this.setBackgroundColor(defaultFontAndColor.getBackgroundColor());
                }
                if (this.getForegroundColor() == null) {
                    this.setForegroundColor(defaultFontAndColor.getForegroundColor());
                }
            }
            this.setUseDefaultColor(bl);
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "process/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public class ProcessedObject {
        private DesignObject object;
        private boolean opCreate;
        private boolean opRead;
        private boolean opUpdate;
        private boolean opDelete;

        public DesignObject getObject() {
            return this.object;
        }

        public void setObject(DesignObject designObject) {
            this.object = designObject;
        }

        public boolean isOpCreate() {
            return this.opCreate;
        }

        public void setOpCreate(boolean bl) {
            this.opCreate = bl;
        }

        public boolean isOpDelete() {
            return this.opDelete;
        }

        public void setOpDelete(boolean bl) {
            this.opDelete = bl;
        }

        public boolean isOpRead() {
            return this.opRead;
        }

        public void setOpRead(boolean bl) {
            this.opRead = bl;
        }

        public boolean isOpUpdate() {
            return this.opUpdate;
        }

        public void setOpUpdate(boolean bl) {
            this.opUpdate = bl;
        }
    }
}

