/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.editor.process.RolePropertiesDialogEx;

public class Role
extends AbstractProcessObject {
    private String description = "";
    private List processes = new ArrayList();
    private Map loadedProcesses = new HashMap();
    private String processesRefs = "";
    public static final String TYPE_NAME = "Role";

    public Role(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "ROLE";
    }

    public List getProcesses() {
        return this.processes;
    }

    public List getEntities() {
        return null;
    }

    public void addProcess(Process process) {
        if (!this.processes.contains(process)) {
            this.processes.add(process);
        }
    }

    public void setAllProcesses(List list) {
        this.processes.clear();
        if (list != null) {
            for (Process process : list) {
                if (this.processes.contains(process)) continue;
                this.processes.add(process);
            }
        }
    }

    public void addProcessInfo(String string, Object object) {
        this.loadedProcesses.put(string, object);
    }

    public void updateProcesses() {
        for (String[] stringArray : this.loadedProcesses.keySet()) {
            Process process = (Process)this.getDesign().getDesignObject((String)stringArray);
            if (process == null) continue;
            this.addProcess(process);
        }
        this.loadedProcesses.clear();
        if (!"".equals(this.processesRefs)) {
            String[] stringArray;
            stringArray = this.processesRefs.split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                Process process = (Process)this.getDesign().getDesignObject(stringArray[i]);
                if (process == null) continue;
                this.addProcess(process);
            }
            this.processesRefs = "";
        }
    }

    public void removeProcess(Process process) {
        this.processes.remove(process);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RolePropertiesDialogEx rolePropertiesDialogEx = new RolePropertiesDialogEx(this.getDesign().getAppView(), this);
            rolePropertiesDialogEx.initProperties(this);
            rolePropertiesDialogEx.show();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "role/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getProcessesRefs() {
        if (this.processes.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            for (DesignObject designObject : this.processes) {
                String string = designObject.getObjectID();
                if (bl) {
                    stringBuffer.append(string);
                    bl = false;
                    continue;
                }
                stringBuffer.append(' ').append(string);
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public void setProcessesRefs(String string) {
        this.processesRefs = string;
    }
}

