/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.swingui.editor.process.RecordStructurePropertiesDialogEx;

public class RecordStructure
extends AbstractProcessObject {
    private List datas = new ArrayList();
    private List loadedDatas = new ArrayList();
    public static final String TYPE_NAME = "RecordStructure";

    public RecordStructure(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "RS";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RecordStructurePropertiesDialogEx recordStructurePropertiesDialogEx = new RecordStructurePropertiesDialogEx(this.getDesign().getAppView(), this);
            recordStructurePropertiesDialogEx.initProperties(this);
            recordStructurePropertiesDialogEx.show();
        }
    }

    public void addExtData(ExternalData externalData) {
        if (!this.datas.contains(externalData)) {
            this.datas.add(externalData);
        }
    }

    public void removeExtData(ExternalData externalData) {
        this.datas.remove(externalData);
        externalData.remove();
    }

    public List getExtDatas() {
        return this.datas;
    }

    public ExternalData createExternalData() {
        ExternalData externalData = ((ProcessModel)this.getDesignPart()).createExternalData();
        this.addExtData(externalData);
        return externalData;
    }

    public void addExtData(String string) {
        this.loadedDatas.add(string);
    }

    public void updatedExtDatas() {
        for (String string : this.loadedDatas) {
            ExternalData externalData = (ExternalData)((ProcessModel)this.getDesignPart()).getExternalDataSet().getObjectByID(string);
            if (externalData == null) continue;
            this.addExtData(externalData);
            externalData.setOwner(this);
        }
        this.loadedDatas.clear();
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "recordstructure/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ExternalData getExternalDataByID(String string) {
        for (ExternalData externalData : this.datas) {
            if (!externalData.getObjectID().equals(string)) continue;
            return externalData;
        }
        return null;
    }
}

