/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.editor.process.ProcessPropertiesDialogEx;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class Process
extends Transformation
implements SetListener,
EditableFonts {
    public static final String[] FREQUENCY_TIME_UNITS_DISPLAY = new String[]{Messages.getString("Process.Second"), Messages.getString("Process.Minute"), Messages.getString("Process.Hour"), Messages.getString("Process.Day"), Messages.getString("Process.Week"), Messages.getString("Process.Month"), Messages.getString("Process.Quarter"), Messages.getString("Process.HalfYear"), Messages.getString("Process.Year")};
    public static final String[] FREQUENCY_TIME_UNITS = new String[]{"Second", "Minute", "Hour", "Day", "Week", "Month", "Quarter", "Half Year", "Year"};
    public static final String[] BATCH_TIME_UNITS_DISPLAY = new String[]{Messages.getString("Process.Second"), Messages.getString("Process.Minute"), Messages.getString("Process.Hour"), Messages.getString("Process.Day")};
    public static final String[] BATCH_TIME_UNITS = new String[]{"Second", "Minute", "Hour", "Day"};
    public static final String[] INTERACTIVE_RESPONSE_TIME_UNITS_DISPLAY = new String[]{Messages.getString("Process.Second"), Messages.getString("Process.Minute")};
    public static final String[] INTERACTIVE_RESPONSE_TIME_UNITS = new String[]{"Second", "Minute"};
    public static final String[] PRIORITY_DISPLAY = new String[]{Messages.getString("Process.None"), Messages.getString("Process.Low"), Messages.getString("Process.Medium"), Messages.getString("Process.High")};
    public static final String[] PRIORITY = new String[]{"None", "Low", "Medium", "High"};
    public static final String[] MODES_DISPLAY = new String[]{Messages.getString("Process.Unknown"), Messages.getString("Process.Batch"), Messages.getString("Process.Interactive"), Messages.getString("Process.Manual")};
    public static final String[] MODES = new String[]{"Unknown", "Batch", "Interactive", "Manual"};
    public static final String[] PROCESS_TYPE_NAMES = new String[]{Messages.getString("Process.TypePrimitive"), Messages.getString("Process.TypeComposite"), Messages.getString("Process.TypeUseTransformationTask")};
    public static final int USE_TRANSFORMATION_TASK_TYPE = 2;
    private int type = 0;
    private DataFlowDesign diagram;
    private String footNote = "";
    private int frequencyTimes = 0;
    private String frequencyTimeUnit = FREQUENCY_TIME_UNITS[3];
    private String priority = PRIORITY[1];
    private String mode = MODES[0];
    private int batchMinimumTransactions = 1000;
    private String batchTimeUnit = BATCH_TIME_UNITS[0];
    private int interactiveLongestResponseTime = 5;
    private String interactiveResponseTimeUnit = INTERACTIVE_RESPONSE_TIME_UNITS[0];
    private boolean[] peakPeriods = new boolean[24];
    private List events = new ArrayList();
    private List targetElements = new ArrayList();
    private TransformationTask transformationTask;
    private List paramsWrappers = new ArrayList();
    private String paramsWrappersString = "";
    private boolean paramsWrappersPreset = false;
    private List editableFonts;
    public static final String TYPE_NAME = "Process";

    public Process(DesignPart designPart) {
        super(designPart);
        this.initEditableFonts();
    }

    public void initDiagram() {
        if (this.diagram == null) {
            this.diagram = this.getDesign().getProcessModel().addDataFlowDesign(null, false);
            this.diagram.setName(MessageFormat.format(Messages.getString("Process.Diagram"), this.getName()));
            this.diagram.setProcess(this);
            this.diagram.setDirty(true);
            this.fireChange(ObjectChangeEvent.PROCESS_DECOMPOSED);
        }
    }

    public void clearDiagram() {
        if (this.diagram != null) {
            ((DataFlowDesign)this.getDesignPart()).getProcessModel().removeDataFlowDesign(this.diagram);
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isLeaf() {
        return this.type == 0;
    }

    @Override
    public int getNumberOfChildren() {
        return this.diagram != null ? 1 : 0;
    }

    @Override
    public ModelObject getChild(int n) {
        if (n == 0 && this.diagram != null) {
            return this.diagram;
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.diagram) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "PRO";
    }

    public int getBatchMinimumTransactions() {
        return this.batchMinimumTransactions;
    }

    public void setBatchMinimumTransactions(int n) {
        this.batchMinimumTransactions = n;
    }

    public String getBatchTimeUnit() {
        return this.batchTimeUnit;
    }

    public void setBatchTimeUnit(String string) {
        this.batchTimeUnit = string;
    }

    public String getFootNote() {
        return this.footNote;
    }

    public void setFootNote(String string) {
        this.footNote = string;
    }

    public int getFrequencyTimes() {
        return this.frequencyTimes;
    }

    public void setFrequencyTimes(int n) {
        this.frequencyTimes = n;
    }

    public String getFrequencyTimeUnit() {
        return this.frequencyTimeUnit;
    }

    public void setFrequencyTimeUnit(String string) {
        this.frequencyTimeUnit = string;
    }

    public int getInteractiveLongestResponseTime() {
        return this.interactiveLongestResponseTime;
    }

    public void setInteractiveLongestResponseTime(int n) {
        this.interactiveLongestResponseTime = n;
    }

    public String getInteractiveResponseTimeUnit() {
        return this.interactiveResponseTimeUnit;
    }

    public void setInteractiveResponseTimeUnit(String string) {
        this.interactiveResponseTimeUnit = string;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String string) {
        this.priority = string;
    }

    public boolean[] getPeakPeriods() {
        return this.peakPeriods;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public String getProcessTypeName() {
        return PROCESS_TYPE_NAMES[this.type];
    }

    public void setType(int n) {
        if (n == 1) {
            this.type = n;
            this.setTransformationTask(null);
            if (!this.getDesign().isLoading()) {
                this.initDiagram();
                this.addConnectedToComposite();
            }
        } else if (n == 0) {
            this.type = n;
            this.setTransformationTask(null);
        } else if (n == 2) {
            this.type = n;
        }
    }

    public DataFlowDesign getDiagram() {
        return this.diagram;
    }

    public void setDiagram(DataFlowDesign dataFlowDesign) {
        this.diagram = dataFlowDesign;
        if (dataFlowDesign != null) {
            dataFlowDesign.setProcess(this);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ProcessPropertiesDialogEx processPropertiesDialogEx = new ProcessPropertiesDialogEx(this.getDesign().getAppView(), this);
            processPropertiesDialogEx.initProperties(this);
            processPropertiesDialogEx.show();
        }
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
    }

    public void clearEvents(Process process) {
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            ((Event)iterator.next()).removeProcess(process);
        }
        this.events.clear();
    }

    public List getFlowEvents() {
        ArrayList<Event> arrayList = new ArrayList<Event>();
        List list = this.getIncomingFlows();
        for (Flow flow : list) {
            if (flow.getEvent() == null || arrayList.contains(flow.getEvent())) continue;
            arrayList.add(flow.getEvent());
        }
        return arrayList;
    }

    public List getEvents() {
        return this.events;
    }

    public void addEvent(Event event) {
        if (event != null && !this.events.contains(event)) {
            this.events.add(event);
            event.addProcess(this);
        }
    }

    public void removeEvent(Event event) {
        this.events.remove(event);
    }

    public Event getEventByID(String string) {
        for (Event event : this.events) {
            if (!event.getObjectID().equals(string)) continue;
            return event;
        }
        return null;
    }

    @Override
    public List getInfoStructures() {
        ArrayList<InfoStructure> arrayList = new ArrayList<InfoStructure>();
        for (int i = 0; i < this.getAllFlows().length; ++i) {
            Flow flow = this.getAllFlows()[i].getFlow();
            for (InfoStructure infoStructure : flow.getInfoStructures()) {
                if (arrayList.contains(infoStructure)) continue;
                arrayList.add(infoStructure);
            }
        }
        return arrayList;
    }

    @Override
    public List getProcessedAttributes(boolean bl) {
        HashMap<String, Flow> hashMap = new HashMap<String, Flow>(50);
        ArrayList<ProcessedObject> arrayList = new ArrayList<ProcessedObject>();
        ArrayList<Flow> arrayList2 = new ArrayList<Flow>();
        for (Flow flow : this.getIncomingFlows()) {
            if (!(flow.getSourceProcessObject() instanceof InfoStore) && (bl || !(flow.getSourceProcessObject() instanceof Process)) || arrayList2.contains(flow)) continue;
            arrayList2.add(flow);
            hashMap.put(flow.getObjectID(), flow);
        }
        for (Flow flow : this.getOutgoingFlows()) {
            if (!(flow.getTargetProcessObject() instanceof InfoStore) && (bl || !(flow.getTargetProcessObject() instanceof Process)) || arrayList2.contains(flow)) continue;
            arrayList2.add(flow);
        }
        for (Flow flow : arrayList2) {
            List list = flow.getInfoStructures();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                for (Attribute attribute : ((InfoStructure)iterator.next()).getAttributes()) {
                    ProcessedObject processedObject = this.getProcessedObjectFor(arrayList, attribute);
                    if (processedObject == null) {
                        processedObject = new ProcessedObject();
                        processedObject.setObject(attribute);
                        arrayList.add(processedObject);
                    }
                    processedObject.setOpCreate(flow.isOpCreate() || processedObject.isOpCreate());
                    processedObject.setOpRead(flow.isOpRead() || processedObject.isOpRead());
                    processedObject.setOpUpdate(flow.isOpUpdate() || processedObject.isOpUpdate());
                    processedObject.setOpDelete(flow.isOpDelete() || processedObject.isOpDelete());
                    processedObject.setFlow(flow);
                    if (hashMap.get(flow.getObjectID()) == null) continue;
                    processedObject.setInbound(true);
                }
            }
        }
        return arrayList;
    }

    public List getProcessedAttributesAndFlows(boolean bl) {
        HashMap<String, Flow> hashMap = new HashMap<String, Flow>(4000);
        TreeMap<String, ProcessedObject> treeMap = new TreeMap<String, ProcessedObject>();
        ArrayList arrayList = new ArrayList();
        ArrayList<Flow> arrayList2 = new ArrayList<Flow>();
        for (Flow flow : this.getIncomingFlows()) {
            if (!(flow.getSourceProcessObject() instanceof InfoStore) && (bl || !(flow.getSourceProcessObject() instanceof Process)) || arrayList2.contains(flow)) continue;
            arrayList2.add(flow);
            hashMap.put(flow.getObjectID(), flow);
        }
        for (Flow flow : this.getOutgoingFlows()) {
            if (!(flow.getTargetProcessObject() instanceof InfoStore) && (bl || !(flow.getTargetProcessObject() instanceof Process)) || arrayList2.contains(flow)) continue;
            arrayList2.add(flow);
        }
        for (Flow flow : arrayList2) {
            List list = flow.getInfoStructures();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                for (Attribute attribute : ((InfoStructure)iterator.next()).getAttributes()) {
                    ProcessedObject processedObject = (ProcessedObject)treeMap.get(attribute.getObjectID() + flow.getObjectID());
                    if (processedObject == null) {
                        processedObject = new ProcessedObject();
                        processedObject.setObject(attribute);
                        treeMap.put(attribute.getObjectID() + flow.getObjectID(), processedObject);
                    }
                    processedObject.setOpCreate(flow.isOpCreate() || processedObject.isOpCreate());
                    processedObject.setOpRead(flow.isOpRead() || processedObject.isOpRead());
                    processedObject.setOpUpdate(flow.isOpUpdate() || processedObject.isOpUpdate());
                    processedObject.setOpDelete(flow.isOpDelete() || processedObject.isOpDelete());
                    processedObject.setFlow(flow);
                    if (hashMap.get(flow.getObjectID()) == null) continue;
                    processedObject.setInbound(true);
                }
            }
        }
        arrayList.addAll(treeMap.values());
        return arrayList;
    }

    public List getProcessedAttributesAndFlows(boolean bl, Attribute attribute) {
        HashMap<String, Flow> hashMap = new HashMap<String, Flow>(4000);
        TreeMap<String, ProcessedObject> treeMap = new TreeMap<String, ProcessedObject>();
        ArrayList arrayList = new ArrayList();
        ArrayList<Flow> arrayList2 = new ArrayList<Flow>();
        for (Flow flow : this.getIncomingFlows()) {
            if (!(flow.getSourceProcessObject() instanceof InfoStore) && (bl || !(flow.getSourceProcessObject() instanceof Process)) || arrayList2.contains(flow)) continue;
            arrayList2.add(flow);
            hashMap.put(flow.getObjectID(), flow);
        }
        for (Flow flow : this.getOutgoingFlows()) {
            if (!(flow.getTargetProcessObject() instanceof InfoStore) && (bl || !(flow.getTargetProcessObject() instanceof Process)) || arrayList2.contains(flow)) continue;
            arrayList2.add(flow);
        }
        for (Flow flow : arrayList2) {
            List list = flow.getInfoStructures();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                for (Attribute attribute2 : ((InfoStructure)iterator.next()).getAttributes()) {
                    if (attribute != attribute2) continue;
                    ProcessedObject processedObject = (ProcessedObject)treeMap.get(attribute2.getObjectID() + flow.getObjectID());
                    if (processedObject == null) {
                        processedObject = new ProcessedObject();
                        processedObject.setObject(attribute2);
                        treeMap.put(attribute2.getObjectID() + flow.getObjectID(), processedObject);
                    }
                    processedObject.setOpCreate(flow.isOpCreate() || processedObject.isOpCreate());
                    processedObject.setOpRead(flow.isOpRead() || processedObject.isOpRead());
                    processedObject.setOpUpdate(flow.isOpUpdate() || processedObject.isOpUpdate());
                    processedObject.setOpDelete(flow.isOpDelete() || processedObject.isOpDelete());
                    processedObject.setFlow(flow);
                    if (hashMap.get(flow.getObjectID()) == null) continue;
                    processedObject.setInbound(true);
                }
            }
        }
        arrayList.addAll(treeMap.values());
        return arrayList;
    }

    public List getProcessedAttributesAndFlows(boolean bl, Entity entity) {
        HashMap<String, Flow> hashMap = new HashMap<String, Flow>(4000);
        TreeMap<String, ProcessedObject> treeMap = new TreeMap<String, ProcessedObject>();
        ArrayList arrayList = new ArrayList();
        ArrayList<Flow> arrayList2 = new ArrayList<Flow>();
        for (Flow flow : this.getIncomingFlows()) {
            if (!(flow.getSourceProcessObject() instanceof InfoStore) && (bl || !(flow.getSourceProcessObject() instanceof Process)) || arrayList2.contains(flow)) continue;
            arrayList2.add(flow);
            hashMap.put(flow.getObjectID(), flow);
        }
        for (Flow flow : this.getOutgoingFlows()) {
            if (!(flow.getTargetProcessObject() instanceof InfoStore) && (bl || !(flow.getTargetProcessObject() instanceof Process)) || arrayList2.contains(flow)) continue;
            arrayList2.add(flow);
        }
        for (Flow flow : arrayList2) {
            List list = flow.getInfoStructures();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                for (Attribute attribute : ((InfoStructure)iterator.next()).getAttributes()) {
                    if (attribute.getContainerWithKeyObject() != entity) continue;
                    ProcessedObject processedObject = (ProcessedObject)treeMap.get(attribute.getObjectID() + flow.getObjectID());
                    if (processedObject == null) {
                        processedObject = new ProcessedObject();
                        processedObject.setObject(attribute);
                        treeMap.put(attribute.getObjectID() + flow.getObjectID(), processedObject);
                    }
                    processedObject.setOpCreate(flow.isOpCreate() || processedObject.isOpCreate());
                    processedObject.setOpRead(flow.isOpRead() || processedObject.isOpRead());
                    processedObject.setOpUpdate(flow.isOpUpdate() || processedObject.isOpUpdate());
                    processedObject.setOpDelete(flow.isOpDelete() || processedObject.isOpDelete());
                    processedObject.setFlow(flow);
                    if (hashMap.get(flow.getObjectID()) == null) continue;
                    processedObject.setInbound(true);
                }
            }
        }
        arrayList.addAll(treeMap.values());
        return arrayList;
    }

    private List getTargets() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Flow flow : this.getOutgoingFlows()) {
            if (flow.getExternalData().size() < 1) {
                Iterator iterator = flow.getInfoStructures().iterator();
                while (iterator.hasNext()) {
                    for (DesignObject designObject : ((InfoStructure)iterator.next()).getAttributes()) {
                        if (arrayList.contains(designObject)) continue;
                        arrayList.add(designObject);
                    }
                }
                continue;
            }
            for (Object object : flow.getExternalData()) {
                if (arrayList.contains(object)) continue;
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    private ProcessedObject getProcessedObjectFor(List list, DesignObject designObject) {
        for (ProcessedObject processedObject : list) {
            if (processedObject.getObject() != designObject) continue;
            return processedObject;
        }
        return null;
    }

    @Override
    public List getProcessedEntities(boolean bl) {
        ArrayList<ProcessedObject> arrayList = new ArrayList<ProcessedObject>();
        for (ProcessedObject processedObject : this.getProcessedAttributes(bl)) {
            ContainerObject containerObject = ((Attribute)processedObject.getObject()).getContainer();
            ProcessedObject processedObject2 = this.getProcessedObjectFor(arrayList, containerObject);
            if (processedObject2 == null) {
                processedObject2 = new ProcessedObject();
                processedObject2.setObject(containerObject);
                arrayList.add(processedObject2);
            }
            processedObject2.setObject(((Attribute)processedObject.getObject()).getContainer());
            processedObject2.setOpCreate(processedObject.isOpCreate() || processedObject2.isOpCreate());
            processedObject2.setOpRead(processedObject.isOpRead() || processedObject2.isOpRead());
            processedObject2.setOpUpdate(processedObject.isOpUpdate() || processedObject2.isOpUpdate());
            processedObject2.setOpDelete(processedObject.isOpDelete() || processedObject2.isOpDelete());
        }
        return arrayList;
    }

    public List getProcessedEntitiesAndFlows(boolean bl) {
        TreeMap<String, ProcessedObject> treeMap = new TreeMap<String, ProcessedObject>();
        ArrayList arrayList = new ArrayList();
        for (ProcessedObject processedObject : this.getProcessedAttributesAndFlows(bl)) {
            ContainerObject containerObject = ((Attribute)processedObject.getObject()).getContainer();
            ProcessedObject processedObject2 = (ProcessedObject)treeMap.get(containerObject.getObjectID() + processedObject.getFlow().getObjectID());
            if (processedObject2 == null) {
                processedObject2 = new ProcessedObject();
                processedObject2.setObject(containerObject);
                processedObject2.setFlow(processedObject.getFlow());
                processedObject2.setInbound(processedObject.isInbound());
                treeMap.put(containerObject.getObjectID() + processedObject.getFlow().getObjectID(), processedObject2);
            }
            processedObject2.setOpCreate(processedObject.isOpCreate() || processedObject2.isOpCreate());
            processedObject2.setOpRead(processedObject.isOpRead() || processedObject2.isOpRead());
            processedObject2.setOpUpdate(processedObject.isOpUpdate() || processedObject2.isOpUpdate());
            processedObject2.setOpDelete(processedObject.isOpDelete() || processedObject2.isOpDelete());
        }
        arrayList.addAll(treeMap.values());
        return arrayList;
    }

    public List getProcessedEntitiesAndFlows(boolean bl, Entity entity) {
        TreeMap<String, ProcessedObject> treeMap = new TreeMap<String, ProcessedObject>();
        ArrayList arrayList = new ArrayList();
        for (ProcessedObject processedObject : this.getProcessedAttributesAndFlows(bl, entity)) {
            ContainerObject containerObject = ((Attribute)processedObject.getObject()).getContainer();
            ProcessedObject processedObject2 = (ProcessedObject)treeMap.get(containerObject.getObjectID() + processedObject.getFlow().getObjectID());
            if (processedObject2 == null) {
                processedObject2 = new ProcessedObject();
                processedObject2.setObject(containerObject);
                processedObject2.setFlow(processedObject.getFlow());
                processedObject2.setInbound(processedObject.isInbound());
                treeMap.put(containerObject.getObjectID() + processedObject.getFlow().getObjectID(), processedObject2);
            }
            processedObject2.setOpCreate(processedObject.isOpCreate() || processedObject2.isOpCreate());
            processedObject2.setOpRead(processedObject.isOpRead() || processedObject2.isOpRead());
            processedObject2.setOpUpdate(processedObject.isOpUpdate() || processedObject2.isOpUpdate());
            processedObject2.setOpDelete(processedObject.isOpDelete() || processedObject2.isOpDelete());
        }
        arrayList.addAll(treeMap.values());
        return arrayList;
    }

    @Override
    public void addProcessedEntitiesToList(List list, boolean bl) {
        for (ProcessedObject processedObject : this.getProcessedEntities(bl)) {
            DesignObject designObject = processedObject.getObject();
            ProcessedObject processedObject2 = this.getProcessedObjectFor(list, designObject);
            if (processedObject2 == null) {
                processedObject2 = new ProcessedObject();
                processedObject2.setObject(designObject);
                list.add(processedObject2);
            }
            processedObject2.setObject(processedObject.getObject());
            processedObject2.setOpCreate(processedObject.isOpCreate() || processedObject2.isOpCreate());
            processedObject2.setOpRead(processedObject.isOpRead() || processedObject2.isOpRead());
            processedObject2.setOpUpdate(processedObject.isOpUpdate() || processedObject2.isOpUpdate());
            processedObject2.setOpDelete(processedObject.isOpDelete() || processedObject2.isOpDelete());
        }
    }

    @Override
    public String getProcessNumber() {
        DataFlowDesign dataFlowDesign;
        String string = Integer.toString(((DataFlowDesign)this.getDesignPart()).getProcessNumber(this));
        String string2 = "";
        if (this.getDesignPart() != null && (dataFlowDesign = (DataFlowDesign)this.getDesignPart()).getProcess() != null) {
            string2 = dataFlowDesign.getProcess().getProcessNumber();
        }
        if (!"".equalsIgnoreCase(string2)) {
            return string2 + "." + string;
        }
        return string;
    }

    public Process getParentProcess() {
        DataFlowDesign dataFlowDesign;
        if (this.getDesignPart() != null && (dataFlowDesign = (DataFlowDesign)this.getDesignPart()).getProcess() != null) {
            return dataFlowDesign.getProcess();
        }
        return null;
    }

    public Process getParentProcessInDFD(DataFlowDesign dataFlowDesign) {
        if (dataFlowDesign != null) {
            if (this.getDesignPart() == dataFlowDesign) {
                return this;
            }
            Process process = this.getParentProcess();
            if (process != null) {
                return process.getParentProcessInDFD(dataFlowDesign);
            }
        }
        return null;
    }

    @Override
    public boolean isComposite() {
        return this.type == 1;
    }

    private void addConnectedToComposite() {
        for (Flow flow : ((DataFlowDesign)this.getDesignPart()).getFlowsForProcessObject(this)) {
            flow.addSynonymToCompositeProcDiagram();
        }
    }

    @Override
    public void remove() {
        this.removeFlows();
        this.clearDiagram();
        super.remove();
    }

    public void remove(boolean bl) {
        if (bl) {
            super.remove();
        } else {
            this.remove();
        }
    }

    public boolean hasEvent() {
        return this.events.size() > 0 || this.getFlowEvents().size() > 0;
    }

    public Collection getComponentFlowsFor(Flow flow) {
        ArrayList arrayList = new ArrayList();
        if (this.getDiagram() != null) {
            return this.getDiagram().getComponentFlowsFor(flow);
        }
        return arrayList;
    }

    @Override
    public void updateTargetElements() {
        this.removeInvalidElements();
        for (Flow flow : this.getOutgoingFlows()) {
            if (flow.getExternalData().size() < 1) {
                for (DesignObject designObject : flow.getInfoStructures()) {
                    for (Attribute attribute : ((InfoStructure)designObject).getAttributes()) {
                        if (this.containsTarget(attribute)) continue;
                        this.targetElements.add(new TargetElement(attribute, this));
                    }
                }
                continue;
            }
            for (DesignObject designObject : flow.getExternalData()) {
                if (this.containsTarget(designObject)) continue;
                this.targetElements.add(new TargetElement(designObject, this));
            }
        }
    }

    @Override
    public void removeInvalidElements() {
        List list = this.getTargets();
        for (int i = this.targetElements.size() - 1; i >= 0; --i) {
            TargetElement targetElement = (TargetElement)this.targetElements.get(i);
            if (list.contains(targetElement.getTarget())) continue;
            this.targetElements.remove(targetElement);
        }
        List list2 = this.getSourceElements_WithParams();
        for (int i = 0; i < this.targetElements.size(); ++i) {
            TargetElement targetElement = (TargetElement)this.targetElements.get(i);
            for (int j = targetElement.getSources().size() - 1; j >= 0; --j) {
                DesignObject designObject = (DesignObject)targetElement.getSources().get(j);
                if (list2.contains(designObject)) continue;
                targetElement.getSources().remove(j);
            }
        }
    }

    private boolean containsTarget(DesignObject designObject) {
        for (TargetElement targetElement : this.targetElements) {
            if (targetElement.getTarget() != designObject) continue;
            return true;
        }
        return false;
    }

    @Override
    public List getSourceElements() {
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        for (Flow flow : this.getIncomingFlows()) {
            Iterator iterator = flow.getInfoStructures().iterator();
            if (flow.getExternalData().size() < 1) {
                while (iterator.hasNext()) {
                    DesignObject designObject = (InfoStructure)iterator.next();
                    for (Attribute attribute : designObject.getAttributes()) {
                        if (arrayList.contains(attribute)) continue;
                        arrayList.add(attribute);
                    }
                }
                continue;
            }
            for (DesignObject designObject : flow.getExternalData()) {
                if (arrayList.contains(designObject)) continue;
                arrayList.add(designObject);
            }
        }
        return arrayList;
    }

    @Override
    public List getSourceElements_WithParams() {
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        for (Flow flow : this.getIncomingFlows()) {
            Iterator iterator = flow.getInfoStructures().iterator();
            if (flow.getExternalData().size() < 1) {
                while (iterator.hasNext()) {
                    DesignObject designObject = (InfoStructure)iterator.next();
                    for (Attribute attribute : designObject.getAttributes()) {
                        if (arrayList.contains(attribute)) continue;
                        arrayList.add(attribute);
                    }
                }
            } else {
                for (DesignObject designObject : flow.getExternalData()) {
                    if (arrayList.contains(designObject)) continue;
                    arrayList.add(designObject);
                }
            }
            if (this.transformationTask == null) continue;
            arrayList.addAll(this.transformationTask.getOutputParameters());
        }
        return arrayList;
    }

    @Override
    public List getTargetElements() {
        return this.targetElements;
    }

    public List getUpdatedTargetElements() {
        this.updateTargetElements();
        return this.targetElements;
    }

    @Override
    public boolean isConnectedToStore() {
        Flow.Connection[] connectionArray = this.getAllFlows();
        for (int i = 0; i < connectionArray.length; ++i) {
            Flow flow = connectionArray[i].getFlow();
            if (!flow.isConnectedToInfoStore()) continue;
            return true;
        }
        return false;
    }

    public TransformationTask getTransformationTask() {
        return this.transformationTask;
    }

    public void setTransformationTask(TransformationTask transformationTask) {
        if (this.transformationTask != transformationTask) {
            this.paramsWrappers.clear();
        }
        this.transformationTask = transformationTask;
        if (transformationTask != null) {
            this.type = 2;
        }
    }

    public List getParamsWrappers() {
        if (this.paramsWrappersPreset && this.transformationTask != null) {
            this.paramsWrappers.clear();
            if (!"".equalsIgnoreCase(this.paramsWrappersString)) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.paramsWrappersString, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    String[] stringArray = string.split(",");
                    if (stringArray.length != 2) continue;
                    ParameterObject parameterObject = this.transformationTask.getParameterObjectById(stringArray[0]);
                    DesignObject designObject = this.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(stringArray[1]);
                    if (designObject == null) {
                        designObject = this.getDesign().getProcessModel().getExternalDataSet().getObjectByID(stringArray[1]);
                    }
                    if (parameterObject == null || designObject == null) continue;
                    ParamWrapper paramWrapper = new ParamWrapper(parameterObject);
                    paramWrapper.setMappedObject(designObject);
                    this.paramsWrappers.add(paramWrapper);
                }
            }
            this.paramsWrappersPreset = false;
        }
        return this.paramsWrappers;
    }

    public void addParamWrapper(ParamWrapper paramWrapper) {
        this.paramsWrappers.add(paramWrapper);
    }

    public DesignObject getParamMapping(ParameterObject parameterObject) {
        for (ParamWrapper paramWrapper : this.getParamsWrappers()) {
            if (paramWrapper.getParam() != parameterObject) continue;
            return paramWrapper.getMappedObject();
        }
        return null;
    }

    public String getParamsWrappersString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getParamsWrappers().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(';');
            }
            ParamWrapper paramWrapper = (ParamWrapper)iterator.next();
            stringBuffer.append(paramWrapper.getParam().getObjectID()).append(",");
            if (paramWrapper.getMappedObject() == null) {
                stringBuffer.append("null");
                continue;
            }
            stringBuffer.append(paramWrapper.getMappedObject().getObjectID());
        }
        return stringBuffer.toString();
    }

    public void setParamsWrappersString(String string) {
        this.paramsWrappersString = string;
        this.paramsWrappersPreset = true;
    }

    private void initEditableFonts() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && this.getDesignPart().getAppView() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    public void resetFontsAndColors() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts.clear();
        if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
        this.setUseDefaultColor(true);
    }

    protected List createTypeOrder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("RecordStructure");
        arrayList.add("ExternalData");
        arrayList.add("Event");
        arrayList.add("InfoStructure");
        arrayList.add("InfoStore");
        arrayList.add("Role");
        arrayList.add("TransformationPackage");
        arrayList.add("Note");
        arrayList.add("MainView");
        arrayList.add("SubView");
        return arrayList;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "process/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        ModelIDObject modelIDObject = null;
        if (string != null && string.equals("targetMapping")) {
            return this.getTargetElementByID(string2);
        }
        if (this.transformationTask != null) {
            modelIDObject = this.transformationTask.getParameterObjectById(string2);
        }
        if (modelIDObject != null) {
            return modelIDObject;
        }
        modelIDObject = this.getDesign().getDesignObject(string2);
        if (modelIDObject != null) {
            return modelIDObject;
        }
        if ("diagram".equalsIgnoreCase(string)) {
            modelIDObject = this.getDesign().getProcessModel().getDataFlowDesigns().getById(string2);
        } else if ("transformationtask".equalsIgnoreCase(string)) {
            modelIDObject = this.getDesign().getProcessModel().getTransformationTaskById(string2);
        }
        if (modelIDObject != null) {
            return modelIDObject;
        }
        return super.translateIdToObject(string, string2);
    }

    public String getPeakPeriodsString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.peakPeriods.length; ++i) {
            stringBuffer.append(this.peakPeriods[i] ? "1" : "0");
        }
        return stringBuffer.toString();
    }

    public void setPeakPeriodsString(String string) {
        if (string != null && !"".equalsIgnoreCase(string) && string.length() == this.getPeakPeriods().length) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                this.getPeakPeriods()[i] = "1".equalsIgnoreCase(String.valueOf(c));
            }
        }
    }

    public TargetElement createTargetElement() {
        TargetElement targetElement = new TargetElement(this.getDesignPart());
        targetElement.setProcess(this);
        return targetElement;
    }

    public void addTargetElement(TargetElement targetElement) {
        if (!this.targetElements.contains(targetElement) && targetElement.getTarget() != null) {
            this.targetElements.add(targetElement);
        }
    }

    public void removeTargetElement(TargetElement targetElement) {
        this.targetElements.remove(targetElement);
    }

    public TargetElement getTargetElementByID(String string) {
        for (TargetElement targetElement : this.targetElements) {
            if (targetElement.getObjectID() == null || !targetElement.getObjectID().equals(string)) continue;
            return targetElement;
        }
        return null;
    }

    @Override
    public boolean setName(String string) {
        boolean bl = super.setName(string);
        if (this.isComposite() && this.diagram != null) {
            this.diagram.setName(MessageFormat.format(Messages.getString("Process.Diagram"), this.getName()));
        }
        return bl;
    }

    @Override
    public void copy(DesignObject designObject) {
        Process process = (Process)designObject;
        super.copy(designObject);
        process.setSynonym(this.getSynonym());
        process.setFilterCondition(this.getFilterCondition());
        process.setJoinCondition(this.getJoinCondition());
        process.setType(this.getType());
        process.setTransformationTask(this.getTransformationTask());
        process.setFootNote(this.getFootNote());
        process.setMode(this.getMode());
        process.setBatchMinimumTransactions(this.getBatchMinimumTransactions());
        process.setBatchTimeUnit(this.getBatchTimeUnit());
        process.setInteractiveLongestResponseTime(this.getInteractiveLongestResponseTime());
        process.setInteractiveResponseTimeUnit(this.getInteractiveResponseTimeUnit());
        process.setFrequencyTimes(this.getFrequencyTimes());
        process.setFrequencyTimeUnit(this.getFrequencyTimeUnit());
        process.setPriority(this.getPriority());
        process.setPeakPeriodsString(this.getPeakPeriodsString());
        for (Event event : this.getEvents()) {
            process.addEvent(event);
        }
    }

    public class ParamWrapper {
        ParameterObject param;
        DesignObject mappedObject;

        public ParamWrapper(ParameterObject parameterObject) {
            this.param = parameterObject;
        }

        public DesignObject getMappedObject() {
            return this.mappedObject;
        }

        public void setMappedObject(DesignObject designObject) {
            this.mappedObject = designObject;
        }

        public ParameterObject getParam() {
            return this.param;
        }
    }

    public class ProcessedObject {
        private DesignObject object;
        private boolean opCreate;
        private boolean opRead;
        private boolean opUpdate;
        private boolean opDelete;
        private Flow flow;
        private boolean inbound = false;

        public DesignObject getObject() {
            return this.object;
        }

        public void setObject(DesignObject designObject) {
            this.object = designObject;
        }

        public boolean isOpCreate() {
            return this.opCreate;
        }

        public void setOpCreate(boolean bl) {
            this.opCreate = bl;
        }

        public boolean isOpDelete() {
            return this.opDelete;
        }

        public void setOpDelete(boolean bl) {
            this.opDelete = bl;
        }

        public boolean isOpRead() {
            return this.opRead;
        }

        public void setOpRead(boolean bl) {
            this.opRead = bl;
        }

        public boolean isOpUpdate() {
            return this.opUpdate;
        }

        public void setOpUpdate(boolean bl) {
            this.opUpdate = bl;
        }

        public Flow getFlow() {
            return this.flow;
        }

        public void setFlow(Flow flow) {
            this.flow = flow;
        }

        public boolean isInbound() {
            return this.inbound;
        }

        public void setInbound(boolean bl) {
            this.inbound = bl;
        }
    }
}

