/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.editor.process.InfoStructurePropertiesDialogEx;

public class InfoStructure
extends AbstractProcessObject {
    public static final String[] GROWTH_RATE_UNITS_DISPLAY = new String[]{Messages.getString("InfoStructure.Day"), Messages.getString("InfoStructure.Month"), Messages.getString("InfoStructure.Year")};
    public static final String[] GROWTH_RATE_UNITS = new String[]{"Day", "Month", "Year"};
    private List attributes = new ArrayList();
    private int volume = 0;
    private int growthRatePercent = 0;
    private String growthRateUnit = GROWTH_RATE_UNITS[0];
    private List flows = new ArrayList();
    public static final String TYPE_NAME = "InfoStructure";

    public InfoStructure(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "ISTR";
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public void removeAttribute(Attribute attribute) {
        this.attributes.remove(attribute);
    }

    public List getProcesses() {
        return null;
    }

    public List getInfoFlows() {
        ModelIDObject modelIDObject;
        Iterator iterator;
        ModelIDObject modelIDObject2;
        this.flows.clear();
        Iterator iterator2 = this.getDesign().getProcessModel().getDataFlowDesigns().iterator();
        while (iterator2.hasNext()) {
            modelIDObject2 = (DataFlowDesign)iterator2.next();
            iterator = ((DataFlowDesign)modelIDObject2).getFlowSet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (Flow)iterator.next();
                if (!((Flow)modelIDObject).getInfoStructures().contains(this) || this.flows.contains(modelIDObject)) continue;
                this.flows.add(modelIDObject);
            }
        }
        iterator2 = this.getDesign().getProcessModel().getTransformationPackageSet().iterator();
        while (iterator2.hasNext()) {
            modelIDObject2 = (TransformationPackage)iterator2.next();
            iterator = ((TransformationPackage)modelIDObject2).getTransformationTaskSet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (TransformationTask)iterator.next();
                Iterator iterator3 = ((TransformationTask)modelIDObject).getFlowSet().iterator();
                while (iterator3.hasNext()) {
                    Flow flow = (Flow)iterator3.next();
                    if (!flow.getInfoStructures().contains(this) || this.flows.contains(flow)) continue;
                    this.flows.add(flow);
                }
            }
        }
        return this.flows;
    }

    public void removeFromFlows() {
        for (Flow flow : this.getInfoFlows()) {
            flow.getInfoStructures().remove(this);
        }
    }

    public int getGrowthRatePercent() {
        return this.growthRatePercent;
    }

    public void setGrowthRatePercent(int n) {
        this.growthRatePercent = n;
    }

    public String getGrowthRateUnit() {
        return this.growthRateUnit;
    }

    public void setGrowthRateUnit(String string) {
        this.growthRateUnit = string;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int n) {
        this.volume = n;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            InfoStructurePropertiesDialogEx infoStructurePropertiesDialogEx = new InfoStructurePropertiesDialogEx(this.getDesign().getAppView(), this);
            infoStructurePropertiesDialogEx.initProperties(this);
            infoStructurePropertiesDialogEx.show();
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "infostructure/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Attribute getAttributeByID(String string) {
        for (Attribute attribute : this.attributes) {
            if (!attribute.getObjectID().equals(string)) continue;
            return attribute;
        }
        return null;
    }
}

