/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.swingui.editor.process.AgentPropertiesDialogEx;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class ExternalAgent
extends AbstractProcessObject
implements EditableFonts {
    public static final int TYPE_ORGANIZATIONAL_UNIT = 0;
    public static final int TYPE_SYSTEM = 1;
    public static final int TYPE_ROLE = 2;
    public static final int TYPE_OTHER = 3;
    public static final String[] FILE_TYPES_DISPLAY = new String[]{Messages.getString("ExternalAgent.CSV"), Messages.getString("ExternalAgent.FixedLengthFields"), Messages.getString("ExternalAgent.Excel"), Messages.getString("ExternalAgent.PlainText")};
    public static final String[] FILE_TYPES_INTERNAL = new String[]{"CSV", "Fixed Length Fields", "Excel", "Plain Text"};
    public static final String[] TRANSFER_TYPES_DISPLAY = new String[]{Messages.getString("ExternalAgent.FullRefresh"), Messages.getString("ExternalAgent.ChangesCapture"), Messages.getString("ExternalAgent.TriggeredCapture"), Messages.getString("ExternalAgent.ApplicationAssistedCapture"), Messages.getString("ExternalAgent.TimeStampBasedCapture"), Messages.getString("ExternalAgent.FileComparisonCapture")};
    public static final String[] TRANSFER_TYPES_INTERNAL = new String[]{"Full Refresh", "Changes Capture", "Triggered Capture", "Application Assisted Capture", "Time-Stamp based Capture", "File Comparison Capture"};
    private int type = 3;
    private String owner = "";
    private String source = "";
    private String fileName = "";
    private String location = "";
    private String fileType = FILE_TYPES_INTERNAL[0];
    private String fieldSeparator = ",";
    private String transferType = TRANSFER_TYPES_INTERNAL[0];
    private List externalDatas = new ArrayList();
    private boolean isSelfDescribing = false;
    private int skipRecords = 0;
    private String textDelimiter = "";
    private List editableFonts;
    public static final String TYPE_NAME = "ExtAgent";

    public ExternalAgent(DesignPart designPart) {
        super(designPart);
        this.initEditableFonts();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "EXA";
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            AgentPropertiesDialogEx agentPropertiesDialogEx = new AgentPropertiesDialogEx(this.getDesign().getAppView(), this);
            agentPropertiesDialogEx.initProperties(this);
            agentPropertiesDialogEx.show();
        }
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String string) {
        this.fieldSeparator = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String string) {
        this.fileType = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public String getTransferType() {
        return this.transferType;
    }

    public void setTransferType(String string) {
        this.transferType = string;
    }

    public void addExternalData(ExternalData externalData) {
        if (!this.externalDatas.contains(externalData)) {
            this.externalDatas.add(externalData);
        }
    }

    public void removeExtData(ExternalData externalData) {
        this.externalDatas.remove(externalData);
        externalData.remove();
    }

    public ExternalData createExternalData() {
        ExternalData externalData = ((DataFlowDesign)this.getDesignPart()).createExternalData();
        this.addExternalData(externalData);
        return externalData;
    }

    public void removeInfoStructure(ExternalData externalData) {
        this.externalDatas.remove(externalData);
    }

    public List getExternalDatas() {
        return this.externalDatas;
    }

    public ExternalData getExternalDataByID(String string) {
        for (ExternalData externalData : this.externalDatas) {
            if (!externalData.getObjectID().equals(string)) continue;
            return externalData;
        }
        return null;
    }

    public List getAttributes() {
        Iterator iterator;
        List list;
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        for (Flow flow : this.getOutgoingFlows()) {
            list = flow.getInfoStructures();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                for (DesignObject designObject : ((InfoStructure)iterator.next()).getAttributes()) {
                    if (arrayList.contains(designObject)) continue;
                    arrayList.add(designObject);
                }
            }
        }
        for (Flow flow : this.getIncomingFlows()) {
            list = flow.getInfoStructures();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                for (DesignObject designObject : ((InfoStructure)iterator.next()).getAttributes()) {
                    if (arrayList.contains(designObject)) continue;
                    arrayList.add(designObject);
                }
            }
        }
        return arrayList;
    }

    public boolean isSelfDescribing() {
        return this.isSelfDescribing;
    }

    public void setSelfDescribing(boolean bl) {
        this.isSelfDescribing = bl;
    }

    public int getSkipRecords() {
        return this.skipRecords;
    }

    public void setSkipRecords(int n) {
        this.skipRecords = n;
    }

    public String getTextDelimiter() {
        return this.textDelimiter;
    }

    public void setTextDelimiter(String string) {
        this.textDelimiter = string;
    }

    private void initEditableFonts() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && this.getDesignPart().getAppView() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject("External Agent")) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    @Override
    public void resetFontsAndColors(boolean bl) {
        if (bl) {
            DefaultFontAndColor defaultFontAndColor;
            this.editableFonts.clear();
            if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject("External Agent")) != null) {
                for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                    this.editableFonts.add(fontObject.copy());
                }
            }
            this.setBackgroundColor(null);
            this.setForegroundColor(null);
            this.setUseDefaultColor(true);
        } else if (DefaultFontAndColor.isModified("External Agent")) {
            DefaultFontAndColor defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject("External Agent");
            if (defaultFontAndColor != null) {
                if (this.getBackgroundColor() == null) {
                    this.setBackgroundColor(defaultFontAndColor.getBackgroundColor());
                }
                if (this.getForegroundColor() == null) {
                    this.setForegroundColor(defaultFontAndColor.getForegroundColor());
                }
            }
            this.setUseDefaultColor(bl);
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "agent/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void copy(DesignObject designObject) {
        ExternalAgent externalAgent = (ExternalAgent)designObject;
        super.copy(designObject);
        externalAgent.setSynonym(this.getSynonym());
        externalAgent.setType(this.getType());
        externalAgent.setOwner(this.getOwner());
        externalAgent.setSource(this.getSource());
        externalAgent.setFileName(this.getFileName());
        externalAgent.setLocation(this.getLocation());
        externalAgent.setFileType(this.getFileType());
        externalAgent.setFieldSeparator(this.getFieldSeparator());
        externalAgent.setTransferType(this.getTransferType());
        externalAgent.setSelfDescribing(this.isSelfDescribing);
        externalAgent.setSkipRecords(this.getSkipRecords());
        externalAgent.setTextDelimiter(this.getTextDelimiter());
        for (ExternalData externalData : this.getExternalDatas()) {
            ExternalData externalData2 = externalAgent.createExternalData();
            externalData2.setName(externalData.getName());
            externalData2.setComment(externalData.getComment());
            externalData2.setType(externalData.getType());
            externalData2.setStartingPos(externalData.getStartingPos());
            externalData2.setDescription(externalData.getDescription());
            externalData2.setStructured(externalData.isStructured());
            externalData2.setRecordStructure(externalData.getRecordStructure());
        }
    }
}

