/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.util.GUID;

public class DataFlowDesignSet
extends ModelIDObjectSet {
    private static final ModelIDObject[] PROTO_ARRAY = new DataFlowDesign[0];
    private Object elDescriptor;
    private ProcessModel processModel;
    private Design dsn;

    public DataFlowDesignSet(ProcessModel processModel) {
        this.processModel = processModel;
        this.setDesign(processModel.getDesign());
        this.setElementDescriptor(DataFlowDesign.class);
    }

    @Override
    public ModelIDObject createElement(String string) {
        DataFlowDesign dataFlowDesign = new DataFlowDesign(this.getProcessModel());
        dataFlowDesign.setDesign(this.getDesign());
        if (string == null || "".equalsIgnoreCase(string)) {
            dataFlowDesign.setObjectID(new GUID().toString());
        } else {
            dataFlowDesign.setObjectID(string);
        }
        dataFlowDesign.setName(this.createName());
        dataFlowDesign.setParent(this);
        this.add(dataFlowDesign);
        return dataFlowDesign;
    }

    public ModelIDObject createElement(String string, boolean bl) {
        DataFlowDesign dataFlowDesign = new DataFlowDesign(this.getProcessModel(), bl);
        dataFlowDesign.setDesign(this.getDesign());
        if (string == null || "".equalsIgnoreCase(string)) {
            dataFlowDesign.createGlobalID();
        } else {
            dataFlowDesign.setObjectID(string);
        }
        dataFlowDesign.setName(this.createName());
        dataFlowDesign.setParent(this);
        this.add(dataFlowDesign);
        return dataFlowDesign;
    }

    @Override
    protected String createName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDefaultNamePrefix());
        stringBuffer.append(this.getSeparator());
        int n = this.size() + 1;
        while (this.getByName(stringBuffer.toString() + String.valueOf(n)) != null) {
            ++n;
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "Data Flow Diagram";
    }

    @Override
    public boolean canCreateElement() {
        return true;
    }

    public ProcessModel getProcessModel() {
        return this.processModel;
    }

    public Object getElementDescriptor() {
        return this.elDescriptor;
    }

    public void setElementDescriptor(Object object) {
        this.elDescriptor = object;
    }

    @Override
    public Design getDesign() {
        return this.dsn;
    }

    @Override
    public void setDesign(Design design) {
        this.dsn = design;
    }

    public void orderDataFlowDesigns() {
        ArrayList<DFDHelper> arrayList = new ArrayList<DFDHelper>();
        ArrayList<DFDHelper> arrayList2 = new ArrayList<DFDHelper>();
        for (int i = 0; i < this.elements.size(); ++i) {
            DataFlowDesign object = (DataFlowDesign)this.elements.get(i);
            DFDHelper dFDHelper = new DFDHelper();
            dFDHelper.id = object.getObjectID();
            dFDHelper.object = object;
            dFDHelper.parent_id = object.getParentDFD_ID();
            dFDHelper.top_level_dfd_design = object.isTopLevel();
            if (dFDHelper == null) continue;
            if (dFDHelper.top_level_dfd_design) {
                arrayList2.add(0, dFDHelper);
                continue;
            }
            arrayList.add(dFDHelper);
        }
        this.orderDFDs_byParent(arrayList, arrayList2);
        if (this.elements.size() == arrayList2.size()) {
            this.elements.clear();
            this.elementsList.clear();
            for (DFDHelper dFDHelper : arrayList2) {
                this.elements.add(dFDHelper.object);
            }
        }
    }

    public void addOrderedDataFlowDesigns(List list) {
        ArrayList<DFDHelper> arrayList = new ArrayList<DFDHelper>();
        ArrayList<DFDHelper> arrayList2 = new ArrayList<DFDHelper>();
        for (int i = 0; i < this.elements.size(); ++i) {
            DataFlowDesign object = (DataFlowDesign)this.elements.get(i);
            DFDHelper dFDHelper = new DFDHelper();
            dFDHelper.id = object.getObjectID();
            dFDHelper.object = object;
            dFDHelper.parent_id = object.getParentDFD_ID();
            dFDHelper.top_level_dfd_design = object.isTopLevel();
            if (dFDHelper == null) continue;
            if (dFDHelper.top_level_dfd_design) {
                arrayList2.add(0, dFDHelper);
                continue;
            }
            arrayList.add(dFDHelper);
        }
        this.orderDFDs_byParent(arrayList, arrayList2);
        for (DFDHelper dFDHelper : arrayList2) {
            list.add(dFDHelper.object);
        }
    }

    private void orderDFDs_byParent(List list, List list2) {
        for (DFDHelper dFDHelper : list) {
            if (list2.contains(dFDHelper)) continue;
            this.addParent(dFDHelper, list, list2);
            list2.add(dFDHelper);
        }
    }

    private void addParent(DFDHelper dFDHelper, List list, List list2) {
        if (dFDHelper.parent_id != null) {
            for (int i = 0; i < list.size(); ++i) {
                DFDHelper dFDHelper2 = (DFDHelper)list.get(i);
                if (!dFDHelper2.id.equals(dFDHelper.parent_id)) continue;
                this.addParent(dFDHelper2, list, list2);
                if (list2.contains(dFDHelper2)) continue;
                list2.add(dFDHelper2);
            }
        }
    }

    class DFDHelper {
        public String id;
        public String parent_id;
        public boolean top_level_dfd_design;
        public DataFlowDesign object;

        DFDHelper() {
        }
    }
}

