/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignEvent;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesignSet;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.ExternalAgentSet;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ExternalDataSet;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.FlowSet;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStoreSet;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.ProcessSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.process.DataFlowModelPropertiesDialog;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.swingui.process.TVProcess;

public class DataFlowDesign
extends DesignPart {
    public static final String OBJECT_TYPE_NAME = "Data Flow Diagram";
    public static final String AGENT_SET_NAME = "Agents";
    public static final String FLOW_SET_NAME = "Flows";
    public static final String NOTE_SET_NAME = "Notes";
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    private ProcessModel processModel;
    protected DesignPartView mainView;
    private ProcessSet processSet;
    private FlowSet flowSet;
    private ExternalAgentSet externalAgentSet;
    DesignObjectCollection agents;
    DesignObjectCollection extProcesses;
    DesignObjectCollection stores;
    private NoteSet noteSet;
    private boolean topLevel = true;
    private Process process;
    private List processOrderList = new ArrayList();
    private boolean clean = false;
    private String processOrderString = "";
    private String parentDFD_ID = "";
    private boolean pmDirty = false;

    public DataFlowDesign(ProcessModel processModel) {
        this.setDesign(processModel.getDesign());
        this.processModel = processModel;
        this.processModel.setDirty(true);
        this.clean = false;
    }

    public DataFlowDesign(ProcessModel processModel, boolean bl) {
        this.setDesign(processModel.getDesign());
        this.processModel = processModel;
        this.topLevel = bl;
        this.processModel.setDirty(true);
        this.clean = false;
    }

    public ProcessModel getProcessModel() {
        return this.processModel;
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList arrayList = new ArrayList();
        this.getProcessSet().addAllElementsTo(arrayList);
        this.getExternalAgentSet().addAllElementsTo(arrayList);
        this.getInfoStoreSet().addAllElementsTo(arrayList);
        this.getFlowSet().addAllElementsTo(arrayList);
        this.getNoteSet().addAllElementsTo(arrayList);
        this.getDiagramViewSet().addAllElementsTo(arrayList);
        return arrayList;
    }

    public ExternalAgentSet getExternalAgentSet() {
        if (this.externalAgentSet == null) {
            if (this.process == null) {
                this.externalAgentSet = new ExternalAgentSet(this);
                this.externalAgentSet.setDesign(this.getDesign());
                this.externalAgentSet.setName(Messages.getString("DataFlowDesign.AllExternalAgents"));
                this.externalAgentSet.setParent(this);
            } else {
                this.externalAgentSet = this.getTLExternalAgentSet();
            }
            this.externalAgentSet.addSetListener(this);
        }
        return this.externalAgentSet;
    }

    public ExternalAgentSet getOwnExternalAgentSet() {
        if (this.process == null) {
            return this.getExternalAgentSet();
        }
        return null;
    }

    public FlowSet getFlowSet() {
        if (this.flowSet == null) {
            this.flowSet = new FlowSet(this);
            this.flowSet.setDesign(this.getDesign());
            this.flowSet.setName(Messages.getString("DataFlowDesign.Flows"));
            this.flowSet.setParent(this);
            this.flowSet.addSetListener(this);
        }
        return this.flowSet;
    }

    public InfoStoreSet getInfoStoreSet() {
        return this.getProcessModel().getInfoStoreSet();
    }

    public static final String getProcessSetName() {
        return Messages.getString("DataFlowDesign.Processes");
    }

    public ProcessSet getProcessSet() {
        if (this.processSet == null) {
            this.processSet = new ProcessSet(this);
            this.processSet.setDesign(this.getDesign());
            this.processSet.setName(Messages.getString("DataFlowDesign.Processes"));
            this.processSet.setParent(this);
            this.processSet.addSetListener(this);
        }
        return this.processSet;
    }

    @Override
    public NoteSet getNoteSet() {
        if (this.noteSet == null) {
            this.noteSet = new NoteSet(this);
            this.noteSet.setDesign(this.getDesign());
            this.noteSet.setName(Messages.getString("DataFlowDesign.Notes"));
            this.noteSet.setParent(this);
            this.noteSet.addSetListener(this);
        }
        return this.noteSet;
    }

    public ExternalDataSet getExternalDataSet() {
        return this.getProcessModel().getExternalDataSet();
    }

    public Process createProcess() {
        Process process = this.getProcessSet().createProcess(null);
        return process;
    }

    public int getProcessNumber(Process process) {
        int n = this.processOrderList.indexOf(process);
        return n + 1;
    }

    public Flow createFlow() {
        return this.getFlowSet().createFlow(null);
    }

    public ExternalAgent createExternalAgent() {
        return this.getExternalAgentSet().createExternalAgent(null);
    }

    public InfoStore createInfoStore() {
        return this.getInfoStoreSet().createInfoStore(null);
    }

    @Override
    public Note createNote() {
        Note note = this.getNoteSet().createNote(null);
        return note;
    }

    @Override
    public Note recreateNote(String string) {
        return this.getNoteSet().createNote(string);
    }

    public ExternalData createExternalData() {
        return this.getExternalDataSet().createExternalData(null);
    }

    @Override
    public void setDirty(boolean bl) {
        super.setDirty(bl);
        if (bl) {
            this.processModel.setDirty(bl);
        }
    }

    @Override
    public void clearAll() {
        for (int i = 0; i < this.getProcessSet().size(); ++i) {
            Process process = (Process)this.getProcessSet().getChild(i);
            process.clearDiagram();
        }
        this.removeGlobals();
        this.getProcessSet().removeAll();
        this.getFlowSet().removeAll();
        this.getNoteSet().removeAll();
        this.getDiagramViewSet().removeAll();
        this.clearDocuments();
        this.clearResponsibleParties();
        this.setComment("");
        this.setNotes("");
        this.clean = true;
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
    }

    @Override
    public void sortCollections() {
        this.getProcessSet().sort();
        this.getFlowSet().sort();
        this.getExternalAgentSet().sort();
        this.getInfoStoreSet().sort();
        this.getExternalDataSet().sort();
    }

    private void removeGlobals() {
        ContainerView containerView;
        AbstractProcessObject abstractProcessObject;
        DesignObjectPlaceHolder designObjectPlaceHolder;
        int n;
        DesignPartView designPartView = this.getMainView();
        Object[] objectArray = this.getAgents().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            designObjectPlaceHolder = (DesignObjectPlaceHolder)objectArray[n];
            abstractProcessObject = (AbstractProcessObject)designObjectPlaceHolder.getDesignObject();
            containerView = (ContainerView)abstractProcessObject.getFirstViewForDPV(designPartView);
            if (containerView == null) continue;
            containerView.remove(false);
        }
        objectArray = this.getAgents().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            designObjectPlaceHolder = (DesignObjectPlaceHolder)objectArray[n];
            abstractProcessObject = (AbstractProcessObject)designObjectPlaceHolder.getDesignObject();
            containerView = (ContainerView)abstractProcessObject.getFirstViewForDPV(designPartView);
            if (containerView == null) continue;
            containerView.remove(false);
        }
    }

    @Override
    public int getNumberOfChildren() {
        if (this.isLoaded()) {
            if (this.process != null) {
                return 5;
            }
            return 5;
        }
        return 0;
    }

    @Override
    public ModelObject getChild(int n) {
        if (this.process != null) {
            switch (n) {
                case 0: {
                    return this.getProcessSet();
                }
                case 1: {
                    return this.getExtProcesses();
                }
                case 2: {
                    return this.getStores();
                }
                case 3: {
                    return this.getAgents();
                }
                case 4: {
                    return this.getFlowSet();
                }
            }
            return null;
        }
        switch (n) {
            case 0: {
                return this.getProcessSet();
            }
            case 1: {
                return this.getStores();
            }
            case 2: {
                return this.getAgents();
            }
            case 3: {
                return this.getFlowSet();
            }
            case 4: {
                return this.getExternalAgentSet();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (this.process != null) {
            if (modelObject == this.getProcessSet()) {
                return 0;
            }
            if (modelObject == this.getExtProcesses()) {
                return 1;
            }
            if (modelObject == this.getStores()) {
                return 2;
            }
            if (modelObject == this.getAgents()) {
                return 3;
            }
            if (modelObject == this.getFlowSet()) {
                return 4;
            }
            return -1;
        }
        if (modelObject == this.getProcessSet()) {
            return 0;
        }
        if (modelObject == this.getStores()) {
            return 1;
        }
        if (modelObject == this.getAgents()) {
            return 2;
        }
        if (modelObject == this.getFlowSet()) {
            return 3;
        }
        if (modelObject == this.getExternalAgentSet()) {
            return 4;
        }
        return -1;
    }

    @Override
    protected DesignPartView createDesignPartSubView(String string) {
        return null;
    }

    @Override
    public DesignPartView getMainView() {
        if (this.mainView == null) {
            this.mainView = new DPVProcess(this.getDesign().getAppView(), this);
            this.mainView.setDPVId(this.getDesign().getAppView().getIDGenerator().createNewID());
        }
        return this.mainView;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "DFD";
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (setEvent == SetEvent.OBJECT_ADDED) {
            this.fireAdded(setEvent.getAffected());
        } else if (setEvent == SetEvent.OBJECT_REMOVED) {
            if (this.process != null) {
                DesignObject designObject = setEvent.getAffected();
                if (this.agents != null && designObject instanceof ExternalAgent) {
                    this.agents.removePlaceHolderFor(designObject);
                }
                if (this.stores != null && designObject instanceof InfoStore) {
                    this.stores.removePlaceHolderFor(setEvent.getAffected());
                }
            }
            if (setEvent.getAffected() instanceof Process) {
                this.processOrderList.remove(setEvent.getAffected());
            }
            this.fireRemoved(setEvent.getAffected());
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> arrayList = new ArrayList<DesignObjectSet>();
        if (this.process == null) {
            arrayList.add(this.getExternalAgentSet());
        }
        arrayList.add(this.getProcessSet());
        arrayList.add(this.getFlowSet());
        arrayList.add(this.getNoteSet());
        return arrayList;
    }

    @Override
    public void doBeforeLoad() {
        this.pmDirty = this.getProcessModel().isDirty();
        this.getProcessModel().setDataFlowDesign(this);
    }

    @Override
    public void doAfterLoad() {
        this.presetProcessOrder();
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.getProcessModel().setDirty(this.pmDirty);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void load() {
        boolean bl = this.getProcessModel().isDirty();
        this.getProcessModel().setDataFlowDesign(this);
        XMLPersistenceManager xMLPersistenceManager = this.getDesign().getAppView().getPersistenceManager();
        AbstractXMLReader abstractXMLReader = xMLPersistenceManager.getDesignPartReader(this);
        if (abstractXMLReader != null) {
            abstractXMLReader.recreateDesign(this.getObjectID(), (DesignPart)this, false);
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.getProcessModel().setDirty(bl);
        this.checkAndSetIDGenerator();
    }

    @Override
    public String getName() {
        if (this.process != null) {
            return MessageFormat.format(Messages.getString("Process.Diagram"), this.process.getName());
        }
        return super.getName();
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
        if (process != null) {
            this.setParent(process);
        }
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    public void setTopLevel(boolean bl) {
        this.topLevel = bl;
        this.fireDFD_TopLevelChanged(new DesignEvent("DFD top level flag changed"));
    }

    public Collection getFlowsForProcessObject(AbstractProcessObject abstractProcessObject) {
        ArrayList<Flow> arrayList = new ArrayList<Flow>();
        Iterator iterator = this.getFlowSet().iterator();
        while (iterator.hasNext()) {
            Flow flow = (Flow)iterator.next();
            if (abstractProcessObject != flow.getSourceProcessObject() && abstractProcessObject != flow.getTargetProcessObject()) continue;
            arrayList.add(flow);
        }
        return arrayList;
    }

    private ExternalAgentSet getTLExternalAgentSet() {
        if (this.process != null) {
            return ((DataFlowDesign)this.process.getDesignPart()).getExternalAgentSet();
        }
        if (this.externalAgentSet == null) {
            this.externalAgentSet = new ExternalAgentSet(this);
            this.externalAgentSet.setDesign(this.getDesign());
            this.externalAgentSet.setName(Messages.getString("DataFlowDesign.ExternalAgents"));
            this.externalAgentSet.setParent(this);
            this.externalAgentSet.addSetListener(this);
        }
        return this.externalAgentSet;
    }

    public void registerLocalObject(TopView topView) {
        DesignObject designObject = topView.getModel();
        if (designObject != null) {
            Process process;
            if (designObject instanceof ExternalAgent && !this.getAgents().containsPlaceHolderFor(designObject)) {
                this.getAgents().add(new DesignObjectPlaceHolder((DesignPart)this, designObject));
            } else if (designObject instanceof InfoStore && !this.getStores().containsPlaceHolderFor(designObject)) {
                this.getStores().add(new DesignObjectPlaceHolder((DesignPart)this, designObject));
            } else if (designObject instanceof Process && !this.getExtProcesses().containsPlaceHolderFor(designObject) && (process = (Process)designObject).getDesignPart() != this) {
                this.getExtProcesses().add(new DesignObjectPlaceHolder((DesignPart)this, designObject));
            }
        }
    }

    public void unRegisterLocalObject(TopView topView) {
        DesignObject designObject = topView.getModel();
        if (designObject != null) {
            if (designObject instanceof ExternalAgent) {
                this.getAgents().removePlaceHolderFor(designObject);
            } else if (designObject instanceof InfoStore) {
                this.getStores().removePlaceHolderFor(designObject);
            } else if (designObject instanceof Process) {
                this.getExtProcesses().removePlaceHolderFor(designObject);
            }
        }
    }

    public DesignObjectCollection getStores() {
        if (this.stores == null) {
            this.stores = new DesignObjectCollection();
            this.stores.setDesign(this.getDesign());
            this.stores.setName(Messages.getString("DataFlowDesign.UsedInformationStores"));
            this.stores.setElementDescriptor(InfoStore.class);
            this.stores.setParent(this);
        }
        return this.stores;
    }

    public DesignObjectCollection getAgents() {
        if (this.agents == null) {
            this.agents = new DesignObjectCollection();
            this.agents.setDesign(this.getDesign());
            this.agents.setName(Messages.getString("DataFlowDesign.UsedExternalAgents"));
            this.agents.setElementDescriptor(ExternalAgent.class);
            this.agents.setParent(this);
        }
        return this.agents;
    }

    public DesignObjectCollection getExtProcesses() {
        if (this.extProcesses == null) {
            this.extProcesses = new DesignObjectCollection();
            this.extProcesses.setDesign(this.getDesign());
            this.extProcesses.setName(Messages.getString("DataFlowDesign.OuterProcesses"));
            this.extProcesses.setParent(this);
        }
        return this.extProcesses;
    }

    public Collection getComponentFlowsFor(Flow flow) {
        ArrayList<Flow> arrayList = new ArrayList<Flow>();
        Iterator iterator = this.getFlowSet().iterator();
        while (iterator.hasNext()) {
            Flow flow2 = (Flow)iterator.next();
            if (flow2.getParentObject() != flow) continue;
            arrayList.add(flow2);
        }
        return arrayList;
    }

    public DataFlowDesign getParentDataFlowdesign() {
        if (this.process != null) {
            return (DataFlowDesign)this.process.getDesignPart();
        }
        return null;
    }

    public Flow getFirstFlowBetween(AbstractProcessObject abstractProcessObject, AbstractProcessObject abstractProcessObject2) {
        Iterator iterator = this.getFlowSet().iterator();
        while (iterator.hasNext()) {
            Flow flow = (Flow)iterator.next();
            if (flow.getSourceProcessObject() != abstractProcessObject || flow.getTargetProcessObject() != abstractProcessObject2) continue;
            return flow;
        }
        return null;
    }

    public List getFlowsBetween(AbstractProcessObject abstractProcessObject, AbstractProcessObject abstractProcessObject2) {
        ArrayList<Flow> arrayList = new ArrayList<Flow>();
        Iterator iterator = this.getFlowSet().iterator();
        while (iterator.hasNext()) {
            Flow flow = (Flow)iterator.next();
            if (flow.getSourceProcessObject() != abstractProcessObject || flow.getTargetProcessObject() != abstractProcessObject2) continue;
            arrayList.add(flow);
        }
        return arrayList;
    }

    public Flow createFlowsBetween(AbstractDataFlowTV abstractDataFlowTV, AbstractDataFlowTV abstractDataFlowTV2) {
        DataFlowDesign dataFlowDesign;
        AbstractProcessObject abstractProcessObject = (AbstractProcessObject)abstractDataFlowTV.getModel();
        AbstractProcessObject abstractProcessObject2 = (AbstractProcessObject)abstractDataFlowTV2.getModel();
        DataFlowDesign dataFlowDesign2 = (DataFlowDesign)abstractDataFlowTV.getDesignPartView().getDesignPart();
        if (dataFlowDesign2 == (dataFlowDesign = (DataFlowDesign)abstractDataFlowTV2.getDesignPartView().getDesignPart()) && dataFlowDesign2 == this) {
            Flow flow = this.createFlow();
            flow.setSourceTV(abstractDataFlowTV);
            flow.setTargetTV(abstractDataFlowTV2);
            TVFlow tVFlow = (TVFlow)flow.getViewFor(this.getMainView());
            tVFlow.addConnection();
            return flow;
        }
        DataFlowDesign dataFlowDesign3 = this.getCommonParentDFD(dataFlowDesign2, dataFlowDesign);
        if (!(abstractProcessObject instanceof Process)) {
            this.createSynonyms(abstractProcessObject, dataFlowDesign, dataFlowDesign3);
            Flow flow = dataFlowDesign.createFlow();
            AbstractDataFlowTV abstractDataFlowTV3 = (AbstractDataFlowTV)((DPVProcess)dataFlowDesign.getMainView()).createViewSynonim(abstractProcessObject);
            flow.setSourceTV(abstractDataFlowTV3);
            flow.setTargetTV(abstractDataFlowTV2);
            TVFlow tVFlow = (TVFlow)flow.getViewFor(dataFlowDesign.getMainView());
            tVFlow.addConnection();
            return flow;
        }
        if (!(abstractProcessObject2 instanceof Process)) {
            this.createSynonyms(abstractProcessObject2, dataFlowDesign2, dataFlowDesign3);
            Flow flow = dataFlowDesign2.createFlow();
            flow.setSourceTV(abstractDataFlowTV);
            AbstractDataFlowTV abstractDataFlowTV4 = (AbstractDataFlowTV)((DPVProcess)dataFlowDesign2.getMainView()).createViewSynonim(abstractProcessObject2);
            flow.setTargetTV(abstractDataFlowTV4);
            TVFlow tVFlow = (TVFlow)flow.getViewFor(dataFlowDesign2.getMainView());
            tVFlow.addConnection();
            return flow;
        }
        return this.createFlowsBetweenLowLevelProcs((Process)abstractProcessObject, (Process)abstractProcessObject2, dataFlowDesign3);
    }

    private DataFlowDesign getCommonParentDFD(DataFlowDesign dataFlowDesign, DataFlowDesign dataFlowDesign2) {
        if (dataFlowDesign == dataFlowDesign2) {
            return dataFlowDesign;
        }
        for (DataFlowDesign dataFlowDesign3 = dataFlowDesign2.getParentDataFlowdesign(); dataFlowDesign3 != null; dataFlowDesign3 = dataFlowDesign3.getParentDataFlowdesign()) {
            if (dataFlowDesign != dataFlowDesign3) continue;
            return dataFlowDesign;
        }
        DataFlowDesign dataFlowDesign4 = dataFlowDesign.getParentDataFlowdesign();
        return this.getCommonParentDFD(dataFlowDesign4, dataFlowDesign2);
    }

    private void createSynonyms(AbstractProcessObject abstractProcessObject, DataFlowDesign dataFlowDesign, DataFlowDesign dataFlowDesign2) {
        DataFlowDesign dataFlowDesign3;
        if (abstractProcessObject instanceof Process) {
            return;
        }
        ((DPVProcess)dataFlowDesign.getMainView()).createViewSynonim(abstractProcessObject);
        if (dataFlowDesign == dataFlowDesign2) {
            return;
        }
        for (dataFlowDesign3 = dataFlowDesign.getParentDataFlowdesign(); dataFlowDesign3 != null && dataFlowDesign3 != dataFlowDesign2; dataFlowDesign3 = dataFlowDesign3.getParentDataFlowdesign()) {
            ((DPVProcess)dataFlowDesign3.getMainView()).createViewSynonim(abstractProcessObject);
        }
        if (dataFlowDesign3 != null) {
            ((DPVProcess)dataFlowDesign3.getMainView()).createViewSynonim(abstractProcessObject);
        }
    }

    private Flow createFlowsBetweenLowLevelProcs(Process process, Process process2, DataFlowDesign dataFlowDesign) {
        Process process3 = process.getParentProcessInDFD(dataFlowDesign);
        if (process3 == null) {
            process3 = process;
        }
        Flow flow = this.createAndPropagateForSource(process3, process2, dataFlowDesign);
        Process process4 = process2.getParentProcessInDFD(dataFlowDesign);
        if (process4 == null) {
            process4 = process2;
        }
        Flow flow2 = this.createAndPropagateForTarget(process, process4, dataFlowDesign);
        return flow != null ? flow : flow2;
    }

    private Flow createAndPropagateForSource(Process process, Process process2, DataFlowDesign dataFlowDesign) {
        Process process3;
        TVProcess tVProcess;
        TVProcess tVProcess2 = (TVProcess)process.getFirstViewForDPV(dataFlowDesign.getMainView());
        if (tVProcess2 == null) {
            tVProcess2 = (TVProcess)((DPVProcess)dataFlowDesign.getMainView()).createViewSynonim(process);
        }
        if ((tVProcess = (TVProcess)(process3 = process2.getParentProcessInDFD(dataFlowDesign)).getFirstViewForDPV(dataFlowDesign.getMainView())) == null) {
            tVProcess = (TVProcess)((DPVProcess)dataFlowDesign.getMainView()).createViewSynonim(process3);
        }
        Flow flow = dataFlowDesign.createFlow();
        flow.setSourceTV(tVProcess2);
        flow.setTargetTV(tVProcess);
        TVFlow tVFlow = (TVFlow)flow.getViewFor(dataFlowDesign.getMainView());
        tVFlow.addConnection();
        if (process3 != process2 && process3.isComposite()) {
            flow = this.createAndPropagateForSource(process, process2, process3.getDiagram());
        }
        return flow;
    }

    private Flow createAndPropagateForTarget(Process process, Process process2, DataFlowDesign dataFlowDesign) {
        Process process3;
        TVProcess tVProcess;
        TVProcess tVProcess2 = (TVProcess)process2.getFirstViewForDPV(dataFlowDesign.getMainView());
        if (tVProcess2 == null) {
            tVProcess2 = (TVProcess)((DPVProcess)dataFlowDesign.getMainView()).createViewSynonim(process2);
        }
        if ((tVProcess = (TVProcess)(process3 = process.getParentProcessInDFD(dataFlowDesign)).getFirstViewForDPV(dataFlowDesign.getMainView())) == null) {
            tVProcess = (TVProcess)((DPVProcess)dataFlowDesign.getMainView()).createViewSynonim(process3);
        }
        Flow flow = dataFlowDesign.createFlow();
        flow.setSourceTV(tVProcess);
        flow.setTargetTV(tVProcess2);
        TVFlow tVFlow = (TVFlow)flow.getViewFor(dataFlowDesign.getMainView());
        tVFlow.addConnection();
        if (process3 != process && process3.isComposite()) {
            flow = this.createAndPropagateForTarget(process, process2, process3.getDiagram());
        }
        return flow;
    }

    public List getAllProcesses() {
        ArrayList arrayList = new ArrayList();
        this.addAllProcesses(arrayList);
        return arrayList;
    }

    private void addAllProcesses(List list) {
        Iterator iterator = this.getProcessSet().iterator();
        while (iterator.hasNext()) {
            Process process = (Process)iterator.next();
            list.add(process);
            if (!process.isComposite()) continue;
            process.getDiagram().addAllProcesses(list);
        }
    }

    public List getAllFlows() {
        ArrayList arrayList = new ArrayList();
        this.addAllFlows(arrayList);
        return arrayList;
    }

    private void addAllFlows(List list) {
        this.getFlowSet().addAllElementsTo(list);
        Iterator iterator = this.getProcessSet().iterator();
        while (iterator.hasNext()) {
            Process process = (Process)iterator.next();
            if (!process.isComposite()) continue;
            process.getDiagram().addAllFlows(list);
        }
    }

    public List getAllPrimitiveProcesses() {
        ArrayList arrayList = new ArrayList();
        this.addAllPrimitiveProcesses(arrayList);
        return arrayList;
    }

    public void addAllPrimitiveProcesses(List list) {
        Iterator iterator = this.getProcessSet().iterator();
        while (iterator.hasNext()) {
            Process process = (Process)iterator.next();
            if (process.isComposite()) {
                process.getDiagram().addAllPrimitiveProcesses(list);
                continue;
            }
            list.add(process);
        }
    }

    public void addAllPrimitiveProcessesConnectedToStore(List list) {
        Iterator iterator = this.getProcessSet().iterator();
        while (iterator.hasNext()) {
            Process process = (Process)iterator.next();
            if (process.isComposite()) {
                process.getDiagram().addAllPrimitiveProcessesConnectedToStore(list);
                continue;
            }
            if (!process.isConnectedToStore()) continue;
            list.add(process);
        }
    }

    public DataFlowDesign getTopLevelDataFlowDesign() {
        if (this.isTopLevel()) {
            return this;
        }
        if (this.getParentDataFlowdesign() != null) {
            return this.getParentDataFlowdesign().getTopLevelDataFlowDesign();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public void updateFontsAndColors(boolean bl) {
        Object object;
        Iterator iterator = this.getProcessSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getExternalAgentSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getInfoStoreSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getNoteSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getFlowSet().iterator();
        while (iterator.hasNext()) {
            object = (DesignObject)iterator.next();
            if (bl) {
                ((DesignObject)object).setBackgroundColor(null);
            } else if (((DesignObject)object).getBackgroundColor() == null) {
                ((DesignObject)object).setBackgroundColor(((DesignObject)object).getTopView().getDefaultLineColor());
            }
            ((DesignObject)object).setUseDefaultColor(bl);
        }
        iterator = this.getLabelSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
    }

    public List getProcessOrderList() {
        return this.processOrderList;
    }

    public boolean isClean() {
        return this.clean;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DataFlowModelPropertiesDialog dataFlowModelPropertiesDialog = new DataFlowModelPropertiesDialog(this.getDesign().getAppView(), this);
            dataFlowModelPropertiesDialog.initProperties(this);
            dataFlowModelPropertiesDialog.show();
        }
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ExtAgent");
        arrayList.add("Process");
        arrayList.add(Flow.TYPE_NAME);
        arrayList.add("Note");
        arrayList.add("MainView");
        arrayList.add("SubView");
        return arrayList;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("agent", "ExtAgent");
            this.f2tMap.put("process", "Process");
            this.f2tMap.put("flow", Flow.TYPE_NAME);
            this.f2tMap.put("note", "Note");
        }
        return this.f2tMap;
    }

    @Override
    public String getStoragePath() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "pm/dflows/" + this.getObjectID()).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "pm/dflows/" + this.getObjectID() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public StorableObject createObject(String string, String string2, String string3) {
        DesignObject designObject = null;
        if ("Process".equalsIgnoreCase(string)) {
            designObject = this.getProcessSet().createProcess(string2);
        } else if ("ExtAgent".equalsIgnoreCase(string)) {
            designObject = this.getExternalAgentSet().createExternalAgent(string2);
        } else if (Flow.TYPE_NAME.equalsIgnoreCase(string)) {
            designObject = this.getFlowSet().createFlow(string2);
        } else if ("Note".equalsIgnoreCase(string)) {
            designObject = this.getNoteSet().createNote(string2);
        }
        if (designObject != null && string3 != null && string3.length() > 0) {
            ((DesignObject)designObject).setName(string3);
        }
        return designObject;
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        ProcessModel processModel;
        DesignObject designObject = null;
        designObject = this.getDesign().getDesignObject(string2);
        if (designObject != null) {
            return designObject;
        }
        if ("processModel".equalsIgnoreCase(string) && (processModel = this.getDesign().getProcessModel()).getObjectID().equals(string2)) {
            return processModel;
        }
        return super.translateIdToObject(string, string2);
    }

    public static void initObjectDetails(Design design, File file, String string, StorableObjectStatusHelper storableObjectStatusHelper, String string2) {
        Class<ModelIDObject> clazz;
        Object object;
        SVNObjectHelper sVNObjectHelper = SVNObjectHelper.getSVNObjectHelperFor(design, string2);
        if (sVNObjectHelper != null) {
            object = SVNObjectHelper.getSVNObjectHelperFor(design, sVNObjectHelper.parentID);
            while (object != null) {
                try {
                    clazz = Class.forName(((SVNObjectHelper)object).className);
                    if (clazz.isAssignableFrom(DataFlowDesign.class)) {
                        storableObjectStatusHelper.treePath.add(0, new TreePathHelper(((SVNObjectHelper)object).propName, new File(((SVNObjectHelper)object).fileName), clazz));
                        storableObjectStatusHelper.treePath.add(0, new TreePathHelper(ProcessModel.getDataFlowDesignSetName(), new File(((SVNObjectHelper)object).fileName).getParentFile(), clazz));
                    } else if (clazz.isAssignableFrom(Process.class)) {
                        storableObjectStatusHelper.treePath.add(0, new TreePathHelper(((SVNObjectHelper)object).propName, new File(((SVNObjectHelper)object).fileName), clazz));
                        storableObjectStatusHelper.treePath.add(0, new TreePathHelper(DataFlowDesign.getProcessSetName(), new File(((SVNObjectHelper)object).fileName).getParentFile(), clazz));
                    } else if (clazz.isAssignableFrom(ProcessModel.class)) {
                        storableObjectStatusHelper.treePath.add(0, new TreePathHelper("Process Model", new File(design.getProcessModel().getStorageName()), clazz));
                    }
                    if ((object = SVNObjectHelper.getSVNObjectHelperFor(design, ((SVNObjectHelper)object).parentID)) == null || !((SVNObjectHelper)object).className.endsWith("Process")) continue;
                    storableObjectStatusHelper.treePath.remove(0);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        if ("agent".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = ExternalAgent.class;
            storableObjectStatusHelper.objectType = "ExtAgent";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(AGENT_SET_NAME, file.getParentFile(), ExternalAgentSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((DataFlowDesign)storableObjectStatusHelper.designPart).getExternalAgentSet();
                storableObjectStatusHelper.storableObject = ((DataFlowDesign)storableObjectStatusHelper.designPart).getExternalAgentSet().getObjectByID(string2);
            }
        } else if ("process".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Process.class;
            storableObjectStatusHelper.objectType = "Process";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(DataFlowDesign.getProcessSetName(), file.getParentFile(), ProcessSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((DataFlowDesign)storableObjectStatusHelper.designPart).getProcessSet();
                storableObjectStatusHelper.storableObject = ((DataFlowDesign)storableObjectStatusHelper.designPart).getProcessSet().getObjectByID(string2);
            }
        } else if ("flow".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Flow.class;
            storableObjectStatusHelper.objectType = Flow.TYPE_NAME;
            storableObjectStatusHelper.treePath.add(new TreePathHelper(FLOW_SET_NAME, file.getParentFile(), FlowSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((DataFlowDesign)storableObjectStatusHelper.designPart).getFlowSet();
                storableObjectStatusHelper.storableObject = ((DataFlowDesign)storableObjectStatusHelper.designPart).getFlowSet().getObjectByID(string2);
            }
        } else if ("note".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Note.class;
            storableObjectStatusHelper.objectType = "Note";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(NOTE_SET_NAME, file.getParentFile(), NoteSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((DataFlowDesign)storableObjectStatusHelper.designPart).getNoteSet();
                storableObjectStatusHelper.storableObject = ((DataFlowDesign)storableObjectStatusHelper.designPart).getNoteSet().getObjectByID(string2);
            }
        } else if ("subviews".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = DPVProcess.class;
            if (sVNObjectHelper != null && (object = SVNObjectHelper.getSVNObjectHelperFor(design, sVNObjectHelper.parentID)) != null) {
                try {
                    clazz = Class.forName(((SVNObjectHelper)object).className);
                    if (clazz.isAssignableFrom(ProcessModel.class)) {
                        storableObjectStatusHelper.treePath.add(new TreePathHelper(ProcessModel.getDataFlowDesignSetName(), new File(sVNObjectHelper.fileName).getParentFile(), DataFlowDesignSet.class));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            storableObjectStatusHelper.treePath.add(new TreePathHelper(DIAGRAM_SET_NAME, file.getParentFile(), DPVProcess.class));
            if (storableObjectStatusHelper.designPart != null && storableObjectStatusHelper.designPart instanceof DataFlowDesign) {
                object = (DataFlowDesign)storableObjectStatusHelper.designPart;
                storableObjectStatusHelper.storableObject = ((DataFlowDesign)object).getMainView().getDPVId().equals(string2) ? ((DataFlowDesign)object).getMainView() : ((DesignPart)object).getSubViewByID(string2);
            }
        }
    }

    public String getProcessOrderString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (Process process : this.getProcessOrderList()) {
            if (!bl) {
                stringBuffer.append(",").append(process.getObjectID());
                continue;
            }
            stringBuffer.append(process.getObjectID());
            bl = false;
        }
        return stringBuffer.toString();
    }

    public void setProcessOrderString(String string) {
        this.processOrderString = string;
    }

    public void presetProcessOrder() {
        String[] stringArray;
        if (!"".equals(this.processOrderString) && (stringArray = this.processOrderString.split(",")).length > 0) {
            List list = this.getProcessOrderList();
            list.clear();
            for (int i = 0; i < stringArray.length; ++i) {
                DesignObject designObject = this.getProcessSet().getObjectByID(stringArray[i]);
                if (designObject == null) continue;
                list.add(designObject);
            }
            this.processOrderString = "";
        }
    }

    public String getParentDFD_ID() {
        if (this.getParentDataFlowdesign() != null) {
            return this.getParentDataFlowdesign().getObjectID();
        }
        return this.parentDFD_ID;
    }

    public void setParentDFD_ID(String string) {
        this.parentDFD_ID = string;
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        if (this.getMainView() != null) {
            this.getMainView().getWorkSpace().updateSettings();
        }
        this.sortCollections();
    }

    protected void fireDFD_TopLevelChanged(DesignEvent designEvent) {
        designEvent.setDesignPart(this);
        DesignListener[] designListenerArray = this.designListeners.toArray(new DesignListener[0]);
        for (int i = 0; i < designListenerArray.length; ++i) {
            try {
                if (designListenerArray[i] == null) continue;
                designListenerArray[i].designChanged(designEvent);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public List<Object> getObjectsWithMeasurements() {
        DesignObject designObject;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.getProcessSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Process)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getFlowSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Flow)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getExternalAgentSet().iterator();
        while (iterator.hasNext()) {
            designObject = (ExternalAgent)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getNoteSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Note)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        return arrayList;
    }
}

