/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.util.GUID;

public class SlowChangingAttribute
implements ID_ObjectPropertyTranslator {
    public static final String[] TYPES = new String[]{"NONE", "TYPE 1", "TYPE 2", "TYPE 3"};
    public static final String[] CLASSIFICATIONS = new String[]{"DEFAULT_ORDER", "END_DATE", "TIME_SPAN", "MEMBER_LONG_DESCRIPTION", "MEMBER_SHORT_DESCRIPTION", "MEMBER_VISIBLE", "USER"};
    private ContainedObject attribute;
    private List historyAttributes = new ArrayList();
    private String type = TYPES[0];
    private String classification = CLASSIFICATIONS[6];
    private String name;
    private boolean indexed;
    private String objectID;
    private Level level;
    public static final String NEW_NAME = "New_Descr_Attr";

    public SlowChangingAttribute(Level level, String string) {
        this.name = string != null ? string : NEW_NAME;
        this.level = level;
        this.objectID = new GUID().toString();
    }

    public SlowChangingAttribute(Level level, ContainedObject containedObject) {
        this(level, containedObject.getName());
        this.attribute = containedObject;
    }

    public SlowChangingAttribute(Level level, SlowChangingAttribute slowChangingAttribute) {
        this(level, slowChangingAttribute.getName());
        this.attribute = slowChangingAttribute.getAttribute();
        this.historyAttributes.addAll(slowChangingAttribute.getHistoryAttributes());
        this.type = slowChangingAttribute.getType();
        this.classification = slowChangingAttribute.getClassification();
        this.indexed = slowChangingAttribute.indexed;
    }

    public ContainedObject getAttribute() {
        return this.attribute;
    }

    public void setAttribute(ContainedObject containedObject) {
        this.attribute = containedObject;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String string) {
        this.classification = string;
    }

    public List getHistoryAttributes() {
        return this.historyAttributes;
    }

    public void addHistoryAttribute(ContainedObject containedObject) {
        this.historyAttributes.add(containedObject);
    }

    public void removeHistoryAttribute(ContainedObject containedObject) {
        this.historyAttributes.remove(containedObject);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        if (this.name == null) {
            if (this.attribute != null) {
                return this.attribute.getName();
            }
            return "";
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean bl) {
        this.indexed = bl;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String string) {
        this.objectID = string;
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        return this.level.translateIdToObject(string, string2);
    }

    @Override
    public String translateObjectToID(String string, Object object) {
        return this.level.translateObjectToID(string, object);
    }
}

