/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DesignPartListener;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.CubeSet;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.DimensionSet;
import oracle.dbtools.crest.model.design.multidimensional.EngineerFromOracle;
import oracle.dbtools.crest.model.design.multidimensional.EngineerToOracle;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoinSet;
import oracle.dbtools.crest.model.design.multidimensional.FromOracleModelSelector;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.HierarchySet;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.LevelSet;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.LinkSet;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolder;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolderCollection;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolderSet;
import oracle.dbtools.crest.model.design.multidimensional.MeasureSet;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesignSet;
import oracle.dbtools.crest.model.design.multidimensional.OracleModelSelector;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLinkSet;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.RollupLinkSet;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAWSet;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteriaSet;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.multidimensional.SliceSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalModelPropertiesDialog;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;
import oracle.dbtools.crest.swingui.multidimensional.DPVMultidimensional;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;

public class MultidimensionalDesign
extends DesignPart
implements ModelObjectSetListener,
ObjectListener,
DesignPartListener {
    public static final String OBJECT_TYPE_NAME = "Dimensional Model";
    public static final String OLD_OBJECT_TYPE_NAME = "Multidimensional Diagram";
    public static final String SEL_CRITERIA_SET_NAME = "Selection Criterias";
    public static final String LEVEL_SET_NAME = "Levels";
    public static final String ROLLUPLINK_SET_NAME = "RollupLinks";
    public static final String RAGGEDHLINK_SET_NAME = "Ragged Hierarchy Links";
    public static final String DIMENSION_SET_NAME = "Dimensions";
    public static final String MEASURE_SET_NAME = "Measures";
    public static final String SLICE_SET_NAME = "Slices";
    public static final String FE_JOINS_SET_NAME = "Fact Entities Joins";
    public static final String CUBE_SET_NAME = "Cubes";
    public static final String LINK_SET_NAME = "Links";
    public static final String HIERARCHY_SET_NAME = "Hierarchies";
    public static final String MEASUREFOLDER_SET_NAME = "MeasureFolders";
    public static final String SQLTOAW_SET_NAME = "SQLAccessToAWs";
    public static final String NOTE_SET_NAME = "Notes";
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    private CubeSet cubeSet;
    private DimensionSet dimensionSet;
    private HierarchySet hierarchySet;
    private LevelSet levelSet;
    private MeasureSet measureSet;
    private LinkSet linkSet;
    private RaggedHLinkSet raggedHLinkSet;
    private RollupLinkSet rollupLinkSet;
    private SliceSet sliceSet;
    private SQLAccessToAWSet sqlAccessToAWSet;
    private NoteSet noteSet;
    private SelectionCriteriaSet scSet;
    private FactEntitiesJoinSet factEntitiesJoinSet;
    private MeasureFolderSet measureFolderSet;
    private MeasureFolderCollection measureFolderCollection;
    private DPVCompactMultidimentional compactDiagram;
    private DesignPartViewPlaceHolder compactDiagramPH;

    public MultidimensionalDesign(Design design) {
        this.setDesign(design);
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList arrayList = new ArrayList();
        this.getCubeSet().addAllElementsTo(arrayList);
        this.getLevelSet().addAllElementsTo(arrayList);
        this.getDimensionSet().addAllElementsTo(arrayList);
        this.getLinkSet().addAllElementsTo(arrayList);
        this.getRaggedHLinkSet().addAllElementsTo(arrayList);
        this.getNoteSet().addAllElementsTo(arrayList);
        this.getDiagramViewSet().addAllElementsTo(arrayList);
        return arrayList;
    }

    @Override
    public void clearAll() {
        this.getCubeSet().removeAll();
        this.getDimensionSet().removeAll();
        this.getHierarchySet().removeAll();
        this.getLevelSet().removeAll();
        this.getMeasureSet().removeAll();
        this.getLinkSet().removeAll();
        this.getRollupLinkSet().removeAll();
        this.getSliceSet().removeAll();
        this.getNoteSet().removeAll();
        this.getDiagramViewSet().removeAll();
        this.getSelectionCriteriaSet().removeAll();
        this.clearDocuments();
        this.clearResponsibleParties();
        this.setComment("");
        this.setNotes("");
        this.getMeasureFolderSet().removeAll();
        this.getMeasureFolderCollection().removeAll();
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
    }

    @Override
    protected DesignPartView createDesignPartSubView(String string) {
        DPVCompactMultidimentional dPVCompactMultidimentional = new DPVCompactMultidimentional(this.getDesign().getAppView(), this);
        dPVCompactMultidimentional.setName(string);
        this.compactDiagramPH = new DesignPartViewPlaceHolder((DesignPart)this, dPVCompactMultidimentional);
        this.compactDiagramPH.setParent(this.subViews);
        this.subViews.add(this.compactDiagramPH);
        return dPVCompactMultidimentional;
    }

    public void createCompactDiagram() {
        if (this.compactDiagram == null) {
            this.compactDiagram = (DPVCompactMultidimentional)this.createDesignPartSubView(this.getName() + Messages.getString("MultidimensionalDesign.CompactDiagram"));
            this.compactDiagram.setDPVId(this.getDesign().getAppView().getIDGenerator().createNewID());
            this.compactDiagram.getTabbedPane().setName(this.getName() + Messages.getString("MultidimensionalDesign.CompactDiagram"));
            this.compactDiagram.getTabbedPane().add(this.compactDiagram);
        }
    }

    @Override
    public boolean setName(String string) {
        boolean bl = super.setName(string);
        if (bl) {
            if (this.compactDiagram == null) {
                this.createCompactDiagram();
            }
            this.compactDiagramPH.setName(string + Messages.getString("MultidimensionalDesign.CompactDiagram"));
        }
        return true;
    }

    public void showCompactDiagram(boolean bl) {
        this.compactDiagramPH.setVisible(bl);
        this.getCompactDiagram().setVisible(bl);
    }

    public boolean isCompactDiagramVisible() {
        return this.compactDiagramPH.getVisible();
    }

    public DPVCompactMultidimentional getCompactDiagram() {
        if (this.compactDiagram == null) {
            this.createCompactDiagram();
        }
        return this.compactDiagram;
    }

    public DesignPartViewPlaceHolder getCompactDiagramPlaceHolder() {
        return this.compactDiagramPH;
    }

    @Override
    public DesignPartView getMainView() {
        if (this.mainView == null) {
            this.mainView = new DPVMultidimensional(this.getDesign().getAppView(), this);
            this.mainView.setDPVId(this.getDesign().getAppView().getIDGenerator().createNewID());
        }
        return this.mainView;
    }

    @Override
    public boolean isEmpty() {
        return this.getCubeSet().size() <= 0 && this.getDimensionSet().size() <= 0 && this.getHierarchySet().size() <= 0 && this.getLevelSet().size() <= 0 && this.getMeasureSet().size() <= 0 && this.getLinkSet().size() <= 0 && this.getRollupLinkSet().size() <= 0 && this.getSliceSet().size() <= 0 && this.getNoteSet().size() <= 0 && this.getDiagramViewSet().size() <= 0 && this.getSelectionCriteriaSet().size() <= 0 && this.getMeasureFolderSet().size() <= 0;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "MDD";
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public CubeSet getCubeSet() {
        if (this.cubeSet == null) {
            this.cubeSet = new CubeSet(this);
            this.cubeSet.setDesign(this.getDesign());
            this.cubeSet.setName(Messages.getString("MultidimensionalDesign.Cubes"));
            this.cubeSet.setParent(this);
            this.cubeSet.addSetListener(this);
        }
        return this.cubeSet;
    }

    public DimensionSet getDimensionSet() {
        if (this.dimensionSet == null) {
            this.dimensionSet = new DimensionSet(this);
            this.dimensionSet.setDesign(this.getDesign());
            this.dimensionSet.setName(Messages.getString("MultidimensionalDesign.Dimensions"));
            this.dimensionSet.setParent(this);
            this.dimensionSet.addSetListener(this);
        }
        return this.dimensionSet;
    }

    public FactEntitiesJoinSet getFactEntitiesJoinSet() {
        if (this.factEntitiesJoinSet == null) {
            this.factEntitiesJoinSet = new FactEntitiesJoinSet(this);
            this.factEntitiesJoinSet.setDesign(this.getDesign());
            this.factEntitiesJoinSet.setName(Messages.getString("MultidimensionalDesign.JoinsFactEntities"));
            this.factEntitiesJoinSet.setParent(this);
            this.factEntitiesJoinSet.addSetListener(this);
        }
        return this.factEntitiesJoinSet;
    }

    public HierarchySet getHierarchySet() {
        if (this.hierarchySet == null) {
            this.hierarchySet = new HierarchySet(this);
            this.hierarchySet.setDesign(this.getDesign());
            this.hierarchySet.setName(Messages.getString("MultidimensionalDesign.Hierarchies"));
            this.hierarchySet.setParent(this);
            this.hierarchySet.addSetListener(this);
        }
        return this.hierarchySet;
    }

    public LevelSet getLevelSet() {
        if (this.levelSet == null) {
            this.levelSet = new LevelSet(this);
            this.levelSet.setDesign(this.getDesign());
            this.levelSet.setName(Messages.getString("MultidimensionalDesign.Levels"));
            this.levelSet.setParent(this);
            this.levelSet.addSetListener(this);
        }
        return this.levelSet;
    }

    public MeasureFolderSet getMeasureFolderSet() {
        if (this.measureFolderSet == null) {
            this.measureFolderSet = new MeasureFolderSet(this);
            this.measureFolderSet.setDesign(this.getDesign());
            this.measureFolderSet.setName(Messages.getString("MultidimensionalDesign.MeasureFolders"));
            this.measureFolderSet.setParent(this);
            this.measureFolderSet.addSetListener(this);
        }
        return this.measureFolderSet;
    }

    private MeasureFolderCollection getMeasureFolderCollection() {
        if (this.measureFolderCollection == null) {
            this.measureFolderCollection = new MeasureFolderCollection();
            this.measureFolderCollection.setDesign(this.getDesign());
            this.measureFolderCollection.setParent(this);
            this.measureFolderCollection.setName(Messages.getString("MultidimensionalDesign.MeasureFolders"));
        }
        return this.measureFolderCollection;
    }

    public MeasureSet getMeasureSet() {
        if (this.measureSet == null) {
            this.measureSet = new MeasureSet(this);
            this.measureSet.setDesign(this.getDesign());
            this.measureSet.setName(Messages.getString("MultidimensionalDesign.Measures"));
            this.measureSet.setParent(this);
            this.measureSet.addSetListener(this);
        }
        return this.measureSet;
    }

    @Override
    public NoteSet getNoteSet() {
        if (this.noteSet == null) {
            this.noteSet = new NoteSet(this);
            this.noteSet.setDesign(this.getDesign());
            this.noteSet.setName(Messages.getString("MultidimensionalDesign.Notes"));
            this.noteSet.setParent(this);
            this.noteSet.addSetListener(this);
        }
        return this.noteSet;
    }

    public RollupLinkSet getRollupLinkSet() {
        if (this.rollupLinkSet == null) {
            this.rollupLinkSet = new RollupLinkSet(this);
            this.rollupLinkSet.setDesign(this.getDesign());
            this.rollupLinkSet.setName(Messages.getString("MultidimensionalDesign.RollupLinks"));
            this.rollupLinkSet.setParent(this);
            this.rollupLinkSet.addSetListener(this);
        }
        return this.rollupLinkSet;
    }

    public LinkSet getLinkSet() {
        if (this.linkSet == null) {
            this.linkSet = new LinkSet(this);
            this.linkSet.setDesign(this.getDesign());
            this.linkSet.setName(Messages.getString("MultidimensionalDesign.Links"));
            this.linkSet.setParent(this);
            this.linkSet.addSetListener(this);
        }
        return this.linkSet;
    }

    public RaggedHLinkSet getRaggedHLinkSet() {
        if (this.raggedHLinkSet == null) {
            this.raggedHLinkSet = new RaggedHLinkSet(this);
            this.raggedHLinkSet.setDesign(this.getDesign());
            this.raggedHLinkSet.setName(Messages.getString("MultidimensionalDesign.RaggedHierarchyLinks"));
            this.raggedHLinkSet.setParent(this);
            this.raggedHLinkSet.addSetListener(this);
        }
        return this.raggedHLinkSet;
    }

    public SliceSet getSliceSet() {
        if (this.sliceSet == null) {
            this.sliceSet = new SliceSet(this);
            this.sliceSet.setDesign(this.getDesign());
            this.sliceSet.setName(Messages.getString("MultidimensionalDesign.Slices"));
            this.sliceSet.setParent(this);
            this.sliceSet.addSetListener(this);
        }
        return this.sliceSet;
    }

    public SQLAccessToAWSet getSQLAccessToAWSet() {
        if (this.sqlAccessToAWSet == null) {
            this.sqlAccessToAWSet = new SQLAccessToAWSet(this);
            this.sqlAccessToAWSet.setDesign(this.getDesign());
            this.sqlAccessToAWSet.setName(Messages.getString("MultidimensionalDesign.ViewDefinitionsForOracleAW"));
            this.sqlAccessToAWSet.setParent(this);
            this.sqlAccessToAWSet.addSetListener(this);
        }
        return this.sqlAccessToAWSet;
    }

    public SelectionCriteriaSet getSelectionCriteriaSet() {
        if (this.scSet == null) {
            this.scSet = new SelectionCriteriaSet(this);
            this.scSet.setDesign(this.getDesign());
            this.scSet.setName(Messages.getString("MultidimensionalDesign.SelectionCriterias"));
            this.scSet.setParent(this);
            this.scSet.addSetListener(this);
        }
        return this.scSet;
    }

    public Cube createCube() {
        return this.getCubeSet().createCube(null);
    }

    public Dimension createDimension() {
        return this.getDimensionSet().createDimension(null);
    }

    public Hierarchy createHierarchy() {
        return this.getHierarchySet().createHierarchy(null);
    }

    public FactEntitiesJoin createFactEntitiesJoin() {
        return this.getFactEntitiesJoinSet().createFactEntitiesJoin(null);
    }

    public Level createLevel() {
        return this.getLevelSet().createLevel(null);
    }

    public Measure createMeasure() {
        return this.getMeasureSet().createMeasure(null);
    }

    public RollupLink createRollupLink() {
        return this.getRollupLinkSet().createRollupLink(null);
    }

    public Link createLink() {
        return this.getLinkSet().createLink(null);
    }

    public RaggedHLink createRaggedHLink(Level level, Level level2) {
        return this.getRaggedHLinkSet().createRaggedHLink(null, level, level2);
    }

    public RaggedHLink createRaggedHLink() {
        return this.getRaggedHLinkSet().createRaggedHLink(null);
    }

    public Slice createSlice() {
        return this.getSliceSet().createSlice(null);
    }

    public SelectionCriteria createSelectionCriteria() {
        return this.getSelectionCriteriaSet().createSC(null);
    }

    public MeasureFolder createMeasureFolder() {
        return this.getMeasureFolderSet().createMeasureFolder(null);
    }

    public SQLAccessToAW createSQLAccessToAW() {
        return this.getSQLAccessToAWSet().createSQLAccessToAW(null);
    }

    @Override
    public Note createNote() {
        return this.getNoteSet().createNote(null);
    }

    @Override
    public Note recreateNote(String string) {
        return this.getNoteSet().createNote(string);
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> arrayList = new ArrayList<DesignObjectSet>();
        arrayList.add(this.getLevelSet());
        arrayList.add(this.getRaggedHLinkSet());
        arrayList.add(this.getDimensionSet());
        arrayList.add(this.getSliceSet());
        arrayList.add(this.getCubeSet());
        arrayList.add(this.getRollupLinkSet());
        arrayList.add(this.getHierarchySet());
        arrayList.add(this.getNoteSet());
        arrayList.add(this.getMeasureFolderSet());
        arrayList.add(this.getSQLAccessToAWSet());
        return arrayList;
    }

    @Override
    public void sortCollections() {
        this.getCubeSet().sort();
        this.getDimensionSet().sort();
        this.getHierarchySet().sort();
        this.getLevelSet().sort();
        this.getMeasureSet().sort();
        this.getLinkSet().sort();
        this.getRollupLinkSet().sort();
        this.getSliceSet().sort();
        this.getSelectionCriteriaSet().sort();
        this.getMeasureFolderSet().sort();
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (setEvent == SetEvent.OBJECT_ADDED) {
            MeasureFolder measureFolder;
            if (designObjectSet instanceof MeasureFolderSet && (measureFolder = (MeasureFolder)setEvent.getAffected()).getParentFolder() == null) {
                measureFolder.setParent(this.measureFolderCollection);
                this.measureFolderCollection.add(measureFolder);
                measureFolder.addObjectListener(this);
            }
            this.fireAdded(setEvent.getAffected());
        } else if (setEvent == SetEvent.OBJECT_REMOVED) {
            AbstractMDObject abstractMDObject;
            if (designObjectSet instanceof MeasureFolderSet) {
                abstractMDObject = (MeasureFolder)setEvent.getAffected();
                this.measureFolderCollection.remove(abstractMDObject);
            }
            if (designObjectSet instanceof CubeSet) {
                abstractMDObject = (Cube)setEvent.getAffected();
                List list = ((Cube)abstractMDObject).getMeasures();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.getMeasureSet().remove((DesignObject)iterator.next());
                }
                List list2 = ((Cube)abstractMDObject).getPrecalculatedSlices();
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    this.getSliceSet().remove((DesignObject)iterator2.next());
                }
            }
            this.fireRemoved(setEvent.getAffected());
        }
    }

    @Override
    public int getNumberOfChildren() {
        if (this.isLoaded()) {
            return 8;
        }
        return 0;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.getCubeSet();
            }
            case 1: {
                return this.getLevelSet();
            }
            case 2: {
                return this.getDimensionSet();
            }
            case 3: {
                return this.getHierarchySet();
            }
            case 4: {
                return this.getMeasureFolderCollection();
            }
            case 5: {
                return this.getRollupLinkSet();
            }
            case 6: {
                return this.getRaggedHLinkSet();
            }
            case 7: {
                return this.getSliceSet();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.getCubeSet()) {
            return 0;
        }
        if (modelObject == this.getLevelSet()) {
            return 1;
        }
        if (modelObject == this.getDimensionSet()) {
            return 2;
        }
        if (modelObject == this.getHierarchySet()) {
            return 3;
        }
        if (modelObject == this.getMeasureFolderCollection()) {
            return 4;
        }
        if (modelObject == this.getRollupLinkSet()) {
            return 5;
        }
        if (modelObject == this.getRaggedHLinkSet()) {
            return 6;
        }
        if (modelObject == this.getSliceSet()) {
            return 7;
        }
        return -1;
    }

    @Override
    public void doAfterLoad() {
        this.getDesign().setMultidimensionalDesign(this);
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.getCompactDiagram().setDirty(false);
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void load() {
        this.getDesign().setMultidimensionalDesign(this);
        XMLPersistenceManager xMLPersistenceManager = this.getDesign().getAppView().getPersistenceManager();
        AbstractXMLReader abstractXMLReader = xMLPersistenceManager.getDesignPartReader(this);
        if (abstractXMLReader != null) {
            abstractXMLReader.recreateDesign(this.getObjectID(), (DesignPart)this, false);
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.getCompactDiagram().setDirty(false);
        this.setDirty(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.getType() == 1) {
            if (modelObjectSetEvent.getAffected() instanceof DesignObject) {
                DesignObject designObject = (DesignObject)modelObjectSetEvent.getAffected();
                this.fireAdded(designObject);
            }
        } else if (modelObjectSetEvent.getType() == 0 && modelObjectSetEvent.getAffected() instanceof DesignObject) {
            DesignObject designObject = (DesignObject)modelObjectSetEvent.getAffected();
            this.fireRemoved(designObject);
        }
    }

    public void processNewLink(Link link) {
        AbstractMDObject abstractMDObject = link.getSourceMDObject();
        AbstractMDObject abstractMDObject2 = link.getTargetMDObject();
        if (abstractMDObject instanceof Dimension && abstractMDObject2 instanceof Level) {
            this.makeNewHiearchies((Dimension)abstractMDObject, (Level)abstractMDObject2, link);
        } else if (abstractMDObject instanceof Level && abstractMDObject2 instanceof Level) {
            this.makeAndUpdateHiearchies((Level)abstractMDObject, (Level)abstractMDObject2, link);
        }
    }

    private void makeNewHiearchies(Dimension dimension, Level level, Link link) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.makePaths(level, new ArrayList(), new ArrayList(), arrayList, arrayList2);
        for (int i = 0; i < arrayList.size(); ++i) {
            List list = (List)arrayList.get(i);
            List list2 = (List)arrayList2.get(i);
            Hierarchy hierarchy = this.createHierarchy();
            hierarchy.setDimension(dimension);
            hierarchy.setLinkToDimension(link);
            for (int j = 0; j < list.size(); ++j) {
                hierarchy.addLevel((Level)list.get(j));
                if (j >= list2.size()) continue;
                hierarchy.addLink(((Link)list2.get(j)).getRollupLink());
            }
            dimension.addHierarchy(hierarchy);
        }
    }

    private void makePaths(Level level, List list, List list2, List list3, List list4) {
        list.add(level);
        List list5 = level.getOutgoingLinks();
        for (Link link : list5) {
            if (!(link.getTargetMDObject() instanceof Level)) continue;
            Level level2 = (Level)link.getTargetMDObject();
            ArrayList arrayList = new ArrayList();
            ArrayList<Link> arrayList2 = new ArrayList<Link>();
            arrayList.addAll(list);
            arrayList2.addAll(list2);
            arrayList2.add(link);
            this.makePaths(level2, arrayList, arrayList2, list3, list4);
        }
        if (list5.size() == 0) {
            list3.add(list);
            list4.add(list2);
        }
    }

    public void removeAndUpdateHierarchies(Link link, AbstractMDObject abstractMDObject, AbstractMDObject abstractMDObject2) {
        block5: {
            Hierarchy hierarchy;
            RollupLink rollupLink;
            block6: {
                Hierarchy[] hierarchyArray = (Hierarchy[])this.getHierarchySet().toArray();
                for (int i = 0; i < hierarchyArray.length; ++i) {
                    if (hierarchyArray[i].getLinkToDimension() != link) continue;
                    hierarchyArray[i].remove();
                    hierarchyArray[i].getDimension().removeHierarchy(hierarchyArray[i]);
                }
                rollupLink = link.getRollupLink();
                if (!(abstractMDObject2 instanceof Level) || !(abstractMDObject instanceof Level)) break block5;
                Level level = (Level)abstractMDObject2;
                List list = this.getHierarchiesContaining(level, rollupLink);
                List list2 = this.getHierarchiesContaining((Level)abstractMDObject);
                if (list2.size() <= list.size()) break block6;
                for (Hierarchy hierarchy2 : list2) {
                    if (list.contains(hierarchy2)) {
                        hierarchy2.remove();
                        hierarchy2.getDimension().removeHierarchy(hierarchy2);
                        continue;
                    }
                    hierarchy2.removePartFromLink(link);
                }
                break block5;
            }
            List list = this.getHierarchiesContaining((Level)abstractMDObject, rollupLink);
            for (int i = 0; i < list.size(); ++i) {
                hierarchy = (Hierarchy)list.get(i);
                hierarchy.removePartFromLink(link);
            }
            list = this.getHierarchiesContaining((Level)abstractMDObject);
            List list3 = this.getHierarchiesWithDifferentPathTo((Level)abstractMDObject);
            if (list3.size() >= list.size()) break block5;
            for (int i = 0; i < list.size(); ++i) {
                hierarchy = (Hierarchy)list.get(i);
                if (list3.contains(hierarchy)) continue;
                hierarchy.remove();
                hierarchy.getDimension().removeHierarchy(hierarchy);
            }
        }
    }

    private void makeAndUpdateHiearchies(Level level, Level level2, Link link) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.makePaths(level2, new ArrayList(), new ArrayList(), arrayList, arrayList2);
        List list = this.getHierarchiesWithDifferentPathTo(level);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Hierarchy hierarchy;
            Hierarchy hierarchy2 = hierarchy = (Hierarchy)iterator.next();
            if (!hierarchy.isLast(level)) {
                hierarchy = hierarchy2.clonePartial(level);
            }
            if (link.getRollupLink() == null) {
                link.addRollupLink();
            }
            hierarchy.addLink(link.getRollupLink());
            for (int i = 0; i < arrayList.size(); ++i) {
                if (i > 0) {
                    hierarchy = hierarchy2.clonePartial(level);
                    hierarchy.addLink(link.getRollupLink());
                }
                List list2 = (List)arrayList.get(i);
                List list3 = (List)arrayList2.get(i);
                for (int j = 0; j < list2.size(); ++j) {
                    hierarchy.addLevel((Level)list2.get(j));
                    if (j >= list3.size()) continue;
                    hierarchy.addLink(((Link)list3.get(j)).getRollupLink());
                }
            }
        }
    }

    private List getHierarchiesContaining(Level level, RollupLink rollupLink) {
        ArrayList<Hierarchy> arrayList = new ArrayList<Hierarchy>();
        Iterator iterator = this.getHierarchySet().iterator();
        while (iterator.hasNext()) {
            Hierarchy hierarchy = (Hierarchy)iterator.next();
            if (!hierarchy.contains(level) || !hierarchy.contains(rollupLink)) continue;
            arrayList.add(hierarchy);
        }
        return arrayList;
    }

    private List getHierarchiesContaining(Level level) {
        ArrayList<Hierarchy> arrayList = new ArrayList<Hierarchy>();
        Iterator iterator = this.getHierarchySet().iterator();
        while (iterator.hasNext()) {
            Hierarchy hierarchy = (Hierarchy)iterator.next();
            if (!hierarchy.contains(level)) continue;
            arrayList.add(hierarchy);
        }
        return arrayList;
    }

    public Hierarchy getHierarchyDefinedByLevels(List list) {
        Iterator iterator = this.getHierarchySet().iterator();
        while (iterator.hasNext()) {
            Hierarchy hierarchy = (Hierarchy)iterator.next();
            if (!hierarchy.isEqualToLevelList(list)) continue;
            return hierarchy;
        }
        return null;
    }

    public Hierarchy getFirstHierarchyDefinedByLinkToDimension(Link link) {
        Iterator iterator = this.getHierarchySet().iterator();
        while (iterator.hasNext()) {
            Hierarchy hierarchy = (Hierarchy)iterator.next();
            if (hierarchy.getLinkToDimension() != link) continue;
            return hierarchy;
        }
        return null;
    }

    private List getHierarchiesWithDifferentPathTo(Level level) {
        ArrayList<Hierarchy> arrayList = new ArrayList<Hierarchy>();
        for (Hierarchy hierarchy : this.getHierarchiesContaining(level)) {
            if (!hierarchy.hasDifferentPathToLevel(level, arrayList)) continue;
            arrayList.add(hierarchy);
        }
        return arrayList;
    }

    public void normalizeHierarchies() {
        Iterator iterator = this.getDimensionSet().iterator();
        while (iterator.hasNext()) {
            Dimension dimension = (Dimension)iterator.next();
            Level level = this.findLowestLevel(dimension);
            if (level == null) continue;
            this.reconnectFirstLevels(dimension, level);
        }
    }

    private Level findLowestLevel(Dimension dimension) {
        Level level;
        Hierarchy hierarchy;
        Iterator iterator = dimension.getHierarchies().iterator();
        ContainerObject containerObject = null;
        while (iterator.hasNext()) {
            hierarchy = (Hierarchy)iterator.next();
            level = (Level)hierarchy.getLevels().get(0);
            if (level.getLevelEntity() == null) continue;
            containerObject = level.getLevelEntity();
            break;
        }
        if (containerObject != null) {
            iterator = dimension.getHierarchies().iterator();
            while (iterator.hasNext()) {
                hierarchy = (Hierarchy)iterator.next();
                level = (Level)hierarchy.getLevels().get(0);
                if (!(containerObject instanceof Entity) || ((Entity)containerObject).getPK() == null || !((Object)level.getLevelKey()).equals(((Entity)containerObject).getPK().getElementsCollection())) continue;
                return level;
            }
        }
        return null;
    }

    private void reconnectFirstLevels(Dimension dimension, Level level) {
        int n = dimension.getHierarchies().size();
        Object[] objectArray = dimension.getHierarchies().toArray();
        for (int i = n - 1; i > -1; --i) {
            int n2;
            Link link;
            Hierarchy hierarchy = (Hierarchy)objectArray[i];
            String string = hierarchy.getName();
            Level level2 = (Level)hierarchy.getLevels().get(0);
            if (level2 == level || (link = dimension.getFirstLinkToTarget(level2)) == null) continue;
            link.remove();
            AbstractMDTV abstractMDTV = (AbstractMDTV)level.getTopView();
            AbstractMDTV abstractMDTV2 = (AbstractMDTV)level2.getTopView();
            if (abstractMDTV != null && abstractMDTV2 != null) {
                link = this.createLink();
                link.setSourceTV(abstractMDTV);
                link.setTargetTV(abstractMDTV2);
                ((TVLink)link.getTopView()).addConnection();
            }
            if ((n2 = dimension.getHierarchies().size() - 1) <= -1) continue;
            Hierarchy hierarchy2 = (Hierarchy)dimension.getHierarchies().getElement(n2);
            hierarchy2.setName(string);
        }
    }

    public void engineerToOracleSD() {
        Object object;
        boolean bl;
        RelationalDesign relationalDesign = null;
        StorageDesignOracle storageDesignOracle = null;
        if ((relationalDesign == null || storageDesignOracle == null) && (bl = ((OracleModelSelector)(object = new OracleModelSelector())).showDialog(this.getAppView()))) {
            relationalDesign = ((OracleModelSelector)object).getPhysicalDesign();
            storageDesignOracle = (StorageDesignOracle)((OracleModelSelector)object).getStorageDesign();
        }
        if (relationalDesign != null && storageDesignOracle != null) {
            object = new EngineerToOracle(this, relationalDesign, storageDesignOracle);
            ((EngineerToOracle)object).engineer();
        }
    }

    public void engineerFromOracleSD() {
        FromOracleModelSelector fromOracleModelSelector;
        boolean bl;
        RelationalDesign relationalDesign = null;
        StorageDesignOracle storageDesignOracle = null;
        int n = 3;
        if ((relationalDesign == null || storageDesignOracle == null) && (bl = (fromOracleModelSelector = new FromOracleModelSelector()).showDialog(this.getAppView()))) {
            relationalDesign = fromOracleModelSelector.getPhysicalDesign();
            storageDesignOracle = (StorageDesignOracle)fromOracleModelSelector.getStorageDesign();
            n = fromOracleModelSelector.getMinDimensions();
            if (relationalDesign != null && storageDesignOracle != null) {
                EngineerFromOracle engineerFromOracle = new EngineerFromOracle(this, relationalDesign, storageDesignOracle, n, fromOracleModelSelector.isUseFactTablesOnly(), fromOracleModelSelector.getSearchMethod());
                engineerFromOracle.engineer();
                ((DPVMultidimensional)this.getMainView()).rearrangeDiagram(true);
                this.getCompactDiagram().generateDiagram();
            }
        }
    }

    public void clearUnusedObjects() {
        AbstractMDObject abstractMDObject;
        int n;
        for (n = this.getSliceSet().size() - 1; n >= 0; --n) {
            abstractMDObject = (Slice)this.getSliceSet().getElement(n);
            if (((Slice)abstractMDObject).getCube() != null) continue;
            abstractMDObject.remove();
        }
        for (n = this.getMeasureSet().size() - 1; n >= 0; --n) {
            abstractMDObject = (Measure)this.getMeasureSet().getElement(n);
            if (((Measure)abstractMDObject).getCube() != null) continue;
            abstractMDObject.remove();
        }
        this.removeInvalidLinks();
    }

    public Cube getCubeOnEntity(Entity entity) {
        Iterator iterator = this.getCubeSet().iterator();
        while (iterator.hasNext()) {
            Cube cube = (Cube)iterator.next();
            if (cube.getFactEntity() != entity) continue;
            return cube;
        }
        return null;
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        MeasureFolder measureFolder;
        if (designObject instanceof MeasureFolder && (measureFolder = (MeasureFolder)designObject).getParentFolder() != null) {
            this.measureFolderCollection.remove(measureFolder);
        }
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject designObject) {
    }

    @Override
    public void objectRemoved(DesignPart designPart, DesignObject designObject) {
        if (designObject instanceof Attribute) {
            AbstractMDObject abstractMDObject;
            Attribute attribute = (Attribute)designObject;
            Iterator iterator = this.getLevelSet().iterator();
            while (iterator.hasNext()) {
                abstractMDObject = (Level)iterator.next();
                ((Level)abstractMDObject).attributeIsDeleted(attribute);
            }
            iterator = this.getCubeSet().iterator();
            while (iterator.hasNext()) {
                abstractMDObject = (Cube)iterator.next();
                ((Cube)abstractMDObject).attributeIsDeleted(attribute);
            }
            iterator = this.getLinkSet().iterator();
            while (iterator.hasNext()) {
                abstractMDObject = (Link)iterator.next();
                ((Link)abstractMDObject).attributeIsDeleted(attribute);
            }
            iterator = this.getRaggedHLinkSet().iterator();
            while (iterator.hasNext()) {
                abstractMDObject = (RaggedHLink)iterator.next();
                ((RaggedHLink)abstractMDObject).attributeIsDeleted(attribute);
            }
            this.getMainView().getWorkSpace().repaint();
        } else if (designObject instanceof Entity) {
            AbstractMDObject abstractMDObject;
            Entity entity = (Entity)designObject;
            Iterator iterator = this.getLevelSet().iterator();
            while (iterator.hasNext()) {
                abstractMDObject = (Level)iterator.next();
                ((Level)abstractMDObject).entityIsDeleted(entity);
            }
            iterator = this.getCubeSet().iterator();
            while (iterator.hasNext()) {
                abstractMDObject = (Cube)iterator.next();
                ((Cube)abstractMDObject).entityIsDeleted(entity);
            }
        }
        this.getMainView().getWorkSpace().repaint();
    }

    public void updateFontsAndColors(boolean bl) {
        Object object;
        Iterator iterator = this.getCubeSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getDimensionSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getLevelSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getNoteSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getLinkSet().iterator();
        while (iterator.hasNext()) {
            object = (DesignObject)iterator.next();
            if (bl) {
                ((DesignObject)object).setBackgroundColor(null);
            } else if (((DesignObject)object).getBackgroundColor() == null) {
                ((DesignObject)object).setBackgroundColor(((DesignObject)object).getTopView().getDefaultLineColor());
            }
            ((DesignObject)object).setUseDefaultColor(bl);
        }
        iterator = this.getRaggedHLinkSet().iterator();
        while (iterator.hasNext()) {
            object = (DesignObject)iterator.next();
            if (bl) {
                ((DesignObject)object).setBackgroundColor(null);
            } else if (((DesignObject)object).getBackgroundColor() == null) {
                ((DesignObject)object).setBackgroundColor(((DesignObject)object).getTopView().getDefaultLineColor());
            }
            ((DesignObject)object).setUseDefaultColor(bl);
        }
        iterator = this.getRollupLinkSet().iterator();
        while (iterator.hasNext()) {
            object = (DesignObject)iterator.next();
            if (bl) {
                ((DesignObject)object).setBackgroundColor(null);
            } else if (((DesignObject)object).getBackgroundColor() == null) {
                ((DesignObject)object).setBackgroundColor(((DesignObject)object).getTopView().getDefaultLineColor());
            }
            ((DesignObject)object).setUseDefaultColor(bl);
        }
        iterator = this.getLabelSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            MultidimensionalModelPropertiesDialog multidimensionalModelPropertiesDialog = new MultidimensionalModelPropertiesDialog(this.getDesign().getAppView(), this);
            multidimensionalModelPropertiesDialog.initProperties(this);
            multidimensionalModelPropertiesDialog.show();
        }
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("SelectionCriteria");
        arrayList.add("Level");
        arrayList.add("RaggedHLink");
        arrayList.add("Dimension");
        arrayList.add("Measure");
        arrayList.add("Slice");
        arrayList.add("FactEntitiesJoin");
        arrayList.add("Cube");
        arrayList.add("RollupLink");
        arrayList.add("Link");
        arrayList.add("Hierarchy");
        arrayList.add("MeasureFolder");
        arrayList.add("SQLAccessToAW");
        arrayList.add("Note");
        arrayList.add("MainView");
        arrayList.add("SubView");
        return arrayList;
    }

    @Override
    public String getStoragePath() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "multidimensional/" + this.getObjectID()).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "multidimensional/" + this.getObjectID() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public StorableObject createObject(String string, String string2, String string3) {
        DesignObject designObject = null;
        if ("SelectionCriteria".equalsIgnoreCase(string)) {
            designObject = this.getSelectionCriteriaSet().createSC(string2);
        } else if ("Level".equalsIgnoreCase(string)) {
            designObject = this.getLevelSet().createLevel(string2);
        } else if ("RollupLink".equalsIgnoreCase(string)) {
            designObject = this.getRollupLinkSet().createRollupLink(string2);
        } else if ("RaggedHLink".equalsIgnoreCase(string)) {
            designObject = this.getRaggedHLinkSet().createRaggedHLink(string2);
        } else if ("Dimension".equalsIgnoreCase(string)) {
            designObject = this.getDimensionSet().createDimension(string2);
        } else if ("Measure".equalsIgnoreCase(string)) {
            designObject = this.getMeasureSet().createMeasure(string2);
        } else if ("Slice".equalsIgnoreCase(string)) {
            designObject = this.getSliceSet().createSlice(string2);
        } else if ("FactEntitiesJoin".equalsIgnoreCase(string)) {
            designObject = this.getFactEntitiesJoinSet().createFactEntitiesJoin(string2);
        } else if ("Cube".equalsIgnoreCase(string)) {
            designObject = this.getCubeSet().createCube(string2);
        } else if ("Link".equalsIgnoreCase(string)) {
            designObject = this.getLinkSet().createLink(string2);
        } else if ("Hierarchy".equalsIgnoreCase(string)) {
            designObject = this.getHierarchySet().createHierarchy(string2);
        } else if ("MeasureFolder".equalsIgnoreCase(string)) {
            designObject = this.getMeasureFolderSet().createMeasureFolder(string2);
        } else if ("SQLAccessToAW".equalsIgnoreCase(string)) {
            designObject = this.getSQLAccessToAWSet().createSQLAccessToAW(string2);
        } else if ("Note".equalsIgnoreCase(string)) {
            designObject = this.getNoteSet().createNote(string2);
        }
        if (designObject != null && string3 != null && string3.length() > 0) {
            designObject.setName(string3);
        }
        return designObject;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("level", "Level");
            this.f2tMap.put("rhlink", "RaggedHLink");
            this.f2tMap.put("dimension", "Dimension");
            this.f2tMap.put("slice", "Slice");
            this.f2tMap.put("cube", "Cube");
            this.f2tMap.put("rolluplink", "RollupLink");
            this.f2tMap.put("hierarchy", "Hierarchy");
            this.f2tMap.put("measurefolder", "MeasureFolder");
            this.f2tMap.put("sqltoaw", "SQLAccessToAW");
            this.f2tMap.put("note", "Note");
        }
        return this.f2tMap;
    }

    public static void initObjectDetails(Design design, File file, String string, StorableObjectStatusHelper storableObjectStatusHelper, String string2) {
        Object object;
        storableObjectStatusHelper.treePath.add(new TreePathHelper(Design.getMultidimensionalDesignSetName(), file.getParentFile().getParentFile(), MultidimensionalDesignSet.class));
        if (storableObjectStatusHelper.designPart != null) {
            storableObjectStatusHelper.treePath.add(new TreePathHelper(storableObjectStatusHelper.designPart.getName(), file.getParentFile(), MultidimensionalDesign.class));
        } else {
            SVNObjectHelper sVNObjectHelper;
            object = SVNClientHelper.svnOHMap.get(string2);
            if (object != null && (sVNObjectHelper = SVNClientHelper.svnOHMap.get(((SVNObjectHelper)object).parentID)) != null) {
                storableObjectStatusHelper.treePath.add(new TreePathHelper(sVNObjectHelper.propName, new File(sVNObjectHelper.fileName), MultidimensionalDesign.class));
            }
        }
        if ("selcriteria".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = SelectionCriteria.class;
            storableObjectStatusHelper.objectType = "SelectionCriteria";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(SEL_CRITERIA_SET_NAME, file.getParentFile(), SelectionCriteriaSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getSelectionCriteriaSet();
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getSelectionCriteriaSet().getObjectByID(string2);
            }
        } else if ("level".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Level.class;
            storableObjectStatusHelper.objectType = "Level";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(LEVEL_SET_NAME, file.getParentFile(), LevelSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getLevelSet();
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getLevelSet().getObjectByID(string2);
            }
        } else if ("rolluplink".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = RollupLink.class;
            storableObjectStatusHelper.objectType = "RollupLink";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(ROLLUPLINK_SET_NAME, file.getParentFile(), RollupLinkSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getRollupLinkSet();
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getRollupLinkSet().getObjectByID(string2);
            }
        } else if ("rhlink".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = RaggedHLink.class;
            storableObjectStatusHelper.objectType = "RaggedHLink";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(RAGGEDHLINK_SET_NAME, file.getParentFile(), RaggedHLinkSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getRaggedHLinkSet();
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getRaggedHLinkSet().getObjectByID(string2);
            }
        } else if ("dimension".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Dimension.class;
            storableObjectStatusHelper.objectType = "Dimension";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(DIMENSION_SET_NAME, file.getParentFile(), DimensionSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getDimensionSet();
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getDimensionSet().getObjectByID(string2);
            }
        } else if ("measure".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Measure.class;
            storableObjectStatusHelper.objectType = "Measure";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(MEASURE_SET_NAME, file.getParentFile(), MeasureSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getMeasureSet();
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getMeasureSet().getObjectByID(string2);
            }
        } else if ("slice".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Slice.class;
            storableObjectStatusHelper.objectType = "Slice";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(SLICE_SET_NAME, file.getParentFile(), SliceSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getSliceSet();
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getSliceSet().getObjectByID(string2);
            }
        } else if ("fejoins".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = FactEntitiesJoin.class;
            storableObjectStatusHelper.objectType = "FactEntitiesJoin";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(FE_JOINS_SET_NAME, file.getParentFile(), FactEntitiesJoinSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getFactEntitiesJoinSet();
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getFactEntitiesJoinSet().getObjectByID(string2);
            }
        } else if ("cube".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Cube.class;
            storableObjectStatusHelper.objectType = "Cube";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(CUBE_SET_NAME, file.getParentFile(), CubeSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getCubeSet();
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getCubeSet().getObjectByID(string2);
            }
        } else if ("link".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Link.class;
            storableObjectStatusHelper.objectType = "Link";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(LINK_SET_NAME, file.getParentFile(), LinkSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getLinkSet();
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getLinkSet().getObjectByID(string2);
            }
        } else if ("hierarchy".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Hierarchy.class;
            storableObjectStatusHelper.objectType = "Hierarchy";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(HIERARCHY_SET_NAME, file.getParentFile(), HierarchySet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getHierarchySet();
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getHierarchySet().getObjectByID(string2);
            }
        } else if ("measurefolder".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = MeasureFolder.class;
            storableObjectStatusHelper.objectType = "MeasureFolder";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(MEASUREFOLDER_SET_NAME, file.getParentFile(), MeasureFolderSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getMeasureFolderSet();
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getMeasureFolderSet().getObjectByID(string2);
            }
        } else if ("sqltoaw".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = SQLAccessToAW.class;
            storableObjectStatusHelper.objectType = "SQLAccessToAW";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(SQLTOAW_SET_NAME, file.getParentFile(), SQLAccessToAWSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getSQLAccessToAWSet();
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getSQLAccessToAWSet().getObjectByID(string2);
            }
        } else if ("note".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Note.class;
            storableObjectStatusHelper.objectType = "Note";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(NOTE_SET_NAME, file.getParentFile(), NoteSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getNoteSet();
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)storableObjectStatusHelper.designPart).getNoteSet().getObjectByID(string2);
            }
        } else if ("subviews".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = DPVMultidimensional.class;
            storableObjectStatusHelper.treePath.add(new TreePathHelper(DIAGRAM_SET_NAME, file.getParentFile(), DPVMultidimensional.class));
            if (storableObjectStatusHelper.designPart != null) {
                object = (MultidimensionalDesign)storableObjectStatusHelper.designPart;
                storableObjectStatusHelper.storableObject = ((MultidimensionalDesign)object).getMainView().getDPVId().equals(string2) ? ((MultidimensionalDesign)object).getMainView() : ((DesignPart)object).getSubViewByID(string2);
            }
        }
    }

    public void removeInvalidLinks() {
        Object[] objectArray = this.getRollupLinkSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            RollupLink rollupLink = (RollupLink)objectArray[i];
            if (rollupLink.getChildLevel() == null && rollupLink.getParentLevel() == null) {
                rollupLink.remove();
                continue;
            }
            if (rollupLink.getLink() != null) continue;
            rollupLink.remove();
        }
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        if (this.getMainView() != null) {
            this.getMainView().getWorkSpace().updateSettings();
        }
        this.clearUnusedObjects();
        this.sortCollections();
    }

    @Override
    public List<Object> getObjectsWithMeasurements() {
        DesignObject designObject;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.getCubeSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Cube)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getDimensionSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Dimension)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getHierarchySet().iterator();
        while (iterator.hasNext()) {
            designObject = (Hierarchy)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getLevelSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Level)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getLinkSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Link)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getRaggedHLinkSet().iterator();
        while (iterator.hasNext()) {
            designObject = (RaggedHLink)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getRollupLinkSet().iterator();
        while (iterator.hasNext()) {
            designObject = (RollupLink)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getSliceSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Slice)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getSQLAccessToAWSet().iterator();
        while (iterator.hasNext()) {
            designObject = (SQLAccessToAW)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getNoteSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Note)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getSelectionCriteriaSet().iterator();
        while (iterator.hasNext()) {
            designObject = (SelectionCriteria)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getFactEntitiesJoinSet().iterator();
        while (iterator.hasNext()) {
            designObject = (FactEntitiesJoin)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getMeasureFolderSet().iterator();
        while (iterator.hasNext()) {
            designObject = (MeasureFolder)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        return arrayList;
    }
}

