/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.swingui.editor.multidimensional.MeasurePropertiesDialogEx;

public class Measure
extends AbstractMDObject {
    private boolean isFormula;
    private List attributes = new ArrayList();
    private String formula = "";
    private AggregateFunction aggregationFunction;
    private String aggregationFunctionID = "";
    private Cube cube;
    public static String FULLY_ADDITIVE = "Fully-Additive";
    public static String SEMI_ADDITIVE = "Semi-Additive";
    public static String NON_ADDITIVE = "Non-Additive";
    public static String AW_BASE_FORMULA = "Base Formila";
    public static String AW_OLAP_FORMULA = "OLAP Formula";
    public static String MS_COMPUTED_FORMULA = "MS Computed";
    public static String AW_NONE = "NO";
    public static String TD_OP_AVERAGE = "AVERAGE";
    public static String TD_OP_LARGEST = "LARGEST";
    public static String TD_OP_SMALLEST = "SMALLEST";
    public static String TD_OP_TOTAL = "TOTAL";
    public static String[] ADDITIVITY_TYPES = new String[]{FULLY_ADDITIVE, SEMI_ADDITIVE, NON_ADDITIVE};
    public static String[] AW_FORMULA_TYPES = new String[]{AW_NONE, AW_BASE_FORMULA, AW_OLAP_FORMULA, MS_COMPUTED_FORMULA};
    public static String[] PERIOD_TO_DATE_OPERATIONS = new String[]{TD_OP_AVERAGE, TD_OP_LARGEST, TD_OP_SMALLEST, TD_OP_TOTAL};
    private String additivity = FULLY_ADDITIVE;
    private int aggrFuncID = 1;
    private List aggregateFunctions = new ArrayList();
    private ContainedObject measureFact;
    private boolean actAsFactDimension = false;
    private String oracleAWFormulaType = AW_NONE;
    private boolean customFormula;
    private Dimension oLAPDimension;
    private Hierarchy oLAPHierarchy;
    private static String rankDirectionCodeHL = "HL";
    private static String rankDirectionCodeLH = "LH";
    private String rankDirectionCode = rankDirectionCodeHL;
    public static String rankDirNameHL = "Highest To Lowest";
    public static String rankDirNameLH = "Lowest To Highest";
    public static String[] rankDirectionNames = new String[]{rankDirNameHL, rankDirNameLH};
    public static String CUMULATIVE_TOTAL_PARENT = "Cumulative Total Parent";
    public static String CUMULATIVE_TOTAL_TOTAL = "Cumulative Total Total";
    public static String LAG = "Lag";
    public static String LEAD = "Lead";
    public static String MOVINGAVERAGE = "MovingAverage";
    public static String MOVINGMAX = "MovingMax";
    public static String MOVINGMIN = "MovingMin";
    public static String MOVINGTOTAL = "MovingTotal";
    public static String PERIOD_TO_DATE = "Period To Date";
    public static String FUTURE_PERIOD = "Future Period";
    public static String PRIOR_PERIOD = "Prior Period";
    public static String PRIOR_PERIOD_VARIANCE = "Prior Period Variance";
    public static String PRIOR_PERIOD_VARIANCE_PERCENTAGE = "Prior Period Variance Percent";
    public static String RANK_LEVEL = "Rank Level";
    public static String RANK_PARENT = "Rank Parent";
    public static String RANK_TOTAL = "Rank Total";
    public static String SAME_PERIOD_ANCESTORS_AGO = "Same Period Ancestors Ago";
    public static String SAME_PERIOD_ANCESTORS_AGO_VARIANCE = "Same Period Ancestors Ago Variance";
    public static String SAME_PERIOD_ANCESTORS_AGO_VARIANCE_PERCENT = "Same Period Ancestors Ago Variance Percent";
    public static String SAME_PERIOD_ANCESTORS_AGO_FVD = "Same Period Ancestors Ago FVD";
    public static String SHARE_TO_LEVEL = "Share to Level";
    public static String SHARE_TO_PARENT = "Share to Parent";
    public static String SHARE_TO_TOTAL = "Share to Total";
    public static String YEAR_TO_DATE = "Year To Date";
    public static String[] OLAP_OPERATORS = new String[]{CUMULATIVE_TOTAL_PARENT, CUMULATIVE_TOTAL_TOTAL, LAG, LEAD, MOVINGAVERAGE, MOVINGMAX, MOVINGMIN, MOVINGTOTAL, PERIOD_TO_DATE, FUTURE_PERIOD, PRIOR_PERIOD, PRIOR_PERIOD_VARIANCE, PRIOR_PERIOD_VARIANCE_PERCENTAGE, RANK_LEVEL, RANK_PARENT, RANK_TOTAL, SAME_PERIOD_ANCESTORS_AGO, SAME_PERIOD_ANCESTORS_AGO_VARIANCE, SAME_PERIOD_ANCESTORS_AGO_VARIANCE_PERCENT, SAME_PERIOD_ANCESTORS_AGO_FVD, SHARE_TO_LEVEL, SHARE_TO_PARENT, SHARE_TO_TOTAL, YEAR_TO_DATE};
    private String oLAPOperator = LAG;
    private Level oLAPLevel;
    private int oLAPOffset;
    private int oLAPStart = 0;
    private int oLAPStop = 1;
    private int oLAPStep = 1;
    private String oLAPPeriodToDateOperation = TD_OP_AVERAGE;
    private Measure usedOLAPMeasure;
    private String usedOLAPMeasureID;
    private String olapHierarchyID;
    private String whereClause = "";
    public static final String TYPE_NAME = "Measure";

    public Measure(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            MeasurePropertiesDialogEx measurePropertiesDialogEx = new MeasurePropertiesDialogEx(this.getDesign().getAppView(), this);
            measurePropertiesDialogEx.initProperties(this);
            measurePropertiesDialogEx.show();
        }
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String string) {
        this.formula = string;
    }

    public boolean isFormula() {
        return this.isFormula;
    }

    public void setFormula(boolean bl) {
        this.isFormula = bl;
    }

    public boolean isNonAdditive() {
        return this.additivity.equalsIgnoreCase(NON_ADDITIVE);
    }

    public boolean isAdditive() {
        return this.additivity.equalsIgnoreCase(FULLY_ADDITIVE);
    }

    public boolean isSemiAdditive() {
        return this.additivity.equalsIgnoreCase(SEMI_ADDITIVE);
    }

    public boolean isFactDimension() {
        return this.additivity.equalsIgnoreCase(NON_ADDITIVE) && this.actAsFactDimension;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void addAttribute(ContainedObject containedObject) {
        this.attributes.add(containedObject);
    }

    public void removeAttribute(ContainedObject containedObject) {
        this.attributes.remove(containedObject);
    }

    public AggregateFunction getDefaultAggregationFunction() {
        if (this.aggregationFunction == null && !"".equals(this.aggregationFunctionID)) {
            this.aggregationFunction = this.getAggregateFunctionById(this.aggregationFunctionID);
        }
        if (this.aggregationFunction == null) {
            this.aggregationFunction = new AggregateFunction();
        }
        if (FULLY_ADDITIVE.equalsIgnoreCase(this.getAdditivity()) || SEMI_ADDITIVE.equalsIgnoreCase(this.getAdditivity())) {
            if (!"".equalsIgnoreCase(this.aggregationFunction.name) || this.aggregateFunctions.size() == 0) {
                return this.aggregationFunction;
            }
            return (AggregateFunction)this.aggregateFunctions.get(0);
        }
        return this.aggregationFunction;
    }

    public void setDefaultAggregationFunction(AggregateFunction aggregateFunction) {
        this.aggregationFunction = aggregateFunction;
    }

    public Cube getCube() {
        return this.cube;
    }

    public void setCube(Cube cube) {
        this.cube = cube;
    }

    public String getAdditivity() {
        return this.additivity;
    }

    public void setAdditivity(String string) {
        this.additivity = string;
    }

    public List getAggregateFunctions() {
        return this.aggregateFunctions;
    }

    public void addAggregateFunction(AggregateFunction aggregateFunction) {
        this.aggregateFunctions.add(aggregateFunction);
        String string = aggregateFunction.getObjectID();
        int n = Integer.valueOf(string);
        if (n > this.aggrFuncID) {
            this.aggrFuncID = n;
        }
    }

    public AggregateFunction addAggregateFunction(String string, String string2) {
        AggregateFunction aggregateFunction = this.createAggregateFunction(string, string2);
        this.aggregateFunctions.add(aggregateFunction);
        return aggregateFunction;
    }

    public AggregateFunction createAggregateFunction() {
        String string = "SUM";
        if (this.isDefinedAsOracleAWCalculated()) {
            string = "OLAP";
        }
        return this.createAggregateFunction(string);
    }

    public AggregateFunction createAggregateFunction(String string) {
        AggregateFunction aggregateFunction = new AggregateFunction();
        aggregateFunction.measure = this;
        aggregateFunction.name = string;
        aggregateFunction.measureAlias = this.getName();
        String string2 = Integer.toString(this.aggrFuncID);
        ++this.aggrFuncID;
        aggregateFunction.setObjectID(string2);
        return aggregateFunction;
    }

    public AggregateFunction createAggregateFunction(String string, String string2) {
        int n = Integer.valueOf(string2);
        if (n > this.aggrFuncID) {
            this.aggrFuncID = n;
        }
        AggregateFunction aggregateFunction = this.createAggregateFunction(string);
        aggregateFunction.setObjectID(string2);
        return aggregateFunction;
    }

    public AggregateFunction getAggregateFunctionById(String string) {
        for (AggregateFunction aggregateFunction : this.aggregateFunctions) {
            if (!aggregateFunction.getObjectID().equalsIgnoreCase(string)) continue;
            return aggregateFunction;
        }
        return null;
    }

    public ContainedObject getMeasureFact() {
        return this.measureFact;
    }

    public void setMeasureFact(ContainedObject containedObject) {
        this.measureFact = containedObject;
    }

    public List getCandidateFactsAndNull() {
        ArrayList<ContainedObject> arrayList = new ArrayList<ContainedObject>();
        arrayList.add(null);
        if (this.getCube() != null && this.getCube().getFactEntities().size() > 0) {
            for (ContainerObject containerObject : this.getCube().getFactEntities()) {
                for (ContainedObject containedObject : containerObject.getElementsCollection()) {
                    if (!(containedObject instanceof Attribute)) {
                        arrayList.add(containedObject);
                        continue;
                    }
                    if (((Attribute)containedObject).isFKAttribute()) continue;
                    arrayList.add(containedObject);
                }
            }
        }
        return arrayList;
    }

    private ModelIDObject getCorrespondentObject(ModelIDObject modelIDObject) {
        return modelIDObject;
    }

    public String getMeasureExpression(Measure measure) {
        String string = "";
        boolean bl = false;
        String string2 = "";
        Cube cube = measure.getCube();
        String string3 = measure.getFormula();
        if (!measure.isFormula()) {
            if (measure.getMeasureFact() != null) {
                ContainedObject containedObject = measure.getMeasureFact();
                ModelIDObject modelIDObject = this.getCorrespondentObject(containedObject);
                if (bl) {
                    return string2 + "." + string + modelIDObject.getName() + string;
                }
                return string + modelIDObject.getName() + string;
            }
            return "";
        }
        if (cube.getFactEntities().size() > 0) {
            String string4;
            ModelIDObject modelIDObject;
            Object object;
            Object object2;
            Object object3;
            for (Object object4 : cube.getFactEntities()) {
                Object object5 = ((ContainerObject)object4).getElementsCollection();
                object3 = object5.iterator();
                while (object3.hasNext()) {
                    object2 = (DesignObject)object3.next();
                    if (object2 == measure) continue;
                    object = "\"" + ((DesignObject)object2).getLongName().trim() + "\"";
                    if (string3.indexOf((String)object) > -1) {
                        modelIDObject = this.getCorrespondentObject((ModelIDObject)object2);
                        string4 = bl ? string2 + "." + string + modelIDObject.getName().trim() + string : (cube.getFactEntities().size() > 1 ? string + ((DesignObject)object4).getName().trim() + string + "." + string + modelIDObject.getName().trim() + string : string + modelIDObject.getName().trim() + string);
                        string3 = this.replace(string3, (String)object, string4);
                        continue;
                    }
                    object = "\"" + ((DesignObject)object2).getName().trim() + "\"";
                    if (string3.indexOf((String)object) <= -1) continue;
                    modelIDObject = this.getCorrespondentObject((ModelIDObject)object2);
                    string4 = bl ? string2 + "." + string + modelIDObject.getName().trim() + string : (cube.getFactEntities().size() > 1 ? string + ((DesignObject)object4).getName().trim() + string + "." + string + modelIDObject.getName().trim() + string : string + modelIDObject.getName().trim() + string);
                    string3 = this.replace(string3, (String)object, string4);
                }
            }
            for (Object object5 : cube.getMeasures()) {
                if (object5 == measure || string3.indexOf((String)(object3 = "\"" + ((DesignObject)object5).getName().trim() + "\"")) <= -1) continue;
                if (!((Measure)object5).isFormula()) {
                    if (((Measure)object5).getMeasureFact() == null) continue;
                    object2 = ((Measure)object5).getMeasureFact();
                    object = ((ContainedObject)object2).getContainer();
                    modelIDObject = this.getCorrespondentObject((ModelIDObject)object2);
                    string4 = bl ? string2 + "." + string + modelIDObject.getName().trim() + string : (cube.getFactEntities().size() > 1 ? string + ((DesignObject)object).getName().trim() + string + "." + string + modelIDObject.getName().trim() + string : string + modelIDObject.getName().trim() + string);
                    string3 = this.replace(string3, (String)object3, string4);
                    continue;
                }
                object2 = "(" + this.getMeasureExpression((Measure)object5) + ")";
                string3 = this.replace(string3, (String)object3, (String)object2);
            }
        }
        return string3;
    }

    private String replace(String string, String string2, String string3) {
        String string4 = string2.trim();
        String string5 = string;
        int n = string5.indexOf(string4);
        int n2 = string4.length();
        while (n > -1) {
            String string6 = n == 0 ? "" : string5.substring(0, n);
            int n3 = string6.length() + string3.length();
            string5 = string6 + string3 + string5.substring(n + n2);
            n = string5.indexOf(string4, n3);
        }
        return string5;
    }

    public ContainerObject getFactEntity() {
        Cube cube = this.getCube();
        if (cube.getFactEntities().size() == 1) {
            ContainerObject containerObject = (ContainerObject)cube.getFactEntities().get(0);
            return containerObject;
        }
        if (!this.isFormula) {
            ContainerObject containerObject;
            ContainedObject containedObject;
            if (this.getMeasureFact() != null && (containedObject = this.getMeasureFact()).getContainer() != null && (containerObject = (ContainerObject)this.getDesign().getDesignObject(containedObject.getContainer().getObjectID())) != null && (containedObject = containerObject.getElementByName(containedObject.getName())) != null) {
                this.measureFact = containedObject;
                return containerObject;
            }
        } else {
            List list = this.getFactEntities();
            if (list.size() > 0) {
                return (ContainerObject)list.get(0);
            }
        }
        return null;
    }

    public List getFactEntities() {
        ArrayList arrayList = new ArrayList();
        this.fillFactEntities(this, arrayList);
        return arrayList;
    }

    private void fillFactEntities(Measure measure, List list) {
        Cube cube = measure.getCube();
        if (cube.getFactEntities().size() == 1) {
            ContainerObject containerObject = (ContainerObject)cube.getFactEntities().get(0);
            if (!list.contains(containerObject)) {
                list.add(containerObject);
            }
            return;
        }
        String string = measure.getFormula();
        if (!measure.isFormula()) {
            ContainerObject containerObject;
            if (measure.getMeasureFact() != null && !list.contains(containerObject = measure.getMeasureFact().getContainer())) {
                list.add(containerObject);
            }
            return;
        }
        if (cube.getFactEntities().size() > 0 && list.size() < cube.getFactEntities().size()) {
            Object object;
            ContainedObject containedObject;
            Object object2;
            for (Object object3 : cube.getFactEntities()) {
                Object object4 = ((ContainerObject)object3).getElementsCollection();
                object2 = object4.iterator();
                while (object2.hasNext()) {
                    ContainerObject containerObject;
                    containedObject = (ContainedObject)object2.next();
                    object = "\"" + containedObject.getLongName().trim() + "\"";
                    if (string.indexOf((String)object) > -1) {
                        containerObject = containedObject.getContainer();
                        if (list.contains(containerObject)) continue;
                        list.add(containerObject);
                        continue;
                    }
                    object = "\"" + containedObject.getName().trim() + "\"";
                    if (string.indexOf((String)object) <= -1 || list.contains(containerObject = containedObject.getContainer())) continue;
                    list.add(containerObject);
                }
            }
            for (Object object4 : cube.getMeasures()) {
                if (object4 == measure || string.indexOf((String)(object2 = "\"" + ((DesignObject)object4).getName().trim() + "\"")) <= -1) continue;
                if (!((Measure)object4).isFormula()) {
                    if (((Measure)object4).getMeasureFact() == null || list.contains(object = (containedObject = ((Measure)object4).getMeasureFact()).getContainer())) continue;
                    list.add(object);
                    continue;
                }
                this.fillFactEntities((Measure)object4, list);
            }
        }
    }

    public String getOracleAWFormulaType() {
        return this.oracleAWFormulaType;
    }

    public void setOracleAWFormulaType(String string) {
        this.oracleAWFormulaType = string;
    }

    public boolean isActAsFactDimension() {
        return this.actAsFactDimension;
    }

    public void setActAsFactDimension(boolean bl) {
        this.actAsFactDimension = bl;
    }

    public boolean isCustomFormula() {
        return this.customFormula;
    }

    public void setCustomFormula(boolean bl) {
        this.customFormula = bl;
    }

    public Dimension getOLAPDimension() {
        return this.oLAPDimension;
    }

    public void setOLAPDimension(Dimension dimension) {
        this.oLAPDimension = dimension;
    }

    public Hierarchy getOLAPHierarchy() {
        if (this.oLAPHierarchy == null && this.olapHierarchyID != null) {
            this.oLAPHierarchy = (Hierarchy)((MultidimensionalDesign)this.getDesignPart()).getHierarchySet().getObjectByID(this.olapHierarchyID);
        }
        return this.oLAPHierarchy;
    }

    public void setOLAPHierarchy(Hierarchy hierarchy) {
        this.oLAPHierarchy = hierarchy;
    }

    public Level getOLAPLevel() {
        return this.oLAPLevel;
    }

    public void setOLAPLevel(Level level) {
        this.oLAPLevel = level;
    }

    public int getOLAPOffset() {
        return this.oLAPOffset;
    }

    public void setOLAPOffset(int n) {
        this.oLAPOffset = n;
    }

    public String getOLAPPeriodToDateOperation() {
        return this.oLAPPeriodToDateOperation;
    }

    public void setOLAPPeriodToDateOperation(String string) {
        this.oLAPPeriodToDateOperation = string;
    }

    public int getOLAPStart() {
        return this.oLAPStart;
    }

    public void setOLAPStart(int n) {
        this.oLAPStart = n;
    }

    public int getOLAPStep() {
        return this.oLAPStep;
    }

    public void setOLAPStep(int n) {
        this.oLAPStep = n;
    }

    public int getOLAPStop() {
        return this.oLAPStop;
    }

    public void setOLAPStop(int n) {
        this.oLAPStop = n;
    }

    public String getRankDirectionCode() {
        return this.rankDirectionCode;
    }

    public void setRankDirectionCode(String string) {
        this.rankDirectionCode = string;
    }

    public String getRankDirectionName() {
        if (this.rankDirectionCode.equalsIgnoreCase(rankDirectionCodeLH)) {
            return rankDirNameLH;
        }
        return rankDirNameHL;
    }

    public void setRankDirectionName(String string) {
        if (rankDirNameLH.equalsIgnoreCase(string)) {
            this.rankDirectionCode = rankDirectionCodeLH;
        }
        this.rankDirectionCode = rankDirectionCodeHL;
    }

    public String getOLAPOperator() {
        return this.oLAPOperator;
    }

    public void setOLAPOperator(String string) {
        this.oLAPOperator = string;
    }

    public Measure getUsedOLAPMeasure() {
        if (this.usedOLAPMeasure == null && this.usedOLAPMeasureID != null) {
            this.usedOLAPMeasure = (Measure)((MultidimensionalDesign)this.getDesignPart()).getMeasureSet().getObjectByID(this.usedOLAPMeasureID);
        }
        return this.usedOLAPMeasure;
    }

    public void setUsedOLAPMeasure(Measure measure) {
        this.usedOLAPMeasure = measure;
    }

    public void setUsedOLAPMeasureID(String string) {
        this.usedOLAPMeasureID = string;
    }

    public void setOlapHierarchyID(String string) {
        this.olapHierarchyID = string;
    }

    public boolean isDefinedAsOracleAWCalculated() {
        return !AW_NONE.equalsIgnoreCase(this.oracleAWFormulaType);
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String string) {
        this.whereClause = string;
    }

    @Override
    public String toString() {
        if (this.cube == null) {
            return this.getName();
        }
        return this.getCube().getName() + "." + this.getName();
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "measure/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getAggregationFunctionID() {
        if (this.aggregationFunction != null) {
            return this.aggregationFunction.getObjectID();
        }
        return this.aggregationFunctionID;
    }

    public void setAggregationFunctionID(String string) {
        this.aggregationFunctionID = string;
    }

    public class AggregateFunction
    implements ID_ObjectPropertyTranslator {
        public String name = "";
        public String measureAlias = "";
        public List dimensions = new ArrayList();
        public List levels = new ArrayList();
        String objectId;
        Measure measure;

        public String toString() {
            return this.name;
        }

        public String getObjectID() {
            if (this.objectId == null) {
                this.objectId = Integer.toString(Measure.this.aggrFuncID);
                Measure.this.aggrFuncID++;
            }
            return this.objectId;
        }

        public void setObjectID(String string) {
            this.objectId = string;
        }

        public boolean isDefinedOnDimension(Dimension dimension) {
            return this.dimensions.contains(dimension);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getMeasureAlias() {
            return this.measureAlias;
        }

        public void setMeasureAlias(String string) {
            this.measureAlias = string;
        }

        public List getDimensions() {
            return this.dimensions;
        }

        public List getLevels() {
            return this.levels;
        }

        @Override
        public Object translateIdToObject(String string, String string2) {
            return this.measure.translateIdToObject(string, string2);
        }

        @Override
        public String translateObjectToID(String string, Object object) {
            return this.measure.translateObjectToID(string, object);
        }
    }
}

